/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketOptions;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xsocket.ByteBufferQueue;
import org.xsocket.ClosedConnectionException;
import org.xsocket.DataConverter;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.stream.ByteBufferParser;
import org.xsocket.stream.IConnection;
import org.xsocket.stream.INonBlockingConnection;
import org.xsocket.stream.StreamSocketConfiguration;
import org.xsocket.stream.io.impl.IoProvider;
import org.xsocket.stream.io.spi.IClientIoProvider;
import org.xsocket.stream.io.spi.IHandlerIoProvider;
import org.xsocket.stream.io.spi.IIoHandler;
import org.xsocket.stream.io.spi.IIoHandlerCallback;
import org.xsocket.stream.io.spi.IIoHandlerContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Connection
implements IConnection {
    private static final Logger LOG = Logger.getLogger(Connection.class.getName());
    static final IConnection.FlushMode INITIAL_FLUSH_MODE = IConnection.FlushMode.SYNC;
    private static final long SEND_TIMEOUT = 60000L;
    private static final ByteBufferParser PARSER = new ByteBufferParser();
    static final IoProvider DEFAULT_CLIENT_IO_PROVIDER = new IoProvider();
    private static IClientIoProvider clientIoProvider = null;
    private IHandlerIoProvider ioProvider = null;
    private boolean isClosed = false;
    private final ByteBufferQueue writeQueue = new ByteBufferQueue();
    private final ByteBufferQueue readQueue = new ByteBufferQueue();
    private IIoHandler ioHandler = null;
    private IIoHandlerContext ioHandlerCtx = null;
    private String defaultEncoding = "UTF-8";
    private boolean autoflush = true;
    private IConnection.FlushMode flushmode = INITIAL_FLUSH_MODE;
    private ByteBufferParser.Index cachedIndex = null;
    private Object attachment = null;
    private final Object writeGuard = new Object();
    private IOException writeException = null;
    private LinkedList<ByteBuffer> readMarkBuffer = null;
    private boolean isReadMarked = false;
    private WriteMarkBuffer writeMarkBuffer = null;
    private boolean isWriteMarked = false;
    private boolean idleTimeoutOccured = false;
    private boolean connectionTimeoutOccured = false;

    @Override
    public final int getPendingWriteDataSize() {
        return this.writeQueue.getSize() + this.ioHandler.getPendingWriteDataSize();
    }

    Connection(IIoHandlerContext ioHandlerCtx, InetSocketAddress remoteAddress, Map<String, Object> options, SSLContext sslContext, boolean sslOn) throws IOException {
        this.ioHandlerCtx = ioHandlerCtx;
        this.ioHandler = sslContext != null ? ((IoProvider)clientIoProvider).createSSLClientIoHandler(ioHandlerCtx, remoteAddress, options, sslContext, sslOn) : clientIoProvider.createClientIoHandler(ioHandlerCtx, remoteAddress, options);
        this.ioProvider = clientIoProvider;
    }

    Connection(IIoHandlerContext ioHandlerCtx, IIoHandler ioHandler, IHandlerIoProvider ioProvider) throws IOException {
        this.ioHandlerCtx = ioHandlerCtx;
        this.ioHandler = ioHandler;
        this.ioProvider = ioProvider;
    }

    protected final IHandlerIoProvider getIoProvider() {
        return this.ioProvider;
    }

    protected final IIoHandlerContext getIoHandlerContext() {
        return this.ioHandlerCtx;
    }

    protected final void init() throws IOException {
        this.ioHandler.init(new HandlerCallback());
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("connection " + this.getId() + " created. IoHandler: " + this.ioHandler.toString());
        }
    }

    protected final IIoHandlerContext getioHandlerCtx() {
        return this.ioHandlerCtx;
    }

    protected final void setIoHandler(IIoHandler ioHandler) {
        this.ioHandler = ioHandler;
    }

    void reset() throws IOException {
        this.writeQueue.drain();
        this.writeException = null;
        this.resumeRead();
        this.setIdleTimeoutSec(Integer.MAX_VALUE);
        this.setConnectionTimeoutSec(Integer.MAX_VALUE);
        this.setAutoflush(true);
        this.setFlushmode(INITIAL_FLUSH_MODE);
        this.setDefaultEncoding("UTF-8");
        this.removeReadMark();
        this.removeWriteMark();
        this.resetCachedIndex();
        this.attachment = null;
        this.idleTimeoutOccured = false;
        this.connectionTimeoutOccured = false;
        this.ioHandler.drainIncoming();
        this.readQueue.drain();
    }

    protected final IIoHandler getIoHandler() {
        return this.ioHandler;
    }

    final SocketOptions getSocketOptions() {
        HashMap<String, Object> opt = new HashMap<String, Object>();
        Map<String, Class> setOpts = this.getOptions();
        for (String optionName : setOpts.keySet()) {
            try {
                opt.put(optionName, this.getOption(optionName));
            }
            catch (IOException ignore) {}
        }
        return StreamSocketConfiguration.fromOptions(opt);
    }

    final ByteBufferQueue getReadQueue() {
        return this.readQueue;
    }

    @Override
    public final void close() throws IOException {
        if (this.isOpen() && !this.isClosed) {
            this.isClosed = true;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("closing connection -> flush all remaining data");
            }
            this.flushWriteQueue();
            this.ioHandler.close(false);
        }
    }

    @Override
    public final boolean isOpen() {
        if (this.isClosed) {
            return false;
        }
        return this.ioHandler.isOpen();
    }

    final void writeIncoming(ByteBuffer data) {
        this.readQueue.append(data);
    }

    final void writeOutgoing(ByteBuffer data) {
        this.writeQueue.append(data);
    }

    void writeOutgoing(LinkedList<ByteBuffer> datas) {
        this.writeQueue.append(datas);
    }

    @Override
    public void suspendRead() throws IOException {
        this.ioHandler.suspendRead();
    }

    @Override
    public void resumeRead() throws IOException {
        this.ioHandler.resumeRead();
    }

    @Override
    public void flush() throws ClosedConnectionException, IOException {
        if (this.autoflush) {
            LOG.warning("flush has been called for a connection which is in autoflush mode (since xSocket V1.1 autoflush is activated by default)");
        }
        this.internalFlush();
    }

    void internalFlush() throws ClosedConnectionException, IOException {
        this.removeWriteMark();
        if (this.flushmode == IConnection.FlushMode.SYNC) {
            this.syncFlush();
        } else {
            this.flushWriteQueue();
        }
    }

    public final void setFlushmode(IConnection.FlushMode flushMode) {
        this.flushmode = flushMode;
    }

    public final IConnection.FlushMode getFlushmode() {
        return this.flushmode;
    }

    @Override
    public void setIdleTimeoutSec(int timeoutInSec) {
        this.getIoHandler().setIdleTimeoutSec(timeoutInSec);
    }

    @Override
    public void setConnectionTimeoutSec(int timeoutSec) {
        this.getIoHandler().setConnectionTimeoutSec(timeoutSec);
    }

    @Override
    public int getConnectionTimeoutSec() {
        return this.getIoHandler().getConnectionTimeoutSec();
    }

    @Override
    public int getIdleTimeoutSec() {
        return this.getIoHandler().getIdleTimeoutSec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncFlush() throws ClosedConnectionException, IOException {
        long start = System.currentTimeMillis();
        long remainingTime = 60000L;
        Object object = this.writeGuard;
        synchronized (object) {
            this.flushWriteQueue();
            do {
                if (this.ioHandler.getPendingWriteDataSize() == 0) {
                    return;
                }
                if (this.writeException != null) {
                    IOException ioe = this.writeException;
                    this.writeException = null;
                    throw ioe;
                }
                try {
                    this.writeGuard.wait(remainingTime);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            } while ((remainingTime = start + 60000L - System.currentTimeMillis()) > 0L);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("send timeout " + DataConverter.toFormatedDuration(60000L) + " reached. returning from sync flushing");
            }
        }
    }

    private void flushWriteQueue() throws ClosedConnectionException, IOException {
        if (!this.writeQueue.isEmpty()) {
            LinkedList<ByteBuffer> buffers = this.writeQueue.drain();
            this.ioHandler.writeOutgoing(buffers);
        }
    }

    @Override
    public final String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    @Override
    public final void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    @Override
    public final void setAutoflush(boolean autoflush) {
        this.autoflush = autoflush;
    }

    @Override
    public final boolean getAutoflush() {
        return this.autoflush;
    }

    @Override
    public final String getId() {
        return this.ioHandler.getId();
    }

    @Override
    public final InetAddress getLocalAddress() {
        return this.ioHandler.getLocalAddress();
    }

    @Override
    public final int getLocalPort() {
        return this.ioHandler.getLocalPort();
    }

    @Override
    public final InetAddress getRemoteAddress() {
        return this.ioHandler.getRemoteAddress();
    }

    @Override
    public final int getRemotePort() {
        return this.ioHandler.getRemotePort();
    }

    @Override
    public void activateSecuredMode() throws IOException {
        boolean isPrestarted = DEFAULT_CLIENT_IO_PROVIDER.preStartSecuredMode(this.ioHandler);
        if (isPrestarted) {
            this.internalFlush();
            DEFAULT_CLIENT_IO_PROVIDER.startSecuredMode(this.ioHandler, this.readQueue.drain());
        }
    }

    @Override
    public final int write(String s) throws ClosedConnectionException, IOException {
        return this.write(s, this.defaultEncoding);
    }

    @Override
    public final int write(String s, String encoding) throws ClosedConnectionException, IOException {
        ByteBuffer buffer = DataConverter.toByteBuffer(s, encoding);
        return this.write(buffer);
    }

    @Override
    public final int write(byte b) throws ClosedConnectionException, IOException {
        ByteBuffer buffer = ByteBuffer.allocate(1).put(b);
        buffer.flip();
        return this.write(buffer);
    }

    @Override
    public final int write(byte ... bytes) throws ClosedConnectionException, IOException {
        return this.write(ByteBuffer.wrap(bytes));
    }

    @Override
    public final int write(byte[] bytes, int offset, int length) throws ClosedConnectionException, IOException {
        return this.write(ByteBuffer.wrap(bytes, offset, length));
    }

    @Override
    public final long write(ByteBuffer[] buffers) throws ClosedConnectionException, IOException {
        if (this.isOpen()) {
            long written = 0L;
            for (ByteBuffer buffer : buffers) {
                written += (long)(buffer.limit() - buffer.position());
            }
            if (this.isWriteMarked) {
                for (ByteBuffer buffer : buffers) {
                    this.writeMarkBuffer.add(buffer);
                }
            } else {
                for (ByteBuffer buffer : buffers) {
                    this.writeQueue.append(buffer);
                }
            }
            if (this.autoflush) {
                this.internalFlush();
            }
            return written;
        }
        throw new ClosedConnectionException("connection " + this.getId() + " is already closed");
    }

    @Override
    public final int write(ByteBuffer buffer) throws ClosedConnectionException, IOException {
        if (this.isOpen()) {
            int written = buffer.limit() - buffer.position();
            if (this.isWriteMarked) {
                this.writeMarkBuffer.add(buffer);
            } else {
                this.writeQueue.append(buffer);
            }
            if (this.autoflush) {
                this.internalFlush();
            }
            return written;
        }
        throw new ClosedConnectionException("connection " + this.getId() + " is already closed");
    }

    @Override
    public final int write(int i) throws ClosedConnectionException, IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4).putInt(i);
        buffer.flip();
        return this.write(buffer);
    }

    @Override
    public final int write(short s) throws ClosedConnectionException, IOException {
        ByteBuffer buffer = ByteBuffer.allocate(2).putShort(s);
        buffer.flip();
        return this.write(buffer);
    }

    @Override
    public final int write(long l) throws ClosedConnectionException, IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8).putLong(l);
        buffer.flip();
        return this.write(buffer);
    }

    @Override
    public final int write(double d) throws ClosedConnectionException, IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8).putDouble(d);
        buffer.flip();
        return this.write(buffer);
    }

    @Override
    public final long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        ByteBuffer[] bufs = new ByteBuffer[length];
        System.arraycopy(srcs, offset, bufs, 0, length);
        return this.write(bufs);
    }

    protected final LinkedList<ByteBuffer> extractAvailableFromReadQueue() {
        this.resetCachedIndex();
        LinkedList<ByteBuffer> buffers = this.readQueue.drain();
        this.onExtracted(buffers);
        return buffers;
    }

    protected final LinkedList<ByteBuffer> extractBytesByDelimiterFromReadQueue(byte[] delimiter, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        if (!this.readQueue.isEmpty()) {
            LinkedList<ByteBuffer> buffers = this.readQueue.drain();
            assert (buffers != null);
            ByteBufferParser.Index index = this.scanByDelimiter(buffers, delimiter);
            if (index.getReadBytes() > maxLength) {
                throw new MaxReadSizeExceededException();
            }
            if (index.hasDelimiterFound()) {
                LinkedList<ByteBuffer> extracted = PARSER.extract(buffers, index);
                this.onExtracted(extracted, delimiter);
                this.readQueue.addFirstSilence(buffers);
                this.resetCachedIndex();
                return extracted;
            }
            this.readQueue.addFirstSilence(buffers);
            this.cachedIndex = index;
        }
        if (this.isOpen()) {
            throw new BufferUnderflowException();
        }
        int read = this.retrieveIoHandlerData();
        if (read > 0) {
            return this.extractBytesByDelimiterFromReadQueue(delimiter, maxLength);
        }
        throw new ClosedConnectionException("connection " + this.getId() + " is already closed");
    }

    public int indexOf(String str) {
        int length = 0;
        if (!this.readQueue.isEmpty()) {
            try {
                LinkedList<ByteBuffer> buffers = this.readQueue.drain();
                ByteBufferParser.Index index = this.scanByDelimiter(buffers, str.getBytes(this.getDefaultEncoding()));
                length = index.hasDelimiterFound() ? index.getReadBytes() - str.length() : -1;
                this.readQueue.addFirstSilence(buffers);
                this.cachedIndex = index;
            }
            catch (UnsupportedEncodingException uce) {
                throw new RuntimeException(uce);
            }
        }
        return length;
    }

    protected final int readIndexOf(byte[] bytes, int maxReadSize) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        Integer length = null;
        if (!this.readQueue.isEmpty()) {
            LinkedList<ByteBuffer> buffers = this.readQueue.drain();
            ByteBufferParser.Index index = this.scanByDelimiter(buffers, bytes);
            length = index.hasDelimiterFound() ? (index.getReadBytes() <= maxReadSize ? Integer.valueOf(index.getReadBytes() - bytes.length) : null) : null;
            this.readQueue.addFirstSilence(buffers);
            this.cachedIndex = index;
        }
        if (length == null) {
            if (this.readQueue.getSize() >= maxReadSize) {
                throw new MaxReadSizeExceededException();
            }
            if (this.isOpen()) {
                throw new BufferUnderflowException();
            }
            throw new ClosedConnectionException("connection " + this.getId() + " is already closed");
        }
        return length;
    }

    protected final LinkedList<ByteBuffer> extractBytesByLength(int length) throws IOException, BufferUnderflowException {
        if (length == 0) {
            return new LinkedList<ByteBuffer>();
        }
        if (this.readQueue.getSize() >= length) {
            LinkedList<ByteBuffer> buffers = this.readQueue.drain();
            assert (buffers != null);
            LinkedList<ByteBuffer> extracted = PARSER.extract(buffers, length);
            this.onExtracted(extracted);
            this.readQueue.addFirstSilence(buffers);
            this.resetCachedIndex();
            return extracted;
        }
        if (this.isOpen()) {
            throw new BufferUnderflowException();
        }
        int read = this.retrieveIoHandlerData();
        if (read > 0) {
            return this.extractBytesByLength(length);
        }
        throw new ClosedConnectionException("connection " + this.getId() + " is already closed");
    }

    protected final boolean extractAvailableFromReadQueue(byte[] delimiter, WritableByteChannel outChannel) throws IOException {
        if (!this.readQueue.isEmpty()) {
            int availableBytes;
            int readBytes;
            LinkedList<ByteBuffer> buffers = this.readQueue.drain();
            assert (buffers != null);
            ByteBufferParser.Index index = this.scanByDelimiter(buffers, delimiter);
            if (index.hasDelimiterFound()) {
                LinkedList<ByteBuffer> extracted = PARSER.extract(buffers, index);
                this.onExtracted(extracted, delimiter);
                for (ByteBuffer buffer : extracted) {
                    outChannel.write(buffer);
                }
                this.readQueue.addFirstSilence(buffers);
                this.resetCachedIndex();
                return true;
            }
            if (index.getDelimiterPos() == 0 && (readBytes = index.getReadBytes()) > 0 && (availableBytes = readBytes - index.getDelimiterPos()) > 0) {
                LinkedList<ByteBuffer> extracted = PARSER.extract(buffers, availableBytes);
                this.onExtracted(extracted);
                for (ByteBuffer buffer : extracted) {
                    outChannel.write(buffer);
                }
                this.resetCachedIndex();
            }
            this.readQueue.addFirstSilence(buffers);
            return false;
        }
        return false;
    }

    private ByteBufferParser.Index scanByDelimiter(LinkedList<ByteBuffer> buffers, byte[] delimiter) {
        if (this.cachedIndex != null) {
            if (this.cachedIndex.isDelimiterEquals(delimiter)) {
                if (this.cachedIndex.hasDelimiterFound()) {
                    return this.cachedIndex;
                }
                return PARSER.find(buffers, this.cachedIndex);
            }
            this.cachedIndex = null;
        }
        return PARSER.find(buffers, delimiter);
    }

    private void onExtracted(LinkedList<ByteBuffer> buffers) {
        if (this.isReadMarked) {
            for (ByteBuffer buffer : buffers) {
                this.onExtracted(buffer);
            }
        }
    }

    private void onExtracted(LinkedList<ByteBuffer> buffers, byte[] delimiter) {
        if (this.isReadMarked) {
            for (ByteBuffer buffer : buffers) {
                this.onExtracted(buffer);
            }
            this.onExtracted(ByteBuffer.wrap(delimiter));
        }
    }

    private void onExtracted(ByteBuffer buffer) {
        if (this.isReadMarked) {
            this.readMarkBuffer.addLast(buffer.duplicate());
        }
    }

    protected final byte[] extractBytesFromReadQueue(int length) throws BufferUnderflowException {
        this.resetCachedIndex();
        ByteBuffer buffer = this.readQueue.read(length);
        this.onExtracted(buffer);
        return DataConverter.toBytes(buffer);
    }

    protected final int extractIntFromReadQueue() throws BufferUnderflowException {
        this.resetCachedIndex();
        ByteBuffer buffer = this.readQueue.read(4);
        this.onExtracted(buffer);
        return buffer.getInt();
    }

    protected final short extractShortFromReadQueue() throws BufferUnderflowException {
        this.resetCachedIndex();
        ByteBuffer buffer = this.readQueue.read(2);
        this.onExtracted(buffer);
        return buffer.getShort();
    }

    protected final byte extractByteFromReadQueue() throws BufferUnderflowException {
        this.resetCachedIndex();
        ByteBuffer buffer = this.readQueue.read(1);
        this.onExtracted(buffer);
        return buffer.get();
    }

    protected final double extractDoubleFromReadQueue() throws BufferUnderflowException {
        this.resetCachedIndex();
        ByteBuffer buffer = this.readQueue.read(8);
        this.onExtracted(buffer);
        return buffer.getDouble();
    }

    protected final long extractLongFromReadQueue() throws BufferUnderflowException {
        this.resetCachedIndex();
        ByteBuffer buffer = this.readQueue.read(8);
        this.onExtracted(buffer);
        return buffer.getLong();
    }

    protected final INonBlockingConnection.TransferResult transferAvailableFromReadQueue(byte[] delimiter, WritableByteChannel outChannel) throws IOException {
        long written = 0L;
        if (!this.readQueue.isEmpty()) {
            int availableBytes;
            int readBytes;
            LinkedList<ByteBuffer> buffers = this.readQueue.drain();
            assert (buffers != null);
            ByteBufferParser.Index index = this.scanByDelimiter(buffers, delimiter);
            if (index.hasDelimiterFound()) {
                LinkedList<ByteBuffer> extracted = PARSER.extract(buffers, index);
                this.onExtracted(extracted, delimiter);
                for (ByteBuffer buffer : extracted) {
                    written += (long)outChannel.write(buffer);
                }
                this.readQueue.addFirstSilence(buffers);
                this.resetCachedIndex();
                return new INonBlockingConnection.TransferResult(true, written);
            }
            if (index.getDelimiterPos() == 0 && (readBytes = index.getReadBytes()) > 0 && (availableBytes = readBytes - index.getDelimiterPos()) > 0) {
                LinkedList<ByteBuffer> extracted = PARSER.extract(buffers, availableBytes);
                this.onExtracted(extracted);
                for (ByteBuffer buffer : extracted) {
                    written += (long)outChannel.write(buffer);
                }
                this.resetCachedIndex();
            }
            this.readQueue.addFirstSilence(buffers);
            return new INonBlockingConnection.TransferResult(false, written);
        }
        return new INonBlockingConnection.TransferResult(false, written);
    }

    private void resetCachedIndex() {
        this.cachedIndex = null;
    }

    @Override
    public final Object attach(Object obj) {
        Object old = this.attachment;
        this.attachment = obj;
        return old;
    }

    @Override
    public final Object attachment() {
        return this.getAttachment();
    }

    @Override
    public final void setAttachment(Object obj) {
        this.attachment = obj;
    }

    @Override
    public final Object getAttachment() {
        return this.attachment;
    }

    @Override
    public void markReadPosition() {
        this.removeReadMark();
        this.isReadMarked = true;
        this.readMarkBuffer = new LinkedList();
    }

    @Override
    public void markWritePosition() {
        if (this.getAutoflush()) {
            throw new UnsupportedOperationException("write mark is only supported for mode autoflush off");
        }
        this.removeWriteMark();
        this.isWriteMarked = true;
        this.writeMarkBuffer = new WriteMarkBuffer();
    }

    @Override
    public boolean resetToWriteMark() {
        if (this.isWriteMarked) {
            this.writeMarkBuffer.resetWritePosition();
            return true;
        }
        return false;
    }

    @Override
    public boolean resetToReadMark() {
        if (this.isReadMarked) {
            this.getReadQueue().addFirstSilence(this.readMarkBuffer);
            this.removeReadMark();
            return true;
        }
        return false;
    }

    @Override
    public void removeReadMark() {
        this.isReadMarked = false;
        this.readMarkBuffer = null;
    }

    @Override
    public void removeWriteMark() {
        if (this.isWriteMarked) {
            this.isWriteMarked = false;
            this.writeQueue.append(this.writeMarkBuffer.drain());
            this.writeMarkBuffer = null;
        }
    }

    protected int onDataEvent() {
        return this.retrieveIoHandlerData();
    }

    private int retrieveIoHandlerData() {
        try {
            LinkedList<ByteBuffer> buffers = this.getIoHandler().drainIncoming();
            int addSize = 0;
            for (ByteBuffer buffer : buffers) {
                addSize += buffer.remaining();
            }
            if (addSize > 0) {
                this.getReadQueue().append(buffers);
            }
            return addSize;
        }
        catch (RuntimeException e) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("error occured by transfering data to connection's read queue " + e.toString());
            }
            throw e;
        }
    }

    protected void onConnectEvent() {
    }

    protected void onDisconnectEvent() {
    }

    protected boolean onConnectionTimeoutEvent() {
        return false;
    }

    protected boolean onIdleTimeoutEvent() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWritten() {
        if (this.flushmode == IConnection.FlushMode.SYNC) {
            Object object = this.writeGuard;
            synchronized (object) {
                this.writeGuard.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWriteException(IOException ioException) {
        if (this.flushmode == IConnection.FlushMode.SYNC) {
            Object object = this.writeGuard;
            synchronized (object) {
                this.writeException = ioException;
                this.writeGuard.notify();
            }
        }
    }

    @Override
    public final Object getOption(String name) throws IOException {
        return this.ioHandler.getOption(name);
    }

    @Override
    public final Map<String, Class> getOptions() {
        return this.ioHandler.getOptions();
    }

    @Override
    public IConnection setOption(String name, Object value) throws IOException {
        this.ioHandler.setOption(name, value);
        return this;
    }

    private void initiateClose() {
        block2: {
            try {
                this.close();
            }
            catch (IOException ioe) {
                if (!LOG.isLoggable(Level.FINE)) break block2;
                LOG.fine("[" + this.getId() + "] error occured closing connection. Reason: " + ioe.toString());
            }
        }
    }

    public String toString() {
        try {
            if (this.isOpen()) {
                return "id=" + this.getId() + ", remote=" + this.getRemoteAddress().getCanonicalHostName() + "(" + this.getRemoteAddress() + ":" + this.getRemotePort() + ")";
            }
            return "id=" + this.getId() + " (closed)";
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    static {
        String clientIoManagerClassname = System.getProperty("org.xsocket.stream.io.spi.ClientIoProviderClass", IoProvider.class.getName());
        try {
            Class<?> clientIoManagerClass = Class.forName(clientIoManagerClassname);
            clientIoProvider = (IClientIoProvider)clientIoManagerClass.newInstance();
        }
        catch (Exception e) {
            LOG.warning("error occured by creating ClientIoManager " + clientIoManagerClassname + ": " + e.toString());
            LOG.info("using default ClientIoManager " + DEFAULT_CLIENT_IO_PROVIDER.getClass().getName());
            clientIoProvider = DEFAULT_CLIENT_IO_PROVIDER;
        }
    }

    private final class HandlerCallback
    implements IIoHandlerCallback {
        private HandlerCallback() {
        }

        public void onWritten() {
            Connection.this.onWritten();
        }

        public void onWriteException(IOException ioException) {
            Connection.this.onWriteException(ioException);
        }

        public void onDataRead() {
            Connection.this.onDataEvent();
        }

        public void onConnectionAbnormalTerminated() {
            Connection.this.initiateClose();
        }

        public void onConnect() {
            Connection.this.onConnectEvent();
        }

        public void onDisconnect() {
            Connection.this.onDisconnectEvent();
        }

        public void onConnectionTimeout() {
            block4: {
                if (!Connection.this.connectionTimeoutOccured) {
                    Connection.this.connectionTimeoutOccured = true;
                    boolean isHandled = Connection.this.onConnectionTimeoutEvent();
                    if (!isHandled) {
                        try {
                            Connection.this.close();
                        }
                        catch (IOException ioe) {
                            if (!LOG.isLoggable(Level.FINE)) break block4;
                            LOG.fine("[" + Connection.this.getId() + "] error occured closing connection caused by connection timeout. Reason: " + ioe.toString());
                        }
                    }
                }
            }
        }

        public void onIdleTimeout() {
            block4: {
                if (!Connection.this.idleTimeoutOccured) {
                    Connection.this.idleTimeoutOccured = true;
                    boolean isHandled = Connection.this.onIdleTimeoutEvent();
                    if (!isHandled) {
                        try {
                            Connection.this.close();
                        }
                        catch (IOException ioe) {
                            if (!LOG.isLoggable(Level.FINE)) break block4;
                            LOG.fine("[" + Connection.this.getId() + "] error occured closing connection caused by idle timeout. Reason: " + ioe.toString());
                        }
                    }
                }
            }
        }
    }

    private static class Entry {
        private ByteBuffer element = null;
        private Entry next = null;

        Entry(ByteBuffer element, Entry next) {
            this.element = element;
            this.next = next;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.element != null) {
                sb.append(DataConverter.toHexString(new ByteBuffer[]{this.element}, 100000));
            }
            if (this.next != null) {
                sb.append(this.next.toString());
            }
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WriteMarkBuffer {
        private final Entry head;
        private Entry tail;

        private WriteMarkBuffer() {
            this.tail = this.head = new Entry(null, null);
        }

        public LinkedList<ByteBuffer> drain() {
            LinkedList<ByteBuffer> result = new LinkedList<ByteBuffer>();
            Entry entry = this.head;
            do {
                if ((entry = entry.next) == null) continue;
                result.add(entry.element);
            } while (entry != null);
            this.head.next = null;
            this.tail = this.head;
            return result;
        }

        public void add(ByteBuffer data) {
            int size = data.remaining();
            if (size == 0) {
                return;
            }
            Entry entry = new Entry(data, this.tail.next);
            this.tail.next = entry;
            this.tail = entry;
            while (size > 0 && this.tail.next != null) {
                int nextSize = this.tail.next.element.remaining();
                if (nextSize <= size) {
                    size -= nextSize;
                    this.tail.next = this.tail.next.next;
                    if (this.tail.next != null) continue;
                    break;
                }
                ByteBuffer buffer = this.tail.next.element;
                buffer.position(buffer.position() + size);
                ByteBuffer sliced = buffer.slice();
                Entry slicedEntry = new Entry(sliced, this.tail.next.next);
                this.tail.next = slicedEntry;
                break;
            }
        }

        public void resetWritePosition() {
            this.tail = this.head;
        }
    }
}

