/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.xsocket.ClosedConnectionException;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.stream.IConnection;

public interface INonBlockingConnection
extends IConnection {
    public static final int UNLIMITED = Integer.MAX_VALUE;
    public static final IConnection.FlushMode INITIAL_FLUSH_MODE = IConnection.FlushMode.SYNC;

    public int getNumberOfAvailableBytes();

    public int indexOf(String var1);

    public int getIndexOf(String var1) throws IOException, ClosedConnectionException, BufferUnderflowException;

    public int getIndexOf(String var1, int var2) throws IOException, ClosedConnectionException, BufferUnderflowException, MaxReadSizeExceededException;

    public ByteBuffer[] readAvailable() throws IOException, ClosedConnectionException;

    public boolean readAvailableByDelimiter(String var1, WritableByteChannel var2) throws IOException, ClosedConnectionException;

    public boolean readAvailableByDelimiter(String var1, String var2, WritableByteChannel var3) throws IOException, ClosedConnectionException;

    public TransferResult transferToAvailableByDelimiter(String var1, WritableByteChannel var2) throws ClosedConnectionException, IOException, SocketTimeoutException;

    public TransferResult transferToAvailableByDelimiter(String var1, String var2, WritableByteChannel var3) throws ClosedConnectionException, IOException, SocketTimeoutException;

    public ByteBuffer[] readByteBufferByDelimiter(String var1) throws IOException, ClosedConnectionException, BufferUnderflowException;

    public ByteBuffer[] readByteBufferByDelimiter(String var1, int var2) throws IOException, ClosedConnectionException, MaxReadSizeExceededException, BufferUnderflowException;

    public ByteBuffer[] readByteBufferByLength(int var1) throws IOException, ClosedConnectionException, BufferUnderflowException;

    public byte[] readBytesByDelimiter(String var1) throws IOException, ClosedConnectionException, BufferUnderflowException;

    public byte[] readBytesByDelimiter(String var1, int var2) throws IOException, ClosedConnectionException, MaxReadSizeExceededException, BufferUnderflowException;

    public byte[] readBytesByLength(int var1) throws IOException, ClosedConnectionException, BufferUnderflowException;

    public String readStringByDelimiter(String var1) throws IOException, ClosedConnectionException, BufferUnderflowException, UnsupportedEncodingException;

    public String readStringByDelimiter(String var1, int var2) throws IOException, ClosedConnectionException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException;

    public String readStringByLength(int var1) throws IOException, ClosedConnectionException, BufferUnderflowException, UnsupportedEncodingException;

    public String readStringByDelimiter(String var1, String var2) throws IOException, ClosedConnectionException, BufferUnderflowException, UnsupportedEncodingException;

    public String readStringByDelimiter(String var1, String var2, int var3) throws IOException, ClosedConnectionException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException;

    public String readStringByLength(int var1, String var2) throws IOException, ClosedConnectionException, BufferUnderflowException, UnsupportedEncodingException;

    public int readInt() throws IOException, ClosedConnectionException, BufferUnderflowException;

    public long readLong() throws IOException, ClosedConnectionException, BufferUnderflowException;

    public double readDouble() throws IOException, ClosedConnectionException, BufferUnderflowException;

    public byte readByte() throws IOException, ClosedConnectionException, BufferUnderflowException;

    public void setWriteTransferRate(int var1) throws ClosedConnectionException, IOException;

    public void flush() throws ClosedConnectionException, IOException;

    public int write(ByteBuffer var1) throws ClosedConnectionException, IOException;

    public long write(ByteBuffer[] var1) throws ClosedConnectionException, IOException;

    public void setFlushmode(IConnection.FlushMode var1);

    public IConnection.FlushMode getFlushmode();

    public INonBlockingConnection setOption(String var1, Object var2) throws IOException;

    public static final class TransferResult {
        private boolean delimiterFound = false;
        private long written = 0L;

        TransferResult(boolean delimiterFound, long written) {
            this.delimiterFound = delimiterFound;
            this.written = written;
        }

        public boolean isDelimiterFound() {
            return this.delimiterFound;
        }

        public long getWritten() {
            return this.written;
        }
    }
}

