/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.ILifeCycle;
import org.xsocket.Synchronized;
import org.xsocket.stream.IConnectHandler;
import org.xsocket.stream.IConnectionScoped;
import org.xsocket.stream.IDataHandler;
import org.xsocket.stream.IDisconnectHandler;
import org.xsocket.stream.IHandler;
import org.xsocket.stream.ITimeoutHandler;
import org.xsocket.stream.io.spi.IIoHandlerContext;

final class IoHandlerContext
implements IIoHandlerContext {
    private static final Logger LOG = Logger.getLogger(IoHandlerContext.class.getName());
    private static final SingleThreadedWorkerPool SINGLE_THREADED_POOL = new SingleThreadedWorkerPool();
    private boolean isConnectHandler = false;
    private boolean isDisconnectHandler = false;
    private boolean isDataHandler = false;
    private boolean isTimeoutHandler = false;
    private boolean isLifeCycleHandler = false;
    private boolean isConnectionScoped = false;
    private boolean isHandlerThreadSave = false;
    private boolean isMultithreaded = false;
    private Executor workerpool = null;

    IoHandlerContext(IHandler appHandler, Executor workerpool) {
        this.updateAppHandler(appHandler);
        this.updateWorkerpool(workerpool);
    }

    void updateAppHandler(IHandler appHandler) {
        this.introspectHandler(appHandler);
    }

    void updateWorkerpool(Executor workerpool) {
        if (workerpool != null) {
            this.workerpool = workerpool;
            this.isMultithreaded = true;
        } else {
            this.workerpool = SINGLE_THREADED_POOL;
            this.isMultithreaded = false;
        }
    }

    public Executor getWorkerpool() {
        return this.workerpool;
    }

    public boolean isAppHandlerListenForConnectEvent() {
        return this.isConnectHandler;
    }

    public boolean isAppHandlerListenForDataEvent() {
        return this.isDataHandler;
    }

    public boolean isAppHandlerListenforDisconnectEvent() {
        return this.isDisconnectHandler;
    }

    public boolean isAppHandlerListenForTimeoutEvent() {
        return this.isTimeoutHandler;
    }

    public boolean isAppHandlerConnectionScoped() {
        return this.isConnectionScoped;
    }

    public boolean isAppHandlerThreadSave() {
        return this.isHandlerThreadSave;
    }

    boolean isConnectionScoped() {
        return this.isConnectionScoped;
    }

    boolean isLifeCycleHandler() {
        return this.isLifeCycleHandler;
    }

    public boolean isAppHandlerThreadSafe() {
        return this.isHandlerThreadSave;
    }

    public boolean isMultithreaded() {
        return this.isMultithreaded;
    }

    private void introspectHandler(IHandler appHandler) {
        if (appHandler == null) {
            this.isDataHandler = true;
            this.isConnectHandler = false;
            this.isDisconnectHandler = false;
            this.isTimeoutHandler = false;
            this.isConnectionScoped = false;
            this.isHandlerThreadSave = false;
            this.isLifeCycleHandler = false;
        } else {
            Synchronized.Mode scope;
            this.isConnectHandler = appHandler instanceof IConnectHandler;
            this.isDisconnectHandler = appHandler instanceof IDisconnectHandler;
            this.isDataHandler = appHandler instanceof IDataHandler;
            this.isTimeoutHandler = appHandler instanceof ITimeoutHandler;
            this.isConnectionScoped = appHandler instanceof IConnectionScoped;
            this.isLifeCycleHandler = appHandler instanceof ILifeCycle;
            Synchronized sync = appHandler.getClass().getAnnotation(Synchronized.class);
            this.isHandlerThreadSave = sync != null ? (scope = sync.value()) == Synchronized.Mode.OFF : false;
        }
    }

    private static final class SingleThreadedWorkerPool
    implements Executor {
        private SingleThreadedWorkerPool() {
        }

        public void execute(Runnable command) {
            block2: {
                try {
                    command.run();
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("error occured within worker thread " + e.toString());
                }
            }
        }
    }
}

