/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xsocket.ILifeCycle;
import org.xsocket.IWorkerPool;
import org.xsocket.Resource;
import org.xsocket.stream.IConnectionScoped;
import org.xsocket.stream.IHandler;
import org.xsocket.stream.IMultithreadedServer;
import org.xsocket.stream.IMutlithreadedServerListener;
import org.xsocket.stream.IServerContext;
import org.xsocket.stream.IoHandlerContext;
import org.xsocket.stream.NonBlockingConnection;
import org.xsocket.stream.StreamSocketConfiguration;
import org.xsocket.stream.io.impl.IoProvider;
import org.xsocket.stream.io.spi.IAcceptor;
import org.xsocket.stream.io.spi.IAcceptorCallback;
import org.xsocket.stream.io.spi.IIoHandler;
import org.xsocket.stream.io.spi.IServerIoProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultithreadedServer
implements IMultithreadedServer {
    private static final Logger LOG = Logger.getLogger(MultithreadedServer.class.getName());
    private static final String DEFAULT_HOST_ADDRESS = "0.0.0.0";
    private boolean isOpen = false;
    private static IServerIoProvider serverIoProvider = null;
    private IAcceptor acceptor = null;
    private InetSocketAddress address = null;
    private Map<String, Object> options = null;
    private boolean sslOn = false;
    private SSLContext sslContext = null;
    private Executor workerpool = null;
    private boolean isSelfCreatedWorkerPool = false;
    private IHandler appHandlerPrototype = null;
    private final IoHandlerContext ioHandlerContext = new IoHandlerContext(null, null);
    private final ArrayList<IMutlithreadedServerListener> listeners = new ArrayList();
    private int idleTimeoutSec = Integer.MAX_VALUE;
    private int connectionTimeoutSec = Integer.MAX_VALUE;

    public MultithreadedServer(IHandler handler) throws UnknownHostException, IOException {
        this(InetAddress.getByName(DEFAULT_HOST_ADDRESS), 0, new HashMap<String, Object>(), handler, false, null);
    }

    public MultithreadedServer(IHandler handler, Executor workerpool) throws UnknownHostException, IOException {
        this(InetAddress.getByName(DEFAULT_HOST_ADDRESS), 0, new HashMap<String, Object>(), handler, workerpool, false, null);
    }

    public MultithreadedServer(StreamSocketConfiguration socketConfiguration, IHandler handler) throws UnknownHostException, IOException {
        this(InetAddress.getByName(DEFAULT_HOST_ADDRESS), 0, socketConfiguration, handler, false, null);
    }

    public MultithreadedServer(Map<String, Object> options, IHandler handler) throws UnknownHostException, IOException {
        this(InetAddress.getByName(DEFAULT_HOST_ADDRESS), 0, options, handler, false, null);
    }

    public MultithreadedServer(int port, IHandler handler) throws UnknownHostException, IOException {
        this(InetAddress.getByName(DEFAULT_HOST_ADDRESS), port, new HashMap<String, Object>(), handler, false, null);
    }

    public MultithreadedServer(int port, IHandler handler, Executor workerpool) throws UnknownHostException, IOException {
        this(InetAddress.getByName(DEFAULT_HOST_ADDRESS), port, new HashMap<String, Object>(), handler, workerpool, false, null);
    }

    public MultithreadedServer(int port, StreamSocketConfiguration socketConfiguration, IHandler handler) throws UnknownHostException, IOException {
        this(InetAddress.getByName(DEFAULT_HOST_ADDRESS), port, socketConfiguration, handler, false, null);
    }

    public MultithreadedServer(int port, Map<String, Object> options, IHandler handler) throws UnknownHostException, IOException {
        this(InetAddress.getByName(DEFAULT_HOST_ADDRESS), port, options, handler, false, null);
    }

    public MultithreadedServer(InetAddress address, int port, IHandler handler) throws UnknownHostException, IOException {
        this(address, port, new HashMap<String, Object>(), handler, false, null);
    }

    public MultithreadedServer(InetAddress address, int port, IHandler handler, Executor workerPool) throws UnknownHostException, IOException {
        this(address, port, new HashMap<String, Object>(), handler, workerPool, false, null);
    }

    public MultithreadedServer(InetAddress address, int port, StreamSocketConfiguration socketConfiguration, IHandler handler) throws UnknownHostException, IOException {
        this(address, port, socketConfiguration, handler, false, null);
    }

    public MultithreadedServer(String ipAddress, int port, IHandler handler) throws UnknownHostException, IOException {
        this(InetAddress.getByName(ipAddress), port, new HashMap<String, Object>(), handler, false, null);
    }

    public MultithreadedServer(String ipAddress, int port, StreamSocketConfiguration socketConfiguration, IHandler handler) throws UnknownHostException, IOException {
        this(InetAddress.getByName(ipAddress), port, socketConfiguration, handler, false, null);
    }

    public MultithreadedServer(String ipAddress, int port, Map<String, Object> options, IHandler handler) throws UnknownHostException, IOException {
        this(InetAddress.getByName(ipAddress), port, options, handler, false, null);
    }

    public MultithreadedServer(int port, IHandler handler, boolean sslOn, SSLContext sslContext) throws UnknownHostException, IOException {
        this(InetAddress.getByName(DEFAULT_HOST_ADDRESS), port, new HashMap<String, Object>(), handler, sslOn, sslContext);
    }

    public MultithreadedServer(int port, StreamSocketConfiguration socketConfiguration, IHandler handler, boolean sslOn, SSLContext sslContext) throws UnknownHostException, IOException {
        this(InetAddress.getByName(DEFAULT_HOST_ADDRESS), port, socketConfiguration, handler, sslOn, sslContext);
    }

    public MultithreadedServer(int port, Map<String, Object> options, IHandler handler, boolean sslOn, SSLContext sslContext) throws UnknownHostException, IOException {
        this(InetAddress.getByName(DEFAULT_HOST_ADDRESS), port, options, handler, sslOn, sslContext);
    }

    public MultithreadedServer(String ipAddress, int port, IHandler handler, boolean sslOn, SSLContext sslContext) throws UnknownHostException, IOException {
        this(InetAddress.getByName(ipAddress), port, new HashMap<String, Object>(), handler, sslOn, sslContext);
    }

    public MultithreadedServer(String ipAddress, int port, StreamSocketConfiguration socketConfiguration, IHandler handler, boolean sslOn, SSLContext sslContext) throws UnknownHostException, IOException {
        this(InetAddress.getByName(ipAddress), port, socketConfiguration, handler, sslOn, sslContext);
    }

    public MultithreadedServer(String ipAddress, int port, Map<String, Object> options, IHandler handler, boolean sslOn, SSLContext sslContext) throws UnknownHostException, IOException {
        this(InetAddress.getByName(ipAddress), port, options, handler, sslOn, sslContext);
    }

    public MultithreadedServer(InetAddress address, int port, IHandler handler, boolean sslOn, SSLContext sslContext) throws UnknownHostException, IOException {
        this(address, port, new HashMap<String, Object>(), handler, sslOn, sslContext);
    }

    public MultithreadedServer(InetAddress address, int port, StreamSocketConfiguration socketConfiguration, IHandler handler, boolean sslOn, SSLContext sslContext) throws UnknownHostException, IOException {
        this(address, port, socketConfiguration, handler, (Executor)MultithreadedServer.newServerWorkerPool(), sslOn, sslContext);
        this.isSelfCreatedWorkerPool = true;
    }

    public MultithreadedServer(InetAddress address, int port, Map<String, Object> options, IHandler handler, boolean sslOn, SSLContext sslContext) throws UnknownHostException, IOException {
        this(address, port, options, handler, (Executor)MultithreadedServer.newServerWorkerPool(), sslOn, sslContext);
        this.isSelfCreatedWorkerPool = true;
    }

    public MultithreadedServer(InetAddress address, int port, StreamSocketConfiguration socketConfiguration, IHandler appHandler, Executor workerpool, boolean sslOn, SSLContext sslContext) throws UnknownHostException, IOException {
        this(new InetSocketAddress(address, port), socketConfiguration.toOptions(), appHandler, workerpool, sslOn, sslContext);
    }

    public MultithreadedServer(InetAddress address, int port, Map<String, Object> options, IHandler appHandler, Executor workerpool, boolean sslOn, SSLContext sslContext) throws UnknownHostException, IOException {
        this(new InetSocketAddress(address, port), options, appHandler, workerpool, sslOn, sslContext);
    }

    private MultithreadedServer(InetSocketAddress address, Map<String, Object> options, IHandler appHandler, Executor workerpool, boolean sslOn, SSLContext sslContext) throws UnknownHostException, IOException {
        this.address = address;
        this.options = options;
        this.appHandlerPrototype = appHandler;
        this.workerpool = workerpool;
        this.sslOn = sslOn;
        this.sslContext = sslContext;
        this.ioHandlerContext.updateAppHandler(appHandler);
        this.ioHandlerContext.updateWorkerpool(workerpool);
    }

    @Override
    public final void run() {
        try {
            if (this.appHandlerPrototype == null) {
                LOG.warning("no handler has been set. Call setHandler-method to set an assigned handler");
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    MultithreadedServer.this.close();
                }
            });
            this.acceptor = this.sslContext != null ? new IoProvider().create(new AcceptorCallback(), this.ioHandlerContext, this.address, 0, this.options, this.sslContext, this.sslOn) : serverIoProvider.createAcceptor(new AcceptorCallback(), this.ioHandlerContext, this.address, 0, this.options);
            this.acceptor.listen();
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    @Override
    public Object getOption(String name) throws IOException {
        return this.acceptor.getOption(name);
    }

    @Override
    public Map<String, Class> getOptions() {
        return this.acceptor.getOptions();
    }

    @Override
    public void close() {
        if (this.isOpen) {
            this.isOpen = false;
            try {
                this.acceptor.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.isSelfCreatedWorkerPool && this.workerpool instanceof ExecutorService) {
                ((ExecutorService)this.workerpool).shutdown();
            }
        }
    }

    private static final ExecutorService newServerWorkerPool() {
        return Executors.newFixedThreadPool(40);
    }

    IAcceptor getAcceptor() {
        return this.acceptor;
    }

    @Override
    public void addListener(IMutlithreadedServerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean removeListener(IMutlithreadedServerListener listener) {
        boolean result = this.listeners.remove(listener);
        return result;
    }

    @Override
    public IWorkerPool getWorkerPool() {
        return (IWorkerPool)this.workerpool;
    }

    @Override
    public Executor getWorkerpool() {
        return this.workerpool;
    }

    @Override
    public void setWorkerPool(IWorkerPool newWorkerPool) {
        this.setWorkerPool((Executor)newWorkerPool);
    }

    private void setWorkerPool(Executor newWorkerPool) {
        Executor oldWorkerPool = this.workerpool;
        this.workerpool = newWorkerPool;
        if (this.isSelfCreatedWorkerPool && oldWorkerPool instanceof ExecutorService) {
            ((ExecutorService)oldWorkerPool).shutdown();
        }
        this.isSelfCreatedWorkerPool = false;
        this.ioHandlerContext.updateWorkerpool(this.workerpool);
        if (newWorkerPool instanceof IWorkerPool) {
            for (IMutlithreadedServerListener listener : (ArrayList)this.listeners.clone()) {
                listener.onWorkerPoolUpdated(null, (IWorkerPool)newWorkerPool);
            }
        }
    }

    @Override
    public final void setDispatcherPoolSize(int size) {
        LOG.warning("not implemented. Method will be removed");
    }

    @Override
    public int getDispatcherPoolSize() {
        LOG.warning("not implemented. Method will be removed");
        return -1;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void setHandler(IHandler appHandler) {
        if (appHandler == null) {
            throw new NullPointerException("handler is null");
        }
        if (this.isOpen) {
            this.destroyCurrentHandler();
            this.appHandlerPrototype = appHandler;
            this.ioHandlerContext.updateAppHandler(this.appHandlerPrototype);
            this.initCurrentHandler();
        } else {
            this.appHandlerPrototype = appHandler;
            this.ioHandlerContext.updateAppHandler(this.appHandlerPrototype);
        }
    }

    private void destroyCurrentHandler() {
        if (this.appHandlerPrototype != null) {
            if (this.ioHandlerContext.isLifeCycleHandler()) {
                ((ILifeCycle)((Object)this.appHandlerPrototype)).onDestroy();
            }
            this.appHandlerPrototype = null;
        }
    }

    private void initCurrentHandler() {
        this.injectContext(this.appHandlerPrototype);
        if (this.ioHandlerContext.isLifeCycleHandler()) {
            ((ILifeCycle)((Object)this.appHandlerPrototype)).onInit();
        }
    }

    @Override
    public final int getLocalPort() {
        return this.address.getPort();
    }

    @Override
    public final InetAddress getLocalAddress() {
        return this.address.getAddress();
    }

    @Override
    public final int getReceiveBufferPreallocationSize() {
        LOG.warning("not implemented. Method will be removed");
        return -1;
    }

    @Override
    public void setReceiveBufferPreallocationSize(int size) {
        LOG.warning("not implemented. Method will be removed");
    }

    @Override
    public void setConnectionTimeoutSec(int timeoutSec) {
        this.connectionTimeoutSec = timeoutSec;
    }

    @Override
    public void setIdleTimeoutSec(int timeoutSec) {
        this.idleTimeoutSec = timeoutSec;
    }

    @Override
    public int getConnectionTimeoutSec() {
        return this.connectionTimeoutSec;
    }

    @Override
    public int getIdleTimeoutSec() {
        return this.idleTimeoutSec;
    }

    int getNumberOfOpenConnections() {
        return this.acceptor.getNumberOfOpenConnections();
    }

    long getNumberOfHandledConnections() {
        return -1L;
    }

    private String getVersionInfo(String packName) {
        Package p = Package.getPackage(packName);
        if (p != null) {
            String implVersion = p.getImplementationVersion();
            if (implVersion == null) {
                implVersion = "";
            }
            return implVersion;
        }
        return "";
    }

    private void injectContext(IHandler hdl) {
        Field[] fields;
        HandlerContext ctx = null;
        for (Field field : fields = hdl.getClass().getDeclaredFields()) {
            if (field.getType() != IServerContext.class || field.getAnnotation(Resource.class) == null) continue;
            field.setAccessible(true);
            try {
                if (ctx == null) {
                    ctx = new HandlerContext();
                }
                field.set(hdl, ctx);
            }
            catch (IllegalAccessException iae) {
                LOG.warning("couldn't set HandlerContext for attribute " + field.getName() + ". Reason " + iae.toString());
            }
        }
    }

    static {
        String serverIoProviderClassname = System.getProperty("org.xsocket.stream.io.spi.ServerIoProviderClass");
        if (serverIoProviderClassname != null) {
            try {
                Class<?> serverIoProviderClass = Class.forName(serverIoProviderClassname);
                serverIoProvider = (IServerIoProvider)serverIoProviderClass.newInstance();
            }
            catch (Exception e) {
                LOG.warning("error occured by creating ServerIoProivder " + serverIoProviderClassname + ": " + e.toString());
                LOG.info("using default ServerIoProvider");
            }
        }
        if (serverIoProvider == null) {
            serverIoProvider = new IoProvider();
        }
    }

    private final class HandlerContext
    implements IServerContext {
        private HandlerContext() {
        }

        public int getLocalePort() {
            return MultithreadedServer.this.getLocalPort();
        }

        public InetAddress getLocaleAddress() {
            return MultithreadedServer.this.getLocalAddress();
        }

        public int getNumberOfOpenConnections() {
            return MultithreadedServer.this.getNumberOfOpenConnections();
        }

        public IWorkerPool getWorkerPool() {
            return MultithreadedServer.this.getWorkerPool();
        }

        public Executor getWorkerpool() {
            return MultithreadedServer.this.getWorkerpool();
        }

        public int getReceiveBufferPreallocationSize() {
            return MultithreadedServer.this.getReceiveBufferPreallocationSize();
        }
    }

    private final class AcceptorCallback
    implements IAcceptorCallback {
        private AcceptorCallback() {
        }

        public void onConnected() {
            String verInfo;
            MultithreadedServer.this.address = MultithreadedServer.this.acceptor.getLocalAddress();
            MultithreadedServer.this.isOpen = true;
            MultithreadedServer.this.initCurrentHandler();
            for (IMutlithreadedServerListener listener : (ArrayList)MultithreadedServer.this.listeners.clone()) {
                listener.onInit();
            }
            String versionInfo = MultithreadedServer.this.getVersionInfo("org.xsocket").trim();
            if (versionInfo.length() > 0) {
                versionInfo = "xSocket " + versionInfo;
            }
            if (!(serverIoProvider instanceof IoProvider) && (verInfo = MultithreadedServer.this.getVersionInfo(serverIoProvider.getClass().getPackage().getName())).length() > 0) {
                versionInfo = versionInfo + "; " + serverIoProvider.getClass().getName() + " " + verInfo;
            }
            LOG.info("server listening on " + MultithreadedServer.this.acceptor.getLocalAddress().toString() + " (" + versionInfo + ")");
        }

        public void onDisconnected() {
            MultithreadedServer.this.destroyCurrentHandler();
            for (IMutlithreadedServerListener listener : (ArrayList)MultithreadedServer.this.listeners.clone()) {
                listener.onDestroy();
            }
            LOG.info("server has been shutdown");
        }

        public void onConnectionAccepted(IIoHandler ioHandler) throws IOException {
            IHandler hdl;
            block3: {
                hdl = MultithreadedServer.this.appHandlerPrototype;
                if (MultithreadedServer.this.ioHandlerContext.isAppHandlerConnectionScoped()) {
                    try {
                        hdl = (IHandler)((IConnectionScoped)((Object)MultithreadedServer.this.appHandlerPrototype)).clone();
                    }
                    catch (CloneNotSupportedException cne) {
                        if (!LOG.isLoggable(Level.FINE)) break block3;
                        LOG.fine("error occured by cloning appHandler " + MultithreadedServer.this.appHandlerPrototype.getClass().getName() + ". " + cne.toString());
                    }
                }
            }
            NonBlockingConnection connection = new NonBlockingConnection(MultithreadedServer.this.ioHandlerContext, ioHandler, hdl, serverIoProvider);
            connection.setIdleTimeoutSec(MultithreadedServer.this.idleTimeoutSec);
            connection.setConnectionTimeoutSec(MultithreadedServer.this.connectionTimeoutSec);
        }
    }
}

