/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.xsocket.IDispatcher;
import org.xsocket.IWorkerPool;
import org.xsocket.stream.IMultithreadedServer;
import org.xsocket.stream.IMutlithreadedServerListener;
import org.xsocket.stream.MultithreadedServer;
import org.xsocket.stream.io.impl.JmxIoProvider;
import org.xsocket.stream.io.spi.IServerIoJmxProvider;

public final class MultithreadedServerMBeanProxyFactory {
    private static final Logger LOG = Logger.getLogger(MultithreadedServerMBeanProxyFactory.class.getName());
    private static IServerIoJmxProvider jmxProvider = null;

    public static void createAndRegister(MultithreadedServer server) throws JMException {
        MultithreadedServerMBeanProxyFactory.createAndRegister(server, "org.xsocket.stream");
    }

    public static void createAndRegister(MultithreadedServer server, String domain) throws JMException {
        MultithreadedServerMBeanProxyFactory.createAndRegister(ManagementFactory.getPlatformMBeanServer(), server, domain);
    }

    public static void createAndRegister(MBeanServer mbeanServer, MultithreadedServer server, String domain) throws JMException {
        ObjectName objectName = new ObjectName(domain + ":type=MultithreadedServer,name=" + server.getLocalPort());
        Object mbean = jmxProvider.createMBean(server, server.getAcceptor(), domain);
        ManagementFactory.getPlatformMBeanServer().registerMBean(mbean, objectName);
        server.addListener(new Listener(server, domain));
    }

    private static void unregister(IMultithreadedServer server, String domain) throws JMException {
        ObjectName objectName = new ObjectName(domain + ":type=MultithreadedServer,name=" + server.getLocalPort());
        ManagementFactory.getPlatformMBeanServer().unregisterMBean(objectName);
    }

    static {
        String jmxIoProviderClassname = System.getProperty("org.xsocket.stream.io.spi.ServerIoJmxProviderClass");
        if (jmxIoProviderClassname != null) {
            try {
                Class<?> jmxProviderClass = Class.forName(jmxIoProviderClassname);
                jmxProvider = (IServerIoJmxProvider)jmxProviderClass.newInstance();
            }
            catch (Exception e) {
                LOG.warning("error occured by creating jmxProivder " + jmxIoProviderClassname + ": " + e.toString());
            }
        }
        if (jmxProvider == null) {
            jmxProvider = new JmxIoProvider();
        }
    }

    private static final class Listener
    implements IMutlithreadedServerListener {
        private static final Logger LOG = Logger.getLogger(Listener.class.getName());
        private MultithreadedServer server = null;
        private String domain = null;

        Listener(MultithreadedServer server, String domain) {
            this.server = server;
            this.domain = domain;
            server.addListener(this);
        }

        public void onInit() {
        }

        public void onDestroy() {
            block2: {
                try {
                    MultithreadedServerMBeanProxyFactory.unregister(this.server, this.domain);
                }
                catch (Exception ex) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("error occured by deregistering the server (domain=" + this.domain + "). reason: " + ex.toString());
                }
            }
        }

        public void onWorkerPoolUpdated(IWorkerPool oldWorkerPool, IWorkerPool newWorkerPool) {
        }

        public void onDispatcherAdded(IDispatcher dispatcher) {
        }

        public void onDispatcherRemoved(IDispatcher dispatcher) {
        }
    }
}

