/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xsocket.ClosedConnectionException;
import org.xsocket.DataConverter;
import org.xsocket.ILifeCycle;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.stream.BlockingConnection;
import org.xsocket.stream.Connection;
import org.xsocket.stream.IConnectHandler;
import org.xsocket.stream.IConnection;
import org.xsocket.stream.IConnectionScoped;
import org.xsocket.stream.IDataHandler;
import org.xsocket.stream.IDisconnectHandler;
import org.xsocket.stream.IHandler;
import org.xsocket.stream.INonBlockingConnection;
import org.xsocket.stream.ITimeoutHandler;
import org.xsocket.stream.IoHandlerContext;
import org.xsocket.stream.StreamSocketConfiguration;
import org.xsocket.stream.io.spi.IHandlerIoProvider;
import org.xsocket.stream.io.spi.IIoHandler;
import org.xsocket.stream.io.spi.IIoHandlerContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NonBlockingConnection
extends Connection
implements INonBlockingConnection {
    private static final Logger LOG = Logger.getLogger(BlockingConnection.class.getName());
    private static final Executor DEFAULT_WORKER_POOL = Executors.newCachedThreadPool();
    private IHandler appHandler = null;
    private boolean disconnectOccured = false;

    public NonBlockingConnection(String hostname, int port) throws IOException {
        this(InetAddress.getByName(hostname), port);
    }

    public NonBlockingConnection(String hostname, int port, StreamSocketConfiguration socketConfiguration) throws IOException {
        this(InetAddress.getByName(hostname), port, socketConfiguration);
    }

    public NonBlockingConnection(InetAddress address, int port) throws IOException {
        this(new InetSocketAddress(address, port), new HashMap<String, Object>(), null, false, null, null);
    }

    public NonBlockingConnection(InetAddress address, int port, StreamSocketConfiguration socketConfiguration) throws IOException {
        this(new InetSocketAddress(address, port), socketConfiguration.toOptions(), null, false, null, null);
    }

    public NonBlockingConnection(InetAddress address, int port, Map<String, Object> options) throws IOException {
        this(new InetSocketAddress(address, port), options, null, false, null, null);
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler) throws IOException {
        this(new InetSocketAddress(address, port), new HashMap<String, Object>(), null, false, appHandler, DEFAULT_WORKER_POOL);
    }

    public NonBlockingConnection(InetAddress address, int port, StreamSocketConfiguration socketConfiguration, IHandler appHandler) throws IOException {
        this(new InetSocketAddress(address, port), socketConfiguration.toOptions(), null, false, appHandler, DEFAULT_WORKER_POOL);
    }

    public NonBlockingConnection(InetAddress address, int port, StreamSocketConfiguration socketConfiguration, IHandler appHandler, int preallocationMemorySize) throws IOException {
        this(new InetSocketAddress(address, port), socketConfiguration.toOptions(), null, false, appHandler, DEFAULT_WORKER_POOL);
        LOG.warning("parameter preallocation memory size is not more supported. use System.property instead (see JavaDoc org.xsocket.stream.io.impl.IoProvider)");
    }

    public NonBlockingConnection(InetAddress address, int port, Map<String, Object> options, IHandler appHandler) throws IOException {
        this(new InetSocketAddress(address, port), options, null, false, appHandler, DEFAULT_WORKER_POOL);
    }

    public NonBlockingConnection(String hostname, int port, IHandler appHandler) throws IOException {
        this(new InetSocketAddress(hostname, port), new HashMap<String, Object>(), null, false, appHandler, DEFAULT_WORKER_POOL);
    }

    public NonBlockingConnection(String hostname, int port, StreamSocketConfiguration socketConfiguration, IHandler appHandler) throws IOException {
        this(new InetSocketAddress(hostname, port), socketConfiguration.toOptions(), null, false, appHandler, DEFAULT_WORKER_POOL);
    }

    public NonBlockingConnection(String hostname, int port, StreamSocketConfiguration socketConfiguration, IHandler appHandler, int preallocationMemorySize) throws IOException {
        this(new InetSocketAddress(hostname, port), socketConfiguration.toOptions(), null, false, appHandler, DEFAULT_WORKER_POOL);
        LOG.warning("parameter preallocation memory size is not more supported. use System.property instead (see JavaDoc org.xsocket.stream.io.impl.IoProvider)");
    }

    public NonBlockingConnection(String hostname, int port, Map<String, Object> options, IHandler appHandler) throws IOException {
        this(new InetSocketAddress(hostname, port), options, null, false, appHandler, DEFAULT_WORKER_POOL);
    }

    public NonBlockingConnection(InetAddress address, int port, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(address, port), new HashMap<String, Object>(), sslContext, sslOn, null, null);
    }

    public NonBlockingConnection(InetAddress address, int port, StreamSocketConfiguration socketConfiguration, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(address, port), socketConfiguration.toOptions(), sslContext, sslOn, null, null);
    }

    public NonBlockingConnection(InetAddress address, int port, Map<String, Object> options, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(address, port), options, sslContext, sslOn, null, null);
    }

    public NonBlockingConnection(String hostname, int port, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(hostname, port), new HashMap<String, Object>(), sslContext, sslOn, null, null);
    }

    public NonBlockingConnection(String hostname, int port, StreamSocketConfiguration socketConfiguration, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(hostname, port), socketConfiguration.toOptions(), sslContext, sslOn, null, null);
    }

    public NonBlockingConnection(String hostname, int port, Map<String, Object> options, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(hostname, port), options, sslContext, sslOn, null, null);
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler, Executor workerPool) throws IOException {
        this(new InetSocketAddress(address, port), new HashMap<String, Object>(), null, false, appHandler, workerPool);
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler, Executor workerPool, int preallocationMemorySize) throws IOException {
        this(new InetSocketAddress(address, port), new HashMap<String, Object>(), null, false, appHandler, workerPool);
        LOG.warning("parameter preallocation memory size is not more supported. use System.property instead (see JavaDoc org.xsocket.stream.io.impl.IoProvider)");
    }

    private NonBlockingConnection(InetSocketAddress remoteAddress, Map<String, Object> options, SSLContext sslContext, boolean sslOn, IHandler appHandler, Executor workerPool) throws IOException {
        super(new IoHandlerContext(appHandler, workerPool), remoteAddress, options, sslContext, sslOn);
        this.appHandler = appHandler;
        if (LOG.isLoggable(Level.FINE)) {
            if (appHandler instanceof IConnectionScoped) {
                LOG.fine("handler type IConnectionScoped is not supported in the client context");
            }
            if (appHandler instanceof ILifeCycle) {
                LOG.fine("ILifeCycle is not supported in the client context");
            }
        }
        this.init();
    }

    NonBlockingConnection(IIoHandlerContext ctx, IIoHandler ioHandler, IHandler appHandler, IHandlerIoProvider ioProvider) throws IOException {
        super(ctx, ioHandler, ioProvider);
        this.appHandler = appHandler;
        this.init();
    }

    IHandler getAppHandler() {
        return this.appHandler;
    }

    @Override
    void reset() throws IOException {
        block2: {
            try {
                this.setWriteTransferRate(Integer.MAX_VALUE);
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block2;
                LOG.fine("error occured by reseting (setWriteTransferRate). Reason: " + e.toString());
            }
        }
        super.reset();
        this.setFlushmode(INonBlockingConnection.INITIAL_FLUSH_MODE);
    }

    @Override
    public void setWriteTransferRate(int bytesPerSecond) throws ClosedConnectionException, IOException {
        if (bytesPerSecond != Integer.MAX_VALUE && this.getFlushmode() != IConnection.FlushMode.ASYNC) {
            LOG.warning("setWriteTransferRate is only supported for FlushMode ASYNC. Ignore update of the transfer rate");
            return;
        }
        this.setIoHandler(this.getIoProvider().setWriteTransferRate(this.getIoHandler(), bytesPerSecond));
    }

    @Override
    public int getNumberOfAvailableBytes() {
        return this.getReadQueue().getSize();
    }

    @Override
    public ByteBuffer[] readAvailable() throws IOException, ClosedConnectionException {
        LinkedList<ByteBuffer> buffers = this.extractAvailableFromReadQueue();
        if (buffers != null) {
            return buffers.toArray(new ByteBuffer[buffers.size()]);
        }
        return new ByteBuffer[0];
    }

    @Override
    public boolean readAvailableByDelimiter(String delimiter, WritableByteChannel outputChannel) throws IOException, ClosedConnectionException {
        return this.readAvailableByDelimiter(delimiter, this.getDefaultEncoding(), outputChannel);
    }

    @Override
    public boolean readAvailableByDelimiter(String delimiter, String encoding, WritableByteChannel outputChannel) throws IOException, ClosedConnectionException {
        return this.extractAvailableFromReadQueue(delimiter.getBytes(encoding), outputChannel);
    }

    @Override
    public final INonBlockingConnection.TransferResult transferToAvailableByDelimiter(String delimiter, WritableByteChannel outputChannel) throws IOException, ClosedConnectionException {
        return this.transferToAvailableByDelimiter(delimiter, this.getDefaultEncoding(), outputChannel);
    }

    @Override
    public final INonBlockingConnection.TransferResult transferToAvailableByDelimiter(String delimiter, String encoding, WritableByteChannel outputChannel) throws IOException, ClosedConnectionException {
        return this.transferAvailableFromReadQueue(delimiter.getBytes(encoding), outputChannel);
    }

    @Override
    public int read(ByteBuffer buffer) throws IOException {
        ByteBuffer[] bufs;
        int size = buffer.remaining();
        int available = this.getNumberOfAvailableBytes();
        if (available < size) {
            size = available;
        }
        for (ByteBuffer buf : bufs = this.readByteBufferByLength(size)) {
            while (buf.hasRemaining()) {
                buffer.put(buf);
            }
        }
        return size;
    }

    @Override
    public byte readByte() throws IOException, ClosedConnectionException, BufferUnderflowException {
        return this.extractByteFromReadQueue();
    }

    @Override
    public ByteBuffer[] readByteBufferByDelimiter(String delimiter) throws IOException, ClosedConnectionException, BufferUnderflowException {
        return this.readByteBufferByDelimiter(delimiter, Integer.MAX_VALUE);
    }

    @Override
    public ByteBuffer[] readByteBufferByDelimiter(String delimiter, int maxLength) throws IOException, ClosedConnectionException, MaxReadSizeExceededException, BufferUnderflowException {
        return this.readByteBufferByDelimiter(delimiter, this.getDefaultEncoding(), maxLength);
    }

    @Override
    public ByteBuffer[] readByteBufferByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, ClosedConnectionException, MaxReadSizeExceededException {
        LinkedList<ByteBuffer> result = this.extractBytesByDelimiterFromReadQueue(delimiter.getBytes(encoding), maxLength);
        return result.toArray(new ByteBuffer[result.size()]);
    }

    @Override
    public ByteBuffer[] readByteBufferByLength(int length) throws IOException, ClosedConnectionException, BufferUnderflowException {
        LinkedList<ByteBuffer> extracted = this.extractBytesByLength(length);
        return extracted.toArray(new ByteBuffer[extracted.size()]);
    }

    @Override
    public byte[] readBytesByDelimiter(String delimiter) throws IOException, ClosedConnectionException, BufferUnderflowException {
        return this.readBytesByDelimiter(delimiter, Integer.MAX_VALUE);
    }

    @Override
    public byte[] readBytesByDelimiter(String delimiter, int maxLength) throws IOException, ClosedConnectionException, MaxReadSizeExceededException, BufferUnderflowException {
        return this.readBytesByDelimiter(delimiter, this.getDefaultEncoding(), maxLength);
    }

    @Override
    public byte[] readBytesByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, ClosedConnectionException, MaxReadSizeExceededException {
        return DataConverter.toBytes(this.readByteBufferByDelimiter(delimiter, encoding, maxLength));
    }

    @Override
    public byte[] readBytesByLength(int length) throws IOException, ClosedConnectionException, BufferUnderflowException {
        return DataConverter.toBytes(this.readByteBufferByLength(length));
    }

    @Override
    public double readDouble() throws IOException, ClosedConnectionException, BufferUnderflowException {
        return this.extractDoubleFromReadQueue();
    }

    @Override
    public int readInt() throws IOException, ClosedConnectionException, BufferUnderflowException {
        return this.extractIntFromReadQueue();
    }

    @Override
    public short readShort() throws IOException, ClosedConnectionException, BufferUnderflowException {
        return this.extractShortFromReadQueue();
    }

    @Override
    public long readLong() throws IOException, ClosedConnectionException, BufferUnderflowException {
        return this.extractLongFromReadQueue();
    }

    @Override
    public String readStringByDelimiter(String delimiter) throws IOException, ClosedConnectionException, BufferUnderflowException, UnsupportedEncodingException {
        return this.readStringByDelimiter(delimiter, Integer.MAX_VALUE);
    }

    @Override
    public String readStringByDelimiter(String delimiter, int maxLength) throws IOException, ClosedConnectionException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException {
        return this.readStringByDelimiter(delimiter, this.getDefaultEncoding(), maxLength);
    }

    @Override
    public String readStringByDelimiter(String delimiter, String encoding) throws IOException, ClosedConnectionException, BufferUnderflowException, UnsupportedEncodingException {
        return this.readStringByDelimiter(delimiter, encoding, Integer.MAX_VALUE);
    }

    @Override
    public String readStringByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, ClosedConnectionException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException {
        LinkedList<ByteBuffer> extracted = this.extractBytesByDelimiterFromReadQueue(delimiter.getBytes(encoding), maxLength);
        return DataConverter.toString(extracted, encoding);
    }

    @Override
    public String readStringByLength(int length) throws IOException, ClosedConnectionException, BufferUnderflowException, UnsupportedEncodingException {
        return this.readStringByLength(length, this.getDefaultEncoding());
    }

    @Override
    public String readStringByLength(int length, String encoding) throws IOException, ClosedConnectionException, BufferUnderflowException, UnsupportedEncodingException {
        LinkedList<ByteBuffer> extracted = this.extractBytesByLength(length);
        return DataConverter.toString(extracted, encoding);
    }

    @Override
    public int getIndexOf(String str) throws IOException, ClosedConnectionException, BufferUnderflowException {
        return this.getIndexOf(str, Integer.MAX_VALUE);
    }

    @Override
    public int getIndexOf(String str, int maxLength) throws IOException, ClosedConnectionException, BufferUnderflowException, MaxReadSizeExceededException {
        return this.getIndexOf(str, this.getDefaultEncoding(), maxLength);
    }

    @Override
    public int getIndexOf(String str, String encoding, int maxLength) throws IOException, ClosedConnectionException, MaxReadSizeExceededException {
        return this.readIndexOf(str.getBytes(encoding), maxLength);
    }

    @Override
    public INonBlockingConnection setOption(String name, Object value) throws IOException {
        return (INonBlockingConnection)super.setOption(name, value);
    }

    @Override
    protected int onDataEvent() {
        int addSize = super.onDataEvent();
        if (addSize > 0 && this.appHandler != null) {
            boolean remaingDataToHandle = false;
            try {
                do {
                    remaingDataToHandle = false;
                    int insertVersion = this.getReadQueue().getInsertVersionVersion();
                    int sizeBeforeHandle = this.getReadQueue().getSize();
                    try {
                        ((IDataHandler)this.appHandler).onData(this);
                    }
                    catch (MaxReadSizeExceededException mee) {
                        try {
                            this.close();
                        }
                        catch (Exception fe) {
                            // empty catch block
                        }
                        return addSize;
                    }
                    catch (BufferUnderflowException bue) {
                        return addSize;
                    }
                    catch (Exception e) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("[" + this.getId() + "] closing connection because an error has been occured by handling data by appHandler. " + this.appHandler + " Reason: " + e.toString());
                        }
                        try {
                            this.close();
                        }
                        catch (IOException ignore) {
                            // empty catch block
                        }
                        return addSize;
                    }
                    if (this.getReadQueue().isEmpty()) continue;
                    if (insertVersion != this.getReadQueue().getInsertVersionVersion()) {
                        remaingDataToHandle = true;
                        continue;
                    }
                    if (sizeBeforeHandle == this.getReadQueue().getSize()) continue;
                    remaingDataToHandle = true;
                } while (remaingDataToHandle);
            }
            catch (Exception e) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] closing connection because an error has been occured by handling data. Reason: " + e.toString());
                }
                try {
                    this.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
        }
        return addSize;
    }

    @Override
    protected void onConnectEvent() {
        try {
            if (this.appHandler != null && this.getIoHandlerContext().isAppHandlerListenForConnectEvent()) {
                ((IConnectHandler)this.appHandler).onConnect(this);
            }
        }
        catch (MaxReadSizeExceededException mee) {
            try {
                this.close();
            }
            catch (Exception fe) {}
        }
        catch (BufferUnderflowException bue) {
        }
        catch (Exception e) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] closing connection because an error has been occured by on connect data. Reason: " + e.toString());
            }
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void onDisconnectEvent() {
        block4: {
            if (!this.disconnectOccured) {
                this.disconnectOccured = true;
                try {
                    if (this.appHandler != null && this.getIoHandlerContext().isAppHandlerListenforDisconnectEvent()) {
                        ((IDisconnectHandler)this.appHandler).onDisconnect(this);
                    }
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block4;
                    LOG.fine("[" + this.getId() + "] error occured by handling connect. Reason: " + e.toString());
                }
            }
        }
    }

    @Override
    protected boolean onConnectionTimeoutEvent() {
        if (this.getIoHandlerContext().isAppHandlerListenForTimeoutEvent()) {
            try {
                if (this.appHandler != null) {
                    boolean isHandled = ((ITimeoutHandler)this.appHandler).onConnectionTimeout(this);
                    return isHandled;
                }
            }
            catch (MaxReadSizeExceededException mee) {
                try {
                    this.close();
                }
                catch (Exception fe) {}
            }
            catch (BufferUnderflowException bue) {
            }
            catch (Exception e) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] closing connection because an error has been occured by on connect timeout. Reason: " + e.toString());
                }
                try {
                    this.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    @Override
    protected boolean onIdleTimeoutEvent() {
        if (this.getIoHandlerContext().isAppHandlerListenForTimeoutEvent()) {
            try {
                if (this.appHandler != null) {
                    boolean isHandled = ((ITimeoutHandler)this.appHandler).onIdleTimeout(this);
                    return isHandled;
                }
            }
            catch (MaxReadSizeExceededException mee) {
                try {
                    this.close();
                }
                catch (Exception fe) {}
            }
            catch (BufferUnderflowException bue) {
            }
            catch (Exception e) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] closing connection because an error has been occured by on idle timeout. Reason: " + e.toString());
                }
                try {
                    this.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return false;
    }
}

