/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.ClosedConnectionException;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.stream.AbstractConnectionPool;
import org.xsocket.stream.IConnectHandler;
import org.xsocket.stream.IConnection;
import org.xsocket.stream.IDataHandler;
import org.xsocket.stream.IDisconnectHandler;
import org.xsocket.stream.IHandler;
import org.xsocket.stream.INonBlockingConnection;
import org.xsocket.stream.ITimeoutHandler;
import org.xsocket.stream.NonBlockingConnection;
import org.xsocket.stream.WaitTimeoutException;

public final class NonBlockingConnectionPool
extends AbstractConnectionPool {
    private static final Logger LOG = Logger.getLogger(NonBlockingConnectionPool.class.getName());
    public static final long UNLIMITED_TIMEOUT = Long.MAX_VALUE;

    public NonBlockingConnectionPool(long timeToIdleMillis) {
        this(timeToIdleMillis, Integer.MAX_VALUE, -1L);
    }

    public NonBlockingConnectionPool(long timeToIdleMillis, int maxActive, long maxWaitTimeMillis) {
        super(timeToIdleMillis, Long.MAX_VALUE, maxActive, maxWaitTimeMillis, Integer.MAX_VALUE);
    }

    public INonBlockingConnection getNonBlockingConnection(String host, int port) throws IOException, WaitTimeoutException {
        return (INonBlockingConnection)((Object)this.getConnection(new InetSocketAddress(host, port), null));
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port) throws IOException, WaitTimeoutException {
        return (INonBlockingConnection)((Object)this.getConnection(new InetSocketAddress(address, port), null));
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, IHandler appHandler) throws IOException, WaitTimeoutException {
        return this.getNonBlockingConnection(address, port, appHandler, null);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, IHandler appHandler, Executor workerPool) throws IOException, WaitTimeoutException {
        return this.getConnection(new InetSocketAddress(address, port), appHandler, workerPool);
    }

    private INonBlockingConnection getConnection(InetSocketAddress address, IHandler appHandler, Executor workerPool) throws IOException, WaitTimeoutException {
        PoolableNonBlockingConnection connection = (PoolableNonBlockingConnection)this.getConnection(address, workerPool);
        if (connection != null) {
            connection.setHandler(appHandler);
            connection.notiyConnect();
            return connection;
        }
        throw new IOException("couldn't create a connection to " + address);
    }

    AbstractConnectionPool.PoolableConnection createConnection(InetSocketAddress address, Executor workerPool) throws IOException {
        if (workerPool != null) {
            return new PoolableNonBlockingConnection(address, workerPool);
        }
        return new PoolableNonBlockingConnection(address);
    }

    private static final class HandlerProxy
    implements IDataHandler,
    IDisconnectHandler,
    ITimeoutHandler {
        private PoolableNonBlockingConnection poolableConnection = null;
        private IHandler handler = null;
        private boolean isDataHandler = false;
        private boolean isConnectHandler = false;
        private boolean isDisconnectHandler = false;
        private boolean isTimeoutHandler = false;

        private HandlerProxy() {
        }

        void init(PoolableNonBlockingConnection poolableConnection) {
            this.poolableConnection = poolableConnection;
        }

        void setHandler(IHandler handler) {
            this.handler = handler;
            if (handler != null) {
                this.isDataHandler = handler instanceof IDataHandler;
                this.isConnectHandler = handler instanceof IConnectHandler;
                this.isDisconnectHandler = handler instanceof IDisconnectHandler;
                this.isTimeoutHandler = handler instanceof ITimeoutHandler;
            }
        }

        void notifyConnect(INonBlockingConnection connection) throws IOException {
            if (this.isConnectHandler) {
                ((IConnectHandler)this.handler).onConnect(this.poolableConnection);
            }
        }

        public boolean onData(INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            if (this.isDataHandler) {
                ((IDataHandler)this.handler).onData(this.poolableConnection);
            }
            return true;
        }

        public boolean onDisconnect(INonBlockingConnection connection) throws IOException {
            if (this.isDisconnectHandler) {
                ((IDisconnectHandler)this.handler).onDisconnect(this.poolableConnection);
            }
            this.poolableConnection.reallyClose();
            return true;
        }

        public boolean onConnectionTimeout(INonBlockingConnection connection) throws IOException {
            this.poolableConnection.setReuseable(false);
            boolean isHandled = false;
            if (this.isTimeoutHandler) {
                isHandled = ((ITimeoutHandler)this.handler).onConnectionTimeout(this.poolableConnection);
            }
            if (!isHandled) {
                this.poolableConnection.reallyClose();
            }
            return true;
        }

        public boolean onIdleTimeout(INonBlockingConnection connection) throws IOException {
            this.poolableConnection.setReuseable(false);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("idle timout occured for pooled connection " + this.poolableConnection.getId());
            }
            boolean isHandled = false;
            if (this.isTimeoutHandler) {
                isHandled = ((ITimeoutHandler)this.handler).onIdleTimeout(this.poolableConnection);
            }
            if (!isHandled) {
                this.poolableConnection.reallyClose();
            }
            return true;
        }
    }

    private final class PoolableNonBlockingConnection
    extends AbstractConnectionPool.PoolableConnection
    implements INonBlockingConnection {
        public PoolableNonBlockingConnection(InetSocketAddress address) throws IOException {
            super(NonBlockingConnectionPool.this, new NonBlockingConnection(address.getAddress(), address.getPort(), (IHandler)new HandlerProxy()), address);
            this.getHandlerProxy().init(this);
        }

        public PoolableNonBlockingConnection(InetSocketAddress address, Executor workerPool) throws IOException {
            super(NonBlockingConnectionPool.this, new NonBlockingConnection(address.getAddress(), address.getPort(), (IHandler)new HandlerProxy(), workerPool), address);
            this.getHandlerProxy().init(this);
        }

        public INonBlockingConnection setOption(String name, Object value) throws IOException {
            return this.getUnderlyingConnection().setOption(name, value);
        }

        void setHandler(IHandler handler) {
            this.getHandlerProxy().setHandler(handler);
        }

        private HandlerProxy getHandlerProxy() {
            return (HandlerProxy)this.getUnderlyingConnection().getAppHandler();
        }

        void notiyConnect() throws IOException {
            HandlerProxy hdlProxy = (HandlerProxy)this.getUnderlyingConnection().getAppHandler();
            hdlProxy.notifyConnect(this.getUnderlyingConnection());
        }

        void reset() throws IOException {
            this.setHandler(null);
            super.reset();
        }

        public void setFlushmode(IConnection.FlushMode flushMode) {
            this.getUnderlyingConnection().setFlushmode(flushMode);
        }

        public IConnection.FlushMode getFlushmode() {
            return this.getUnderlyingConnection().getFlushmode();
        }

        public void setWriteTransferRate(int bytesPerSecond) throws ClosedConnectionException, IOException {
            this.getUnderlyingConnection().setWriteTransferRate(bytesPerSecond);
        }

        public ByteBuffer[] readAvailable() throws IOException, ClosedConnectionException {
            return this.getUnderlyingConnection().readAvailable();
        }

        public boolean readAvailableByDelimiter(String delimiter, WritableByteChannel outputChannel) throws IOException, ClosedConnectionException {
            return this.getUnderlyingConnection().readAvailableByDelimiter(delimiter, outputChannel);
        }

        public boolean readAvailableByDelimiter(String delimiter, String encoding, WritableByteChannel outputChannel) throws IOException, ClosedConnectionException {
            return this.getUnderlyingConnection().readAvailableByDelimiter(delimiter, encoding, outputChannel);
        }

        public INonBlockingConnection.TransferResult transferToAvailableByDelimiter(String delimiter, String encoding, WritableByteChannel outputChannel) throws ClosedConnectionException, IOException, SocketTimeoutException {
            return this.getUnderlyingConnection().transferToAvailableByDelimiter(delimiter, encoding, outputChannel);
        }

        public INonBlockingConnection.TransferResult transferToAvailableByDelimiter(String delimiter, WritableByteChannel outputChannel) throws ClosedConnectionException, IOException, SocketTimeoutException {
            return this.getUnderlyingConnection().transferToAvailableByDelimiter(delimiter, outputChannel);
        }

        public int getNumberOfAvailableBytes() {
            return this.getUnderlyingConnection().getNumberOfAvailableBytes();
        }

        public int indexOf(String str) {
            return this.getUnderlyingConnection().indexOf(str);
        }

        private NonBlockingConnection getUnderlyingConnection() {
            return (NonBlockingConnection)this.getDelegee();
        }
    }
}

