/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.util.concurrent.CountDownLatch;
import org.xsocket.IDispatcher;
import org.xsocket.IWorkerPool;
import org.xsocket.stream.IMultithreadedServer;
import org.xsocket.stream.IMutlithreadedServerListener;
import org.xsocket.stream.INonBlockingConnection;

public final class StreamUtils {
    public static final String SERVER_TRHREAD_PREFIX = "xServer";

    private StreamUtils() {
    }

    public static int validateSufficientDatasizeByIntLengthField(INonBlockingConnection connection) throws IOException, BufferUnderflowException {
        connection.resetToReadMark();
        connection.markReadPosition();
        int length = connection.readInt();
        if (connection.getNumberOfAvailableBytes() < length) {
            throw new BufferUnderflowException();
        }
        connection.removeReadMark();
        return length;
    }

    public static void start(IMultithreadedServer server) {
        final CountDownLatch startedSignal = new CountDownLatch(1);
        IMutlithreadedServerListener startupListener = new IMutlithreadedServerListener(){

            public void onInit() {
                startedSignal.countDown();
            }

            public void onWorkerPoolUpdated(IWorkerPool oldWorkerPool, IWorkerPool newWorkerPool) {
            }

            public void onDispatcherRemoved(IDispatcher dispatcher) {
            }

            public void onDispatcherAdded(IDispatcher dispatcher) {
            }

            public void onDestroy() {
            }
        };
        server.addListener(startupListener);
        Thread t = new Thread(server);
        t.start();
        try {
            startedSignal.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("start signal doesn't occured. " + e.toString());
        }
        t.setName("xServer:" + server.getLocalPort());
        server.removeListener(startupListener);
    }
}

