/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream.io.impl;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xsocket.IDispatcher;
import org.xsocket.stream.io.impl.IoProvider;
import org.xsocket.stream.io.impl.IoSocketDispatcher;
import org.xsocket.stream.io.impl.IoSocketDispatcherPool;
import org.xsocket.stream.io.impl.IoSocketHandler;
import org.xsocket.stream.io.spi.IAcceptor;
import org.xsocket.stream.io.spi.IAcceptorCallback;
import org.xsocket.stream.io.spi.IIoHandler;
import org.xsocket.stream.io.spi.IIoHandlerContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Acceptor
implements IAcceptor {
    private static final Logger LOG = Logger.getLogger(Acceptor.class.getName());
    private static final Map<String, Class> SUPPORTED_OPTIONS = new HashMap<String, Class>();
    private static final IoProvider IO_PROVIDER;
    private IAcceptorCallback callback = null;
    private IIoHandlerContext handlerContext = null;
    private volatile boolean isRunning = true;
    private InetSocketAddress address = null;
    private ServerSocketChannel serverChannel = null;
    private int backlog = 0;
    private boolean sslOn = false;
    private SSLContext sslContext = null;
    private final IoSocketDispatcherPool dispatcherPool = new IoSocketDispatcherPool(IoProvider.getReadBufferPreallocationsizeServer(), IoProvider.isUseDirectReadBufferServer());
    private long handledConnections = 0L;

    public Acceptor(IAcceptorCallback callback, IIoHandlerContext handlerContext, InetSocketAddress address, int backlog) throws IOException {
        this(callback, handlerContext, address, backlog, null, false);
    }

    public Acceptor(IAcceptorCallback callback, IIoHandlerContext handlerContext, InetSocketAddress address, int backlog, SSLContext sslContext, boolean sslOn) throws IOException {
        this.callback = callback;
        this.address = address;
        this.handlerContext = handlerContext;
        this.backlog = backlog;
        this.sslContext = sslContext;
        this.sslOn = sslOn;
        LOG.fine("try to bind server on " + address);
        this.serverChannel = ServerSocketChannel.open();
        this.serverChannel.configureBlocking(true);
        this.serverChannel.socket().setSoTimeout(0);
        this.serverChannel.socket().setReuseAddress(true);
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return new InetSocketAddress(this.serverChannel.socket().getInetAddress(), this.serverChannel.socket().getLocalPort());
    }

    void setOption(String name, Object value) throws IOException {
        if (name.equals("SOL_SOCKET.SO_RCVBUF")) {
            this.serverChannel.socket().setReceiveBufferSize((Integer)value);
        } else if (name.equals("SOL_SOCKET.SO_REUSEADDR")) {
            this.serverChannel.socket().setReuseAddress((Boolean)value);
        } else {
            LOG.warning("option " + name + " is not supproted for " + this.getClass().getName());
        }
    }

    @Override
    public Object getOption(String name) throws IOException {
        if (name.equals("SOL_SOCKET.SO_RCVBUF")) {
            return this.serverChannel.socket().getReceiveBufferSize();
        }
        if (name.equals("SOL_SOCKET.SO_REUSEADDR")) {
            return this.serverChannel.socket().getReuseAddress();
        }
        LOG.warning("option " + name + " is not supproted for " + this.getClass().getName());
        return null;
    }

    @Override
    public Map<String, Class> getOptions() {
        return Collections.unmodifiableMap(SUPPORTED_OPTIONS);
    }

    @Override
    public void listen() throws IOException {
        try {
            this.setDispatcherPoolSize(Runtime.getRuntime().availableProcessors() + 1);
            assert (this.serverChannel != null);
            this.serverChannel.socket().bind(this.address, this.backlog);
            this.callback.onConnected();
            this.accept();
        }
        catch (BindException be) {
            if (this.serverChannel != null) {
                this.serverChannel.close();
            }
            LOG.info("error occured while binding server on on " + this.address + ". Reason: " + be.toString());
            throw be;
        }
    }

    private void accept() {
        this.dispatcherPool.run();
        while (this.isRunning) {
            try {
                SocketChannel channel = this.serverChannel.accept();
                IoSocketDispatcher dispatcher = this.dispatcherPool.nextDispatcher();
                IIoHandler ioHandler = IO_PROVIDER.createIoHandler(this.handlerContext, false, dispatcher, channel, this.sslContext, this.sslOn);
                this.callback.onConnectionAccepted(ioHandler);
                ++this.handledConnections;
            }
            catch (Throwable t) {
                if (!LOG.isLoggable(Level.FINE) || !this.serverChannel.isOpen()) continue;
                LOG.fine("error occured while accepting connection: " + t.toString());
            }
        }
    }

    public void setDispatcherPoolSize(int size) {
        this.dispatcherPool.setSize(size);
    }

    public int getDispatcherPoolSize() {
        return this.dispatcherPool.getDispatchers().size();
    }

    public int getReceiveBufferPreallocationSize() {
        return this.dispatcherPool.getReceiveBufferPreallocationSize();
    }

    public void setReceiveBufferPreallocationSize(int size) {
        this.dispatcherPool.setReceiveBufferPreallocationSize(size);
    }

    public List<String> getOpenConnections() {
        ArrayList<String> result = new ArrayList<String>();
        for (IDispatcher<IoSocketHandler> dispatcher : this.dispatcherPool.getDispatchers()) {
            for (IoSocketHandler handler : dispatcher.getRegistered()) {
                result.add(handler.toString());
            }
        }
        return result;
    }

    List<IDispatcher<IoSocketHandler>> getDispatchers() {
        return this.dispatcherPool.getDispatchers();
    }

    @Override
    public int getNumberOfOpenConnections() {
        return this.getOpenConnections().size();
    }

    IoSocketDispatcherPool getDispatcherPool() {
        return this.dispatcherPool;
    }

    public long getNumberOfHandledConnections() {
        return this.handledConnections;
    }

    public long getNumberOfConnectionTimeouts() {
        return this.dispatcherPool.getNumberOfConnectionTimeouts();
    }

    public long getNumberOfIdleTimeouts() {
        return this.dispatcherPool.getNumberOfIdleTimeouts();
    }

    @Override
    public void close() throws IOException {
        if (this.isRunning) {
            this.isRunning = false;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("closing acceptor");
            }
            try {
                this.serverChannel.close();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            try {
                this.dispatcherPool.shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.callback.onDisconnected();
        }
    }

    static {
        SUPPORTED_OPTIONS.put("SOL_SOCKET.SO_RCVBUF", Integer.class);
        SUPPORTED_OPTIONS.put("SOL_SOCKET.SO_REUSEADDR", Boolean.class);
        IO_PROVIDER = new IoProvider();
    }
}

