/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream.io.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Map;
import org.xsocket.stream.io.spi.IIoHandler;
import org.xsocket.stream.io.spi.IIoHandlerCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ChainableIoHandler
implements IIoHandler {
    private ChainableIoHandler successor = null;
    private ChainableIoHandler previous = null;
    private IIoHandlerCallback callback = null;

    public ChainableIoHandler(ChainableIoHandler successor) {
        this.setSuccessor(successor);
    }

    public final ChainableIoHandler getSuccessor() {
        return this.successor;
    }

    protected final void setSuccessor(ChainableIoHandler successor) {
        this.successor = successor;
        if (successor != null) {
            successor.setPrevious(this);
        }
    }

    protected final void setPrevious(ChainableIoHandler previous) {
        this.previous = previous;
    }

    protected final ChainableIoHandler getPrevious() {
        return this.previous;
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.getSuccessor().getLocalAddress();
    }

    @Override
    public int getPendingWriteDataSize() {
        ChainableIoHandler successor = this.getSuccessor();
        if (successor != null) {
            return successor.getPendingWriteDataSize();
        }
        return 0;
    }

    int getPendingReceiveDataSize() {
        ChainableIoHandler successor = this.getSuccessor();
        if (successor != null) {
            return successor.getPendingReceiveDataSize();
        }
        return 0;
    }

    @Override
    public void suspendRead() throws IOException {
        ChainableIoHandler successor = this.getSuccessor();
        if (successor != null) {
            successor.suspendRead();
        }
    }

    @Override
    public void resumeRead() throws IOException {
        ChainableIoHandler successor = this.getSuccessor();
        if (successor != null) {
            successor.resumeRead();
        }
    }

    @Override
    public String getId() {
        return this.getSuccessor().getId();
    }

    void setPreviousCallback(IIoHandlerCallback callback) {
        this.callback = callback;
    }

    IIoHandlerCallback getPreviousCallback() {
        return this.callback;
    }

    @Override
    public int getLocalPort() {
        return this.getSuccessor().getLocalPort();
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.getSuccessor().getRemoteAddress();
    }

    @Override
    public int getRemotePort() {
        return this.getSuccessor().getRemotePort();
    }

    @Override
    public boolean isOpen() {
        return this.getSuccessor().isOpen();
    }

    @Override
    public void setIdleTimeoutSec(int timeout) {
        this.getSuccessor().setIdleTimeoutSec(timeout);
    }

    @Override
    public void setConnectionTimeoutSec(int timeout) {
        this.getSuccessor().setConnectionTimeoutSec(timeout);
    }

    @Override
    public int getConnectionTimeoutSec() {
        return this.getSuccessor().getConnectionTimeoutSec();
    }

    @Override
    public int getIdleTimeoutSec() {
        return this.getSuccessor().getIdleTimeoutSec();
    }

    @Override
    public Object getOption(String name) throws IOException {
        return this.getSuccessor().getOption(name);
    }

    @Override
    public Map<String, Class> getOptions() {
        return this.getSuccessor().getOptions();
    }

    @Override
    public void setOption(String name, Object value) throws IOException {
        this.getSuccessor().setOption(name, value);
    }

    public abstract void flushOutgoing() throws IOException;

    @Override
    public abstract LinkedList<ByteBuffer> drainIncoming();

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName() + "#" + this.hashCode());
        ChainableIoHandler ioHandler = this;
        while (ioHandler.getPrevious() != null) {
            ioHandler = ioHandler.getPrevious();
        }
        String forwardChain = "";
        while (ioHandler != null) {
            forwardChain = forwardChain + ioHandler.getClass().getSimpleName() + " > ";
            ioHandler = ioHandler.getSuccessor();
        }
        forwardChain = forwardChain.trim();
        forwardChain = forwardChain.substring(0, forwardChain.length() - 1);
        sb.append(" (forward chain: " + forwardChain.trim() + ")");
        return sb.toString();
    }
}

