/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream.io.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.rmi.server.UID;
import java.security.SecureRandom;
import java.util.LinkedList;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xsocket.DataConverter;
import org.xsocket.stream.io.impl.Acceptor;
import org.xsocket.stream.io.impl.ChainableIoHandler;
import org.xsocket.stream.io.impl.IMemoryManager;
import org.xsocket.stream.io.impl.IoActivateableSSLHandler;
import org.xsocket.stream.io.impl.IoMultithreadedHandler;
import org.xsocket.stream.io.impl.IoSSLHandler;
import org.xsocket.stream.io.impl.IoSocketDispatcher;
import org.xsocket.stream.io.impl.IoSocketHandler;
import org.xsocket.stream.io.impl.IoThrottledWriteHandler;
import org.xsocket.stream.io.impl.SynchronizedMemoryManager;
import org.xsocket.stream.io.impl.UnsynchronizedMemoryManager;
import org.xsocket.stream.io.spi.IAcceptor;
import org.xsocket.stream.io.spi.IAcceptorCallback;
import org.xsocket.stream.io.spi.IClientIoProvider;
import org.xsocket.stream.io.spi.IIoHandler;
import org.xsocket.stream.io.spi.IIoHandlerContext;
import org.xsocket.stream.io.spi.IServerIoProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IoProvider
implements IClientIoProvider,
IServerIoProvider {
    private static final Logger LOG = Logger.getLogger(IoProvider.class.getName());
    private static final Timer TIMER = new Timer("xIoTimer", true);
    private static IoSocketDispatcher globalDispatcher = null;
    public static final int DEFAULT_READ_BUFFER_PREALLOCATION_SIZE = 65536;
    public static final boolean DEFAULT_USE_DIRECT_BUFFER = true;
    public static final String USE_DIRECT_READ_BUFFER_CLIENT_KEY = "org.xsocket.stream.UseDirectReadBufferClient";
    public static final String READ_BUFFER_PREALLOCATIONSIZE_CLIENT_KEY = "org.xsocket.stream.ReadBufferPreallocationsizeClient";
    public static final String USE_DIRECT_READ_BUFFER_SERVER_KEY = "org.xsocket.stream.UseDirectReadBufferServer";
    public static final String READ_BUFFER_PREALLOCATIONSIZE_SERVER_KEY = "org.xsocket.stream.ReadBufferPreallocationsizeServer";
    private static Boolean useDirectReadBufferClient = null;
    private static int readBufferPreallocationsizeClient = 65536;
    private static Boolean useDirectReadBufferServer = null;
    private static int readBufferPreallocationsizeServer = 65536;
    private final IMemoryManager sslMemoryManagerServer = new SynchronizedMemoryManager(readBufferPreallocationsizeServer, useDirectReadBufferServer);
    private final IMemoryManager sslMemoryManagerClient = new SynchronizedMemoryManager(readBufferPreallocationsizeClient, useDirectReadBufferClient);
    private final AtomicInteger nextId = new AtomicInteger();
    private static String idPrefix = null;

    @Override
    public IAcceptor createAcceptor(IAcceptorCallback callback, IIoHandlerContext handlerContext, InetSocketAddress address, int backlog, Map<String, Object> options) throws IOException {
        Acceptor acceptor = new Acceptor(callback, handlerContext, address, backlog);
        for (Map.Entry<String, Object> entry : options.entrySet()) {
            acceptor.setOption(entry.getKey(), entry.getValue());
        }
        return acceptor;
    }

    public IAcceptor create(IAcceptorCallback callback, IIoHandlerContext handlerContext, InetSocketAddress address, int backlog, Map<String, Object> options, SSLContext sslContext, boolean sslOn) throws IOException {
        Acceptor acceptor = new Acceptor(callback, handlerContext, address, backlog, sslContext, sslOn);
        for (Map.Entry<String, Object> entry : options.entrySet()) {
            acceptor.setOption(entry.getKey(), entry.getValue());
        }
        return acceptor;
    }

    @Override
    public IIoHandler createClientIoHandler(IIoHandlerContext ctx, InetSocketAddress remoteAddress, Map<String, Object> options) throws IOException {
        return this.createIoHandler(ctx, true, IoProvider.getClientDispatcher(), IoProvider.openSocket(remoteAddress, options), null, false);
    }

    public IIoHandler createSSLClientIoHandler(IIoHandlerContext ctx, InetSocketAddress remoteAddress, Map<String, Object> options, SSLContext sslContext, boolean sslOn) throws IOException {
        return this.createIoHandler(ctx, true, IoProvider.getClientDispatcher(), IoProvider.openSocket(remoteAddress, options), sslContext, sslOn);
    }

    IIoHandler createIoHandler(IIoHandlerContext ctx, boolean isClient, IoSocketDispatcher dispatcher, SocketChannel channel, SSLContext sslContext, boolean sslOn) throws IOException {
        String connectionId = null;
        connectionId = isClient ? idPrefix + ".c." + this.nextId.incrementAndGet() : idPrefix + ".s." + this.nextId.incrementAndGet();
        ChainableIoHandler ioHandler = new IoSocketHandler(channel, dispatcher, ctx, connectionId);
        if (sslContext != null) {
            IMemoryManager mm = null;
            mm = isClient ? this.sslMemoryManagerClient : this.sslMemoryManagerServer;
            ioHandler = sslOn ? new IoSSLHandler(ioHandler, sslContext, isClient, mm) : new IoActivateableSSLHandler(ioHandler, sslContext, isClient, mm);
        }
        if (ctx.isMultithreaded()) {
            ioHandler = new IoMultithreadedHandler(ioHandler, ctx);
        }
        return ioHandler;
    }

    @Override
    public IIoHandler setWriteTransferRate(IIoHandler ioHandler, int bytesPerSecond) throws IOException {
        if (bytesPerSecond == Integer.MAX_VALUE) {
            IoThrottledWriteHandler delayWriter = (IoThrottledWriteHandler)this.getHandler((ChainableIoHandler)ioHandler, IoThrottledWriteHandler.class);
            if (delayWriter != null) {
                delayWriter.flushOutgoing();
                ChainableIoHandler successor = delayWriter.getSuccessor();
                return successor;
            }
            return ioHandler;
        }
        IoThrottledWriteHandler delayWriter = (IoThrottledWriteHandler)this.getHandler((ChainableIoHandler)ioHandler, IoThrottledWriteHandler.class);
        if (delayWriter == null) {
            delayWriter = new IoThrottledWriteHandler((ChainableIoHandler)ioHandler);
        }
        delayWriter.setWriteRateSec(bytesPerSecond);
        return delayWriter;
    }

    public boolean preStartSecuredMode(IIoHandler ioHandler) throws IOException {
        try {
            IoActivateableSSLHandler activateableHandler = (IoActivateableSSLHandler)this.getHandler((ChainableIoHandler)ioHandler, IoActivateableSSLHandler.class);
            if (activateableHandler != null) {
                return activateableHandler.preStartSecuredMode();
            }
            LOG.warning("connection is not SSL activatable (non IoActivateableHandler in chain");
            return false;
        }
        catch (ClassCastException cce) {
            throw new IOException("only ioHandler of tpye " + ChainableIoHandler.class.getName() + " are supported");
        }
    }

    public void startSecuredMode(IIoHandler ioHandler, LinkedList<ByteBuffer> buffers) throws IOException {
        try {
            ((ChainableIoHandler)ioHandler).flushOutgoing();
        }
        catch (ClassCastException cce) {
            throw new IOException("only ioHandler of tpye " + ChainableIoHandler.class.getName() + " are supported");
        }
        IoActivateableSSLHandler activateableHandler = (IoActivateableSSLHandler)this.getHandler((ChainableIoHandler)ioHandler, IoActivateableSSLHandler.class);
        if (activateableHandler != null) {
            activateableHandler.startSecuredMode(buffers);
        } else {
            LOG.warning("connection is not SSL activatable (non IoActivateableHandler in chain");
        }
    }

    static Timer getTimer() {
        return TIMER;
    }

    static boolean isUseDirectReadBufferServer() {
        return useDirectReadBufferServer;
    }

    static int getReadBufferPreallocationsizeServer() {
        return readBufferPreallocationsizeServer;
    }

    private static SocketChannel openSocket(InetSocketAddress remoteAddress, Map<String, Object> options) throws IOException {
        SocketChannel channel = SocketChannel.open();
        for (Map.Entry<String, Object> entry : options.entrySet()) {
            IoProvider.setOption(channel.socket(), entry.getKey(), entry.getValue());
        }
        try {
            channel.socket().connect(remoteAddress);
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("error occured by bindung socket to remote address " + remoteAddress + " " + ioe.toString());
            }
            throw ioe;
        }
        return channel;
    }

    static void setOption(Socket socket, String name, Object value) throws IOException {
        if (name.equals("SOL_SOCKET.SO_RCVBUF")) {
            socket.setReceiveBufferSize((Integer)value);
        } else if (name.equals("SOL_SOCKET.SO_REUSEADDR")) {
            socket.setReuseAddress((Boolean)value);
        } else if (name.equals("SOL_SOCKET.SO_SNDBUF")) {
            socket.setSendBufferSize((Integer)value);
        } else if (name.equals("SOL_SOCKET.SO_KEEPALIVE")) {
            socket.setKeepAlive((Boolean)value);
        } else if (name.equals("IPPROTO_TCP.TCP_NODELAY")) {
            socket.setTcpNoDelay((Boolean)value);
        } else if (name.equals("IPPROTO_TCP.TCP_NODELAY")) {
            socket.setTcpNoDelay((Boolean)value);
        } else if (name.equals("SOL_SOCKET.SO_LINGER")) {
            if (value instanceof Integer) {
                socket.setSoLinger(true, (Integer)value);
            } else if (value instanceof Boolean && ((Boolean)value).equals(Boolean.FALSE)) {
                socket.setSoLinger(Boolean.FALSE, 0);
            }
        } else {
            LOG.warning("option " + name + " is not supported");
        }
    }

    private ChainableIoHandler getHandler(ChainableIoHandler head, Class clazz) {
        ChainableIoHandler handler = head;
        do {
            if (handler.getClass() != clazz) continue;
            return handler;
        } while ((handler = handler.getSuccessor()) != null);
        return null;
    }

    private static synchronized IoSocketDispatcher getClientDispatcher() {
        if (globalDispatcher == null) {
            globalDispatcher = new IoSocketDispatcher(new UnsynchronizedMemoryManager(readBufferPreallocationsizeClient, useDirectReadBufferClient));
            Thread t = new Thread(globalDispatcher);
            t.setName("xDispatcher#CLIENT");
            t.setDaemon(true);
            t.start();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("client dispatcher created (readbuffer preallocation size=" + readBufferPreallocationsizeClient + ", useDirectBuffer=" + useDirectReadBufferClient + ")");
            }
        }
        return globalDispatcher;
    }

    static {
        try {
            useDirectReadBufferClient = Boolean.valueOf(System.getProperty(USE_DIRECT_READ_BUFFER_CLIENT_KEY, Boolean.toString(true)));
        }
        catch (Exception e) {
            LOG.warning("invalid value for system property org.xsocket.stream.UseDirectReadBufferClient: " + System.getProperty(USE_DIRECT_READ_BUFFER_CLIENT_KEY) + " (valid is true|false)" + " using direct buffer");
            useDirectReadBufferClient = Boolean.TRUE;
        }
        try {
            useDirectReadBufferServer = Boolean.valueOf(System.getProperty(USE_DIRECT_READ_BUFFER_SERVER_KEY, Boolean.toString(true)));
        }
        catch (Exception e) {
            LOG.warning("invalid value for system property org.xsocket.stream.UseDirectReadBufferServer: " + System.getProperty(USE_DIRECT_READ_BUFFER_SERVER_KEY) + " (valid is true|false)" + " using direct buffer");
            useDirectReadBufferServer = Boolean.TRUE;
        }
        try {
            readBufferPreallocationsizeClient = Integer.parseInt(System.getProperty(READ_BUFFER_PREALLOCATIONSIZE_CLIENT_KEY, Integer.toString(65536)));
        }
        catch (Exception e) {
            LOG.warning("invalid value for system property org.xsocket.stream.ReadBufferPreallocationsizeClient: " + System.getProperty(READ_BUFFER_PREALLOCATIONSIZE_CLIENT_KEY) + " using default size " + 65536);
            readBufferPreallocationsizeClient = 65536;
        }
        try {
            readBufferPreallocationsizeServer = Integer.parseInt(System.getProperty(READ_BUFFER_PREALLOCATIONSIZE_SERVER_KEY, Integer.toString(65536)));
        }
        catch (Exception e) {
            LOG.warning("invalid value for system property org.xsocket.stream.ReadBufferPreallocationsizeServer: " + System.getProperty(READ_BUFFER_PREALLOCATIONSIZE_SERVER_KEY) + " using default size " + 65536);
            readBufferPreallocationsizeServer = 65536;
        }
        String base = null;
        try {
            base = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (Exception e) {
            base = new UID().toString();
        }
        int random = 0;
        SecureRandom rand = new SecureRandom();
        while ((random = rand.nextInt()) < 0) {
        }
        idPrefix = Integer.toHexString(base.hashCode()) + "." + Long.toHexString(System.currentTimeMillis()) + "." + Integer.toHexString(random);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(IoProvider.class.getName() + " initialized (useDirectReadBufferClient=" + useDirectReadBufferClient + " readBufferPreallocationsizeClient=" + DataConverter.toFormatedBytesSize(readBufferPreallocationsizeClient) + " useDirectReadBufferServer=" + useDirectReadBufferServer + " readBufferPreallocationsizeServer=" + DataConverter.toFormatedBytesSize(readBufferPreallocationsizeServer) + ")");
        }
    }
}

