/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream.io.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xsocket.ByteBufferQueue;
import org.xsocket.ClosedConnectionException;
import org.xsocket.stream.io.impl.ChainableIoHandler;
import org.xsocket.stream.io.impl.IMemoryManager;
import org.xsocket.stream.io.impl.SSLProcessor;
import org.xsocket.stream.io.spi.IIoHandlerCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IoSSLHandler
extends ChainableIoHandler
implements SSLProcessor.EventHandler {
    private static final Logger LOG = Logger.getLogger(IoSSLHandler.class.getName());
    private final ByteBufferQueue outAppDataQueue = new ByteBufferQueue();
    private final ByteBufferQueue inAppDataQueue = new ByteBufferQueue();
    private final IOEventHandler ioEventHandler = new IOEventHandler();
    private SSLProcessor sslProcessor = null;
    private boolean isClientMode = false;
    private boolean isSSLConnected = false;

    IoSSLHandler(ChainableIoHandler successor, SSLContext sslContext, boolean isClientMode, IMemoryManager memoryManager) throws IOException {
        super(successor);
        this.isClientMode = isClientMode;
        this.sslProcessor = new SSLProcessor(sslContext, isClientMode, memoryManager, this);
    }

    @Override
    public void init(IIoHandlerCallback callbackHandler) throws IOException {
        this.setPreviousCallback(callbackHandler);
        this.getSuccessor().init(this.ioEventHandler);
        this.startSSL();
    }

    @Override
    public void setPreviousCallback(IIoHandlerCallback callbackHandler) {
        super.setPreviousCallback(callbackHandler);
        this.getSuccessor().setPreviousCallback(this.ioEventHandler);
    }

    @Override
    public int getPendingWriteDataSize() {
        return this.outAppDataQueue.getSize() + super.getPendingWriteDataSize();
    }

    @Override
    int getPendingReceiveDataSize() {
        return this.inAppDataQueue.getSize() + super.getPendingReceiveDataSize();
    }

    void startSSL() throws IOException {
        if (!this.isSSLConnected) {
            this.sslProcessor.start();
        }
        this.readIncomingEncryptedData();
    }

    @Override
    public LinkedList<ByteBuffer> drainIncoming() {
        return this.inAppDataQueue.drain();
    }

    @Override
    public final void close(boolean immediate) throws IOException {
        if (!immediate) {
            this.flushOutgoing();
        }
        this.getSuccessor().close(immediate);
    }

    @Override
    public final void writeOutgoing(ByteBuffer buffer) throws ClosedConnectionException, IOException {
        LinkedList<ByteBuffer> buffers = new LinkedList<ByteBuffer>();
        buffers.add(buffer);
        this.writeOutgoing(buffers);
    }

    @Override
    public final void writeOutgoing(LinkedList<ByteBuffer> buffers) throws ClosedConnectionException, IOException {
        this.outAppDataQueue.append(buffers);
        this.flushOutgoing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushOutgoing() throws IOException {
        SSLProcessor sSLProcessor = this.sslProcessor;
        synchronized (sSLProcessor) {
            if (!this.sslProcessor.isHandshaking()) {
                if (!this.outAppDataQueue.isEmpty()) {
                    this.sslProcessor.encrypt(this.outAppDataQueue.drain());
                }
            } else {
                this.sslProcessor.encrypt();
            }
        }
    }

    protected final void readIncomingEncryptedData() throws ClosedConnectionException, IOException {
        this.readIncomingEncryptedData(this.getSuccessor().drainIncoming());
    }

    private synchronized void readIncomingEncryptedData(LinkedList<ByteBuffer> inNetDataList) throws ClosedConnectionException, IOException {
        if (inNetDataList != null) {
            if (LOG.isLoggable(Level.FINE)) {
                int size = 0;
                for (ByteBuffer buffer : inNetDataList) {
                    size += buffer.remaining();
                }
                LOG.fine("received " + size + " bytes encrypted data");
            }
            this.sslProcessor.decrypt(inNetDataList);
        }
    }

    @Override
    public void onHandshakeFinished() throws IOException {
        if (!this.isSSLConnected) {
            if (LOG.isLoggable(Level.FINE)) {
                if (this.isClientMode) {
                    LOG.fine("[" + this.getId() + "] handshake has been finished (clientMode)");
                } else {
                    LOG.fine("[" + this.getId() + "] handshake has been finished (serverMode)");
                }
            }
            this.isSSLConnected = true;
            this.getPreviousCallback().onConnect();
        }
        this.flushOutgoing();
        this.readIncomingEncryptedData();
    }

    @Override
    public void onSSLProcessorClosed() throws IOException {
        this.close(true);
    }

    @Override
    public void onDataDecrypted(LinkedList<ByteBuffer> appDataList) {
        this.inAppDataQueue.append(appDataList);
        if (!this.inAppDataQueue.isEmpty()) {
            this.getPreviousCallback().onDataRead();
        }
    }

    @Override
    public void onDataEncrypted(ByteBuffer netData) throws IOException {
        if (netData.hasRemaining()) {
            this.getSuccessor().writeOutgoing(netData);
        }
    }

    private final class IOEventHandler
    implements IIoHandlerCallback {
        private IOEventHandler() {
        }

        public void onDataRead() {
            block4: {
                try {
                    IoSSLHandler.this.readIncomingEncryptedData();
                }
                catch (ClosedConnectionException ce) {
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("[" + IoSSLHandler.this.getId() + "] couldn't handle incoming data. connection is already closed: " + ce.toString());
                    }
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block4;
                    LOG.fine("[" + IoSSLHandler.this.getId() + "] error occured while receiving data. Reason: " + e.toString());
                }
            }
        }

        public void onConnect() {
        }

        public void onWriteException(IOException ioException) {
            IoSSLHandler.this.getPreviousCallback().onWriteException(ioException);
        }

        public void onWritten() {
            IoSSLHandler.this.getPreviousCallback().onWritten();
        }

        public void onDisconnect() {
            IoSSLHandler.this.sslProcessor.destroy();
            IoSSLHandler.this.getPreviousCallback().onDisconnect();
        }

        public void onConnectionAbnormalTerminated() {
            IoSSLHandler.this.getPreviousCallback().onConnectionAbnormalTerminated();
        }

        public void onConnectionTimeout() {
            IoSSLHandler.this.getPreviousCallback().onConnectionTimeout();
        }

        public void onIdleTimeout() {
            IoSSLHandler.this.getPreviousCallback().onIdleTimeout();
        }
    }
}

