/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream.io.impl;

import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.util.Set;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.DataConverter;
import org.xsocket.Dispatcher;
import org.xsocket.IEventHandler;
import org.xsocket.stream.io.impl.IMemoryManager;
import org.xsocket.stream.io.impl.IoProvider;
import org.xsocket.stream.io.impl.IoSocketHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IoSocketDispatcher
extends Dispatcher<IoSocketHandler> {
    private static final Logger LOG = Logger.getLogger(IoSocketDispatcher.class.getName());
    static final String DISPATCHER_PREFIX = "xDispatcher";
    private static final long DEFAULT_WATCHDOG_PERIOD_MILLIS = 300000L;
    private long watchDogPeriod = 300000L;
    private TimerTask watchDogTask = null;
    private IMemoryManager memoryManager = null;
    private long countIdleTimeouts = 0L;
    private long countConnectionTimeouts = 0L;

    IoSocketDispatcher(IMemoryManager memoryManager) {
        super(new DispatcherEventHandler(memoryManager));
        this.memoryManager = memoryManager;
        this.updateTimeoutCheckPeriod(300000L);
    }

    @Override
    public void register(IoSocketHandler handle, int ops) throws IOException {
        handle.setMemoryManager(this.memoryManager);
        super.register(handle, ops);
    }

    public int getPreallocatedReadMemorySize() {
        return this.memoryManager.getFreeBufferSize();
    }

    void updateTimeoutCheckPeriod(long requiredMinPeriod) {
        if (this.watchDogTask != null && this.watchDogPeriod <= requiredMinPeriod) {
            return;
        }
        this.watchDogPeriod = requiredMinPeriod;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("update dispatcher's watchdog task " + DataConverter.toFormatedDuration(this.watchDogPeriod));
        }
        if (this.watchDogTask != null) {
            this.watchDogTask.cancel();
        }
        this.watchDogTask = new TimerTask(){

            public void run() {
                IoSocketDispatcher.this.checkTimeouts();
            }
        };
        IoProvider.getTimer().schedule(this.watchDogTask, this.watchDogPeriod, this.watchDogPeriod);
    }

    @Override
    public void close() {
        super.close();
        if (this.watchDogTask != null) {
            this.watchDogTask.cancel();
        }
    }

    long getCountIdleTimeout() {
        return this.countIdleTimeouts;
    }

    long getCountConnectionTimeout() {
        return this.countConnectionTimeouts;
    }

    void checkTimeouts() {
        block4: {
            try {
                long current = System.currentTimeMillis();
                Set socketHandlers = this.getRegistered();
                for (IoSocketHandler socketHandler : socketHandlers) {
                    this.checkTimeout(socketHandler, current);
                }
            }
            catch (ClosedSelectorException cse) {
                this.watchDogTask.cancel();
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block4;
                LOG.fine("error occured: " + e.toString());
            }
        }
    }

    private void checkTimeout(IoSocketHandler ioSocketHandler, long current) {
        ioSocketHandler.checkConnection();
        boolean timeoutOccured = ioSocketHandler.checkIdleTimeout(current);
        if (timeoutOccured) {
            ++this.countIdleTimeouts;
        }
        if (timeoutOccured = ioSocketHandler.checkConnectionTimeout(current)) {
            ++this.countConnectionTimeouts;
        }
    }

    static boolean isDispatcherThread() {
        return Thread.currentThread().getName().startsWith(DISPATCHER_PREFIX);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DispatcherEventHandler
    implements IEventHandler<IoSocketHandler> {
        private IMemoryManager memoryManager = null;

        DispatcherEventHandler(IMemoryManager memoryManager) {
            this.memoryManager = memoryManager;
        }

        IMemoryManager getMemoryManager() {
            return this.memoryManager;
        }

        @Override
        public void onHandleReadableEvent(IoSocketHandler socketIOHandler) throws IOException {
            socketIOHandler.onReadableEvent();
        }

        @Override
        public void onHandleWriteableEvent(IoSocketHandler socketIOHandler) throws IOException {
            socketIOHandler.onWriteableEvent();
        }

        @Override
        public void onHandleRegisterEvent(IoSocketHandler socketIOHandler) throws IOException {
            socketIOHandler.onConnectEvent();
        }

        @Override
        public void onDispatcherCloseEvent(IoSocketHandler socketIOHandler) {
            socketIOHandler.onDispatcherClose();
        }
    }
}

