/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream.io.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.DataConverter;
import org.xsocket.stream.io.impl.ChainableIoHandler;
import org.xsocket.stream.io.impl.IoProvider;
import org.xsocket.stream.io.spi.IIoHandlerCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IoThrottledWriteHandler
extends ChainableIoHandler {
    private static final Logger LOG = Logger.getLogger(IoThrottledWriteHandler.class.getName());
    private final LinkedList<DelayQueueEntry> sendQueue = new LinkedList();
    private int sendBytesPerSec = Integer.MAX_VALUE;
    private TimerTask delayedDelivererTask = null;

    @Override
    public void init(IIoHandlerCallback callbackHandler) throws IOException {
        this.setPreviousCallback(callbackHandler);
        this.getSuccessor().init(callbackHandler);
    }

    IoThrottledWriteHandler(ChainableIoHandler successor) {
        super(successor);
    }

    void setWriteRateSec(int writeRateSec) {
        this.sendBytesPerSec = writeRateSec;
    }

    @Override
    public int getPendingWriteDataSize() {
        return this.getSendQueueSize() + super.getPendingWriteDataSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSendQueueSize() {
        int size = 0;
        LinkedList copy = null;
        LinkedList<DelayQueueEntry> linkedList = this.sendQueue;
        synchronized (linkedList) {
            copy = (LinkedList)this.sendQueue.clone();
        }
        for (DelayQueueEntry entry : copy) {
            size += entry.buffer.remaining();
        }
        return size;
    }

    @Override
    public LinkedList<ByteBuffer> drainIncoming() {
        return this.getSuccessor().drainIncoming();
    }

    @Override
    public void close(boolean immediate) throws IOException {
        if (!immediate) {
            this.flushOutgoing();
        }
        this.getSuccessor().close(immediate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeOutgoing(ByteBuffer buffer) {
        int size = buffer.remaining();
        if (size > 0) {
            DelayQueueEntry delayQueueEntry = new DelayQueueEntry(buffer.duplicate(), this.sendBytesPerSec);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] add " + delayQueueEntry + " to delay queue");
            }
            LinkedList<DelayQueueEntry> linkedList = this.sendQueue;
            synchronized (linkedList) {
                this.sendQueue.offer(delayQueueEntry);
            }
        }
        if (this.delayedDelivererTask == null) {
            int period = 500;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] delay delivery task is null. Starting task (period=" + DataConverter.toFormatedDuration(period) + ")");
            }
            this.delayedDelivererTask = new DeliveryTask();
            IoProvider.getTimer().schedule(this.delayedDelivererTask, 0L, 500L);
        }
    }

    @Override
    public void writeOutgoing(LinkedList<ByteBuffer> buffers) {
        for (ByteBuffer buffer : buffers) {
            this.writeOutgoing(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushOutgoing() throws IOException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("flush remaning data");
        }
        LinkedList<DelayQueueEntry> linkedList = this.sendQueue;
        synchronized (linkedList) {
            if (!this.sendQueue.isEmpty()) {
                DelayQueueEntry[] entries = this.sendQueue.toArray(new DelayQueueEntry[this.sendQueue.size()]);
                this.sendQueue.clear();
                ByteBuffer[] buffers = new ByteBuffer[entries.length];
                for (int i = 0; i < buffers.length; ++i) {
                    buffers[i] = entries[i].getBuffer();
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] flushing " + buffers.length + " buffers of delay queue");
                }
                for (ByteBuffer buffer : buffers) {
                    try {
                        this.getSuccessor().writeOutgoing(buffer);
                    }
                    catch (Exception e) {
                        if (!LOG.isLoggable(Level.FINE)) continue;
                        LOG.fine("[" + this.getId() + "] error occured while writing. Reason: " + e.toString());
                    }
                }
            }
        }
        this.getSuccessor().flushOutgoing();
    }

    @Override
    public String toString() {
        try {
            return this.getClass().getSimpleName() + "(pending delayQueueSize=" + DataConverter.toFormatedBytesSize(this.getPendingWriteDataSize()) + ") ->" + "\r\n" + this.getSuccessor().toString();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    private final class DelayQueueEntry {
        private ByteBuffer buffer = null;
        private int bytesPerSec = 0;
        private long lastWriteTime = 0L;

        DelayQueueEntry(ByteBuffer buffer, int bytesPerSec) {
            this.buffer = buffer;
            this.bytesPerSec = bytesPerSec;
            this.lastWriteTime = System.currentTimeMillis();
        }

        ByteBuffer getBuffer() {
            return this.buffer;
        }

        int write(long currentTime) throws IOException {
            int sizeToWrite;
            int elapsedTimeSec;
            int remaingSize = this.buffer.remaining();
            long elapsedTimeMillis = currentTime - this.lastWriteTime;
            if (elapsedTimeMillis > 0L && (elapsedTimeSec = (int)elapsedTimeMillis / 1000) > 0 && (sizeToWrite = this.bytesPerSec * elapsedTimeSec) > 0) {
                ByteBuffer bytesToWrite = null;
                if (this.buffer.remaining() <= sizeToWrite) {
                    bytesToWrite = this.buffer;
                    remaingSize = 0;
                } else {
                    int saveLimit = this.buffer.limit();
                    this.buffer.limit(sizeToWrite);
                    bytesToWrite = this.buffer.slice();
                    this.buffer.position(this.buffer.limit());
                    this.buffer.limit(saveLimit);
                    this.buffer = this.buffer.slice();
                    remaingSize = this.buffer.remaining();
                }
                this.lastWriteTime = currentTime;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + IoThrottledWriteHandler.this.getId() + "] release " + sizeToWrite + " bytes from delay queue");
                }
                IoThrottledWriteHandler.this.getSuccessor().writeOutgoing(bytesToWrite);
            }
            return remaingSize;
        }

        public String toString() {
            return "buffer " + DataConverter.toFormatedBytesSize(this.buffer.remaining()) + " (write rate " + this.bytesPerSec + " bytes/sec)";
        }
    }

    private final class DeliveryTask
    extends TimerTask {
        private DeliveryTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LinkedList linkedList = IoThrottledWriteHandler.this.sendQueue;
            synchronized (linkedList) {
                long currentTime = System.currentTimeMillis();
                while (!IoThrottledWriteHandler.this.sendQueue.isEmpty()) {
                    try {
                        DelayQueueEntry qe = (DelayQueueEntry)IoThrottledWriteHandler.this.sendQueue.peek();
                        int remaingSize = qe.write(currentTime);
                        if (remaingSize != 0) break;
                        IoThrottledWriteHandler.this.sendQueue.remove(qe);
                        if (!LOG.isLoggable(Level.FINE)) continue;
                        LOG.fine("throttling write queue is emtpy");
                    }
                    catch (Throwable e) {
                        if (!LOG.isLoggable(Level.FINE)) continue;
                        LOG.fine("[" + IoThrottledWriteHandler.this.getId() + "] Error occured while write delayed. Reason: " + e.toString());
                    }
                }
            }
        }
    }
}

