/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream.io.impl;

import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.ObjectName;
import org.xsocket.Dispatcher;
import org.xsocket.IDispatcher;
import org.xsocket.IWorkerPool;
import org.xsocket.IntrospectionBasedDynamicBean;
import org.xsocket.stream.MultithreadedServer;
import org.xsocket.stream.io.impl.Acceptor;
import org.xsocket.stream.io.impl.IIoSocketDispatcherPoolListener;
import org.xsocket.stream.io.impl.IoSocketHandler;
import org.xsocket.stream.io.spi.IAcceptor;
import org.xsocket.stream.io.spi.IServerIoJmxProvider;

public final class JmxIoProvider
implements IServerIoJmxProvider {
    private static final Logger LOG = Logger.getLogger(JmxIoProvider.class.getName());

    public Object createMBean(MultithreadedServer server, IAcceptor acceptor, String domain) throws JMException {
        if (acceptor instanceof Acceptor) {
            Acceptor acptr = (Acceptor)acceptor;
            Listener listener = new Listener(server, acptr, domain);
            acptr.getDispatcherPool().addListener(listener);
            for (IDispatcher<IoSocketHandler> dispatcher : acptr.getDispatchers()) {
                try {
                    listener.onDispatcherAdded((Dispatcher)dispatcher);
                }
                catch (Exception ignore) {}
            }
            return new IntrospectionBasedDynamicBean(new ServerManagementBean(server, acptr));
        }
        return new IntrospectionBasedDynamicBean(server);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ServerManagementBean {
        private MultithreadedServer server = null;
        private Acceptor acceptor = null;

        ServerManagementBean(MultithreadedServer server, Acceptor acceptor) {
            this.server = server;
            this.acceptor = acceptor;
        }

        public void setReceiveBufferPreallocationSize(int size) {
            this.acceptor.setReceiveBufferPreallocationSize(size);
        }

        public int getReceiveBufferPreallocationSize() {
            return this.acceptor.getReceiveBufferPreallocationSize();
        }

        public int getIdleTimeoutSec() {
            return this.server.getIdleTimeoutSec();
        }

        public void setIdleTimeoutSec(int timeoutInSec) {
            this.server.setIdleTimeoutSec(timeoutInSec);
        }

        public int getConnectionTimeoutSec() {
            return this.server.getConnectionTimeoutSec();
        }

        public void setConnectionTimeoutSec(int timeoutSec) {
            this.server.setConnectionTimeoutSec(timeoutSec);
        }

        public long getCountHandledConnections() {
            return this.acceptor.getNumberOfHandledConnections();
        }

        public int getDispatcherPoolSize() {
            return this.acceptor.getDispatcherPoolSize();
        }

        public void setDispatcherPoolSize(int size) {
            this.acceptor.setDispatcherPoolSize(size);
        }

        public List<String> getOpenConnections() {
            return this.acceptor.getOpenConnections();
        }

        public int getNumberOpenConnections() {
            return this.acceptor.getNumberOfOpenConnections();
        }

        public long getCountConnectionTimeouts() {
            return this.acceptor.getNumberOfConnectionTimeouts();
        }

        public long getCountIdleTimeouts() {
            return this.acceptor.getNumberOfIdleTimeouts();
        }

        public int getLocalPort() {
            return this.server.getLocalPort();
        }

        public String getLocalAddressString() {
            return this.server.getLocalAddress().toString();
        }

        public Integer getWorkerpoolActiveCount() {
            if (this.server.getWorkerpool() instanceof ThreadPoolExecutor) {
                ThreadPoolExecutor tpe = (ThreadPoolExecutor)this.server.getWorkerpool();
                return tpe.getActiveCount();
            }
            return null;
        }

        public Integer getWorkerpoolMaximumPoolSize() {
            if (this.server.getWorkerpool() instanceof ThreadPoolExecutor) {
                ThreadPoolExecutor tpe = (ThreadPoolExecutor)this.server.getWorkerpool();
                return tpe.getMaximumPoolSize();
            }
            return null;
        }

        public Integer getWorkerpoolSize() {
            if (this.server.getWorkerpool() instanceof ThreadPoolExecutor) {
                ThreadPoolExecutor tpe = (ThreadPoolExecutor)this.server.getWorkerpool();
                return tpe.getPoolSize();
            }
            return null;
        }

        public Integer getWorkerpoolLargestPoolSize() {
            if (this.server.getWorkerpool() instanceof ThreadPoolExecutor) {
                ThreadPoolExecutor tpe = (ThreadPoolExecutor)this.server.getWorkerpool();
                return tpe.getLargestPoolSize();
            }
            return null;
        }

        public Integer getWorkerpoolKeepAliveTimeSec() {
            if (this.server.getWorkerpool() instanceof ThreadPoolExecutor) {
                ThreadPoolExecutor tpe = (ThreadPoolExecutor)this.server.getWorkerpool();
                return (int)tpe.getKeepAliveTime(TimeUnit.SECONDS);
            }
            return null;
        }
    }

    private static final class Listener
    implements IIoSocketDispatcherPoolListener {
        private MultithreadedServer server = null;
        private String domain = null;

        Listener(MultithreadedServer server, Acceptor acceptor, String domain) {
            this.server = server;
            this.domain = domain;
        }

        public void onWorkerPoolUpdated(IWorkerPool oldWorkerPool, IWorkerPool newWorkerPool) {
        }

        public void onDispatcherAdded(IDispatcher dispatcher) {
            block2: {
                try {
                    ObjectName objectName = new ObjectName(this.domain + ":type=IoSocketDispatcher,name=" + this.server.getLocalPort() + "." + dispatcher.hashCode());
                    ManagementFactory.getPlatformMBeanServer().registerMBean(new IntrospectionBasedDynamicBean(dispatcher), objectName);
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("error occured by registering mbean for new dispatcher " + e.toString());
                }
            }
        }

        public void onDispatcherRemoved(IDispatcher dispatcher) {
            block2: {
                try {
                    ObjectName objectName = new ObjectName(this.domain + ":type=IoSocketDispatcher,name=" + this.server.getLocalPort() + "." + dispatcher.hashCode());
                    ManagementFactory.getPlatformMBeanServer().unregisterMBean(objectName);
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("error occured by unregistering mbean of a dispatcher " + e.toString());
                }
            }
        }
    }
}

