/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream.io.impl;

import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.DataConverter;
import org.xsocket.stream.io.impl.IMemoryManager;

class SynchronizedMemoryManager
implements IMemoryManager {
    private static final Logger LOG = Logger.getLogger(SynchronizedMemoryManager.class.getName());
    private List<SoftReference<ByteBuffer>> memoryBuffer = new ArrayList<SoftReference<ByteBuffer>>();
    private boolean useDirectMemory = false;
    private int preallocationSize = 65536;

    SynchronizedMemoryManager(int preallocationSize, boolean useDirectMemory) {
        this.preallocationSize = preallocationSize;
        this.useDirectMemory = useDirectMemory;
    }

    public final synchronized int getFreeBufferSize() {
        int size = 0;
        for (SoftReference<ByteBuffer> bufferRef : this.memoryBuffer) {
            ByteBuffer buffer = bufferRef.get();
            if (buffer == null) continue;
            size += buffer.remaining();
        }
        return size;
    }

    public void recycleMemory(ByteBuffer buffer, int minSize) {
        int remaining = buffer.remaining();
        if (remaining >= minSize) {
            this.memoryBuffer.add(new SoftReference<ByteBuffer>(buffer.slice()));
        }
    }

    public void preallocate(int minSize) {
    }

    public final synchronized ByteBuffer acquireMemory(int minSize) {
        SoftReference<ByteBuffer> freeBuffer;
        ByteBuffer buffer = null;
        if (!this.memoryBuffer.isEmpty() && (buffer = (freeBuffer = this.memoryBuffer.remove(0)).get()) != null && buffer.limit() < minSize) {
            buffer = null;
        }
        if (buffer == null) {
            int size = this.getPreallocationSize();
            if (this.getPreallocationSize() < minSize) {
                size = minSize * 4;
            }
            buffer = this.newBuffer(size);
        }
        return buffer;
    }

    public int getPreallocationSize() {
        return this.preallocationSize;
    }

    public void setPreallocationSize(int preallocationSize) {
        this.preallocationSize = preallocationSize;
    }

    private final ByteBuffer newBuffer(int size) {
        if (this.useDirectMemory) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("allocating " + DataConverter.toFormatedBytesSize(size) + " direct memory");
            }
            return ByteBuffer.allocateDirect(size);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("allocating " + DataConverter.toFormatedBytesSize(size) + " heap memory");
        }
        return ByteBuffer.allocate(size);
    }
}

