/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.ClosedConnectionException;
import org.xsocket.DataConverter;
import org.xsocket.ILifeCycle;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.stream.Connection;
import org.xsocket.stream.IConnection;
import org.xsocket.stream.IConnectionPool;
import org.xsocket.stream.WaitTimeoutException;

abstract class AbstractConnectionPool
implements IConnectionPool {
    private static final Logger LOG = Logger.getLogger(AbstractConnectionPool.class.getName());
    static final long MIN_CHECKPERIOD_MILLIS = 60000L;
    static final long NULL = -1L;
    static final int MAX_SIZE = Integer.MAX_VALUE;
    static final long MAX_TIMEOUT = Long.MAX_VALUE;
    static final int CREATE_CONNECTION_TIMEOUT = 250;
    private final Timer timer = new Timer("ConPoolWatchdog", true);
    private int maxActive = Integer.MAX_VALUE;
    private int maxIdle = 3;
    private long maxWaitMillis = 0L;
    private long idleTimeoutMillis = Long.MAX_VALUE;
    private long lifeTimeoutMillis = Long.MAX_VALUE;
    private boolean isOpen = true;
    private final Map<InetSocketAddress, List<PoolableConnection>> idlePool = new HashMap<InetSocketAddress, List<PoolableConnection>>();
    private final Set<PoolableConnection> activePool = new HashSet<PoolableConnection>();
    private long checkPeriod = 0L;
    private TimerTask watchDogTask = null;
    private final List<ILifeCycle> listeners = new ArrayList<ILifeCycle>();

    AbstractConnectionPool(long idleTimeoutMillis, long lifeTimeoutMillis, int maxActive, long maxWaitMillis, int maxIdle) {
        this.idleTimeoutMillis = idleTimeoutMillis;
        this.lifeTimeoutMillis = lifeTimeoutMillis;
        this.maxActive = maxActive;
        this.maxWaitMillis = maxWaitMillis;
        this.maxIdle = maxIdle;
        this.resetCheckPeriod();
    }

    @Override
    public final synchronized void destroyConnection(IConnection connection) throws IOException {
        if (connection == null) {
            return;
        }
        if (connection instanceof PoolableConnection) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("destroying connection " + connection.getId());
            }
            this.activePool.remove(connection);
            ((PoolableConnection)connection).reallyClose();
        } else {
            connection.close();
        }
    }

    public void addListener(ILifeCycle listener) {
        this.listeners.add(listener);
    }

    public boolean removeListener(ILifeCycle listener) {
        boolean result = this.listeners.remove(listener);
        return result;
    }

    private void resetCheckPeriod() {
        if (this.watchDogTask != null) {
            this.watchDogTask.cancel();
        }
        this.watchDogTask = new TimerTask(){

            @Override
            public void run() {
                Thread.currentThread().setPriority(1);
                List idleConnections = AbstractConnectionPool.this.idleConnectionList();
                AbstractConnectionPool.this.checkTimeout(idleConnections);
                AbstractConnectionPool.this.checkSize(idleConnections);
            }
        };
        long time = 60000L;
        if (this.lifeTimeoutMillis / 5L < time) {
            time = this.lifeTimeoutMillis / 5L;
        }
        if (this.idleTimeoutMillis / 5L < time) {
            time = this.idleTimeoutMillis / 5L;
        }
        this.checkPeriod = time;
        this.timer.schedule(this.watchDogTask, this.checkPeriod, this.checkPeriod);
    }

    final long getCheckPeriodMillis() {
        return this.checkPeriod;
    }

    @Override
    public final synchronized int getMaxActive() {
        return this.maxActive;
    }

    @Override
    public final synchronized void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
        this.notifyAll();
    }

    @Override
    public final synchronized long getMaxWaitMillis() {
        return this.maxWaitMillis;
    }

    @Override
    public final synchronized void setMaxWaitMillis(long maxWaitMillis) {
        this.maxWaitMillis = maxWaitMillis;
        this.notifyAll();
    }

    @Override
    public final synchronized int getMaxIdle() {
        return this.maxIdle;
    }

    @Override
    public final synchronized void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
        this.notifyAll();
    }

    @Override
    public final synchronized int getNumActive() {
        return this.activePool.size();
    }

    @Override
    public final synchronized int getNumIdle() {
        int size = 0;
        for (List<PoolableConnection> connectionList : this.idlePool.values()) {
            size += connectionList.size();
        }
        return size;
    }

    @Override
    public final long getIdleTimeoutMillis() {
        return this.idleTimeoutMillis;
    }

    @Override
    public final void setIdleTimeoutMillis(long idleTimeoutMillis) {
        this.idleTimeoutMillis = idleTimeoutMillis;
        this.resetCheckPeriod();
    }

    @Override
    public final long getLifeTimeoutMillis() {
        return this.lifeTimeoutMillis;
    }

    @Override
    public final void setLifeTimeoutMillis(long lifeTimeoutMillis) {
        this.lifeTimeoutMillis = lifeTimeoutMillis;
        this.resetCheckPeriod();
    }

    synchronized List<String> getConnectionInfo() {
        ArrayList<String> info = new ArrayList<String>();
        for (PoolableConnection activeConnection : this.activePool) {
            info.add(activeConnection.toString());
        }
        for (PoolableConnection idleConnection : this.idleConnectionList()) {
            info.add(idleConnection.toString());
        }
        return info;
    }

    final synchronized PoolableConnection getConnection(InetSocketAddress address, Executor workerPool, int connectTimeoutMillis) throws IOException, WaitTimeoutException {
        if (this.isOpen) {
            PoolableConnection poolableConnection = this.getConnectionFromPool(address);
            if (poolableConnection == null) {
                if (this.maxWaitMillis == -1L) {
                    poolableConnection = this.newConnection(address, workerPool, connectTimeoutMillis);
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("new connection to " + poolableConnection.getId() + " has been established (idling=" + this.getNumIdle() + ", active=" + this.getNumActive() + ", maxActive=" + this.getMaxActive() + ", idleTimeoutMillis=" + this.getIdleTimeoutMillis() + ", lifeTimeout=" + this.getLifeTimeoutMillis() + ")");
                    }
                } else if (this.activePool.size() < this.maxActive) {
                    poolableConnection = this.newConnection(address, workerPool, connectTimeoutMillis);
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("new connection to " + poolableConnection.getId() + " has been established (idling=" + this.getNumIdle() + ", active=" + this.getNumActive() + ", maxActive=" + this.getMaxActive() + ", idleTimeoutMillis=" + this.getIdleTimeoutMillis() + ", lifeTimeout=" + this.getLifeTimeoutMillis() + ")");
                    }
                } else {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("no free connection available waiting for a free connection (idling=" + this.getNumIdle() + ", active=" + this.getNumActive() + ", maxActive=" + this.getMaxActive() + ", idleTimeoutMillis=" + this.getIdleTimeoutMillis() + ", lifeTimeout=" + this.getLifeTimeoutMillis() + ")");
                    }
                    long start = System.currentTimeMillis();
                    while (System.currentTimeMillis() - start < this.maxWaitMillis) {
                        try {
                            this.wait(this.maxWaitMillis - (System.currentTimeMillis() - start));
                        }
                        catch (InterruptedException ignore) {
                            // empty catch block
                        }
                        if ((poolableConnection = this.getConnectionFromPool(address)) == null) continue;
                    }
                    if (poolableConnection == null) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("wait timeout reached (" + DataConverter.toFormatedDuration(this.maxWaitMillis) + ")");
                        }
                        throw new WaitTimeoutException("wait timeout reached (" + DataConverter.toFormatedDuration(this.maxWaitMillis) + ")");
                    }
                }
            }
            if (poolableConnection != null) {
                this.activePool.add(poolableConnection);
                poolableConnection.setStateActive();
            }
            return poolableConnection;
        }
        throw new RuntimeException("pool is already closed");
    }

    private PoolableConnection getConnectionFromPool(InetSocketAddress address) throws IOException {
        try {
            List<PoolableConnection> connectionList = this.idlePool.get(address);
            if (connectionList != null && !connectionList.isEmpty()) {
                PoolableConnection poolableConnection = connectionList.remove(0);
                if (this.isConnectionValid(System.currentTimeMillis(), poolableConnection)) {
                    poolableConnection.reset();
                    if (connectionList.isEmpty()) {
                        this.idlePool.remove(address);
                    }
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("got connection to " + poolableConnection.getId() + " from pool (idling=" + this.getNumIdle() + ", active=" + this.getNumActive() + ", maxActive=" + this.getMaxActive() + ", idleTimeoutMillis=" + this.getIdleTimeoutMillis() + ", lifeTimeout=" + this.getLifeTimeoutMillis() + ")");
                    }
                    return poolableConnection;
                }
                return this.getConnectionFromPool(address);
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    final String getAddressString(String host, int port) {
        return host + ":" + port;
    }

    final synchronized void returnConnection(PoolableConnection poolableConnection) throws IOException {
        this.activePool.remove(poolableConnection);
        poolableConnection.setStateIdle();
        if (this.isOpen) {
            if (!this.isConnectionValid(System.currentTimeMillis(), poolableConnection)) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("do not return given connection to pool, because it is not valid/reuseable");
                }
                poolableConnection.reallyClose();
                return;
            }
            try {
                poolableConnection.reset();
            }
            catch (Exception e) {
                poolableConnection.reallyClose();
                return;
            }
        } else {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("pool is already closed destroy returned connection to " + poolableConnection.getId());
            }
            poolableConnection.reallyClose();
            return;
        }
        this.addConnectionToPool(poolableConnection);
        this.notifyAll();
    }

    private void addConnectionToPool(PoolableConnection connection) throws IOException {
        if (this.idlePool.size() < this.maxIdle) {
            List<PoolableConnection> connectionList = this.idlePool.get(connection.getAddress());
            if (connectionList == null) {
                connectionList = new ArrayList<PoolableConnection>();
                this.idlePool.put(connection.getAddress(), connectionList);
            }
            connectionList.add(connection);
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("connection to " + connection.getId() + " has been inserted into the pool (idling=" + this.getNumIdle() + ", active=" + this.getNumActive() + ", maxActive=" + this.getMaxActive() + ", idleTimeoutMillis=" + this.getIdleTimeoutMillis() + ", lifeTimeout=" + this.getLifeTimeoutMillis() + ")");
            }
        } else {
            connection.reallyClose();
        }
    }

    @Override
    public final synchronized void close() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("closing (idling=" + this.getNumIdle() + ", active=" + this.getNumActive() + ")");
        }
        this.timer.cancel();
        for (List<PoolableConnection> connectionList : this.idlePool.values()) {
            for (PoolableConnection connection : connectionList) {
                try {
                    connection.reallyClose();
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("error occured by (really) closing of conection " + connection.getId() + ". Reason: " + e.toString());
                }
            }
        }
        this.idlePool.clear();
        for (ILifeCycle lifeCycle : this.listeners) {
            lifeCycle.onDestroy();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " idling=" + this.getNumIdle() + ", active=" + this.getNumActive() + ", maxActive=" + this.getMaxActive() + ", idleTimeoutMillis=" + this.getIdleTimeoutMillis() + ", lifeTimeout=" + this.getLifeTimeoutMillis() + ")";
    }

    private boolean isConnectionValid(long currentTime, PoolableConnection poolableConnection) {
        if (!poolableConnection.isOpen()) {
            return false;
        }
        if (!poolableConnection.isReuseable()) {
            return false;
        }
        if (this.idleTimeoutMillis != Long.MAX_VALUE && currentTime > poolableConnection.getLastUsageTime() + this.idleTimeoutMillis) {
            return false;
        }
        return this.lifeTimeoutMillis == Long.MAX_VALUE || currentTime <= poolableConnection.getCreationTime() + this.lifeTimeoutMillis;
    }

    private void checkTimeout(List<PoolableConnection> idleConnections) {
        long currentTime = System.currentTimeMillis();
        for (PoolableConnection poolableConnection : idleConnections) {
            if (this.isConnectionValid(currentTime, poolableConnection)) continue;
            this.closeConnection(poolableConnection, "auto");
        }
    }

    private void checkSize(List<PoolableConnection> idleConnections) {
        if (idleConnections.size() > this.maxIdle) {
            for (int i = 0; i < idleConnections.size() - this.maxIdle; ++i) {
                PoolableConnection poolableConnection = idleConnections.get(i);
                this.closeConnection(poolableConnection, "auto");
            }
        }
    }

    private synchronized List<PoolableConnection> idleConnectionList() {
        ArrayList<PoolableConnection> idleConnections = new ArrayList<PoolableConnection>();
        for (List<PoolableConnection> connectionList : this.idlePool.values()) {
            idleConnections.addAll(connectionList);
        }
        return idleConnections;
    }

    private synchronized boolean closeConnection(PoolableConnection poolableConnection, String reason) {
        assert (poolableConnection != null);
        List<PoolableConnection> connectionList = this.idlePool.get(poolableConnection.getAddress());
        if (connectionList.contains(poolableConnection)) {
            block5: {
                connectionList.remove(poolableConnection);
                try {
                    poolableConnection.reallyClose();
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block5;
                    LOG.fine("error occured by (really) closing of connection " + poolableConnection.getId() + ". Reason: " + e.toString());
                }
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(reason + " close of connection " + poolableConnection.getId() + " (idling=" + this.getNumIdle() + ", active=" + this.getNumActive() + ", maxActive=" + this.getMaxActive() + ", idleTimeoutMillis=" + this.getIdleTimeoutMillis() + ", lifeTimeout=" + this.getLifeTimeoutMillis() + ")");
            }
            return true;
        }
        return false;
    }

    private PoolableConnection newConnection(InetSocketAddress address, Executor workerPool, int connectTimeoutMillis) throws IOException {
        int trials = 0;
        int sleepTime = 3;
        IOException ex = null;
        long start = System.currentTimeMillis();
        PoolableConnection connection = null;
        while (true) {
            ++trials;
            try {
                connection = this.createConnection(address, workerPool, connectTimeoutMillis);
                return connection;
            }
            catch (IOException ioe) {
                ex = ioe;
                sleepTime *= 3;
                try {
                    Thread.sleep(sleepTime);
                    continue;
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                if (System.currentTimeMillis() < start + 250L) continue;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("error occured by creating connection to " + address + ". creation timeout " + 250 + " reached. (" + trials + " trials done)");
                }
                if (ex != null) {
                    throw ex;
                }
                throw new IOException("could not create a new connetion to " + address);
            }
            break;
        }
    }

    abstract PoolableConnection createConnection(InetSocketAddress var1, Executor var2, int var3) throws IOException;

    abstract class PoolableConnection
    implements IConnection {
        private AbstractConnectionPool pool = null;
        private InetSocketAddress address = null;
        private Connection delegee;
        private long creationTime = System.currentTimeMillis();
        private long lastUsageTime = System.currentTimeMillis();
        private boolean isActive = false;
        private long enteredState = System.currentTimeMillis();
        private boolean isDeleted = false;
        private boolean isReuseable = true;

        public PoolableConnection(AbstractConnectionPool pool, Connection delegee, InetSocketAddress address) throws IOException {
            this.pool = pool;
            this.delegee = delegee;
            this.address = address;
        }

        final boolean isReuseable() {
            return this.isReuseable;
        }

        final void setReuseable(boolean isReusable) {
            this.isReuseable = isReusable;
        }

        final void setStateActive() {
            this.isActive = true;
            this.enteredState = System.currentTimeMillis();
        }

        final void setStateIdle() {
            this.isActive = false;
            this.enteredState = System.currentTimeMillis();
        }

        final boolean isActive() {
            return this.isActive;
        }

        final long getStateEntered() {
            return this.enteredState;
        }

        final Connection getDelegee() {
            return this.delegee;
        }

        final InetSocketAddress getAddress() {
            return this.address;
        }

        final long getLastUsageTime() {
            return this.lastUsageTime;
        }

        final long getCreationTime() {
            return this.creationTime;
        }

        @Override
        public void close() throws IOException {
            if (this.delegee.isOpen()) {
                this.lastUsageTime = System.currentTimeMillis();
                this.pool.returnConnection(this);
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("connection " + this.delegee.getId() + " will not return to pool because it is closed");
            }
        }

        void reset() throws IOException {
            this.delegee.reset();
        }

        @Override
        public void setIdleTimeoutSec(int timeoutInSec) {
            this.getDelegee().setIdleTimeoutSec(timeoutInSec);
        }

        @Override
        public int getIdleTimeoutSec() {
            return this.getDelegee().getIdleTimeoutSec();
        }

        @Override
        public Object getOption(String name) throws IOException {
            return this.getDelegee().getOption(name);
        }

        @Override
        public Map<String, Class> getOptions() {
            return this.getDelegee().getOptions();
        }

        @Override
        public void setConnectionTimeoutSec(int timeoutSec) {
            this.getDelegee().setConnectionTimeoutSec(timeoutSec);
        }

        @Override
        public int getConnectionTimeoutSec() {
            return this.getDelegee().getConnectionTimeoutSec();
        }

        @Override
        public void resumeRead() throws IOException {
            this.getDelegee().resumeRead();
        }

        @Override
        public void suspendRead() throws IOException {
            this.getDelegee().suspendRead();
        }

        void reallyClose() throws IOException {
            this.isDeleted = true;
            this.delegee.close();
        }

        @Override
        public void flush() throws ClosedConnectionException, IOException, SocketTimeoutException {
            this.delegee.flush();
        }

        @Override
        public boolean isOpen() {
            return !this.isDeleted && this.delegee.isOpen();
        }

        @Override
        public void activateSecuredMode() throws IOException {
            throw new UnsupportedOperationException("activateSecuredMode is not supported for a pooled connection");
        }

        @Override
        public final int getPendingWriteDataSize() {
            return this.delegee.getPendingWriteDataSize();
        }

        @Override
        public boolean getAutoflush() {
            return this.delegee.getAutoflush();
        }

        @Override
        public void setAutoflush(boolean autoflush) {
            this.delegee.setAutoflush(autoflush);
        }

        @Override
        public void setDefaultEncoding(String encoding) {
            this.delegee.setDefaultEncoding(encoding);
        }

        @Override
        public String getDefaultEncoding() {
            return this.delegee.getDefaultEncoding();
        }

        @Override
        public int read(ByteBuffer buffer) throws IOException {
            return this.delegee.read(buffer);
        }

        @Override
        public byte readByte() throws IOException, ClosedConnectionException, SocketTimeoutException {
            return this.delegee.readByte();
        }

        @Override
        public ByteBuffer[] readByteBufferByDelimiter(String delimiter) throws IOException, ClosedConnectionException, SocketTimeoutException {
            return this.delegee.readByteBufferByDelimiter(delimiter);
        }

        @Override
        public ByteBuffer[] readByteBufferByDelimiter(String delimiter, int maxLength) throws IOException, ClosedConnectionException, SocketTimeoutException, MaxReadSizeExceededException {
            return this.delegee.readByteBufferByDelimiter(delimiter, maxLength);
        }

        @Override
        public ByteBuffer[] readByteBufferByDelimiter(String delimiter, String encoding) throws IOException, ClosedConnectionException, MaxReadSizeExceededException {
            return this.delegee.readByteBufferByDelimiter(delimiter, encoding);
        }

        @Override
        public ByteBuffer[] readByteBufferByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, ClosedConnectionException, MaxReadSizeExceededException {
            return this.delegee.readByteBufferByDelimiter(delimiter, encoding, maxLength);
        }

        @Override
        public ByteBuffer[] readByteBufferByLength(int length) throws IOException, ClosedConnectionException, SocketTimeoutException {
            return this.delegee.readByteBufferByLength(length);
        }

        @Override
        public byte[] readBytesByDelimiter(String delimiter) throws IOException, ClosedConnectionException, SocketTimeoutException {
            return this.delegee.readBytesByDelimiter(delimiter);
        }

        @Override
        public byte[] readBytesByDelimiter(String delimiter, int maxLength) throws IOException, ClosedConnectionException, SocketTimeoutException, MaxReadSizeExceededException {
            return this.delegee.readBytesByDelimiter(delimiter, maxLength);
        }

        @Override
        public byte[] readBytesByDelimiter(String delimiter, String encoding) throws IOException, ClosedConnectionException, MaxReadSizeExceededException {
            return this.delegee.readBytesByDelimiter(delimiter, encoding);
        }

        @Override
        public byte[] readBytesByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, ClosedConnectionException, MaxReadSizeExceededException {
            return this.delegee.readBytesByDelimiter(delimiter, encoding, maxLength);
        }

        @Override
        public byte[] readBytesByLength(int length) throws IOException, ClosedConnectionException, SocketTimeoutException {
            return this.delegee.readBytesByLength(length);
        }

        @Override
        public double readDouble() throws IOException, ClosedConnectionException, SocketTimeoutException {
            return this.delegee.readDouble();
        }

        @Override
        public int readInt() throws IOException, ClosedConnectionException, SocketTimeoutException {
            return this.delegee.readInt();
        }

        @Override
        public short readShort() throws IOException, ClosedConnectionException, SocketTimeoutException {
            return this.delegee.readShort();
        }

        @Override
        public long readLong() throws IOException, ClosedConnectionException, SocketTimeoutException {
            return this.delegee.readLong();
        }

        @Override
        public String readStringByDelimiter(String delimiter) throws IOException, ClosedConnectionException, UnsupportedEncodingException, SocketTimeoutException {
            return this.delegee.readStringByDelimiter(delimiter);
        }

        @Override
        public String readStringByDelimiter(String delimiter, int maxLength) throws IOException, ClosedConnectionException, UnsupportedEncodingException, SocketTimeoutException, MaxReadSizeExceededException {
            return this.delegee.readStringByDelimiter(delimiter, maxLength);
        }

        @Override
        public String readStringByDelimiter(String delimiter, String encoding) throws IOException, ClosedConnectionException, UnsupportedEncodingException, SocketTimeoutException {
            return this.delegee.readStringByDelimiter(delimiter, encoding);
        }

        @Override
        public String readStringByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, ClosedConnectionException, UnsupportedEncodingException, SocketTimeoutException, MaxReadSizeExceededException {
            return this.delegee.readStringByDelimiter(delimiter, encoding, maxLength);
        }

        @Override
        public String readStringByLength(int length) throws IOException, ClosedConnectionException, SocketTimeoutException {
            return this.delegee.readStringByLength(length);
        }

        @Override
        public String readStringByLength(int length, String encoding) throws IOException, ClosedConnectionException, SocketTimeoutException {
            return this.delegee.readStringByLength(length, encoding);
        }

        @Override
        public void removeReadMark() {
            this.delegee.removeReadMark();
        }

        @Override
        public void removeWriteMark() {
            this.delegee.removeWriteMark();
        }

        @Override
        public void markReadPosition() {
            this.delegee.markReadPosition();
        }

        @Override
        public void markWritePosition() {
            this.delegee.markWritePosition();
        }

        @Override
        public boolean resetToReadMark() {
            return this.delegee.resetToReadMark();
        }

        @Override
        public boolean resetToWriteMark() {
            return this.delegee.resetToWriteMark();
        }

        @Override
        public String getId() {
            return this.delegee.getId();
        }

        @Override
        public InetAddress getLocalAddress() {
            return this.delegee.getLocalAddress();
        }

        @Override
        public int getLocalPort() {
            return this.delegee.getLocalPort();
        }

        @Override
        public InetAddress getRemoteAddress() {
            return this.delegee.getRemoteAddress();
        }

        @Override
        public int getRemotePort() {
            return this.delegee.getRemotePort();
        }

        @Override
        public int write(byte b) throws ClosedConnectionException, IOException, SocketTimeoutException {
            return this.delegee.write(b);
        }

        @Override
        public int write(byte ... bytes) throws ClosedConnectionException, IOException, SocketTimeoutException {
            return this.delegee.write(bytes);
        }

        @Override
        public int write(short s) throws ClosedConnectionException, IOException, SocketTimeoutException {
            return this.delegee.write(s);
        }

        @Override
        public int write(byte[] bytes, int offset, int length) throws ClosedConnectionException, IOException, SocketTimeoutException {
            return this.delegee.write(bytes, offset, length);
        }

        @Override
        public int write(ByteBuffer buffer) throws ClosedConnectionException, IOException, SocketTimeoutException {
            return this.delegee.write(buffer);
        }

        @Override
        public long write(ByteBuffer[] arg0, int arg1, int arg2) throws IOException {
            return this.delegee.write(arg0, arg1, arg2);
        }

        @Override
        public long write(ByteBuffer[] buffers) throws ClosedConnectionException, IOException, SocketTimeoutException {
            return this.delegee.write(buffers);
        }

        @Override
        public int write(double d) throws ClosedConnectionException, IOException, SocketTimeoutException {
            return this.delegee.write(d);
        }

        @Override
        public int write(int i) throws ClosedConnectionException, IOException, SocketTimeoutException {
            return this.delegee.write(i);
        }

        @Override
        public int write(long l) throws ClosedConnectionException, IOException, SocketTimeoutException {
            return this.delegee.write(l);
        }

        @Override
        public int write(String message) throws ClosedConnectionException, IOException, SocketTimeoutException {
            return this.delegee.write(message);
        }

        @Override
        public int write(String message, String encoding) throws ClosedConnectionException, IOException, SocketTimeoutException {
            return this.delegee.write(message, encoding);
        }

        @Override
        public void setAttachment(Object obj) {
            this.delegee.setAttachment(obj);
        }

        @Override
        public Object getAttachment() {
            return this.delegee.getAttachment();
        }

        public String toString() {
            String state = "idle";
            if (this.isActive()) {
                state = "active";
            }
            return "[" + state + ", since " + DataConverter.toFormatedDuration(System.currentTimeMillis() - this.getStateEntered()) + "] " + this.delegee.toString();
        }
    }
}

