/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import org.xsocket.stream.AbstractConnectionPool;
import org.xsocket.stream.BlockingConnection;
import org.xsocket.stream.IBlockingConnection;
import org.xsocket.stream.WaitTimeoutException;

public final class BlockingConnectionPool
extends AbstractConnectionPool {
    public static final long UNLIMITED_TIMEOUT = Long.MAX_VALUE;

    public BlockingConnectionPool(long timeToIdleMillis) {
        this(timeToIdleMillis, Integer.MAX_VALUE, -1L);
    }

    public BlockingConnectionPool(long timeToIdleMillis, int maxActive, long maxWaitTimeMillis) {
        super(timeToIdleMillis, Long.MAX_VALUE, maxActive, maxWaitTimeMillis, Integer.MAX_VALUE);
    }

    public BlockingConnectionPool(long timeToIdleMillis, int maxActive, long maxWaitTimeMillis, int maxIdle) {
        super(timeToIdleMillis, Long.MAX_VALUE, maxActive, maxWaitTimeMillis, maxIdle);
    }

    public IBlockingConnection getBlockingConnection(String host, int port) throws IOException, WaitTimeoutException {
        return (IBlockingConnection)((Object)this.getConnection(new InetSocketAddress(host, port), null, Integer.MAX_VALUE));
    }

    public IBlockingConnection getBlockingConnection(String host, int port, int connectTimeoutMillis) throws IOException, WaitTimeoutException {
        return (IBlockingConnection)((Object)this.getConnection(new InetSocketAddress(host, port), null, connectTimeoutMillis));
    }

    public IBlockingConnection getBlockingConnection(InetAddress address, int port) throws IOException, WaitTimeoutException {
        return (IBlockingConnection)((Object)this.getConnection(new InetSocketAddress(address, port), null, Integer.MAX_VALUE));
    }

    public IBlockingConnection getBlockingConnection(InetAddress address, int port, int connectTimeoutMillis) throws IOException, WaitTimeoutException {
        return (IBlockingConnection)((Object)this.getConnection(new InetSocketAddress(address, port), null, connectTimeoutMillis));
    }

    @Override
    AbstractConnectionPool.PoolableConnection createConnection(InetSocketAddress address, Executor workerPool, int connectTimeoutMillis) throws IOException {
        return new PoolableBlockingConnection(address, connectTimeoutMillis);
    }

    private final class PoolableBlockingConnection
    extends AbstractConnectionPool.PoolableConnection
    implements IBlockingConnection {
        public PoolableBlockingConnection(InetSocketAddress address, int connectTimeoutMillis) throws IOException {
            super(BlockingConnectionPool.this, new BlockingConnection(address.getAddress(), address.getPort(), connectTimeoutMillis), address);
        }

        @Override
        public void setReceiveTimeoutMillis(int timeout) throws IOException {
            ((BlockingConnection)this.getDelegee()).setReceiveTimeoutMillis(timeout);
        }

        @Override
        public IBlockingConnection setOption(String name, Object value) throws IOException {
            return ((BlockingConnection)this.getDelegee()).setOption(name, value);
        }
    }
}

