/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import org.xsocket.ILifeCycle;
import org.xsocket.stream.IConnectHandler;
import org.xsocket.stream.IConnectionScoped;
import org.xsocket.stream.IDataHandler;
import org.xsocket.stream.IDisconnectHandler;
import org.xsocket.stream.IHandler;
import org.xsocket.stream.IServerContext;
import org.xsocket.stream.ITimeoutHandler;
import org.xsocket.stream.IoHandlerContext;

final class DynamicHandlerAdapterFactory {
    private static final Logger LOG = Logger.getLogger(DynamicHandlerAdapterFactory.class.getName());
    private static final DynamicHandlerAdapterFactory INSTANCE = new DynamicHandlerAdapterFactory();
    private static final int MAX_METHOD_MAP_CACHE_SIZE = 10;
    private static final LinkedHashMap<Class, Map<String, Method>> cachedMethodMaps = new LinkedHashMap<Class, Map<String, Method>>(10){
        private static final long serialVersionUID = -4481693873559847580L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<Class, Map<String, Method>> eldest) {
            return this.size() > 10;
        }
    };

    DynamicHandlerAdapterFactory() {
    }

    public static DynamicHandlerAdapterFactory getInstance() {
        return INSTANCE;
    }

    static Map<String, Method> getHandlerMethods(Class appHandlerClass) {
        Method[] meths;
        Map<String, Method> methodMap = cachedMethodMaps.get(appHandlerClass);
        if (methodMap != null) {
            return methodMap;
        }
        methodMap = new HashMap<String, Method>();
        for (Method meth : meths = appHandlerClass.getMethods()) {
            String methodName = meth.getName();
            if (methodName.equals("onConnect") && meth.getParameterTypes().length == 1) {
                methodMap.put(methodName, meth);
                continue;
            }
            if (methodName.equals("onDisconnect") && meth.getParameterTypes().length == 1) {
                methodMap.put(methodName, meth);
                continue;
            }
            if (methodName.equals("onData") && meth.getParameterTypes().length == 1) {
                methodMap.put(methodName, meth);
                continue;
            }
            if (methodName.equals("onIdleTimeout") && meth.getParameterTypes().length == 1) {
                methodMap.put(methodName, meth);
                continue;
            }
            if (methodName.equals("onConnectionTimeout") && meth.getParameterTypes().length == 1) {
                methodMap.put(methodName, meth);
                continue;
            }
            if (methodName.equals("onInit") && meth.getParameterTypes().length == 0) {
                methodMap.put(methodName, meth);
                continue;
            }
            if (methodName.equals("onDestroy") && meth.getParameterTypes().length == 0) {
                methodMap.put(methodName, meth);
                continue;
            }
            if (methodName.equals("clone") && meth.getParameterTypes().length == 0) {
                methodMap.put(methodName, meth);
                continue;
            }
            if (methodName.startsWith("set") && meth.getParameterTypes().length == 1) {
                methodMap.put(methodName, meth);
                continue;
            }
            if (!methodName.startsWith("get") || meth.getParameterTypes().length != 0) continue;
            methodMap.put(methodName, meth);
        }
        cachedMethodMaps.put(appHandlerClass, methodMap);
        return methodMap;
    }

    IHandler createHandlerAdapter(IoHandlerContext handlerCtx, Object handler) {
        return new DynamicHandlerAdapter(handlerCtx, handler).createProxy();
    }

    static final class DynamicHandlerAdapter
    implements InvocationHandler,
    Cloneable {
        private Map<String, Method> methodMap = null;
        private Class[] supportedInterfaces = null;
        private Object delegee = null;

        DynamicHandlerAdapter(IoHandlerContext handlerCtx, Object delegee) {
            this.delegee = delegee;
            this.methodMap = DynamicHandlerAdapterFactory.getHandlerMethods(delegee.getClass());
            HashSet<Class> classes = new HashSet<Class>();
            if (handlerCtx.isAppHandlerListenForConnectEvent()) {
                classes.add(IConnectHandler.class);
            }
            if (handlerCtx.isAppHandlerListenforDisconnectEvent()) {
                classes.add(IDisconnectHandler.class);
            }
            if (handlerCtx.isAppHandlerListenForDataEvent()) {
                classes.add(IDataHandler.class);
            }
            if (handlerCtx.isAppHandlerListenForTimeoutEvent()) {
                classes.add(ITimeoutHandler.class);
            }
            if (handlerCtx.isLifeCycleHandler()) {
                classes.add(ILifeCycle.class);
            }
            if (handlerCtx.isConnectionScoped()) {
                classes.add(IConnectionScoped.class);
            }
            this.supportedInterfaces = classes.toArray(new Class[classes.size()]);
            if (LOG.isLoggable(Level.FINE)) {
                StringBuilder sb = new StringBuilder();
                for (Class clazz : this.supportedInterfaces) {
                    sb.append(clazz.getSimpleName() + " ");
                }
                LOG.fine("detected interfaces for handler " + delegee.getClass().getName() + ": " + sb.toString().trim());
            }
        }

        IHandler createProxy() {
            if (this.supportedInterfaces.length == 0) {
                return new IHandler(){};
            }
            IHandler hdl = (IHandler)Proxy.newProxyInstance(IHandler.class.getClassLoader(), this.supportedInterfaces, (InvocationHandler)this);
            return hdl;
        }

        void injectServerContextField(IServerContext ctx) {
            Field[] fields;
            for (Field field : fields = this.delegee.getClass().getDeclaredFields()) {
                if (field.getType() != IServerContext.class || !field.isAnnotationPresent(Resource.class)) continue;
                field.setAccessible(true);
                try {
                    field.set(this.delegee, ctx);
                }
                catch (IllegalAccessException iae) {
                    LOG.warning("could not set HandlerContext for attribute " + field.getName() + ". Reason " + iae.toString());
                }
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (methodName.equals("clone") && args == null) {
                return this.clone();
            }
            Method meth = this.methodMap.get(methodName);
            if (meth != null) {
                try {
                    Object result = meth.invoke(this.delegee, args);
                    if (methodName.equals("onConnect") || methodName.equals("onDisconnect") || methodName.equals("onData") || methodName.equals("onIdleTimeout") || methodName.equals("onConnectionTimeout")) {
                        if (result != null && result instanceof Boolean) {
                            return (Boolean)result;
                        }
                        return true;
                    }
                    if (methodName.equals("clone")) {
                        DynamicHandlerAdapter copy = (DynamicHandlerAdapter)this.clone();
                        copy.delegee = result;
                        return copy.createProxy();
                    }
                    return null;
                }
                catch (InvocationTargetException ite) {
                    throw ite.getTargetException();
                }
            }
            return null;
        }

        protected Object clone() throws CloneNotSupportedException {
            DynamicHandlerAdapter copy = (DynamicHandlerAdapter)super.clone();
            try {
                copy.delegee = this.methodMap.get("clone").invoke(this.delegee, (Object[])null);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            return Proxy.newProxyInstance(IHandler.class.getClassLoader(), this.supportedInterfaces, (InvocationHandler)copy);
        }
    }
}

