/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import org.xsocket.ClosedConnectionException;
import org.xsocket.IDataSink;
import org.xsocket.IDataSource;
import org.xsocket.MaxReadSizeExceededException;

public interface IConnection
extends IDataSource,
IDataSink,
GatheringByteChannel,
ReadableByteChannel,
WritableByteChannel,
Flushable,
Closeable {
    public static final String INITIAL_DEFAULT_ENCODING = "UTF-8";
    public static final boolean INITIAL_AUTOFLUSH = true;
    public static final String SO_SNDBUF = "SOL_SOCKET.SO_SNDBUF";
    public static final String SO_RCVBUF = "SOL_SOCKET.SO_RCVBUF";
    public static final String SO_REUSEADDR = "SOL_SOCKET.SO_REUSEADDR";
    public static final String SO_KEEPALIVE = "SOL_SOCKET.SO_KEEPALIVE";
    public static final String SO_LINGER = "SOL_SOCKET.SO_LINGER";
    public static final String TCP_NODELAY = "IPPROTO_TCP.TCP_NODELAY";

    public String getId();

    @Override
    public boolean isOpen();

    @Override
    public void flush() throws ClosedConnectionException, IOException;

    public int getLocalPort();

    public InetAddress getLocalAddress();

    public InetAddress getRemoteAddress();

    public int getRemotePort();

    public void setDefaultEncoding(String var1);

    public void suspendRead() throws IOException;

    public void resumeRead() throws IOException;

    public String getDefaultEncoding();

    public void setAutoflush(boolean var1);

    public boolean getAutoflush();

    public int getIdleTimeoutSec();

    public void setIdleTimeoutSec(int var1);

    public int getConnectionTimeoutSec();

    public void setConnectionTimeoutSec(int var1);

    public int getPendingWriteDataSize();

    public void activateSecuredMode() throws IOException;

    @Override
    public int write(String var1, String var2) throws ClosedConnectionException, IOException;

    @Override
    public int write(String var1) throws ClosedConnectionException, IOException;

    @Override
    public int write(byte var1) throws ClosedConnectionException, IOException;

    @Override
    public int write(byte ... var1) throws ClosedConnectionException, IOException;

    @Override
    public int write(byte[] var1, int var2, int var3) throws ClosedConnectionException, IOException;

    @Override
    public int write(ByteBuffer var1) throws ClosedConnectionException, IOException;

    @Override
    public long write(ByteBuffer[] var1) throws ClosedConnectionException, IOException;

    @Override
    public int write(int var1) throws ClosedConnectionException, IOException;

    @Override
    public int write(long var1) throws ClosedConnectionException, IOException;

    @Override
    public int write(double var1) throws ClosedConnectionException, IOException;

    @Override
    public byte readByte() throws IOException, ClosedConnectionException;

    @Override
    public int readInt() throws IOException, ClosedConnectionException;

    @Override
    public long readLong() throws IOException, ClosedConnectionException;

    @Override
    public double readDouble() throws IOException, ClosedConnectionException;

    @Override
    public ByteBuffer[] readByteBufferByDelimiter(String var1) throws IOException, ClosedConnectionException;

    @Override
    public ByteBuffer[] readByteBufferByDelimiter(String var1, int var2) throws IOException, ClosedConnectionException, MaxReadSizeExceededException;

    public ByteBuffer[] readByteBufferByDelimiter(String var1, String var2) throws IOException, ClosedConnectionException, MaxReadSizeExceededException;

    @Override
    public ByteBuffer[] readByteBufferByDelimiter(String var1, String var2, int var3) throws IOException, ClosedConnectionException, MaxReadSizeExceededException;

    @Override
    public ByteBuffer[] readByteBufferByLength(int var1) throws IOException, ClosedConnectionException;

    public byte[] readBytesByDelimiter(String var1) throws IOException, ClosedConnectionException;

    @Override
    public byte[] readBytesByDelimiter(String var1, int var2) throws IOException, ClosedConnectionException, MaxReadSizeExceededException;

    public byte[] readBytesByDelimiter(String var1, String var2) throws IOException, ClosedConnectionException, MaxReadSizeExceededException;

    public byte[] readBytesByDelimiter(String var1, String var2, int var3) throws IOException, ClosedConnectionException, MaxReadSizeExceededException;

    @Override
    public byte[] readBytesByLength(int var1) throws IOException, ClosedConnectionException;

    @Override
    public String readStringByDelimiter(String var1) throws IOException, ClosedConnectionException, UnsupportedEncodingException;

    @Override
    public String readStringByDelimiter(String var1, int var2) throws IOException, ClosedConnectionException, UnsupportedEncodingException, MaxReadSizeExceededException;

    @Override
    public String readStringByLength(int var1) throws IOException, ClosedConnectionException, UnsupportedEncodingException;

    public String readStringByDelimiter(String var1, String var2) throws IOException, ClosedConnectionException, UnsupportedEncodingException;

    @Override
    public String readStringByDelimiter(String var1, String var2, int var3) throws IOException, ClosedConnectionException, UnsupportedEncodingException, MaxReadSizeExceededException;

    @Override
    public String readStringByLength(int var1, String var2) throws IOException, ClosedConnectionException, UnsupportedEncodingException;

    public void markWritePosition();

    public void removeWriteMark();

    public boolean resetToWriteMark();

    public void markReadPosition();

    public void removeReadMark();

    public boolean resetToReadMark();

    public void setAttachment(Object var1);

    public Object getAttachment();

    public IConnection setOption(String var1, Object var2) throws IOException;

    public Object getOption(String var1) throws IOException;

    public Map<String, Class> getOptions();

    public static enum FlushMode {
        SYNC,
        ASYNC;

    }
}

