/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import org.xsocket.ClosedConnectionException;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.stream.IConnection;

public interface INonBlockingConnection
extends IConnection {
    public static final int UNLIMITED = Integer.MAX_VALUE;
    public static final IConnection.FlushMode INITIAL_FLUSH_MODE = IConnection.FlushMode.SYNC;

    public int getNumberOfAvailableBytes();

    public int indexOf(String var1) throws IOException, ClosedConnectionException;

    public int indexOf(String var1, int var2) throws IOException, ClosedConnectionException, MaxReadSizeExceededException;

    public ByteBuffer[] readAvailable() throws IOException;

    public TransferResult transferAvailableByDelimiter(String var1, WritableByteChannel var2) throws IOException;

    public TransferResult transferAvailableByDelimiter(String var1, String var2, WritableByteChannel var3) throws IOException;

    @Override
    public ByteBuffer[] readByteBufferByDelimiter(String var1) throws IOException, ClosedConnectionException, BufferUnderflowException;

    public List<ByteBuffer[]> readAvailableByteBufferByDelimiter(String var1) throws IOException;

    @Override
    public ByteBuffer[] readByteBufferByDelimiter(String var1, int var2) throws IOException, ClosedConnectionException, MaxReadSizeExceededException, BufferUnderflowException;

    public List<ByteBuffer[]> readAvailableByteBufferByDelimiter(String var1, String var2) throws IOException;

    @Override
    public ByteBuffer[] readByteBufferByLength(int var1) throws IOException, ClosedConnectionException, BufferUnderflowException;

    public List<byte[]> readAvailableBytesByDelimiter(String var1) throws IOException;

    public List<byte[]> readAvailableBytesByDelimiter(String var1, String var2) throws IOException;

    @Override
    public byte[] readBytesByDelimiter(String var1) throws IOException, ClosedConnectionException, BufferUnderflowException;

    @Override
    public byte[] readBytesByDelimiter(String var1, int var2) throws IOException, ClosedConnectionException, MaxReadSizeExceededException, BufferUnderflowException;

    @Override
    public byte[] readBytesByLength(int var1) throws IOException, ClosedConnectionException, BufferUnderflowException;

    public List<String> readAvailableStringsByDelimiter(String var1) throws IOException, UnsupportedEncodingException;

    public List<String> readAvailableStringsByDelimiter(String var1, String var2) throws IOException, UnsupportedEncodingException;

    @Override
    public String readStringByDelimiter(String var1) throws IOException, ClosedConnectionException, BufferUnderflowException, UnsupportedEncodingException;

    @Override
    public String readStringByDelimiter(String var1, int var2) throws IOException, ClosedConnectionException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException;

    @Override
    public String readStringByLength(int var1) throws IOException, ClosedConnectionException, BufferUnderflowException, UnsupportedEncodingException;

    @Override
    public String readStringByDelimiter(String var1, String var2) throws IOException, ClosedConnectionException, BufferUnderflowException, UnsupportedEncodingException;

    @Override
    public String readStringByDelimiter(String var1, String var2, int var3) throws IOException, ClosedConnectionException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException;

    @Override
    public String readStringByLength(int var1, String var2) throws IOException, ClosedConnectionException, BufferUnderflowException, UnsupportedEncodingException;

    @Override
    public int readInt() throws IOException, ClosedConnectionException, BufferUnderflowException;

    @Override
    public long readLong() throws IOException, ClosedConnectionException, BufferUnderflowException;

    @Override
    public double readDouble() throws IOException, ClosedConnectionException, BufferUnderflowException;

    @Override
    public byte readByte() throws IOException, ClosedConnectionException, BufferUnderflowException;

    public void setWriteTransferRate(int var1) throws ClosedConnectionException, IOException;

    @Override
    public void flush() throws ClosedConnectionException, IOException;

    @Override
    public int write(ByteBuffer var1) throws ClosedConnectionException, IOException;

    @Override
    public long write(ByteBuffer[] var1) throws ClosedConnectionException, IOException;

    public void setFlushmode(IConnection.FlushMode var1);

    public IConnection.FlushMode getFlushmode();

    @Override
    public INonBlockingConnection setOption(String var1, Object var2) throws IOException;

    public static final class TransferResult {
        private boolean delimiterFound = false;
        private long written = 0L;

        TransferResult(boolean delimiterFound, long written) {
            this.delimiterFound = delimiterFound;
            this.written = written;
        }

        public boolean isDelimiterFound() {
            return this.delimiterFound;
        }

        public long getWritten() {
            return this.written;
        }
    }
}

