/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.ILifeCycle;
import org.xsocket.Synchronized;
import org.xsocket.stream.DynamicHandlerAdapterFactory;
import org.xsocket.stream.IConnectHandler;
import org.xsocket.stream.IConnectionScoped;
import org.xsocket.stream.IDataHandler;
import org.xsocket.stream.IDisconnectHandler;
import org.xsocket.stream.IHandler;
import org.xsocket.stream.ITimeoutHandler;
import org.xsocket.stream.io.spi.IIoHandlerContext;

final class IoHandlerContext
implements IIoHandlerContext {
    private static final Logger LOG = Logger.getLogger(IoHandlerContext.class.getName());
    private static final SingleThreadedWorkerPool SINGLE_THREADED_POOL = new SingleThreadedWorkerPool();
    private boolean isConnectHandler = false;
    private boolean isDisconnectHandler = false;
    private boolean isDataHandler = false;
    private boolean isTimeoutHandler = false;
    private boolean isLifeCycleHandler = false;
    private boolean isConnectionScoped = false;
    private boolean isHandlerThreadSave = false;
    private boolean isMultithreaded = false;
    private boolean isDynamicHandler = false;
    private Executor workerpool = null;

    IoHandlerContext(Object appHandler, Executor workerpool) {
        this.updateAppHandler(appHandler);
        this.updateWorkerpool(workerpool);
    }

    void updateAppHandler(Object appHandler) {
        this.isConnectHandler = false;
        this.isDisconnectHandler = false;
        this.isDataHandler = false;
        this.isTimeoutHandler = false;
        this.isLifeCycleHandler = false;
        this.isConnectionScoped = false;
        this.isHandlerThreadSave = false;
        this.isDynamicHandler = false;
        this.introspectHandler(appHandler);
    }

    void updateWorkerpool(Executor workerpool) {
        if (workerpool != null) {
            this.workerpool = workerpool;
            this.isMultithreaded = true;
        } else {
            this.workerpool = SINGLE_THREADED_POOL;
            this.isMultithreaded = false;
        }
    }

    @Override
    public Executor getWorkerpool() {
        return this.workerpool;
    }

    @Override
    public boolean isAppHandlerListenForConnectEvent() {
        return this.isConnectHandler;
    }

    @Override
    public boolean isAppHandlerListenForDataEvent() {
        return this.isDataHandler;
    }

    @Override
    public boolean isAppHandlerListenforDisconnectEvent() {
        return this.isDisconnectHandler;
    }

    @Override
    public boolean isAppHandlerListenForTimeoutEvent() {
        return this.isTimeoutHandler;
    }

    public boolean isAppHandlerConnectionScoped() {
        return this.isConnectionScoped;
    }

    public boolean isAppHandlerThreadSave() {
        return this.isHandlerThreadSave;
    }

    boolean isConnectionScoped() {
        return this.isConnectionScoped;
    }

    boolean isLifeCycleHandler() {
        return this.isLifeCycleHandler;
    }

    @Override
    public boolean isAppHandlerThreadSafe() {
        return this.isHandlerThreadSave;
    }

    @Override
    public boolean isMultithreaded() {
        return this.isMultithreaded;
    }

    boolean isDynamicHandler() {
        return this.isDynamicHandler;
    }

    private void introspectHandler(Object appHandler) {
        Synchronized.Mode scope;
        if (appHandler == null) {
            this.isDynamicHandler = false;
            this.isDataHandler = true;
            this.isConnectHandler = false;
            this.isDisconnectHandler = false;
            this.isTimeoutHandler = false;
            this.isConnectionScoped = false;
            this.isHandlerThreadSave = false;
            this.isLifeCycleHandler = false;
            return;
        }
        if (appHandler instanceof IHandler) {
            this.isDynamicHandler = false;
            this.introspectTypedHandler((IHandler)appHandler);
        } else {
            this.isDynamicHandler = true;
            this.introspectDynamicHandler(appHandler);
        }
        Synchronized sync = appHandler.getClass().getAnnotation(Synchronized.class);
        this.isHandlerThreadSave = sync != null ? (scope = sync.value()) == Synchronized.Mode.OFF : false;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("app handler " + appHandler + " analysed: " + " isConnectHandler=" + this.isConnectHandler + " isDisconnectHandler=" + this.isDisconnectHandler + " isDataHandler=" + this.isDataHandler + " isTimeoutHandler=" + this.isTimeoutHandler + " isLifeCycleHandler=" + this.isLifeCycleHandler + " isConnectionScoped=" + this.isConnectionScoped + " isHandlerThreadSave=" + this.isHandlerThreadSave + " isDynamicHandler=" + this.isDynamicHandler);
        }
    }

    private void introspectTypedHandler(IHandler appHandler) {
        this.isConnectHandler = appHandler instanceof IConnectHandler;
        this.isDisconnectHandler = appHandler instanceof IDisconnectHandler;
        this.isDataHandler = appHandler instanceof IDataHandler;
        this.isTimeoutHandler = appHandler instanceof ITimeoutHandler;
        this.isConnectionScoped = appHandler instanceof IConnectionScoped;
        this.isLifeCycleHandler = appHandler instanceof ILifeCycle;
    }

    private void introspectDynamicHandler(Object appHandler) {
        boolean callbackMethodFound = false;
        Map<String, Method> methodMap = DynamicHandlerAdapterFactory.getHandlerMethods(appHandler.getClass());
        if (methodMap.containsKey("onConnect")) {
            this.isConnectHandler = true;
            callbackMethodFound = true;
        }
        if (methodMap.containsKey("onDisconnect")) {
            this.isDisconnectHandler = true;
            callbackMethodFound = true;
        }
        if (methodMap.containsKey("onData")) {
            this.isDataHandler = true;
            callbackMethodFound = true;
        }
        if (methodMap.containsKey("onIdleTimeout")) {
            this.isTimeoutHandler = true;
            callbackMethodFound = true;
        }
        if (methodMap.containsKey("onConnectionTimeout")) {
            this.isTimeoutHandler = true;
            callbackMethodFound = true;
        }
        if (methodMap.containsKey("onInit")) {
            this.isLifeCycleHandler = true;
            callbackMethodFound = true;
        }
        if (methodMap.containsKey("onDestroy")) {
            this.isLifeCycleHandler = true;
            callbackMethodFound = true;
        }
        if (methodMap.containsKey("clone")) {
            this.isConnectionScoped = true;
        }
        if (!callbackMethodFound) {
            LOG.warning("the handler " + appHandler + " doesn't implement any callback method (like onData(INonBlockingConnection))");
        }
    }

    public String toString() {
        return "isConnectHandler=" + this.isConnectHandler + " " + "isDisconnectHandler=" + this.isDisconnectHandler + " " + "isDataHandler=" + this.isDataHandler + " " + "isTimeoutHandler=" + this.isTimeoutHandler + " " + "isLifeCycleHandler=" + this.isLifeCycleHandler + " " + "isConnectionScoped=" + this.isConnectionScoped + " " + "isHandlerThreadSave=" + this.isHandlerThreadSave + " " + "isDynamicHandler=" + this.isDynamicHandler + " " + "isMultithreaded=" + this.isMultithreaded + " ";
    }

    private static final class SingleThreadedWorkerPool
    implements Executor {
        private SingleThreadedWorkerPool() {
        }

        @Override
        public void execute(Runnable command) {
            block2: {
                try {
                    command.run();
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("error occured within worker thread " + e.toString());
                }
            }
        }
    }
}

