/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.ClosedConnectionException;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.stream.AbstractConnectionPool;
import org.xsocket.stream.IConnectHandler;
import org.xsocket.stream.IConnection;
import org.xsocket.stream.IDataHandler;
import org.xsocket.stream.IDisconnectHandler;
import org.xsocket.stream.IHandler;
import org.xsocket.stream.INonBlockingConnection;
import org.xsocket.stream.ITimeoutHandler;
import org.xsocket.stream.NonBlockingConnection;
import org.xsocket.stream.WaitTimeoutException;

public final class NonBlockingConnectionPool
extends AbstractConnectionPool {
    private static final Logger LOG = Logger.getLogger(NonBlockingConnectionPool.class.getName());
    public static final long UNLIMITED_TIMEOUT = Long.MAX_VALUE;

    public NonBlockingConnectionPool(long timeToIdleMillis) {
        this(timeToIdleMillis, Integer.MAX_VALUE, -1L);
    }

    public NonBlockingConnectionPool(long timeToIdleMillis, int maxActive, long maxWaitTimeMillis) {
        super(timeToIdleMillis, Long.MAX_VALUE, maxActive, maxWaitTimeMillis, Integer.MAX_VALUE);
    }

    public INonBlockingConnection getNonBlockingConnection(String host, int port) throws IOException, WaitTimeoutException {
        return (INonBlockingConnection)((Object)this.getConnection(new InetSocketAddress(host, port), null, Integer.MAX_VALUE));
    }

    public INonBlockingConnection getNonBlockingConnection(String host, int port, int connectTimeoutMillis) throws IOException, WaitTimeoutException {
        return (INonBlockingConnection)((Object)this.getConnection(new InetSocketAddress(host, port), null, connectTimeoutMillis));
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port) throws IOException, WaitTimeoutException {
        return (INonBlockingConnection)((Object)this.getConnection(new InetSocketAddress(address, port), null, Integer.MAX_VALUE));
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, int connectTimeoutMillis) throws IOException, WaitTimeoutException {
        return (INonBlockingConnection)((Object)this.getConnection(new InetSocketAddress(address, port), null, connectTimeoutMillis));
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, IHandler appHandler) throws IOException, WaitTimeoutException {
        return this.getNonBlockingConnection(address, port, appHandler, null, Integer.MAX_VALUE);
    }

    public INonBlockingConnection getNonBlockingConnection(String host, int port, IHandler appHandler) throws IOException, WaitTimeoutException {
        return this.getConnection(new InetSocketAddress(host, port), appHandler, null, Integer.MAX_VALUE);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, IHandler appHandler, int connectTimeoutMillis) throws IOException, WaitTimeoutException {
        return this.getNonBlockingConnection(address, port, appHandler, null, connectTimeoutMillis);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, IHandler appHandler, Executor workerPool, int connectTimeoutMillis) throws IOException, WaitTimeoutException {
        return this.getConnection(new InetSocketAddress(address, port), appHandler, workerPool, connectTimeoutMillis);
    }

    private INonBlockingConnection getConnection(InetSocketAddress address, IHandler appHandler, Executor workerPool, int connectTimeoutMillis) throws IOException, WaitTimeoutException {
        PoolableNonBlockingConnection connection = (PoolableNonBlockingConnection)this.getConnection(address, workerPool, connectTimeoutMillis);
        if (connection != null) {
            connection.setHandler(appHandler);
            connection.notiyConnect();
            return connection;
        }
        throw new IOException("could not create a connection to " + address);
    }

    @Override
    AbstractConnectionPool.PoolableConnection createConnection(InetSocketAddress address, Executor workerPool, int connectTimeoutMillis) throws IOException {
        if (workerPool != null) {
            return new PoolableNonBlockingConnection(address, workerPool, connectTimeoutMillis);
        }
        return new PoolableNonBlockingConnection(address, connectTimeoutMillis);
    }

    private static final class HandlerProxy
    implements IDataHandler,
    IDisconnectHandler,
    ITimeoutHandler {
        private PoolableNonBlockingConnection poolableConnection = null;
        private IHandler handler = null;
        private boolean isDataHandler = false;
        private boolean isConnectHandler = false;
        private boolean isDisconnectHandler = false;
        private boolean isTimeoutHandler = false;

        private HandlerProxy() {
        }

        void init(PoolableNonBlockingConnection poolableConnection) {
            this.poolableConnection = poolableConnection;
        }

        void setHandler(IHandler handler) {
            this.handler = handler;
            if (handler != null) {
                this.isDataHandler = handler instanceof IDataHandler;
                this.isConnectHandler = handler instanceof IConnectHandler;
                this.isDisconnectHandler = handler instanceof IDisconnectHandler;
                this.isTimeoutHandler = handler instanceof ITimeoutHandler;
            }
        }

        void notifyConnect(INonBlockingConnection connection) throws IOException {
            if (this.isConnectHandler) {
                ((IConnectHandler)this.handler).onConnect(this.poolableConnection);
            }
        }

        @Override
        public boolean onData(INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            if (this.isDataHandler) {
                ((IDataHandler)this.handler).onData(this.poolableConnection);
            }
            return true;
        }

        @Override
        public boolean onDisconnect(INonBlockingConnection connection) throws IOException {
            if (this.isDisconnectHandler) {
                ((IDisconnectHandler)this.handler).onDisconnect(this.poolableConnection);
            }
            this.poolableConnection.reallyClose();
            return true;
        }

        @Override
        public boolean onConnectionTimeout(INonBlockingConnection connection) throws IOException {
            this.poolableConnection.setReuseable(false);
            boolean isHandled = false;
            if (this.isTimeoutHandler) {
                isHandled = ((ITimeoutHandler)this.handler).onConnectionTimeout(this.poolableConnection);
            }
            if (!isHandled) {
                this.poolableConnection.reallyClose();
            }
            return true;
        }

        @Override
        public boolean onIdleTimeout(INonBlockingConnection connection) throws IOException {
            this.poolableConnection.setReuseable(false);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("idle timout occured for pooled connection " + this.poolableConnection.getId());
            }
            boolean isHandled = false;
            if (this.isTimeoutHandler) {
                isHandled = ((ITimeoutHandler)this.handler).onIdleTimeout(this.poolableConnection);
            }
            if (!isHandled) {
                this.poolableConnection.reallyClose();
            }
            return true;
        }
    }

    private final class PoolableNonBlockingConnection
    extends AbstractConnectionPool.PoolableConnection
    implements INonBlockingConnection {
        public PoolableNonBlockingConnection(InetSocketAddress address, int connectTimeoutMillis) throws IOException {
            super(NonBlockingConnectionPool.this, new NonBlockingConnection(address.getAddress(), address.getPort(), connectTimeoutMillis, (IHandler)new HandlerProxy()), address);
            this.getHandlerProxy().init(this);
        }

        public PoolableNonBlockingConnection(InetSocketAddress address, Executor workerPool, int connectTimeoutMillis) throws IOException {
            super(NonBlockingConnectionPool.this, new NonBlockingConnection(address.getAddress(), address.getPort(), connectTimeoutMillis, new HandlerProxy(), workerPool), address);
            this.getHandlerProxy().init(this);
        }

        @Override
        public INonBlockingConnection setOption(String name, Object value) throws IOException {
            return this.getUnderlyingConnection().setOption(name, value);
        }

        void setHandler(IHandler handler) {
            this.getHandlerProxy().setHandler(handler);
        }

        private HandlerProxy getHandlerProxy() {
            return (HandlerProxy)this.getUnderlyingConnection().getAppHandler();
        }

        void notiyConnect() throws IOException {
            HandlerProxy hdlProxy = (HandlerProxy)this.getUnderlyingConnection().getAppHandler();
            hdlProxy.notifyConnect(this.getUnderlyingConnection());
        }

        @Override
        void reset() throws IOException {
            this.setHandler(null);
            super.reset();
        }

        @Override
        public void setFlushmode(IConnection.FlushMode flushMode) {
            this.getUnderlyingConnection().setFlushmode(flushMode);
        }

        @Override
        public IConnection.FlushMode getFlushmode() {
            return this.getUnderlyingConnection().getFlushmode();
        }

        @Override
        public void setWriteTransferRate(int bytesPerSecond) throws ClosedConnectionException, IOException {
            this.getUnderlyingConnection().setWriteTransferRate(bytesPerSecond);
        }

        @Override
        public ByteBuffer[] readAvailable() throws IOException, ClosedConnectionException {
            return this.getUnderlyingConnection().readAvailable();
        }

        @Override
        public List<ByteBuffer[]> readAvailableByteBufferByDelimiter(String delimiter) throws IOException {
            return this.getUnderlyingConnection().readAvailableByteBufferByDelimiter(delimiter);
        }

        @Override
        public List<ByteBuffer[]> readAvailableByteBufferByDelimiter(String delimiter, String encoding) throws IOException {
            return this.getUnderlyingConnection().readAvailableByteBufferByDelimiter(delimiter, encoding);
        }

        @Override
        public List<byte[]> readAvailableBytesByDelimiter(String delimiter) throws IOException {
            return this.getUnderlyingConnection().readAvailableBytesByDelimiter(delimiter);
        }

        @Override
        public List<byte[]> readAvailableBytesByDelimiter(String delimiter, String encoding) throws IOException {
            return this.getUnderlyingConnection().readAvailableBytesByDelimiter(delimiter, encoding);
        }

        @Override
        public List<String> readAvailableStringsByDelimiter(String delimiter) throws IOException, UnsupportedEncodingException {
            return this.getUnderlyingConnection().readAvailableStringsByDelimiter(delimiter);
        }

        @Override
        public List<String> readAvailableStringsByDelimiter(String delimiter, String encoding) throws IOException, UnsupportedEncodingException {
            return this.getUnderlyingConnection().readAvailableStringsByDelimiter(delimiter, encoding);
        }

        @Override
        public INonBlockingConnection.TransferResult transferAvailableByDelimiter(String delimiter, WritableByteChannel outputChannel) throws IOException, ClosedConnectionException {
            return this.getUnderlyingConnection().transferAvailableByDelimiter(delimiter, outputChannel);
        }

        @Override
        public INonBlockingConnection.TransferResult transferAvailableByDelimiter(String delimiter, String encoding, WritableByteChannel outputChannel) throws IOException, ClosedConnectionException {
            return this.getUnderlyingConnection().transferAvailableByDelimiter(delimiter, encoding, outputChannel);
        }

        @Override
        public int getNumberOfAvailableBytes() {
            return this.getUnderlyingConnection().getNumberOfAvailableBytes();
        }

        @Override
        public int indexOf(String str) throws IOException, ClosedConnectionException {
            return this.getUnderlyingConnection().indexOf(str);
        }

        @Override
        public int indexOf(String str, int maxLength) throws IOException, ClosedConnectionException, MaxReadSizeExceededException {
            return this.getUnderlyingConnection().indexOf(str, maxLength);
        }

        public int indexOf(String str, String encoding, int maxLength) throws IOException, ClosedConnectionException, MaxReadSizeExceededException {
            return this.getUnderlyingConnection().indexOf(str, encoding, maxLength);
        }

        private NonBlockingConnection getUnderlyingConnection() {
            return (NonBlockingConnection)this.getDelegee();
        }
    }
}

