/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.net.ssl.SSLContext;
import org.xsocket.ILifeCycle;
import org.xsocket.stream.DefaultConnectionFactory;
import org.xsocket.stream.DynamicHandlerAdapterFactory;
import org.xsocket.stream.IConnectionScoped;
import org.xsocket.stream.IHandler;
import org.xsocket.stream.INonBlockingConnection;
import org.xsocket.stream.INonBlockingConnectionFactory;
import org.xsocket.stream.IServer;
import org.xsocket.stream.IServerContext;
import org.xsocket.stream.IServerListener;
import org.xsocket.stream.IoHandlerContext;
import org.xsocket.stream.io.impl.IoProvider;
import org.xsocket.stream.io.spi.IAcceptor;
import org.xsocket.stream.io.spi.IAcceptorCallback;
import org.xsocket.stream.io.spi.IIoHandler;
import org.xsocket.stream.io.spi.IServerIoProvider;

public final class Server
implements IServer {
    private static final Logger LOG = Logger.getLogger(Server.class.getName());
    private static final int DEFAULT_WORKER_POOL_MAX_SIZE = 250;
    private static String implementationVersion = null;
    private boolean isOpen = false;
    private String name = "server";
    private static IServerIoProvider serverIoProvider = null;
    private IAcceptor acceptor = null;
    private InetSocketAddress address = null;
    private Map<String, Object> options = null;
    private boolean sslOn = false;
    private SSLContext sslContext = null;
    private Executor workerpool = null;
    private boolean isSelfCreatedWorkerPool = false;
    private INonBlockingConnectionFactory connectionFactory = new DefaultConnectionFactory();
    private Object orgAppHandler = null;
    private IHandler appHandlerPrototype = null;
    private final IoHandlerContext ioHandlerContext = new IoHandlerContext(null, null);
    private final ArrayList<IServerListener> listeners = new ArrayList();
    private int idleTimeoutSec = Integer.MAX_VALUE;
    private int connectionTimeoutSec = Integer.MAX_VALUE;

    public Server(IHandler handler) throws UnknownHostException, IOException {
        this(new InetSocketAddress(InetAddress.getByName("0.0.0.0"), 0), new HashMap<String, Object>(), handler, Server.newServerWorkerPool(250), false, null);
    }

    public Server(Object handler) throws UnknownHostException, IOException {
        this(new InetSocketAddress(InetAddress.getByName("0.0.0.0"), 0), new HashMap<String, Object>(), handler, Server.newServerWorkerPool(250), false, null);
    }

    public Server(IHandler handler, Executor workerpool) throws UnknownHostException, IOException {
        this(new InetSocketAddress(InetAddress.getByName("0.0.0.0"), 0), new HashMap<String, Object>(), handler, workerpool, false, null);
    }

    public Server(Object handler, int maxWorkers) throws UnknownHostException, IOException {
        this(new InetSocketAddress(InetAddress.getByName("0.0.0.0"), 0), new HashMap<String, Object>(), handler, Server.newServerWorkerPool(maxWorkers), false, null);
    }

    public Server(Map<String, Object> options, IHandler handler) throws UnknownHostException, IOException {
        this(InetAddress.getByName("0.0.0.0"), 0, options, handler, false, null);
    }

    public Server(int port, IHandler handler) throws UnknownHostException, IOException {
        this(new InetSocketAddress(InetAddress.getByName("0.0.0.0"), port), new HashMap<String, Object>(), handler, Server.newServerWorkerPool(250), false, null);
    }

    public Server(int port, Object handler) throws UnknownHostException, IOException {
        this(new InetSocketAddress(InetAddress.getByName("0.0.0.0"), port), new HashMap<String, Object>(), handler, Server.newServerWorkerPool(250), false, null);
    }

    public Server(int port, IHandler handler, Executor workerpool) throws UnknownHostException, IOException {
        this(InetAddress.getByName("0.0.0.0"), port, new HashMap<String, Object>(), handler, workerpool, false, null);
    }

    public Server(int port, Object handler, int maxWorkers) throws UnknownHostException, IOException {
        this(new InetSocketAddress(InetAddress.getByName("0.0.0.0"), port), new HashMap<String, Object>(), handler, Server.newServerWorkerPool(maxWorkers), false, null);
    }

    public Server(int port, Map<String, Object> options, IHandler handler) throws UnknownHostException, IOException {
        this(InetAddress.getByName("0.0.0.0"), port, options, handler, false, null);
    }

    public Server(InetAddress address, int port, IHandler handler) throws UnknownHostException, IOException {
        this(address, port, new HashMap<String, Object>(), handler, false, null);
    }

    public Server(InetAddress address, int port, IHandler handler, Executor workerPool) throws UnknownHostException, IOException {
        this(address, port, new HashMap<String, Object>(), handler, workerPool, false, null);
    }

    public Server(String ipAddress, int port, IHandler handler) throws UnknownHostException, IOException {
        this(InetAddress.getByName(ipAddress), port, new HashMap<String, Object>(), handler, false, null);
    }

    public Server(String ipAddress, int port, Map<String, Object> options, IHandler handler) throws UnknownHostException, IOException {
        this(InetAddress.getByName(ipAddress), port, options, handler, false, null);
    }

    public Server(int port, IHandler handler, boolean sslOn, SSLContext sslContext) throws UnknownHostException, IOException {
        this(InetAddress.getByName("0.0.0.0"), port, new HashMap<String, Object>(), handler, sslOn, sslContext);
    }

    public Server(int port, Map<String, Object> options, IHandler handler, boolean sslOn, SSLContext sslContext) throws UnknownHostException, IOException {
        this(InetAddress.getByName("0.0.0.0"), port, options, handler, sslOn, sslContext);
    }

    public Server(String ipAddress, int port, IHandler handler, boolean sslOn, SSLContext sslContext) throws UnknownHostException, IOException {
        this(InetAddress.getByName(ipAddress), port, new HashMap<String, Object>(), handler, sslOn, sslContext);
    }

    public Server(String ipAddress, int port, Map<String, Object> options, IHandler handler, boolean sslOn, SSLContext sslContext) throws UnknownHostException, IOException {
        this(InetAddress.getByName(ipAddress), port, options, handler, sslOn, sslContext);
    }

    public Server(InetAddress address, int port, IHandler handler, boolean sslOn, SSLContext sslContext) throws UnknownHostException, IOException {
        this(address, port, new HashMap<String, Object>(), handler, sslOn, sslContext);
    }

    public Server(InetAddress address, int port, Map<String, Object> options, IHandler handler, boolean sslOn, SSLContext sslContext) throws UnknownHostException, IOException {
        this(address, port, options, handler, Server.newServerWorkerPool(250), sslOn, sslContext);
        this.isSelfCreatedWorkerPool = true;
    }

    public Server(int port, Object appHandler, int maxWorkers, boolean sslOn, SSLContext sslContext) throws UnknownHostException, IOException {
        this(new InetSocketAddress(InetAddress.getByName("0.0.0.0"), port), new HashMap<String, Object>(), appHandler, Server.newServerWorkerPool(maxWorkers), sslOn, sslContext);
    }

    public Server(InetAddress address, int port, Map<String, Object> options, IHandler appHandler, Executor workerpool, boolean sslOn, SSLContext sslContext) throws UnknownHostException, IOException {
        this(new InetSocketAddress(address, port), options, appHandler, workerpool, sslOn, sslContext);
    }

    private Server(InetSocketAddress address, Map<String, Object> options, Object appHandler, Executor workerpool, boolean sslOn, SSLContext sslContext) throws UnknownHostException, IOException {
        this.address = address;
        this.options = options;
        this.workerpool = workerpool;
        this.sslOn = sslOn;
        this.sslContext = sslContext;
        this.ioHandlerContext.updateWorkerpool(workerpool);
        this.setAppHandler(appHandler);
    }

    private void setAppHandler(Object appHandler) {
        this.orgAppHandler = appHandler;
        this.ioHandlerContext.updateAppHandler(appHandler);
        this.injectServerContext(appHandler);
        this.appHandlerPrototype = this.ioHandlerContext.isDynamicHandler() ? DynamicHandlerAdapterFactory.getInstance().createHandlerAdapter(this.ioHandlerContext, appHandler) : (IHandler)appHandler;
    }

    public Object getAppHandler() {
        return this.orgAppHandler;
    }

    public void setServerName(String name) {
        this.name = name;
    }

    public String getServerName() {
        return this.name;
    }

    private static IServerIoProvider getServerIoProvider() {
        if (serverIoProvider == null) {
            String serverIoProviderClassname = System.getProperty("org.xsocket.stream.io.spi.ServerIoProviderClass");
            if (serverIoProviderClassname != null) {
                try {
                    Class<?> serverIoProviderClass = Class.forName(serverIoProviderClassname);
                    serverIoProvider = (IServerIoProvider)serverIoProviderClass.newInstance();
                }
                catch (Exception e) {
                    LOG.warning("error occured by creating ServerIoProivder " + serverIoProviderClassname + ": " + e.toString());
                    LOG.info("using default ServerIoProvider");
                }
            }
            if (serverIoProvider == null) {
                serverIoProvider = new IoProvider();
            }
        }
        return serverIoProvider;
    }

    @Override
    public final void run() {
        try {
            if (this.appHandlerPrototype == null) {
                LOG.warning("no handler has been set. Call setHandler-method to set an assigned handler");
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    Server.this.close();
                }
            });
            this.acceptor = this.sslContext != null ? new IoProvider().create(new AcceptorCallback(), this.ioHandlerContext, this.address, 0, this.options, this.sslContext, this.sslOn) : Server.getServerIoProvider().createAcceptor(new AcceptorCallback(), this.ioHandlerContext, this.address, 0, this.options);
            this.acceptor.listen();
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    @Override
    public Object getOption(String name) throws IOException {
        return this.acceptor.getOption(name);
    }

    public IHandler getHandler() {
        return this.appHandlerPrototype;
    }

    @Override
    public Map<String, Class> getOptions() {
        return this.acceptor.getOptions();
    }

    @Override
    public void close() {
        if (this.isOpen) {
            this.isOpen = false;
            try {
                this.acceptor.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.isSelfCreatedWorkerPool && this.workerpool instanceof ExecutorService) {
                ((ExecutorService)this.workerpool).shutdown();
            }
        }
    }

    private static final ExecutorService newServerWorkerPool(int size) {
        return Executors.newFixedThreadPool(size);
    }

    IAcceptor getAcceptor() {
        return this.acceptor;
    }

    @Override
    public void addListener(IServerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void setConnectionFactory(INonBlockingConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    @Override
    public boolean removeListener(IServerListener listener) {
        boolean result = this.listeners.remove(listener);
        return result;
    }

    @Override
    public Executor getWorkerpool() {
        return this.workerpool;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    private void destroyCurrentHandler() {
        if (this.appHandlerPrototype != null) {
            if (this.ioHandlerContext.isLifeCycleHandler()) {
                ((ILifeCycle)((Object)this.appHandlerPrototype)).onDestroy();
            }
            this.appHandlerPrototype = null;
        }
    }

    private void initCurrentHandler() {
        if (this.ioHandlerContext.isLifeCycleHandler()) {
            ((ILifeCycle)((Object)this.appHandlerPrototype)).onInit();
        }
    }

    @Override
    public final int getLocalPort() {
        return this.acceptor.getLocalPort();
    }

    @Override
    public final InetAddress getLocalAddress() {
        return this.acceptor.getLocalAddress();
    }

    @Override
    public void setConnectionTimeoutSec(int timeoutSec) {
        this.connectionTimeoutSec = timeoutSec;
    }

    @Override
    public void setIdleTimeoutSec(int timeoutSec) {
        this.idleTimeoutSec = timeoutSec;
    }

    @Override
    public int getConnectionTimeoutSec() {
        return this.connectionTimeoutSec;
    }

    @Override
    public int getIdleTimeoutSec() {
        return this.idleTimeoutSec;
    }

    private int numberOfOpenConnections() {
        return this.acceptor.getNumberOfOpenConnections();
    }

    public String getImplementationVersion() {
        if (implementationVersion == null) {
            try {
                LineNumberReader lnr = new LineNumberReader(new InputStreamReader(this.getClass().getResourceAsStream("/org/xsocket/version.txt")));
                String line = null;
                do {
                    if ((line = lnr.readLine()) == null || !line.startsWith("Implementation-Version=")) continue;
                    implementationVersion = line.substring("Implementation-Version=".length(), line.length()).trim();
                    break;
                } while (line != null);
                lnr.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return implementationVersion;
    }

    private void injectServerContext(Object hdl) {
        Field[] fields;
        HandlerContext ctx = null;
        for (Field field : fields = hdl.getClass().getDeclaredFields()) {
            Resource annotation;
            if (!field.isAnnotationPresent(Resource.class) || (annotation = field.getAnnotation(Resource.class)).type() != IServerContext.class && field.getType() != IServerContext.class) continue;
            field.setAccessible(true);
            try {
                if (ctx == null) {
                    ctx = new HandlerContext();
                }
                field.set(hdl, ctx);
            }
            catch (IllegalAccessException iae) {
                LOG.warning("could not set HandlerContext for attribute " + field.getName() + ". Reason " + iae.toString());
            }
        }
    }

    private final class HandlerContext
    implements IServerContext {
        private HandlerContext() {
        }

        @Override
        public int getLocalPort() {
            return Server.this.getLocalPort();
        }

        @Override
        public InetAddress getLocalAddress() {
            return Server.this.getLocalAddress();
        }

        @Override
        public int getNumberOfOpenConnections() {
            return Server.this.numberOfOpenConnections();
        }

        @Override
        public Executor getWorkerpool() {
            return Server.this.getWorkerpool();
        }
    }

    private final class AcceptorCallback
    implements IAcceptorCallback {
        private AcceptorCallback() {
        }

        @Override
        public void onConnected() {
            String verInfo;
            Server.this.isOpen = true;
            Server.this.initCurrentHandler();
            for (IServerListener listener : (ArrayList)Server.this.listeners.clone()) {
                listener.onInit();
            }
            String versionInfo = Server.this.getImplementationVersion();
            if (versionInfo.length() > 0) {
                versionInfo = "xSocket " + versionInfo;
            }
            if (!(serverIoProvider instanceof IoProvider) && (verInfo = Server.getServerIoProvider().getImplementationVersion()).length() > 0) {
                versionInfo = versionInfo + "; " + Server.getServerIoProvider().getClass().getSimpleName() + " " + verInfo;
            }
            LOG.info(Server.this.name + " listening on " + Server.this.acceptor.getLocalAddress().getHostName() + "/" + Server.this.acceptor.getLocalPort() + " (" + versionInfo + ")");
        }

        @Override
        public void onDisconnected() {
            Server.this.destroyCurrentHandler();
            for (IServerListener listener : (ArrayList)Server.this.listeners.clone()) {
                listener.onDestroy();
            }
            LOG.info("server has been shutdown");
        }

        @Override
        public void onConnectionAccepted(IIoHandler ioHandler) throws IOException {
            IHandler hdl;
            block3: {
                hdl = Server.this.appHandlerPrototype;
                if (Server.this.ioHandlerContext.isAppHandlerConnectionScoped()) {
                    try {
                        hdl = (IHandler)((IConnectionScoped)((Object)Server.this.appHandlerPrototype)).clone();
                    }
                    catch (CloneNotSupportedException cne) {
                        if (!LOG.isLoggable(Level.FINE)) break block3;
                        LOG.fine("error occured by cloning appHandler " + Server.this.appHandlerPrototype.getClass().getName() + ". " + cne.toString());
                    }
                }
            }
            INonBlockingConnection connection = Server.this.connectionFactory.createNonBlockingConnection(Server.this.ioHandlerContext, ioHandler, hdl, Server.getServerIoProvider());
            connection.setIdleTimeoutSec(Server.this.idleTimeoutSec);
            connection.setConnectionTimeoutSec(Server.this.connectionTimeoutSec);
        }
    }
}

