/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.xsocket.IntrospectionBasedDynamicBean;
import org.xsocket.stream.IServer;
import org.xsocket.stream.IServerListener;
import org.xsocket.stream.IServerMXBean;
import org.xsocket.stream.Server;
import org.xsocket.stream.io.impl.JmxIoProvider;
import org.xsocket.stream.io.spi.IAcceptorMXBean;
import org.xsocket.stream.io.spi.IServerIoJmxProvider;

public final class ServerMBeanProxyFactory {
    private static final Logger LOG = Logger.getLogger(ServerMBeanProxyFactory.class.getName());
    private static IServerIoJmxProvider jmxProvider = null;

    public static ObjectName createAndRegister(Server server) throws JMException {
        return ServerMBeanProxyFactory.createAndRegister(server, "org.xsocket.stream");
    }

    public static ObjectName createAndRegister(Server server, String domain) throws JMException {
        return ServerMBeanProxyFactory.createAndRegister(ManagementFactory.getPlatformMBeanServer(), server, domain);
    }

    public static ObjectName createAndRegister(MBeanServer mbeanServer, Server server, String domain) throws JMException {
        String address = server.getLocalAddress().getCanonicalHostName() + "/" + server.getLocalPort();
        ObjectName serverObjectName = ServerMBeanProxyFactory.registerMBeans(server, domain, address);
        server.addListener(new Listener(server, domain, address));
        return serverObjectName;
    }

    private static ObjectName registerMBeans(Server server, String domain, String address) throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException, JMException {
        ObjectName hdlObjectName = new ObjectName(domain + ":type=Handler,name=" + address);
        ManagementFactory.getPlatformMBeanServer().registerMBean(new IntrospectionBasedDynamicBean(server.getAppHandler()), hdlObjectName);
        ObjectName acceptorObjectName = new ObjectName(domain + ":type=Acceptor,name=" + address);
        IAcceptorMXBean acceptorMXBean = jmxProvider.createMBean(server, server.getAcceptor(), domain, address);
        ManagementFactory.getPlatformMBeanServer().registerMBean(acceptorMXBean, acceptorObjectName);
        ObjectName workerpoolObjectName = new ObjectName(domain + ":type=Workerpool,name=" + address);
        ManagementFactory.getPlatformMBeanServer().registerMBean(new IntrospectionBasedDynamicBean(server.getWorkerpool()), workerpoolObjectName);
        ObjectName serverObjectName = new ObjectName(domain + ":type=Server,name=" + address);
        ServerMXBeanAdapter serverMXBean = new ServerMXBeanAdapter(server);
        ManagementFactory.getPlatformMBeanServer().registerMBean(serverMXBean, serverObjectName);
        return serverObjectName;
    }

    private static void unregisterMBeans(IServer server, String domain, String address) throws JMException {
        ObjectName hdlObjectName = new ObjectName(domain + ":type=Handler,name=" + address);
        ManagementFactory.getPlatformMBeanServer().unregisterMBean(hdlObjectName);
        ObjectName acceptorObjectName = new ObjectName(domain + ":type=Acceptor,name=" + address);
        ManagementFactory.getPlatformMBeanServer().unregisterMBean(acceptorObjectName);
        ObjectName workerpoolObjectName = new ObjectName(domain + ":type=Workerpool,name=" + address);
        ManagementFactory.getPlatformMBeanServer().unregisterMBean(workerpoolObjectName);
        ObjectName serverObjectName = new ObjectName(domain + ":type=Server,name=" + address);
        ManagementFactory.getPlatformMBeanServer().unregisterMBean(serverObjectName);
    }

    static {
        String jmxIoProviderClassname = System.getProperty("org.xsocket.stream.io.spi.ServerIoJmxProviderClass");
        if (jmxIoProviderClassname != null) {
            try {
                Class<?> jmxProviderClass = Class.forName(jmxIoProviderClassname);
                jmxProvider = (IServerIoJmxProvider)jmxProviderClass.newInstance();
            }
            catch (Exception e) {
                LOG.warning("error occured by creating jmxProivder " + jmxIoProviderClassname + ": " + e.toString());
            }
        }
        if (jmxProvider == null) {
            jmxProvider = new JmxIoProvider();
        }
    }

    private static final class ServerMXBeanAdapter
    implements IServerMXBean {
        private IServer delegee = null;

        public ServerMXBeanAdapter(IServer delegee) {
            this.delegee = delegee;
        }

        @Override
        public int getConnectionTimeoutSec() {
            return this.delegee.getConnectionTimeoutSec();
        }

        @Override
        public int getIdleTimeoutSec() {
            return this.delegee.getIdleTimeoutSec();
        }

        @Override
        public boolean isOpen() {
            return this.delegee.isOpen();
        }

        @Override
        public void setConnectionTimeoutSec(int timeoutSec) {
            this.delegee.setConnectionTimeoutSec(timeoutSec);
        }

        @Override
        public void setIdleTimeoutSec(int timeoutInSec) {
            this.delegee.setIdleTimeoutSec(timeoutInSec);
        }
    }

    private static final class Listener
    implements IServerListener {
        private static final Logger LOG = Logger.getLogger(Listener.class.getName());
        private Server server = null;
        private String domain = null;
        private String address = null;

        Listener(Server server, String domain, String address) {
            this.server = server;
            this.domain = domain;
            this.address = address;
            server.addListener(this);
        }

        @Override
        public void onInit() {
        }

        @Override
        public void onDestroy() {
            block2: {
                try {
                    ServerMBeanProxyFactory.unregisterMBeans(this.server, this.domain, this.address);
                }
                catch (Exception ex) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("error occured by deregistering the server (domain=" + this.domain + "). reason: " + ex.toString());
                }
            }
        }
    }
}

