/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import org.xsocket.stream.INonBlockingConnection;
import org.xsocket.stream.IServer;
import org.xsocket.stream.IServerListener;

public final class StreamUtils {
    public static final String SERVER_TRHREAD_PREFIX = "xServer";

    private StreamUtils() {
    }

    public static int validateSufficientDatasizeByIntLengthField(INonBlockingConnection connection) throws IOException, BufferUnderflowException {
        connection.resetToReadMark();
        connection.markReadPosition();
        int length = connection.readInt();
        if (connection.getNumberOfAvailableBytes() < length) {
            throw new BufferUnderflowException();
        }
        connection.removeReadMark();
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start(IServer server) {
        IServerListener startupListener = new IServerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onInit() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    this.notify();
                }
            }

            @Override
            public void onDestroy() {
            }
        };
        server.addListener(startupListener);
        Thread t = new Thread(server);
        t.start();
        if (!server.isOpen()) {
            IServerListener iServerListener = startupListener;
            synchronized (iServerListener) {
                try {
                    startupListener.wait();
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            }
        }
        t.setName("xServer:" + server.getLocalPort());
        server.removeListener(startupListener);
    }
}

