/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream.io.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xsocket.ByteBufferQueue;
import org.xsocket.ClosedConnectionException;
import org.xsocket.stream.io.impl.ChainableIoHandler;
import org.xsocket.stream.io.impl.IMemoryManager;
import org.xsocket.stream.io.impl.IoSSLHandler;
import org.xsocket.stream.io.impl.SSLProcessor;
import org.xsocket.stream.io.spi.IIoHandlerCallback;

final class IoActivateableSSLHandler
extends ChainableIoHandler
implements SSLProcessor.EventHandler {
    private static final Logger LOG = Logger.getLogger(IoSSLHandler.class.getName());
    private Mode mode = Mode.OFF;
    private final ByteBufferQueue inNetDataQueue = new ByteBufferQueue();
    private final ByteBufferQueue outAppDataQueue = new ByteBufferQueue();
    private final ByteBufferQueue inAppDataQueue = new ByteBufferQueue();
    private final IOEventHandler ioEventHandler = new IOEventHandler();
    private SSLProcessor sslProcessor = null;

    IoActivateableSSLHandler(ChainableIoHandler successor, SSLContext sslContext, boolean isClientMode, IMemoryManager memoryManager) throws IOException {
        super(successor);
        this.sslProcessor = new SSLProcessor(sslContext, isClientMode, memoryManager, this);
    }

    @Override
    public void init(IIoHandlerCallback callbackHandler) throws IOException {
        this.setPreviousCallback(callbackHandler);
        this.getSuccessor().init(this.ioEventHandler);
    }

    @Override
    public void setPreviousCallback(IIoHandlerCallback callbackHandler) {
        super.setPreviousCallback(callbackHandler);
        this.getSuccessor().setPreviousCallback(this.ioEventHandler);
    }

    @Override
    public final void close(boolean immediate) throws IOException {
        if (!immediate) {
            this.flushOutgoing();
        }
        this.getSuccessor().close(immediate);
    }

    public boolean isSSLActivated() {
        return this.mode == Mode.SSL;
    }

    @Override
    public int getPendingWriteDataSize() {
        return this.outAppDataQueue.getSize() + super.getPendingWriteDataSize();
    }

    @Override
    int getPendingReceiveDataSize() {
        return this.inAppDataQueue.getSize() + super.getPendingReceiveDataSize();
    }

    @Override
    public final LinkedList<ByteBuffer> drainIncoming() {
        if (this.mode == Mode.OFF) {
            return this.getSuccessor().drainIncoming();
        }
        return this.inAppDataQueue.drain();
    }

    @Override
    public final void writeOutgoing(ByteBuffer buffer) throws ClosedConnectionException, IOException {
        LinkedList<ByteBuffer> buffers = new LinkedList<ByteBuffer>();
        buffers.add(buffer);
        this.writeOutgoing(buffers);
    }

    @Override
    public final void writeOutgoing(LinkedList<ByteBuffer> buffers) throws ClosedConnectionException, IOException {
        this.outAppDataQueue.append(buffers);
        this.flushOutgoing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushOutgoing() throws IOException {
        if (this.mode == Mode.SSL) {
            SSLProcessor sSLProcessor = this.sslProcessor;
            synchronized (sSLProcessor) {
                if (this.sslProcessor.isHandshaking()) {
                    this.sslProcessor.processOutAppData();
                } else if (!this.outAppDataQueue.isEmpty()) {
                    this.sslProcessor.processOutAppData(this.outAppDataQueue.drain());
                }
            }
        } else if (this.mode == Mode.OFF || this.mode == Mode.NON_RECEIVING) {
            LinkedList<ByteBuffer> data = this.outAppDataQueue.drain();
            this.getSuccessor().writeOutgoing(data);
        }
    }

    public boolean preStartSecuredMode() {
        if (this.mode == Mode.OFF) {
            this.mode = Mode.NON_RECEIVING;
            return true;
        }
        LOG.warning("connection is already in ssl mode (mode=" + (Object)((Object)this.mode) + "). Ignore (pre)startSecured Mode");
        return false;
    }

    public void startSecuredMode(LinkedList<ByteBuffer> data) throws IOException {
        if (this.mode != Mode.NON_RECEIVING) {
            LOG.warning("connection is not in non_receiving mode (mode=" + (Object)((Object)this.mode) + ")");
            return;
        }
        this.mode = Mode.NON_RECEIVING_AND_WRITING;
        this.inNetDataQueue.addFirst(data);
        this.sslProcessor.start();
        this.mode = Mode.SSL;
        this.flushOutgoing();
        this.readIncomingEncryptedData();
    }

    @Override
    public void onHandshakeFinished() throws IOException {
        this.flushOutgoing();
        this.readIncomingEncryptedData();
    }

    protected final void readIncomingEncryptedData() throws ClosedConnectionException, IOException {
        this.inNetDataQueue.append(this.getSuccessor().drainIncoming());
        this.readIncomingEncryptedData(this.inNetDataQueue.drain());
    }

    private synchronized void readIncomingEncryptedData(LinkedList<ByteBuffer> inNetDataList) throws ClosedConnectionException, IOException {
        if (inNetDataList != null) {
            if (LOG.isLoggable(Level.FINE)) {
                int size = 0;
                for (ByteBuffer buffer : inNetDataList) {
                    size += buffer.remaining();
                }
                LOG.fine("received " + size + " bytes encrypted data");
            }
            this.sslProcessor.processInNetData(inNetDataList);
        }
    }

    @Override
    public void onSSLProcessorClosed() throws IOException {
        this.close(true);
    }

    @Override
    public void onInAppDataReceived(LinkedList<ByteBuffer> appDataList) {
        this.inAppDataQueue.append(appDataList);
        if (!this.inAppDataQueue.isEmpty()) {
            this.getPreviousCallback().onDataRead();
        }
    }

    @Override
    public void onOutNetDataToWrite(ByteBuffer netData) throws IOException {
        if (netData.hasRemaining()) {
            this.getSuccessor().writeOutgoing(netData);
        }
    }

    private final class IOEventHandler
    implements IIoHandlerCallback {
        private IOEventHandler() {
        }

        @Override
        public void onDataRead() {
            block5: {
                try {
                    if (IoActivateableSSLHandler.this.mode == Mode.OFF) {
                        IoActivateableSSLHandler.this.getPreviousCallback().onDataRead();
                        break block5;
                    }
                    if (IoActivateableSSLHandler.this.mode == Mode.SSL) {
                        IoActivateableSSLHandler.this.readIncomingEncryptedData();
                        break block5;
                    }
                    assert (IoActivateableSSLHandler.this.mode == Mode.NON_RECEIVING || IoActivateableSSLHandler.this.mode == Mode.NON_RECEIVING_AND_WRITING);
                    return;
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block5;
                    LOG.fine("[" + IoActivateableSSLHandler.this.getId() + "] error occured while receiving data. Reason: " + e.toString());
                }
            }
        }

        @Override
        public void onConnect() {
            IoActivateableSSLHandler.this.getPreviousCallback().onConnect();
        }

        @Override
        public void onWriteException(IOException ioException) {
            IoActivateableSSLHandler.this.getPreviousCallback().onWriteException(ioException);
        }

        @Override
        public void onWritten() {
            IoActivateableSSLHandler.this.getPreviousCallback().onWritten();
        }

        @Override
        public void onDisconnect() {
            IoActivateableSSLHandler.this.getPreviousCallback().onDisconnect();
        }

        @Override
        public void onConnectionAbnormalTerminated() {
            IoActivateableSSLHandler.this.getPreviousCallback().onConnectionAbnormalTerminated();
        }

        @Override
        public void onConnectionTimeout() {
            IoActivateableSSLHandler.this.getPreviousCallback().onConnectionTimeout();
        }

        @Override
        public void onIdleTimeout() {
            IoActivateableSSLHandler.this.getPreviousCallback().onIdleTimeout();
        }
    }

    private static enum Mode {
        OFF,
        NON_RECEIVING,
        NON_RECEIVING_AND_WRITING,
        SSL;

    }
}

