/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream.io.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.stream.io.impl.ChainableIoHandler;
import org.xsocket.stream.io.spi.IIoHandlerCallback;
import org.xsocket.stream.io.spi.IIoHandlerContext;

final class IoMultithreadedHandler
extends ChainableIoHandler {
    private static final Logger LOG = Logger.getLogger(IoMultithreadedHandler.class.getName());
    private String id = "<null>";
    private IIoHandlerContext ctx = null;
    private final TaskQueue taskQueue = new TaskQueue();
    private final IOEventHandler eventHandler = new IOEventHandler();

    IoMultithreadedHandler(ChainableIoHandler successor, IIoHandlerContext ctx) {
        super(successor);
        this.ctx = ctx;
        this.setSuccessor(successor);
    }

    @Override
    public void init(IIoHandlerCallback callbackHandler) throws IOException {
        this.setPreviousCallback(callbackHandler);
        this.getSuccessor().init(this.eventHandler);
    }

    @Override
    public LinkedList<ByteBuffer> drainIncoming() {
        return this.getSuccessor().drainIncoming();
    }

    @Override
    public void close(boolean immediate) throws IOException {
        if (!immediate) {
            this.flushOutgoing();
        }
        this.getSuccessor().close(immediate);
    }

    @Override
    public void writeOutgoing(ByteBuffer buffer) throws IOException {
        this.getSuccessor().writeOutgoing(buffer);
    }

    @Override
    public void writeOutgoing(LinkedList<ByteBuffer> buffers) throws IOException {
        this.getSuccessor().writeOutgoing(buffers);
    }

    @Override
    public void flushOutgoing() throws IOException {
        this.getSuccessor().flushOutgoing();
    }

    private final class TaskQueueProcessor
    implements Runnable {
        private TaskQueueProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!IoMultithreadedHandler.this.ctx.isAppHandlerThreadSafe()) {
                IoMultithreadedHandler ioMultithreadedHandler = IoMultithreadedHandler.this;
                synchronized (ioMultithreadedHandler) {
                    Runnable task = (Runnable)IoMultithreadedHandler.this.taskQueue.tasks.poll();
                    this.processTask(task);
                }
            } else {
                Runnable task = null;
                task = (Runnable)IoMultithreadedHandler.this.taskQueue.tasks.poll();
                this.processTask(task);
            }
        }

        private void processTask(Runnable task) {
            block3: {
                if (task != null) {
                    try {
                        task.run();
                    }
                    catch (Exception e) {
                        if (!LOG.isLoggable(Level.FINE)) break block3;
                        LOG.fine("error occured by proccesing task " + task);
                    }
                }
            }
        }
    }

    private final class TaskQueue {
        private final TaskQueueProcessor taskProcessor;
        private final Queue<Runnable> tasks;

        private TaskQueue() {
            this.taskProcessor = new TaskQueueProcessor();
            this.tasks = new ConcurrentLinkedQueue<Runnable>();
        }

        public void processTask(Runnable task) {
            if (IoMultithreadedHandler.this.ctx.getWorkerpool() != null) {
                this.tasks.offer(task);
                IoMultithreadedHandler.this.ctx.getWorkerpool().execute(this.taskProcessor);
            } else {
                task.run();
            }
        }
    }

    private final class IOEventHandler
    implements IIoHandlerCallback {
        private IOEventHandler() {
        }

        @Override
        public void onWriteException(IOException ioException) {
            IoMultithreadedHandler.this.getPreviousCallback().onWriteException(ioException);
        }

        @Override
        public void onWritten() {
            IoMultithreadedHandler.this.getPreviousCallback().onWritten();
        }

        @Override
        public void onConnectionAbnormalTerminated() {
            IoMultithreadedHandler.this.getPreviousCallback().onConnectionAbnormalTerminated();
        }

        @Override
        public void onConnect() {
            if (IoMultithreadedHandler.this.ctx.isAppHandlerListenForConnectEvent()) {
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        block2: {
                            try {
                                IoMultithreadedHandler.this.getPreviousCallback().onConnect();
                            }
                            catch (Exception e) {
                                if (!LOG.isLoggable(Level.FINE)) break block2;
                                LOG.fine("[" + IoMultithreadedHandler.this.id + "] error occured by handling connect. Reason: " + e.toString());
                            }
                        }
                    }
                };
                IoMultithreadedHandler.this.taskQueue.processTask(task);
            }
        }

        @Override
        public void onDataRead() {
            if (IoMultithreadedHandler.this.ctx.isAppHandlerListenForDataEvent()) {
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        block2: {
                            try {
                                IoMultithreadedHandler.this.getPreviousCallback().onDataRead();
                            }
                            catch (Exception e) {
                                if (!LOG.isLoggable(Level.FINE)) break block2;
                                LOG.fine("[" + IoMultithreadedHandler.this.id + "] error occured by handling data. Reason: " + e.toString());
                            }
                        }
                    }
                };
                IoMultithreadedHandler.this.taskQueue.processTask(task);
            }
        }

        @Override
        public void onDisconnect() {
            if (IoMultithreadedHandler.this.ctx.isAppHandlerListenforDisconnectEvent()) {
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        block2: {
                            try {
                                IoMultithreadedHandler.this.getPreviousCallback().onDisconnect();
                            }
                            catch (Exception e) {
                                if (!LOG.isLoggable(Level.FINE)) break block2;
                                LOG.fine("[" + IoMultithreadedHandler.this.id + "] error occured by handling connect. Reason: " + e.toString());
                            }
                        }
                    }
                };
                IoMultithreadedHandler.this.taskQueue.processTask(task);
            }
        }

        @Override
        public void onConnectionTimeout() {
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            IoMultithreadedHandler.this.getPreviousCallback().onConnectionTimeout();
                        }
                        catch (Exception e) {
                            if (!LOG.isLoggable(Level.FINE)) break block2;
                            LOG.fine("[" + IoMultithreadedHandler.this.id + "] error occured by handling onConnectionTimeout. Reason: " + e.toString());
                        }
                    }
                }
            };
            IoMultithreadedHandler.this.taskQueue.processTask(task);
        }

        @Override
        public void onIdleTimeout() {
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            IoMultithreadedHandler.this.getPreviousCallback().onIdleTimeout();
                        }
                        catch (Exception e) {
                            if (!LOG.isLoggable(Level.FINE)) break block2;
                            LOG.fine("[" + IoMultithreadedHandler.this.id + "] error occured by handling onIdleTimeout. Reason: " + e.toString());
                        }
                    }
                }
            };
            IoMultithreadedHandler.this.taskQueue.processTask(task);
        }
    }
}

