/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream.io.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.IDispatcher;
import org.xsocket.stream.io.impl.IIoSocketDispatcherPoolListener;
import org.xsocket.stream.io.impl.IoSocketDispatcher;
import org.xsocket.stream.io.impl.IoSocketHandler;
import org.xsocket.stream.io.impl.UnsynchronizedMemoryManager;

final class IoSocketDispatcherPool {
    private static final Logger LOG = Logger.getLogger(IoSocketDispatcherPool.class.getName());
    private boolean isRunning = true;
    private int preallocationSize = 65536;
    private boolean useDirect = false;
    private final List<IIoSocketDispatcherPoolListener> listeners = new ArrayList<IIoSocketDispatcherPoolListener>();
    private final LinkedList<IoSocketDispatcher> dispatchers = new LinkedList();
    private int size = 0;
    private int pointer = 0;

    IoSocketDispatcherPool(int preallocationSize, boolean useDirect) {
        this.preallocationSize = preallocationSize;
        this.useDirect = useDirect;
    }

    synchronized void setSize(int size) {
        this.size = size;
        this.updateDispatcher();
    }

    synchronized void addListener(IIoSocketDispatcherPoolListener listener) {
        this.listeners.add(listener);
    }

    synchronized boolean removeListener(IIoSocketDispatcherPoolListener listener) {
        return this.listeners.remove(listener);
    }

    void run() {
        this.isRunning = true;
        this.updateDispatcher();
    }

    void resetStatistics() {
        LinkedList copy = (LinkedList)this.dispatchers.clone();
        for (IoSocketDispatcher dispatcher : copy) {
            dispatcher.resetStatistics();
        }
    }

    synchronized int getReceiveBufferPreallocationSize() {
        return this.preallocationSize;
    }

    synchronized void setReceiveBufferPreallocationSize(int size) {
        this.preallocationSize = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<IDispatcher<IoSocketHandler>> getDispatchers() {
        List result = null;
        LinkedList<IoSocketDispatcher> linkedList = this.dispatchers;
        synchronized (linkedList) {
            result = (List)this.dispatchers.clone();
        }
        return result;
    }

    private synchronized void updateDispatcher() {
        if (this.isRunning) {
            int currentRunning = this.dispatchers.size();
            if (currentRunning != this.size) {
                IDispatcher dispatcher;
                int i;
                if (currentRunning > this.size) {
                    for (i = this.size; i < currentRunning; ++i) {
                        block12: {
                            dispatcher = this.dispatchers.getLast();
                            this.dispatchers.remove(dispatcher);
                            try {
                                dispatcher.close();
                            }
                            catch (IOException ioe) {
                                if (!LOG.isLoggable(Level.FINE)) break block12;
                                LOG.fine("error occured by closing the dispatcher " + dispatcher + ". reason " + ioe.toString());
                            }
                        }
                        for (IIoSocketDispatcherPoolListener listener : this.listeners) {
                            listener.onDispatcherRemoved(dispatcher);
                        }
                    }
                } else if (currentRunning < this.size) {
                    for (i = currentRunning; i < this.size; ++i) {
                        dispatcher = new IoSocketDispatcher(new UnsynchronizedMemoryManager(this.preallocationSize, this.useDirect));
                        this.dispatchers.addLast((IoSocketDispatcher)dispatcher);
                        Thread t = new Thread(dispatcher);
                        t.setDaemon(false);
                        t.setName("xDispatcher#" + i);
                        t.start();
                        for (IIoSocketDispatcherPoolListener listener : this.listeners) {
                            listener.onDispatcherAdded(dispatcher);
                        }
                    }
                }
            }
            IDispatcher[] connectionDispatchers = new IDispatcher[this.dispatchers.size()];
            for (int i = 0; i < connectionDispatchers.length; ++i) {
                connectionDispatchers[i] = this.dispatchers.get(i);
            }
        }
    }

    void shutdown() {
        this.isRunning = false;
        if (LOG.isLoggable(Level.FINER)) {
            LOG.fine("terminate dispatchers");
        }
        for (IoSocketDispatcher dispatcher : this.dispatchers) {
            try {
                dispatcher.close();
                for (IIoSocketDispatcherPoolListener listener : this.listeners) {
                    listener.onDispatcherRemoved(dispatcher);
                }
            }
            catch (IOException ioe) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("error occured by closing the dispatcher " + dispatcher + ". reason " + ioe.toString());
            }
        }
        this.dispatchers.clear();
    }

    IoSocketDispatcher nextDispatcher() {
        ++this.pointer;
        if (this.pointer >= this.size) {
            this.pointer = 0;
        }
        return this.dispatchers.get(this.pointer);
    }

    long getNumberOfConnectionTimeouts() {
        long timeouts = 0L;
        LinkedList copy = (LinkedList)this.dispatchers.clone();
        for (IoSocketDispatcher dispatcher : copy) {
            timeouts += dispatcher.getCountConnectionTimeout();
        }
        return timeouts;
    }

    public long getNumberOfIdleTimeouts() {
        long timeouts = 0L;
        LinkedList copy = (LinkedList)this.dispatchers.clone();
        for (IoSocketDispatcher dispatcher : copy) {
            timeouts += dispatcher.getCountIdleTimeout();
        }
        return timeouts;
    }
}

