/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream.io.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.ByteBufferQueue;
import org.xsocket.ClosedConnectionException;
import org.xsocket.DataConverter;
import org.xsocket.IDispatcher;
import org.xsocket.IHandle;
import org.xsocket.stream.io.impl.ChainableIoHandler;
import org.xsocket.stream.io.impl.IMemoryManager;
import org.xsocket.stream.io.impl.IoProvider;
import org.xsocket.stream.io.impl.IoSocketDispatcher;
import org.xsocket.stream.io.impl.UnsynchronizedMemoryManager;
import org.xsocket.stream.io.spi.IIoHandlerCallback;
import org.xsocket.stream.io.spi.IIoHandlerContext;

final class IoSocketHandler
extends ChainableIoHandler
implements IHandle {
    private static final Logger LOG = Logger.getLogger(IoSocketHandler.class.getName());
    private static final int MIN_READ_BUFFER_SIZE = 64;
    private static final Map<String, Class> SUPPORTED_OPTIONS = new HashMap<String, Class>();
    private boolean isLogicalOpen = true;
    private boolean isDisconnect = false;
    private SocketChannel channel = null;
    private IoSocketDispatcher dispatcher = null;
    private IMemoryManager memoryManager = null;
    private final ByteBufferQueue sendQueue = new ByteBufferQueue();
    private final ByteBufferQueue receiveQueue = new ByteBufferQueue();
    private String id = null;
    private long idleTimeout = Long.MAX_VALUE;
    private long connectionTimeout = Long.MAX_VALUE;
    private boolean suspendRead = false;
    private long openTime = -1L;
    private long lastTimeReceived = System.currentTimeMillis();
    private long receivedBytes = 0L;
    private long sendBytes = 0L;

    IoSocketHandler(SocketChannel channel, IoSocketDispatcher dispatcher, IIoHandlerContext ctx, String connectionId) throws IOException {
        super(null);
        assert (channel != null);
        this.channel = channel;
        this.openTime = System.currentTimeMillis();
        channel.configureBlocking(false);
        this.dispatcher = dispatcher;
        this.id = connectionId;
    }

    @Override
    public void init(IIoHandlerCallback callbackHandler) throws IOException, SocketTimeoutException {
        this.setPreviousCallback(callbackHandler);
        this.blockUntilIsConnected();
        this.dispatcher.register(this, 1);
    }

    void setMemoryManager(IMemoryManager memoryManager) {
        this.memoryManager = memoryManager;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getPendingWriteDataSize() {
        return this.sendQueue.getSize() + super.getPendingWriteDataSize();
    }

    @Override
    int getPendingReceiveDataSize() {
        return this.receiveQueue.getSize() + super.getPendingReceiveDataSize();
    }

    @Override
    public void setOption(String name, Object value) throws IOException {
        IoProvider.setOption(this.channel.socket(), name, value);
    }

    @Override
    public Object getOption(String name) throws IOException {
        return IoProvider.getOption(this.channel.socket(), name);
    }

    @Override
    public Map<String, Class> getOptions() {
        return Collections.unmodifiableMap(SUPPORTED_OPTIONS);
    }

    @Override
    public void setIdleTimeoutSec(int timeout) {
        long timeoutMillis;
        if (timeout <= 0) {
            LOG.warning("connection timeout " + timeout + " sec is invalid");
            return;
        }
        this.idleTimeout = timeoutMillis = (long)timeout * 1000L;
        this.dispatcher.updateTimeoutCheckPeriod((long)timeout * 250L);
    }

    @Override
    public void setConnectionTimeoutSec(int timeout) {
        long timeoutMillis;
        if (timeout <= 0) {
            LOG.warning("connection timeout " + timeout + " sec is invalid");
            return;
        }
        this.connectionTimeout = timeoutMillis = (long)timeout * 1000L;
        this.dispatcher.updateTimeoutCheckPeriod((long)timeout * 250L);
    }

    @Override
    public int getConnectionTimeoutSec() {
        return (int)(this.connectionTimeout / 1000L);
    }

    @Override
    public int getIdleTimeoutSec() {
        return (int)(this.idleTimeout / 1000L);
    }

    public int getReceiveQueueSize() {
        return this.receiveQueue.getSize();
    }

    int getSendQueueSize() {
        return this.sendQueue.getSize();
    }

    boolean checkIdleTimeout(Long current) {
        boolean timeoutReached;
        long maxTime = this.lastTimeReceived + this.idleTimeout;
        if (maxTime < 0L) {
            maxTime = Long.MAX_VALUE;
        }
        boolean bl = timeoutReached = maxTime < current;
        if (timeoutReached) {
            this.getPreviousCallback().onIdleTimeout();
        }
        return timeoutReached;
    }

    void checkConnection() {
        if (!this.channel.isOpen()) {
            this.getPreviousCallback().onConnectionAbnormalTerminated();
        }
    }

    boolean checkConnectionTimeout(Long current) {
        boolean timeoutReached;
        long maxTime = this.openTime + this.connectionTimeout;
        if (maxTime < 0L) {
            maxTime = Long.MAX_VALUE;
        }
        boolean bl = timeoutReached = maxTime < current;
        if (timeoutReached) {
            this.getPreviousCallback().onConnectionTimeout();
        }
        return timeoutReached;
    }

    int getIncomingQueueSize() {
        return this.receiveQueue.getSize();
    }

    void onConnectEvent() throws IOException {
        this.getPreviousCallback().onConnect();
    }

    void onReadableEvent() throws IOException {
        block7: {
            assert (IoSocketDispatcher.isDispatcherThread());
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("[" + this.getId() + "] readable event occured for");
            }
            try {
                this.readSocketIntoReceiveQueue();
                if (this.getReceiveQueueSize() > 0) {
                    this.getPreviousCallback().onDataRead();
                }
                this.checkPreallocatedReadMemory();
            }
            catch (ClosedConnectionException ce) {
                this.close(false);
            }
            catch (Throwable t) {
                this.close(false);
                if (!LOG.isLoggable(Level.FINE)) break block7;
                LOG.fine("[" + this.getId() + "] error occured by handling readable event. reason: " + t.toString());
            }
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("[" + this.getId() + "] readable event handled");
        }
    }

    void onWriteableEvent() throws IOException {
        assert (IoSocketDispatcher.isDispatcherThread());
        if (this.suspendRead) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("[" + this.getId() + "] writeable event occured. update interested to none (because suspendRead is set) and write data to socket");
            }
            this.updateInterestedSetNonen();
        } else {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("[" + this.getId() + "] writeable event occured. update interested to read and write data to socket");
            }
            this.updateInterestedSetRead();
        }
        try {
            this.writeSendQueueDataToSocket();
            this.getPreviousCallback().onWritten();
        }
        catch (IOException ioe) {
            this.getPreviousCallback().onWriteException(ioe);
        }
        if (this.getSendQueueSize() > 0) {
            this.getDispatcher().updateInterestSet(this, 4);
        } else if (this.shouldClosedPhysically()) {
            this.realClose();
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("[" + this.getId() + "] writeable event handled");
        }
    }

    private void blockUntilIsConnected() throws IOException, SocketTimeoutException {
        while (!this.getChannel().finishConnect()) {
            try {
                Thread.sleep(25L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private boolean shouldClosedPhysically() {
        return !this.isLogicalOpen && this.sendQueue.isEmpty();
    }

    @Override
    public void writeOutgoing(ByteBuffer buffer) throws IOException {
        if (buffer != null) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("appending " + buffer.remaining() + " bytes to send buffer, and update interestedSet to write");
            }
            this.sendQueue.append(buffer);
            this.updateInterestedSetWrite();
        }
    }

    @Override
    public void writeOutgoing(LinkedList<ByteBuffer> buffers) throws IOException {
        if (buffers != null) {
            if (LOG.isLoggable(Level.FINEST)) {
                int size = 0;
                for (ByteBuffer buffer : buffers) {
                    size += buffer.remaining();
                }
                LOG.finest("appending " + size + " bytes to send buffer, and update interestedSet to write");
            }
            this.sendQueue.append(buffers);
            this.updateInterestedSetWrite();
        }
    }

    @Override
    public LinkedList<ByteBuffer> drainIncoming() {
        return this.receiveQueue.drain();
    }

    @Override
    public void close(boolean immediate) throws IOException {
        if (immediate || this.sendQueue.isEmpty()) {
            this.realClose();
        } else {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("postpone close until remaning data to write (" + this.sendQueue.getSize() + ") has been written");
            }
            this.isLogicalOpen = false;
            this.updateInterestedSetWrite();
        }
    }

    private void realClose() {
        block7: {
            block6: {
                try {
                    this.getDispatcher().deregister(this);
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block6;
                    LOG.fine("error occured by deregistering connection " + this.id + " on dispatcher. reason: " + e.toString());
                }
            }
            try {
                this.channel.close();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("connection " + this.id + " has been closed");
                }
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block7;
                LOG.fine("error occured by closing connection " + this.id + " reason: " + e.toString());
            }
        }
        if (!this.isDisconnect) {
            this.isDisconnect = true;
            this.getPreviousCallback().onDisconnect();
        }
    }

    void onDispatcherClose() {
        this.getPreviousCallback().onConnectionAbnormalTerminated();
    }

    private void updateInterestedSetWrite() throws ClosedConnectionException {
        try {
            this.dispatcher.updateInterestSet(this, 5);
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("couldn`t update interested set to write data on socket. Reason: " + ioe.toString());
            }
            try {
                this.dispatcher.deregister(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ClosedConnectionException("connection " + this.id + " is already closed", ioe);
        }
    }

    private void updateInterestedSetRead() throws ClosedConnectionException {
        try {
            this.dispatcher.updateInterestSet(this, 1);
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("couldn`t update interested set to read data. Reason: " + ioe.toString());
            }
            try {
                this.dispatcher.deregister(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ClosedConnectionException("connection " + this.id + " is already closed", ioe);
        }
    }

    private void updateInterestedSetNonen() throws ClosedConnectionException {
        try {
            this.dispatcher.updateInterestSet(this, 0);
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("could not update interested set to nonen. Reason: " + ioe.toString());
            }
            try {
                this.dispatcher.deregister(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ClosedConnectionException("connection " + this.id + " is already closed", ioe);
        }
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public SocketChannel getChannel() {
        return this.channel;
    }

    IDispatcher<IoSocketHandler> getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public void suspendRead() throws IOException {
        this.suspendRead = true;
        this.updateInterestedSetWrite();
    }

    @Override
    public void resumeRead() throws IOException {
        this.suspendRead = false;
        this.updateInterestedSetWrite();
    }

    private int readSocketIntoReceiveQueue() throws IOException {
        assert (IoSocketDispatcher.isDispatcherThread());
        int read = 0;
        this.lastTimeReceived = System.currentTimeMillis();
        if (this.isOpen() && !this.suspendRead) {
            assert (this.memoryManager instanceof UnsynchronizedMemoryManager);
            ByteBuffer readBuffer = this.memoryManager.acquireMemory(64);
            int pos = readBuffer.position();
            int limit = readBuffer.limit();
            try {
                read = this.channel.read(readBuffer);
            }
            catch (IOException ioe) {
                readBuffer.position(pos);
                readBuffer.limit(limit);
                this.memoryManager.recycleMemory(readBuffer, 64);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.id + "] error occured while reading channel: " + ioe.toString());
                }
                throw ioe;
            }
            switch (read) {
                case -1: {
                    this.memoryManager.recycleMemory(readBuffer, 64);
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + this.id + "] channel has reached end-of-stream (maybe closed by peer)");
                    }
                    ClosedConnectionException cce = new ClosedConnectionException("[" + this.id + "] End of stream reached");
                    throw cce;
                }
                case 0: {
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("[" + this.getId() + "] nothing to read");
                    }
                    this.memoryManager.recycleMemory(readBuffer, 64);
                    break;
                }
                default: {
                    int savePos = readBuffer.position();
                    int saveLimit = readBuffer.limit();
                    readBuffer.position(savePos - read);
                    readBuffer.limit(savePos);
                    ByteBuffer readData = readBuffer.slice();
                    this.receiveQueue.append(readData);
                    if (readBuffer.hasRemaining()) {
                        readBuffer.position(savePos);
                        readBuffer.limit(saveLimit);
                        this.memoryManager.recycleMemory(readBuffer, 64);
                    }
                    if (!LOG.isLoggable(Level.FINE)) break;
                    LOG.fine("[" + this.id + "] received (" + (readData.limit() - readData.position()) + " bytes, total " + (this.receivedBytes + (long)read) + " bytes): " + DataConverter.toTextOrHexString(new ByteBuffer[]{readData.duplicate()}, "UTF-8", 500));
                }
            }
            this.receivedBytes += (long)read;
        } else if (LOG.isLoggable(Level.FINEST)) {
            if (!this.isOpen()) {
                LOG.finest("[" + this.getId() + "] couldn't read socket because socket is already closed");
            }
            if (this.suspendRead) {
                LOG.finest("[" + this.getId() + "] read is suspended, do nothing");
            }
        }
        return read;
    }

    private void checkPreallocatedReadMemory() {
        assert (IoSocketDispatcher.isDispatcherThread());
        this.memoryManager.preallocate(64);
    }

    private void writeSendQueueDataToSocket() throws IOException {
        assert (IoSocketDispatcher.isDispatcherThread());
        if (this.isOpen() && !this.sendQueue.isEmpty()) {
            ByteBuffer buffer = null;
            do {
                int writeSize;
                if ((buffer = this.sendQueue.removeFirst()) == null || (writeSize = buffer.remaining()) <= 0) continue;
                if (LOG.isLoggable(Level.FINE) && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.id + "] sending (" + writeSize + " bytes): " + DataConverter.toTextOrHexString(buffer.duplicate(), "UTF-8", 500));
                }
                int written = this.channel.write(buffer);
                this.sendBytes += (long)written;
                if (written == writeSize) continue;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.id + "] " + written + " of " + (writeSize - written) + " bytes has been sent. initiate sending of the remaining (total sent " + this.sendBytes + " bytes)");
                }
                this.sendQueue.addFirst(buffer);
                this.updateInterestedSetWrite();
                break;
            } while (buffer != null);
        } else if (LOG.isLoggable(Level.FINEST)) {
            if (!this.isOpen()) {
                LOG.finest("[" + this.getId() + "] couldn't write send queue to socket because socket is already closed (sendQueuesize=" + DataConverter.toFormatedBytesSize(this.sendQueue.getSize()) + ")");
            }
            if (this.sendQueue.isEmpty()) {
                LOG.finest("[" + this.getId() + "] nothing to write, because send queue is empty ");
            }
        }
    }

    @Override
    public final InetAddress getLocalAddress() {
        return this.channel.socket().getLocalAddress();
    }

    @Override
    public final int getLocalPort() {
        return this.channel.socket().getLocalPort();
    }

    @Override
    public final InetAddress getRemoteAddress() {
        return this.channel.socket().getInetAddress();
    }

    @Override
    public final int getRemotePort() {
        return this.channel.socket().getPort();
    }

    @Override
    public void flushOutgoing() {
    }

    @Override
    public String toString() {
        try {
            return "(" + this.channel.socket().getInetAddress().toString() + ":" + this.channel.socket().getPort() + " -> " + this.channel.socket().getLocalAddress().toString() + ":" + this.channel.socket().getLocalPort() + ")" + " received=" + DataConverter.toFormatedBytesSize(this.receivedBytes) + ", sent=" + DataConverter.toFormatedBytesSize(this.sendBytes) + ", age=" + DataConverter.toFormatedDuration(System.currentTimeMillis() - this.openTime) + ", lastReceived=" + DataConverter.toFormatedDate(this.lastTimeReceived) + ", sendQueueSize=" + DataConverter.toFormatedBytesSize(this.sendQueue.getSize()) + " [" + this.id + "]";
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    static {
        SUPPORTED_OPTIONS.put("SOL_SOCKET.SO_RCVBUF", Integer.class);
        SUPPORTED_OPTIONS.put("SOL_SOCKET.SO_SNDBUF", Integer.class);
        SUPPORTED_OPTIONS.put("SOL_SOCKET.SO_REUSEADDR", Boolean.class);
        SUPPORTED_OPTIONS.put("SOL_SOCKET.SO_KEEPALIVE", Boolean.class);
        SUPPORTED_OPTIONS.put("IPPROTO_TCP.TCP_NODELAY", Boolean.class);
        SUPPORTED_OPTIONS.put("SOL_SOCKET.SO_LINGER", Integer.class);
    }
}

