/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream.io.impl;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import javax.management.JMException;
import javax.management.ObjectName;
import org.xsocket.Dispatcher;
import org.xsocket.IDispatcher;
import org.xsocket.stream.IServerListener;
import org.xsocket.stream.Server;
import org.xsocket.stream.io.impl.Acceptor;
import org.xsocket.stream.io.impl.IIoSocketDispatcherMXBean;
import org.xsocket.stream.io.impl.IIoSocketDispatcherPoolListener;
import org.xsocket.stream.io.impl.IStdAcceptorMXBean;
import org.xsocket.stream.io.impl.IoSocketDispatcher;
import org.xsocket.stream.io.impl.IoSocketHandler;
import org.xsocket.stream.io.spi.IAcceptor;
import org.xsocket.stream.io.spi.IAcceptorMXBean;
import org.xsocket.stream.io.spi.IServerIoJmxProvider;

public final class JmxIoProvider
implements IServerIoJmxProvider {
    @Override
    public IAcceptorMXBean createMBean(Server server, IAcceptor acceptor, String domain, String address) throws JMException {
        if (acceptor instanceof Acceptor) {
            AcceptorMXBeanAdapter acceptorMXBean = new AcceptorMXBeanAdapter((Acceptor)acceptor);
            DispatcherPoolListener dispatcherPoolListener = new DispatcherPoolListener(server, domain, address);
            ((Acceptor)acceptor).getDispatcherPool().addListener(dispatcherPoolListener);
            for (IDispatcher<IoSocketHandler> dispatcher : ((Acceptor)acceptor).getDispatchers()) {
                try {
                    dispatcherPoolListener.onDispatcherAdded((Dispatcher)dispatcher);
                }
                catch (Exception ignore) {}
            }
            server.addListener(new ServerListener());
            return acceptorMXBean;
        }
        throw new JMException("only accpetor of instance " + Acceptor.class.getName() + " is supported, not " + acceptor.getClass().getName());
    }

    private final class DispatcherPoolListener
    implements IIoSocketDispatcherPoolListener {
        private Server server = null;
        private String domain = null;
        private String address = null;

        DispatcherPoolListener(Server server, String domain, String address) {
            this.server = server;
            this.domain = domain;
            this.address = address;
        }

        @Override
        public void onDispatcherAdded(IDispatcher dispatcher) {
            try {
                ObjectName objectName = new ObjectName(this.domain + ":type=Dispatcher,name=" + this.address + "." + dispatcher.hashCode());
                ManagementFactory.getPlatformMBeanServer().registerMBean(new IoSocketDispatcherMXBeanAdapter((IoSocketDispatcher)dispatcher), objectName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void onDispatcherRemoved(IDispatcher dispatcher) {
            try {
                ObjectName objectName = new ObjectName(this.domain + ":type=Dispatcher,name=" + this.address + "." + dispatcher.hashCode());
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(objectName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static final class ServerListener
    implements IServerListener {
        private ServerListener() {
        }

        @Override
        public void onInit() {
        }

        @Override
        public void onDestroy() {
        }
    }

    private static final class IoSocketDispatcherMXBeanAdapter
    implements IIoSocketDispatcherMXBean {
        private IoSocketDispatcher delegee = null;

        public IoSocketDispatcherMXBeanAdapter(IoSocketDispatcher delegee) {
            this.delegee = delegee;
        }

        @Override
        public int getPreallocatedReadMemorySize() {
            return this.delegee.getPreallocatedReadMemorySize();
        }

        @Override
        public long getCountConnectionTimeout() {
            return this.delegee.getCountConnectionTimeout();
        }

        @Override
        public long getCountIdleTimeout() {
            return this.delegee.getCountIdleTimeout();
        }

        @Override
        public long getNumberOfHandledReads() {
            return this.delegee.getNumberOfHandledReads();
        }

        @Override
        public long getNumberOfHandledRegistrations() {
            return this.delegee.getNumberOfHandledRegistrations();
        }

        @Override
        public long getNumberOfHandledWrites() {
            return this.delegee.getNumberOfHandledWrites();
        }

        @Override
        public void resetStatistics() {
            this.delegee.resetStatistics();
        }

        @Override
        public long getStatisticsStartTime() {
            return this.delegee.getStatisticsStartTime();
        }
    }

    private static final class AcceptorMXBeanAdapter
    implements IStdAcceptorMXBean {
        private Acceptor delegee = null;

        public AcceptorMXBeanAdapter(Acceptor delegee) {
            this.delegee = delegee;
        }

        @Override
        public long getNumberOfConnectionTimeouts() {
            return this.delegee.getNumberOfConnectionTimeouts();
        }

        @Override
        public long getNumberOfHandledConnections() {
            return this.delegee.getNumberOfHandledConnections();
        }

        @Override
        public long getNumberOfIdleTimeouts() {
            return this.delegee.getNumberOfIdleTimeouts();
        }

        @Override
        public List<String> getOpenConnections() {
            ArrayList<String> result = new ArrayList<String>();
            for (IoSocketHandler hdl : this.delegee.getOpenConnections()) {
                result.add(hdl.toString());
            }
            return result;
        }

        @Override
        public int getNumberOfOpenConnections() {
            return this.delegee.getNumberOfOpenConnections();
        }

        @Override
        public int getReceiveBufferPreallocationSize() {
            return this.delegee.getReceiveBufferPreallocationSize();
        }

        @Override
        public void setReceiveBufferPreallocationSize(int size) {
            this.delegee.setReceiveBufferPreallocationSize(size);
        }

        @Override
        public String getLocalHost() {
            return this.delegee.getLocalAddress().getCanonicalHostName();
        }

        @Override
        public int getLocalPort() {
            return this.delegee.getLocalPort();
        }

        @Override
        public int getDispatcherPoolSize() {
            return this.delegee.getDispatcherPoolSize();
        }

        @Override
        public void setDispatcherPoolSize(int size) {
            this.delegee.setDispatcherPoolSize(size);
        }

        @Override
        public void resetStatistics() {
            this.delegee.resetStatistics();
        }

        @Override
        public long getStatisiticsStartTime() {
            return this.delegee.getStatisticsStartTime();
        }
    }
}

