/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream.io.impl;

import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.stream.io.impl.IMemoryManager;

final class UnsynchronizedMemoryManager
implements IMemoryManager {
    private static final Logger LOG = Logger.getLogger(UnsynchronizedMemoryManager.class.getName());
    private ByteBuffer freeBuffer = null;
    private boolean useDirectMemory = false;
    private int preallocationSize = 65536;

    UnsynchronizedMemoryManager(int preallocationSize, boolean useDirectMemory) {
        this.preallocationSize = preallocationSize;
        this.useDirectMemory = useDirectMemory;
    }

    public int getCurrentPreallocationBufferSize() {
        ByteBuffer b = this.freeBuffer;
        if (b == null) {
            return 0;
        }
        return b.remaining();
    }

    @Override
    public void recycleMemory(ByteBuffer buffer, int minSize) {
        int remaining = buffer.remaining();
        if (remaining >= minSize) {
            this.freeBuffer = buffer;
        }
    }

    @Override
    public final ByteBuffer acquireMemory(int minSize) {
        this.preallocate(minSize);
        ByteBuffer buffer = this.freeBuffer;
        this.freeBuffer = null;
        return buffer;
    }

    @Override
    public void preallocate(int minSize) {
        if (this.freeBuffer != null && this.freeBuffer.remaining() >= minSize) {
            return;
        }
        this.freeBuffer = this.newBuffer(this.preallocationSize);
    }

    private ByteBuffer newBuffer(int preallocationSize) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("allocate new physical memory (size: " + preallocationSize + ") by thread " + Thread.currentThread().getName());
        }
        if (this.useDirectMemory) {
            return ByteBuffer.allocateDirect(preallocationSize);
        }
        return ByteBuffer.allocate(preallocationSize);
    }

    @Override
    public int getFreeBufferSize() {
        if (this.freeBuffer != null) {
            return this.freeBuffer.remaining();
        }
        return 0;
    }
}

