/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.ClosedException;
import org.xsocket.DataConverter;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.ReadQueue;
import org.xsocket.connection.WriteQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNonBlockingStream
implements WritableByteChannel,
Closeable,
Cloneable {
    private Logger LOG = Logger.getLogger(AbstractNonBlockingStream.class.getName());
    private boolean isOpen = true;
    private ReadQueue readQueue = new ReadQueue();
    private WriteQueue writeQueue = new WriteQueue();
    private String defaultEncoding = "UTF-8";
    private boolean autoflush = true;
    private IConnection.FlushMode flushmode = IConnection.DEFAULT_FLUSH_MODE;
    private Object attachment = null;

    public final void setAttachment(Object obj) {
        this.attachment = obj;
    }

    public final Object getAttachment() {
        return this.attachment;
    }

    public final void setEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public final String getEncoding() {
        return this.defaultEncoding;
    }

    public void setFlushmode(IConnection.FlushMode flushMode) {
        this.flushmode = flushMode;
    }

    public final IConnection.FlushMode getFlushmode() {
        return this.flushmode;
    }

    public final void setAutoflush(boolean autoflush) {
        this.autoflush = autoflush;
    }

    public final boolean isAutoflush() {
        return this.autoflush;
    }

    public final int indexOf(String str) throws IOException {
        return this.indexOf(str, this.getEncoding());
    }

    public final int indexOf(String str, String encoding) throws IOException, MaxReadSizeExceededException {
        return this.readQueue.retrieveIndexOf(str.getBytes(encoding), Integer.MAX_VALUE);
    }

    public final int available() {
        if (this.isReadBufferEmpty()) {
            return 0;
        }
        return this.readQueue.getSize();
    }

    public int getReadBufferVersion() {
        return this.readQueue.geVersion();
    }

    protected void onPostRead() {
    }

    public final ByteBuffer[] readAvailableByteBuffer() throws IOException {
        ByteBuffer[] buffers = this.readQueue.readAvailable();
        if (buffers == null) {
            buffers = new ByteBuffer[]{};
        }
        this.onPostRead();
        return buffers;
    }

    public final byte readByte() throws IOException, BufferUnderflowException {
        byte b = this.readSingleByteBuffer(1).get();
        this.onPostRead();
        return b;
    }

    public final short readShort() throws IOException, BufferUnderflowException {
        short s = this.readSingleByteBuffer(2).getShort();
        this.onPostRead();
        return s;
    }

    public final int readInt() throws IOException, BufferUnderflowException {
        int i = this.readSingleByteBuffer(4).getInt();
        this.onPostRead();
        return i;
    }

    public final long readLong() throws IOException, BufferUnderflowException {
        long l = this.readSingleByteBuffer(8).getLong();
        this.onPostRead();
        return l;
    }

    public final double readDouble() throws IOException, BufferUnderflowException {
        double d = this.readSingleByteBuffer(8).getDouble();
        this.onPostRead();
        return d;
    }

    public final int read(ByteBuffer buffer) throws IOException {
        int size = buffer.remaining();
        int available = this.available();
        if (available == 0 && !this.isOpen()) {
            return -1;
        }
        if (available < size) {
            size = available;
        }
        if (size > 0) {
            ByteBuffer[] bufs;
            for (ByteBuffer buf : bufs = this.readByteBufferByLength(size)) {
                while (buf.hasRemaining()) {
                    buffer.put(buf);
                }
            }
        }
        this.onPostRead();
        return size;
    }

    public final ByteBuffer[] readByteBufferByDelimiter(String delimiter) throws IOException, BufferUnderflowException {
        ByteBuffer[] buffers = this.readByteBufferByDelimiter(delimiter, this.getEncoding());
        this.onPostRead();
        return buffers;
    }

    public final ByteBuffer[] readByteBufferByDelimiter(String delimiter, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        ByteBuffer[] buffers = this.readByteBufferByDelimiter(delimiter, this.getEncoding(), maxLength);
        this.onPostRead();
        return buffers;
    }

    public final ByteBuffer[] readByteBufferByDelimiter(String delimiter, String encoding) throws IOException, BufferUnderflowException {
        ByteBuffer[] buffers = this.readByteBufferByDelimiter(delimiter, encoding, Integer.MAX_VALUE);
        this.onPostRead();
        return buffers;
    }

    public ByteBuffer[] readByteBufferByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        try {
            ByteBuffer[] buffers = this.readQueue.readByteBufferByDelimiter(delimiter.getBytes(encoding), maxLength);
            this.onPostRead();
            return buffers;
        }
        catch (MaxReadSizeExceededException mre) {
            if (this.isOpen()) {
                throw mre;
            }
            throw new ClosedException("data source is already closed");
        }
        catch (BufferUnderflowException bue) {
            if (this.isOpen()) {
                throw bue;
            }
            throw new ClosedException("data source is already closed");
        }
    }

    public ByteBuffer[] readByteBufferByLength(int length) throws IOException, BufferUnderflowException {
        if (length <= 0) {
            this.onPostRead();
            if (length == 0) {
                return new ByteBuffer[0];
            }
            throw new IllegalArgumentException("length has to be positive");
        }
        try {
            ByteBuffer[] buffers = this.readQueue.readByteBufferByLength(length);
            this.onPostRead();
            return buffers;
        }
        catch (BufferUnderflowException bue) {
            if (this.isOpen()) {
                throw bue;
            }
            throw new ClosedException("data source is already closed");
        }
    }

    public final byte[] readBytesByDelimiter(String delimiter) throws IOException, BufferUnderflowException {
        byte[] bytes = this.readBytesByDelimiter(delimiter, this.getEncoding());
        this.onPostRead();
        return bytes;
    }

    public final byte[] readBytesByDelimiter(String delimiter, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        byte[] bytes = this.readBytesByDelimiter(delimiter, this.getEncoding(), maxLength);
        this.onPostRead();
        return bytes;
    }

    public final byte[] readBytesByDelimiter(String delimiter, String encoding) throws IOException, BufferUnderflowException {
        byte[] bytes = this.readBytesByDelimiter(delimiter, encoding, Integer.MAX_VALUE);
        this.onPostRead();
        return bytes;
    }

    public final byte[] readBytesByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        byte[] bytes = DataConverter.toBytes(this.readByteBufferByDelimiter(delimiter, encoding, maxLength));
        this.onPostRead();
        return bytes;
    }

    public final byte[] readBytesByLength(int length) throws IOException, BufferUnderflowException {
        byte[] bytes = DataConverter.toBytes(this.readByteBufferByLength(length));
        this.onPostRead();
        return bytes;
    }

    public final String readStringByDelimiter(String delimiter) throws IOException, BufferUnderflowException, UnsupportedEncodingException {
        String s = this.readStringByDelimiter(delimiter, Integer.MAX_VALUE);
        this.onPostRead();
        return s;
    }

    public final String readStringByDelimiter(String delimiter, int maxLength) throws IOException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException {
        String s = this.readStringByDelimiter(delimiter, this.getEncoding(), maxLength);
        this.onPostRead();
        return s;
    }

    public final String readStringByDelimiter(String delimiter, String encoding) throws IOException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException {
        String s = this.readStringByDelimiter(delimiter, encoding, Integer.MAX_VALUE);
        this.onPostRead();
        return s;
    }

    public final String readStringByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException {
        String s = DataConverter.toString(this.readByteBufferByDelimiter(delimiter, encoding, maxLength), encoding);
        this.onPostRead();
        return s;
    }

    public final String readStringByLength(int length) throws IOException, BufferUnderflowException, UnsupportedEncodingException {
        String s = this.readStringByLength(length, this.getEncoding());
        this.onPostRead();
        return s;
    }

    public final String readStringByLength(int length, String encoding) throws IOException, BufferUnderflowException, UnsupportedEncodingException {
        String s = DataConverter.toString(this.readByteBufferByLength(length), encoding);
        this.onPostRead();
        return s;
    }

    public final long transferTo(WritableByteChannel target, int length) throws IOException, ClosedChannelException, BufferUnderflowException {
        if (length > 0) {
            ByteBuffer[] buffers;
            long written = 0L;
            for (ByteBuffer buffer : buffers = this.readByteBufferByLength(length)) {
                written += (long)target.write(buffer);
            }
            this.onPostRead();
            return written;
        }
        this.onPostRead();
        return 0L;
    }

    protected ByteBuffer readSingleByteBuffer(int length) throws IOException, ClosedException, BufferUnderflowException {
        try {
            ByteBuffer buffer = this.readQueue.readSingleByteBuffer(length);
            this.onPostRead();
            return buffer;
        }
        catch (BufferUnderflowException bue) {
            if (this.isOpen()) {
                throw bue;
            }
            throw new ClosedException("data source is already closed");
        }
    }

    public final int write(byte b) throws IOException, BufferOverflowException {
        if (this.isOpen()) {
            this.writeQueue.append(DataConverter.toByteBuffer(b));
            this.onWriteDataInserted();
            return 1;
        }
        throw new ClosedException("data source is already closed");
    }

    public final int write(byte ... bytes) throws IOException, BufferOverflowException {
        if (this.isOpen()) {
            if (bytes.length > 0) {
                this.writeQueue.append(DataConverter.toByteBuffer(bytes));
                this.onWriteDataInserted();
                return bytes.length;
            }
            if (this.LOG.isLoggable(Level.FINE)) {
                this.LOG.fine("warning length of byte array to send is 0");
            }
            return 0;
        }
        throw new ClosedException("data source is already closed");
    }

    public final int write(byte[] bytes, int offset, int length) throws IOException, BufferOverflowException {
        if (this.isOpen()) {
            if (bytes.length > 0) {
                ByteBuffer buffer = DataConverter.toByteBuffer(bytes, offset, length);
                int written = buffer.remaining();
                this.writeQueue.append(buffer);
                this.onWriteDataInserted();
                return written;
            }
            if (this.LOG.isLoggable(Level.FINE)) {
                this.LOG.fine("warning length of buffer array to send is 0");
            }
            return 0;
        }
        throw new ClosedException("data source is already closed");
    }

    public final int write(short s) throws IOException, BufferOverflowException {
        if (this.isOpen()) {
            this.writeQueue.append(DataConverter.toByteBuffer(s));
            this.onWriteDataInserted();
            return 2;
        }
        throw new ClosedException("data source is already closed");
    }

    public final int write(int i) throws IOException, BufferOverflowException {
        if (this.isOpen()) {
            this.writeQueue.append(DataConverter.toByteBuffer(i));
            this.onWriteDataInserted();
            return 4;
        }
        throw new ClosedException("data source is already closed");
    }

    public final int write(long l) throws IOException, BufferOverflowException {
        if (this.isOpen()) {
            this.writeQueue.append(DataConverter.toByteBuffer(l));
            this.onWriteDataInserted();
            return 8;
        }
        throw new ClosedException("data source is already closed");
    }

    public final int write(double d) throws IOException, BufferOverflowException {
        if (this.isOpen()) {
            this.writeQueue.append(DataConverter.toByteBuffer(d));
            this.onWriteDataInserted();
            return 8;
        }
        throw new ClosedException("data source is already closed");
    }

    public final int write(String message) throws IOException, BufferOverflowException {
        return this.write(message, this.getEncoding());
    }

    public final int write(String message, String encoding) throws IOException, BufferOverflowException {
        if (this.isOpen()) {
            ByteBuffer buffer = DataConverter.toByteBuffer(message, encoding);
            int written = buffer.remaining();
            this.writeQueue.append(buffer);
            this.onWriteDataInserted();
            return written;
        }
        throw new ClosedException("data source is already closed");
    }

    public final long write(List<ByteBuffer> buffers) throws IOException, BufferOverflowException {
        if (buffers == null) {
            if (this.LOG.isLoggable(Level.FINE)) {
                this.LOG.fine("warning buffer list to send is null");
            }
            return 0L;
        }
        return this.write(buffers.toArray(new ByteBuffer[buffers.size()]));
    }

    public final long write(ByteBuffer[] buffers) throws IOException, BufferOverflowException {
        if (this.isOpen()) {
            if (buffers == null) {
                if (this.LOG.isLoggable(Level.FINE)) {
                    this.LOG.fine("warning buffer array to send is null");
                }
                return 0L;
            }
            if (buffers.length == 0) {
                if (this.LOG.isLoggable(Level.FINE)) {
                    this.LOG.fine("warning lenth of buffer array to send is 0");
                }
                return 0L;
            }
            long written = 0L;
            for (ByteBuffer buffer : buffers) {
                written += (long)buffer.remaining();
                this.writeQueue.append(buffer);
            }
            this.onWriteDataInserted();
            return written;
        }
        throw new ClosedException("data source is already closed");
    }

    public final long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (srcs == null) {
            if (this.LOG.isLoggable(Level.FINE)) {
                this.LOG.fine("warning buffer array to send is null");
            }
            return 0L;
        }
        return this.write(DataConverter.toByteBuffers(srcs, offset, length));
    }

    @Override
    public final int write(ByteBuffer buffer) throws IOException, BufferOverflowException {
        if (this.isOpen()) {
            if (buffer == null) {
                if (this.LOG.isLoggable(Level.FINE)) {
                    this.LOG.fine("warning buffer is null");
                }
                return 0;
            }
            int written = buffer.remaining();
            this.writeQueue.append(buffer);
            this.onWriteDataInserted();
            return written;
        }
        throw new ClosedException("data source is already closed");
    }

    public final long transferFrom(FileChannel fileChannel) throws ClosedException, IOException, SocketTimeoutException {
        if (this.getFlushmode() == IConnection.FlushMode.SYNC) {
            return fileChannel.transferTo(fileChannel.position(), fileChannel.size() - fileChannel.position(), this);
        }
        return this.transferFrom((ReadableByteChannel)fileChannel);
    }

    public long transferFrom(ReadableByteChannel source) throws IOException, BufferOverflowException {
        return this.transferFrom(source, 8192);
    }

    public final long transferFrom(ReadableByteChannel source, int chunkSize) throws IOException, BufferOverflowException {
        if (this.isOpen()) {
            return AbstractNonBlockingStream.transfer(source, this, chunkSize);
        }
        throw new ClosedException("data source is already closed");
    }

    private static long transfer(ReadableByteChannel source, WritableByteChannel target, int chunkSize) throws IOException {
        long transfered = 0L;
        int read = 0;
        do {
            ByteBuffer transferBuffer;
            if ((read = source.read(transferBuffer = ByteBuffer.allocate(chunkSize))) <= 0) continue;
            if (transferBuffer.remaining() == 0) {
                transferBuffer.flip();
                target.write(transferBuffer);
            } else {
                transferBuffer.flip();
                target.write(transferBuffer.slice());
            }
            transfered += (long)read;
        } while (read > 0);
        return transfered;
    }

    public final void markReadPosition() {
        this.readQueue.markReadPosition();
    }

    public final void markWritePosition() {
        if (this.isAutoflush()) {
            throw new UnsupportedOperationException("write mark is only supported for mode autoflush off");
        }
        this.writeQueue.markWritePosition();
    }

    public final boolean resetToWriteMark() {
        return this.writeQueue.resetToWriteMark();
    }

    public final boolean resetToReadMark() {
        return this.readQueue.resetToReadMark();
    }

    public final void removeReadMark() {
        this.readQueue.removeReadMark();
    }

    public final void removeWriteMark() {
        this.writeQueue.removeWriteMark();
    }

    protected boolean reset() {
        this.readQueue.reset();
        this.writeQueue.reset();
        this.defaultEncoding = "UTF-8";
        this.autoflush = true;
        this.flushmode = IConnection.DEFAULT_FLUSH_MODE;
        this.attachment = null;
        return true;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void close() throws IOException {
        this.isOpen = false;
    }

    protected void onWriteDataInserted() throws IOException, ClosedException {
    }

    protected final int getWriteBufferSize() {
        return this.writeQueue.getSize();
    }

    protected final boolean isWriteBufferEmpty() {
        return this.writeQueue.isEmpty();
    }

    protected ByteBuffer[] drainWriteQueue() {
        return this.writeQueue.drain();
    }

    protected final boolean isReadBufferEmpty() {
        return this.readQueue.isEmpty();
    }

    protected final void appendDataToReadBuffer(ByteBuffer[] data) {
        if (data == null) {
            return;
        }
        if (data.length == 0) {
            return;
        }
        this.readQueue.append(data);
    }

    protected final String printReadBuffer(String encoding) {
        return this.readQueue.asString(encoding);
    }

    protected final String printWriteBuffer(String encoding) {
        return this.writeQueue.asString(encoding);
    }

    protected Object clone() throws CloneNotSupportedException {
        AbstractNonBlockingStream copy = (AbstractNonBlockingStream)super.clone();
        copy.readQueue = (ReadQueue)this.readQueue.clone();
        copy.writeQueue = (WriteQueue)this.writeQueue.clone();
        return copy;
    }
}

