/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.management.ManagementFactory;
import java.net.SocketTimeoutException;
import java.nio.BufferUnderflowException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.xsocket.DataConverter;
import org.xsocket.connection.ConnectionPoolMBeanProxyFactory;
import org.xsocket.connection.IConnectionPool;
import org.xsocket.connection.INonBlockingConnection;
import org.xsocket.connection.IServer;
import org.xsocket.connection.IServerListener;
import org.xsocket.connection.ServerMBeanProxyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConnectionUtils {
    private static final Logger LOG = Logger.getLogger(ConnectionUtils.class.getName());
    public static final String DEFAULT_DOMAIN = "org.xsocket.stream";
    public static final String SERVER_TRHREAD_PREFIX = "xServer";
    private static String versionInfo = null;

    private ConnectionUtils() {
    }

    public static int validateSufficientDatasizeByIntLengthField(INonBlockingConnection connection) throws IOException, BufferUnderflowException {
        connection.resetToReadMark();
        connection.markReadPosition();
        int length = connection.readInt();
        if (connection.available() < length) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "]insufficient data. require " + length + " got " + connection.available());
            }
            throw new BufferUnderflowException();
        }
        connection.removeReadMark();
        return length;
    }

    public static int validateSufficientDatasizeByIntLengthField(INonBlockingConnection connection, boolean removeLengthField) throws IOException, BufferUnderflowException {
        connection.resetToReadMark();
        connection.markReadPosition();
        int length = connection.readInt();
        if (connection.available() < length) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "]insufficient data. require " + length + " got " + connection.available());
            }
            throw new BufferUnderflowException();
        }
        if (!removeLengthField) {
            connection.resetToReadMark();
        }
        connection.removeReadMark();
        return length;
    }

    public static void start(IServer server) throws SocketTimeoutException {
        ConnectionUtils.start(server, 60);
    }

    public static void start(IServer server, int timeoutSec) throws SocketTimeoutException {
        final CountDownLatch startedSignal = new CountDownLatch(1);
        IServerListener startupListener = new IServerListener(){

            public void onInit() {
                startedSignal.countDown();
            }

            public void onDestroy() {
            }
        };
        server.addListener(startupListener);
        Thread t = new Thread(server);
        t.start();
        boolean isStarted = false;
        try {
            isStarted = startedSignal.await(timeoutSec, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("start signal doesn't occured. " + e.toString());
        }
        if (!isStarted) {
            throw new SocketTimeoutException("start timeout (" + DataConverter.toFormatedDuration((long)timeoutSec * 1000L) + ")");
        }
        t.setName("xServer:" + server.getLocalPort());
        server.removeListener(startupListener);
    }

    public static ObjectName registerMBean(IServer server) throws JMException {
        return ConnectionUtils.registerMBean(server, DEFAULT_DOMAIN);
    }

    public static ObjectName registerMBean(IServer server, String domain) throws JMException {
        return ConnectionUtils.registerMBean(server, domain, ManagementFactory.getPlatformMBeanServer());
    }

    public static ObjectName registerMBean(IServer server, String domain, MBeanServer mbeanServer) throws JMException {
        return ServerMBeanProxyFactory.createAndRegister(server, domain, mbeanServer);
    }

    public static ObjectName registerMBean(IConnectionPool pool) throws JMException {
        return ConnectionUtils.registerMBean(pool, DEFAULT_DOMAIN);
    }

    public static ObjectName registerMBean(IConnectionPool pool, String domain) throws JMException {
        return ConnectionUtils.registerMBean(pool, domain, ManagementFactory.getPlatformMBeanServer());
    }

    public static ObjectName registerMBean(IConnectionPool pool, String domain, MBeanServer mbeanServer) throws JMException {
        return ConnectionPoolMBeanProxyFactory.createAndRegister(pool, domain, mbeanServer);
    }

    public static String getVersionInfo() {
        if (versionInfo == null) {
            versionInfo = "<unknown>";
            try {
                InputStreamReader isr = new InputStreamReader(ConnectionUtils.class.getResourceAsStream("/org/xsocket/version.txt"));
                if (isr != null) {
                    LineNumberReader lnr = new LineNumberReader(isr);
                    String line = null;
                    do {
                        if ((line = lnr.readLine()) == null || !line.startsWith("Implementation-Version=")) continue;
                        versionInfo = line.substring("Implementation-Version=".length(), line.length()).trim();
                    } while (line != null);
                    lnr.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return versionInfo;
    }

    public static <T> Map<Class, T> newMapCache(int maxSize) {
        return new MapCache(maxSize);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MapCache<T>
    extends LinkedHashMap<Class, T> {
        private static final long serialVersionUID = 4513864504007457500L;
        private int maxSize = 0;

        MapCache(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Class, T> eldest) {
            return this.size() > this.maxSize;
        }
    }
}

