/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.Execution;
import org.xsocket.ILifeCycle;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.Resource;
import org.xsocket.connection.ConnectionUtils;
import org.xsocket.connection.IConnectHandler;
import org.xsocket.connection.IConnectionScoped;
import org.xsocket.connection.IConnectionTimeoutHandler;
import org.xsocket.connection.IDataHandler;
import org.xsocket.connection.IDisconnectHandler;
import org.xsocket.connection.IHandler;
import org.xsocket.connection.IIdleTimeoutHandler;
import org.xsocket.connection.IInternalHandler;
import org.xsocket.connection.INonBlockingConnection;
import org.xsocket.connection.IServer;
import org.xsocket.connection.spi.DefaultIoProvider;

final class HandlerProxy
implements Cloneable {
    private static final Logger LOG = Logger.getLogger(HandlerProxy.class.getName());
    private static final Map<Class, HandlerProxy> cache = ConnectionUtils.newMapCache(25);
    private static final HandlerProxy NULL_HANDLER_PROXY_PROTOTYPE = new HandlerProxy(HandlerProxy.newNullHandler());
    private static final int MODE_NON_THREADED = 0;
    private static final int MODE_MULTI_THREADED = 1;
    private static final int MODE_MIXED_THREADED = 2;
    private static final int MODE_NON_THREADED_NON_PROXIED = 3;
    private int threadMode = 0;
    private Boolean isHandlerMultithreaded = null;
    private boolean isConnectHandler = false;
    private boolean isConnectHandlerThreaded = false;
    private boolean isDataHandler = false;
    private boolean isDataHandlerThreaded = false;
    private boolean isDisconnectHandler = false;
    private boolean isDisconnectHandlerThreaded = false;
    private boolean isIdleTimeoutHandler = false;
    private boolean isIdleTimeoutHandlerThreaded = false;
    private boolean isConnectionTimeoutHandler = false;
    private boolean isConnectionTimeoutHandlerThreaded = false;
    private IHandler handler = null;
    private boolean isLifeCycle = false;
    private boolean isConnectionScoped = false;
    private IHandler cachedNonThreadedDelegator = null;

    HandlerProxy(IHandler handler) {
        boolean isMixedThreaded;
        this.handler = handler;
        if (this.isHandlerMultithreaded()) {
            this.isConnectHandlerThreaded = true;
            this.isDisconnectHandlerThreaded = true;
            this.isDataHandlerThreaded = true;
            this.isConnectionTimeoutHandlerThreaded = true;
            this.isIdleTimeoutHandlerThreaded = true;
        }
        boolean isFullHandler = handler instanceof IInternalHandler;
        if (handler instanceof IConnectHandler) {
            this.isConnectHandler = true;
            this.isConnectHandlerThreaded = HandlerProxy.isThreaded(handler.getClass(), "onConnect", this.isHandlerMultithreaded(), INonBlockingConnection.class);
        }
        if (handler instanceof IDataHandler) {
            this.isDataHandler = true;
            this.isDataHandlerThreaded = HandlerProxy.isThreaded(handler.getClass(), "onData", this.isHandlerMultithreaded(), INonBlockingConnection.class);
        }
        if (handler instanceof IDisconnectHandler) {
            this.isDisconnectHandler = true;
            this.isDisconnectHandlerThreaded = HandlerProxy.isThreaded(handler.getClass(), "onDisconnect", this.isHandlerMultithreaded(), INonBlockingConnection.class);
        }
        if (handler instanceof IIdleTimeoutHandler) {
            this.isIdleTimeoutHandler = true;
            this.isIdleTimeoutHandlerThreaded = HandlerProxy.isThreaded(handler.getClass(), "onIdleTimeout", this.isHandlerMultithreaded(), INonBlockingConnection.class);
        }
        if (handler instanceof IConnectionTimeoutHandler) {
            this.isConnectionTimeoutHandler = true;
            this.isConnectionTimeoutHandlerThreaded = HandlerProxy.isThreaded(handler.getClass(), "onConnectionTimeout", this.isHandlerMultithreaded(), INonBlockingConnection.class);
        }
        this.isConnectionScoped = handler instanceof IConnectionScoped;
        this.isLifeCycle = handler instanceof ILifeCycle;
        boolean bl = isMixedThreaded = this.isHandlerMultithreaded() != this.isConnectHandlerThreaded != this.isDisconnectHandlerThreaded != this.isDataHandlerThreaded != this.isIdleTimeoutHandlerThreaded != this.isConnectionTimeoutHandlerThreaded;
        this.threadMode = isMixedThreaded ? 2 : (this.isHandlerMultithreaded != false ? 1 : (isFullHandler ? 3 : 0));
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("handler analyzed: " + this.toString());
        }
    }

    private boolean isHandlerMultithreaded() {
        if (this.isHandlerMultithreaded == null) {
            Execution execution = this.handler.getClass().getAnnotation(Execution.class);
            this.isHandlerMultithreaded = execution != null ? (execution.value() == Execution.Mode.NONTHREADED ? Boolean.valueOf(false) : Boolean.valueOf(true)) : Boolean.valueOf(true);
        }
        return this.isHandlerMultithreaded;
    }

    public IHandler newProxy(INonBlockingConnection connection) {
        HandlerProxy proxy = this;
        if (this.isConnectionScoped) {
            try {
                proxy = (HandlerProxy)this.clone();
                proxy.handler = (IHandler)((IConnectionScoped)((Object)this.handler)).clone();
            }
            catch (CloneNotSupportedException cnse) {
                throw new RuntimeException("error occured by cloning handler " + this.handler + " " + cnse.toString());
            }
        }
        switch (this.threadMode) {
            case 3: {
                return proxy.handler;
            }
            case 0: {
                return proxy.newNonThreadedDelegator();
            }
            case 1: {
                return proxy.newMultiThreadedDelegator(connection);
            }
        }
        return this.newMixedThreadedDelegator(connection);
    }

    private IHandler newNonThreadedDelegator() {
        if (this.isConnectionScoped) {
            return new NonThreadedDelegator();
        }
        if (this.cachedNonThreadedDelegator == null) {
            this.cachedNonThreadedDelegator = new NonThreadedDelegator();
        }
        return this.cachedNonThreadedDelegator;
    }

    private IHandler newMultiThreadedDelegator(INonBlockingConnection connection) {
        return new MultiThreadedDelegator(connection);
    }

    private IHandler newMixedThreadedDelegator(INonBlockingConnection connection) {
        return new MixedThreadedDelegator(connection);
    }

    public final void onInit() {
        if (this.isLifeCycle) {
            ((ILifeCycle)((Object)this.handler)).onInit();
        }
    }

    public final void onDestroy() {
        block3: {
            if (this.isLifeCycle) {
                try {
                    ((ILifeCycle)((Object)this.handler)).onDestroy();
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block3;
                    LOG.fine("exception occured by destroying " + this.handler + " " + ioe.toString());
                }
            }
        }
    }

    IHandler getHandler() {
        return this.handler;
    }

    final void setHandler(IHandler handler) {
        this.handler = handler;
    }

    private void performTask(TaskType taskType, INonBlockingConnection connection) {
        block9: {
            try {
                switch (taskType) {
                    case ON_CONNECT: {
                        this.callOnConnect(connection);
                        break;
                    }
                    case ON_DISCONNECT: {
                        this.callOnDisconnect(connection);
                        break;
                    }
                    case ON_DATA: {
                        this.callOnData(connection);
                        break;
                    }
                    case ON_IDLE_TIMEOUT: {
                        this.callOnIdleTimeout(connection);
                        break;
                    }
                    case ON_CONNECTION_TIMEOUT: {
                        this.callOnConnectionTimeout(connection);
                        break;
                    }
                    default: {
                        LOG.warning("error unknown task type " + (Object)((Object)taskType));
                        break;
                    }
                }
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block9;
                LOG.fine("error occured by preforming call back " + e.toString());
            }
        }
    }

    private boolean callOnConnect(INonBlockingConnection connection) throws IOException {
        try {
            ((IConnectHandler)this.handler).onConnect(connection);
        }
        catch (MaxReadSizeExceededException mee) {
            this.closeSilence(connection);
        }
        catch (BufferUnderflowException bue) {
        }
        catch (RuntimeException re) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onConnect by appHandler. " + this.handler + " Reason: " + re.toString());
            }
            this.closeSilence(connection);
            throw re;
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onConnect by appHandler. " + this.handler + " Reason: " + ioe.toString());
            }
            this.closeSilence(connection);
            throw ioe;
        }
        return false;
    }

    private boolean callOnConnectionTimeout(INonBlockingConnection connection) throws IOException {
        try {
            boolean isHandled = ((IConnectionTimeoutHandler)this.handler).onConnectionTimeout(connection);
            if (!isHandled) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + connection.getId() + "] closing connection because connection timeout has been occured and timeout handler returns true)");
                }
                this.closeSilence(connection);
            }
        }
        catch (MaxReadSizeExceededException mee) {
            this.closeSilence(connection);
        }
        catch (BufferUnderflowException bue) {
        }
        catch (RuntimeException re) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onConnectionTimeout by appHandler. " + this.handler + " Reason: " + re.toString());
            }
            this.closeSilence(connection);
            throw re;
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onConnectionTimeout by appHandler. " + this.handler + " Reason: " + ioe.toString());
            }
            this.closeSilence(connection);
            throw ioe;
        }
        return true;
    }

    private boolean callOnData(INonBlockingConnection connection) throws IOException {
        while (connection.available() > 0) {
            int version = connection.getReadBufferVersion();
            try {
                ((IDataHandler)this.handler).onData(connection);
                int newVersion = connection.getReadBufferVersion();
                if (newVersion != version) {
                    version = newVersion;
                    continue;
                }
                return true;
            }
            catch (MaxReadSizeExceededException mee) {
                this.closeSilence(connection);
                return true;
            }
            catch (BufferUnderflowException bue) {
                return true;
            }
            catch (RuntimeException re) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling data by appHandler. " + this.handler + " Reason: " + re.toString());
                }
                this.closeSilence(connection);
                throw re;
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling data by appHandler. " + this.handler + " Reason: " + ioe.toString());
                }
                this.closeSilence(connection);
                throw ioe;
            }
        }
        return true;
    }

    private boolean callOnDisconnect(INonBlockingConnection connection) throws IOException {
        try {
            return ((IDisconnectHandler)this.handler).onDisconnect(connection);
        }
        catch (RuntimeException re) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onDisconnect by appHandler. " + this.handler + " Reason: " + re.toString());
            }
            this.closeSilence(connection);
            throw re;
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onDisconnect by appHandler. " + this.handler + " Reason: " + ioe.toString());
            }
            this.closeSilence(connection);
            throw ioe;
        }
    }

    private boolean callOnIdleTimeout(INonBlockingConnection connection) throws IOException {
        try {
            boolean isHandled = ((IIdleTimeoutHandler)this.handler).onIdleTimeout(connection);
            if (!isHandled) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + connection.getId() + "] closing connection because idle timeout has been occured and timeout handler returns true)");
                }
                this.closeSilence(connection);
            }
        }
        catch (MaxReadSizeExceededException mee) {
            this.closeSilence(connection);
        }
        catch (BufferUnderflowException bue) {
        }
        catch (RuntimeException re) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onIdleTimeout by appHandler. " + this.handler + " Reason: " + re.toString());
            }
            this.closeSilence(connection);
            throw re;
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onIdleTimeout by appHandler. " + this.handler + " Reason: " + ioe.toString());
            }
            this.closeSilence(connection);
            throw ioe;
        }
        return true;
    }

    private void closeSilence(INonBlockingConnection connection) {
        block2: {
            try {
                connection.close();
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block2;
                LOG.fine("error occured by closing connection " + connection + " " + e.toString());
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private static IHandler newNullHandler() {
        return new NullHandler();
    }

    private static void injectServerField(IServer server, Object handler) {
        Field[] fields;
        for (Field field : fields = handler.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Resource.class)) continue;
            Resource res = field.getAnnotation(Resource.class);
            if (field.getType() != IServer.class && res.type() != IServer.class) continue;
            field.setAccessible(true);
            try {
                field.set(handler, server);
            }
            catch (IllegalAccessException iae) {
                LOG.warning("could not set HandlerContext for attribute " + field.getName() + ". Reason " + iae.toString());
            }
        }
    }

    private static boolean isThreaded(Class clazz, String methodname, boolean dflt, Class ... paramClass) {
        try {
            Method meth = clazz.getMethod(methodname, paramClass);
            Execution execution = meth.getAnnotation(Execution.class);
            if (execution != null) {
                return execution.value() != Execution.Mode.NONTHREADED;
            }
            return dflt;
        }
        catch (NoSuchMethodException nsme) {
            return dflt;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("handler=" + this.handler.getClass().getName() + "#" + this.handler.hashCode());
        sb.append(" isConnectHandler=" + this.isConnectHandler + " isConnectHandlerThreaded=" + this.isConnectHandlerThreaded + " isDataHandler=" + this.isDataHandler + " isDataHandlerThreaded=" + this.isDataHandlerThreaded + " isDisconnectHandler=" + this.isDisconnectHandler + " isDisconnectHandlerThreaded=" + this.isDisconnectHandlerThreaded + " isIdleTimeoutHandler=" + this.isIdleTimeoutHandler + " isIdleTimeoutHandlerThreaded=" + this.isIdleTimeoutHandlerThreaded + " isConnectionTimeoutHandler=" + this.isConnectionTimeoutHandler + " isConnetionTimeoutHandlerThreaded=" + this.isConnectionTimeoutHandlerThreaded + " isConnectionSCoped=" + this.isConnectionScoped + " isLifeCycle=" + this.isLifeCycle);
        return sb.toString();
    }

    static HandlerProxy newPrototype(IHandler handler, IServer server) {
        if (handler == null) {
            return NULL_HANDLER_PROXY_PROTOTYPE;
        }
        HandlerProxy proxyPrototype = cache.get(handler.getClass());
        if (proxyPrototype == null) {
            proxyPrototype = new HandlerProxy(handler);
            cache.put(handler.getClass(), proxyPrototype);
        }
        try {
            HandlerProxy result = (HandlerProxy)proxyPrototype.clone();
            result.setHandler(handler);
            if (server != null) {
                HandlerProxy.injectServerField(server, result.getHandler());
            }
            return result;
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException("error occured by cloning hndler proxy " + proxyPrototype + " " + cnse.toString());
        }
    }

    @Execution(value=Execution.Mode.NONTHREADED)
    private static final class NullHandler
    implements IInternalHandler {
        private NullHandler() {
        }

        public boolean onConnect(INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            return false;
        }

        public boolean onData(INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            return false;
        }

        public boolean onDisconnect(INonBlockingConnection connection) throws IOException {
            return false;
        }

        public boolean onConnectionTimeout(INonBlockingConnection connection) throws IOException {
            connection.close();
            return true;
        }

        public boolean onIdleTimeout(INonBlockingConnection connection) throws IOException {
            connection.close();
            return true;
        }
    }

    private final class MixedThreadedDelegator
    implements IConnectHandler,
    IDataHandler,
    IDisconnectHandler,
    IIdleTimeoutHandler,
    IConnectionTimeoutHandler {
        private final LinkedList<TaskType> taskQueue = new LinkedList();
        private INonBlockingConnection connection = null;

        public MixedThreadedDelegator(INonBlockingConnection connection) {
            this.connection = connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processNonThreaded(TaskType taskType) {
            LinkedList<TaskType> linkedList = this.taskQueue;
            synchronized (linkedList) {
                if (this.taskQueue.isEmpty()) {
                    HandlerProxy.this.performTask(taskType, this.connection);
                } else {
                    this.taskQueue.addLast(taskType);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processThreaded(TaskType taskType) {
            LinkedList<TaskType> linkedList = this.taskQueue;
            synchronized (linkedList) {
                if (this.taskQueue.isEmpty()) {
                    this.taskQueue.addLast(taskType);
                    Runnable task = new Runnable(){

                        public void run() {
                            MixedThreadedDelegator.this.performPendingTasks();
                        }
                    };
                    this.connection.getWorkerpool().execute(task);
                } else {
                    this.taskQueue.addLast(taskType);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void performPendingTasks() {
            assert (!DefaultIoProvider.isDispatcherThread());
            boolean taskToProcess = true;
            while (taskToProcess) {
                TaskType task = null;
                LinkedList<TaskType> linkedList = this.taskQueue;
                synchronized (linkedList) {
                    task = this.taskQueue.getFirst();
                    assert (task != null) : "a task should always be available";
                    if (this.taskQueue.size() > 1) {
                        ArrayList<TaskType> tasksToRemove = new ArrayList<TaskType>();
                        for (int i = 1; i < this.taskQueue.size(); ++i) {
                            if (!this.taskQueue.get(i).equals((Object)task)) continue;
                            tasksToRemove.add(this.taskQueue.get(i));
                        }
                        if (LOG.isLoggable(Level.FINE) && tasksToRemove.size() > 0) {
                            LOG.fine("removing " + tasksToRemove.size() + " duplicate task entries");
                        }
                        for (TaskType taskToRemove : tasksToRemove) {
                            this.taskQueue.remove((Object)taskToRemove);
                        }
                        assert (this.taskQueue.size() > 0);
                    }
                }
                HandlerProxy.this.performTask(task, this.connection);
                linkedList = this.taskQueue;
                synchronized (linkedList) {
                    if (this.taskQueue.size() > 1) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("more task to process. process next task");
                        }
                        this.taskQueue.remove((Object)task);
                        taskToProcess = true;
                    } else {
                        this.taskQueue.remove((Object)task);
                        taskToProcess = false;
                    }
                }
            }
        }

        public boolean onConnect(INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            assert (this.connection == connection);
            if (HandlerProxy.this.isConnectHandler) {
                if (HandlerProxy.this.isConnectHandlerThreaded) {
                    this.processThreaded(TaskType.ON_CONNECT);
                    return true;
                }
                this.processNonThreaded(TaskType.ON_CONNECT);
                return true;
            }
            return false;
        }

        public boolean onData(INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            assert (this.connection == connection);
            if (HandlerProxy.this.isDataHandler) {
                if (HandlerProxy.this.isDataHandlerThreaded) {
                    this.processThreaded(TaskType.ON_DATA);
                    return true;
                }
                this.processNonThreaded(TaskType.ON_DATA);
                return true;
            }
            return false;
        }

        public boolean onDisconnect(INonBlockingConnection connection) throws IOException {
            assert (this.connection == connection);
            if (HandlerProxy.this.isDisconnectHandler) {
                if (HandlerProxy.this.isDisconnectHandlerThreaded) {
                    this.processThreaded(TaskType.ON_DISCONNECT);
                    return true;
                }
                this.processNonThreaded(TaskType.ON_DISCONNECT);
                return true;
            }
            return false;
        }

        public boolean onIdleTimeout(INonBlockingConnection connection) throws IOException {
            assert (this.connection == connection);
            if (HandlerProxy.this.isIdleTimeoutHandler) {
                if (HandlerProxy.this.isIdleTimeoutHandlerThreaded) {
                    this.processThreaded(TaskType.ON_IDLE_TIMEOUT);
                    return true;
                }
                this.processNonThreaded(TaskType.ON_IDLE_TIMEOUT);
                return true;
            }
            HandlerProxy.this.closeSilence(connection);
            return true;
        }

        public boolean onConnectionTimeout(INonBlockingConnection connection) throws IOException {
            assert (this.connection == connection);
            if (HandlerProxy.this.isConnectionTimeoutHandler) {
                if (HandlerProxy.this.isConnectionTimeoutHandlerThreaded) {
                    this.processThreaded(TaskType.ON_CONNECTION_TIMEOUT);
                    return true;
                }
                this.processNonThreaded(TaskType.ON_CONNECTION_TIMEOUT);
                return true;
            }
            HandlerProxy.this.closeSilence(connection);
            return true;
        }

        public String toString() {
            return super.toString() + "-> " + HandlerProxy.this.handler.toString();
        }
    }

    private final class MultiThreadedDelegator
    implements IConnectHandler,
    IDataHandler,
    IDisconnectHandler,
    IIdleTimeoutHandler,
    IConnectionTimeoutHandler {
        private final LinkedList<TaskType> taskQueue = new LinkedList();
        private INonBlockingConnection connection = null;

        public MultiThreadedDelegator(INonBlockingConnection connection) {
            this.connection = connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processThreaded(TaskType taskType) {
            LinkedList<TaskType> linkedList = this.taskQueue;
            synchronized (linkedList) {
                if (this.taskQueue.isEmpty()) {
                    this.taskQueue.addLast(taskType);
                    Runnable task = new Runnable(){

                        public void run() {
                            MultiThreadedDelegator.this.performPendingTasks();
                        }
                    };
                    this.connection.getWorkerpool().execute(task);
                } else {
                    this.taskQueue.addLast(taskType);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void performPendingTasks() {
            assert (!DefaultIoProvider.isDispatcherThread());
            boolean taskToProcess = true;
            while (taskToProcess) {
                TaskType task = null;
                LinkedList<TaskType> linkedList = this.taskQueue;
                synchronized (linkedList) {
                    task = this.taskQueue.getFirst();
                    assert (task != null) : "a task should always be available";
                    if (this.taskQueue.size() > 1) {
                        ArrayList<TaskType> tasksToRemove = new ArrayList<TaskType>();
                        for (int i = 1; i < this.taskQueue.size(); ++i) {
                            if (!this.taskQueue.get(i).equals((Object)task)) continue;
                            tasksToRemove.add(this.taskQueue.get(i));
                        }
                        if (LOG.isLoggable(Level.FINE) && tasksToRemove.size() > 0) {
                            LOG.fine("removing " + tasksToRemove.size() + " duplicate task entries");
                        }
                        for (TaskType taskToRemove : tasksToRemove) {
                            this.taskQueue.remove((Object)taskToRemove);
                        }
                        assert (this.taskQueue.size() > 0);
                    }
                }
                HandlerProxy.this.performTask(task, this.connection);
                linkedList = this.taskQueue;
                synchronized (linkedList) {
                    if (this.taskQueue.size() > 1) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("more task to process. process next task");
                        }
                        this.taskQueue.remove((Object)task);
                        taskToProcess = true;
                    } else {
                        this.taskQueue.remove((Object)task);
                        taskToProcess = false;
                    }
                }
            }
        }

        public boolean onConnect(INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            assert (this.connection == connection);
            if (HandlerProxy.this.isConnectHandler) {
                this.processThreaded(TaskType.ON_CONNECT);
                return true;
            }
            return false;
        }

        public boolean onData(INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            assert (this.connection == connection);
            if (HandlerProxy.this.isDataHandler) {
                this.processThreaded(TaskType.ON_DATA);
                return true;
            }
            return false;
        }

        public boolean onDisconnect(INonBlockingConnection connection) throws IOException {
            assert (this.connection == connection);
            if (HandlerProxy.this.isDisconnectHandler) {
                this.processThreaded(TaskType.ON_DISCONNECT);
                return true;
            }
            return false;
        }

        public boolean onIdleTimeout(INonBlockingConnection connection) throws IOException {
            assert (this.connection == connection);
            if (HandlerProxy.this.isIdleTimeoutHandler) {
                this.processThreaded(TaskType.ON_IDLE_TIMEOUT);
                return true;
            }
            HandlerProxy.this.closeSilence(connection);
            return true;
        }

        public boolean onConnectionTimeout(INonBlockingConnection connection) throws IOException {
            assert (this.connection == connection);
            if (HandlerProxy.this.isConnectionTimeoutHandler) {
                this.processThreaded(TaskType.ON_CONNECTION_TIMEOUT);
                return true;
            }
            HandlerProxy.this.closeSilence(connection);
            return true;
        }

        public String toString() {
            return super.toString() + "-> " + HandlerProxy.this.handler.toString();
        }
    }

    private final class NonThreadedDelegator
    implements IConnectHandler,
    IDataHandler,
    IDisconnectHandler,
    IIdleTimeoutHandler,
    IConnectionTimeoutHandler {
        private NonThreadedDelegator() {
        }

        public boolean onConnect(INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            if (HandlerProxy.this.isConnectHandler) {
                return HandlerProxy.this.callOnConnect(connection);
            }
            return false;
        }

        public boolean onData(INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            if (HandlerProxy.this.isDataHandler) {
                return HandlerProxy.this.callOnData(connection);
            }
            return false;
        }

        public boolean onDisconnect(INonBlockingConnection connection) throws IOException {
            if (HandlerProxy.this.isDisconnectHandler) {
                return HandlerProxy.this.callOnDisconnect(connection);
            }
            return false;
        }

        public boolean onIdleTimeout(INonBlockingConnection connection) throws IOException {
            if (HandlerProxy.this.isIdleTimeoutHandler) {
                return HandlerProxy.this.callOnIdleTimeout(connection);
            }
            HandlerProxy.this.closeSilence(connection);
            return true;
        }

        public boolean onConnectionTimeout(INonBlockingConnection connection) throws IOException {
            if (HandlerProxy.this.isConnectionTimeoutHandler) {
                return HandlerProxy.this.callOnConnectionTimeout(connection);
            }
            HandlerProxy.this.closeSilence(connection);
            return true;
        }

        public String toString() {
            return super.toString() + "-> " + HandlerProxy.this.handler.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TaskType {
        ON_CONNECT,
        ON_DATA,
        ON_DISCONNECT,
        ON_IDLE_TIMEOUT,
        ON_CONNECTION_TIMEOUT;

    }
}

