/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xsocket.ClosedException;
import org.xsocket.DataConverter;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.connection.AbstractNonBlockingStream;
import org.xsocket.connection.BlockingConnection;
import org.xsocket.connection.HandlerProxy;
import org.xsocket.connection.IConnectHandler;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IConnectionTimeoutHandler;
import org.xsocket.connection.IDataHandler;
import org.xsocket.connection.IDisconnectHandler;
import org.xsocket.connection.IHandler;
import org.xsocket.connection.IIdleTimeoutHandler;
import org.xsocket.connection.INonBlockingConnection;
import org.xsocket.connection.spi.DefaultIoProvider;
import org.xsocket.connection.spi.IClientIoProvider;
import org.xsocket.connection.spi.IHandlerIoProvider;
import org.xsocket.connection.spi.IIoHandler;
import org.xsocket.connection.spi.IIoHandlerCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NonBlockingConnection
extends AbstractNonBlockingStream
implements INonBlockingConnection {
    private static final Logger LOG = Logger.getLogger(BlockingConnection.class.getName());
    public static final String SEND_TIMEOUT_KEY = "org.xsocket.stream.send_timeout_millis";
    public static final long DEFAULT_SEND_TIMEOUT_MILLIS = 60000L;
    private static Executor defaultWorkerPool = null;
    private static long sendTimeoutMillis = 60000L;
    private boolean isClosed = false;
    private static final DefaultIoProvider DEFAULT_CLIENT_IO_PROVIDER;
    private static IClientIoProvider clientIoProvider;
    private final IoHandlerCallback ioHandlerCallback = new IoHandlerCallback();
    private IHandlerIoProvider ioProvider = null;
    private IIoHandler ioHandler = null;
    private IHandler appHandler = null;
    private Executor workerpool = null;
    private final Object writeSynchronizer = new Object();
    private IOException writeException = null;
    private final List<ByteBuffer> pendingWriteConfirmations = new ArrayList<ByteBuffer>();
    private boolean idleTimeoutOccured = false;
    private boolean connectionTimeoutOccured = false;
    private boolean disconnectOccured = false;
    private boolean isSecured = false;
    private Integer cachedSoSndBuf = null;

    public NonBlockingConnection(String hostname, int port) throws IOException {
        this(InetAddress.getByName(hostname), port);
    }

    public NonBlockingConnection(InetAddress address, int port) throws IOException {
        this(new InetSocketAddress(address, port), Integer.MAX_VALUE, new HashMap<String, Object>(), null, false, null, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, int connectTimeoutMillis) throws IOException {
        this(new InetSocketAddress(address, port), connectTimeoutMillis, new HashMap<String, Object>(), null, false, null, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, Map<String, Object> options) throws IOException {
        this(new InetSocketAddress(address, port), Integer.MAX_VALUE, options, null, false, null, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, int connectTimeoutMillis, Map<String, Object> options) throws IOException {
        this(new InetSocketAddress(address, port), connectTimeoutMillis, options, null, false, null, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler) throws IOException {
        this(new InetSocketAddress(address, port), Integer.MAX_VALUE, new HashMap<String, Object>(), null, false, appHandler, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler, int connectTimeoutMillis) throws IOException {
        this(new InetSocketAddress(address, port), connectTimeoutMillis, new HashMap<String, Object>(), null, false, appHandler, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler, int connectTimeoutMillis, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(address, port), connectTimeoutMillis, new HashMap<String, Object>(), sslContext, sslOn, appHandler, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler, Map<String, Object> options) throws IOException {
        this(new InetSocketAddress(address, port), Integer.MAX_VALUE, options, null, false, appHandler, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler, int connectTimeoutMillis, Map<String, Object> options) throws IOException {
        this(new InetSocketAddress(address, port), connectTimeoutMillis, options, null, false, appHandler, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(String hostname, int port, IHandler appHandler) throws IOException {
        this(new InetSocketAddress(hostname, port), Integer.MAX_VALUE, new HashMap<String, Object>(), null, false, appHandler, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(String hostname, int port, IHandler appHandler, Executor workerPool) throws IOException {
        this(new InetSocketAddress(hostname, port), Integer.MAX_VALUE, new HashMap<String, Object>(), null, false, appHandler, workerPool);
    }

    public NonBlockingConnection(String hostname, int port, IHandler appHandler, Map<String, Object> options) throws IOException {
        this(new InetSocketAddress(hostname, port), Integer.MAX_VALUE, options, null, false, appHandler, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(address, port), Integer.MAX_VALUE, new HashMap<String, Object>(), sslContext, sslOn, null, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, Map<String, Object> options, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(address, port), Integer.MAX_VALUE, options, sslContext, sslOn, null, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(String hostname, int port, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(hostname, port), Integer.MAX_VALUE, new HashMap<String, Object>(), sslContext, sslOn, null, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(String hostname, int port, Map<String, Object> options, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(hostname, port), Integer.MAX_VALUE, options, sslContext, sslOn, null, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler, Executor workerPool) throws IOException {
        this(new InetSocketAddress(address, port), Integer.MAX_VALUE, new HashMap<String, Object>(), null, false, appHandler, workerPool);
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler, int connectTimeoutMillis, Executor workerPool) throws IOException {
        this(new InetSocketAddress(address, port), connectTimeoutMillis, new HashMap<String, Object>(), null, false, appHandler, workerPool);
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler, int connectTimeoutMillis, SSLContext sslContext, boolean sslOn, Executor workerPool) throws IOException {
        this(new InetSocketAddress(address, port), connectTimeoutMillis, new HashMap<String, Object>(), sslContext, sslOn, appHandler, workerPool);
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler, boolean autoflush, IConnection.FlushMode flushmode) throws IOException {
        this(new InetSocketAddress(address, port), Integer.MAX_VALUE, new HashMap<String, Object>(), null, false, appHandler, NonBlockingConnection.getDefaultWorkerpool(), autoflush, flushmode);
    }

    NonBlockingConnection(InetSocketAddress remoteAddress, int connectTimeoutMillis, Map<String, Object> options, SSLContext sslContext, boolean sslOn, IHandler appHandler, Executor workerpool) throws IOException {
        this(remoteAddress, connectTimeoutMillis, options, sslContext, sslOn, appHandler, workerpool, true, DEFAULT_FLUSH_MODE);
    }

    private NonBlockingConnection(InetSocketAddress remoteAddress, int connectTimeoutMillis, Map<String, Object> options, SSLContext sslContext, boolean isSecured, IHandler appHandler, Executor workerpool, boolean autoflush, IConnection.FlushMode flushmode) throws IOException {
        this.isSecured = isSecured;
        this.setFlushmode(flushmode);
        this.setAutoflush(autoflush);
        IIoHandler ioHandler = NonBlockingConnection.createClientIoHandler(remoteAddress, connectTimeoutMillis, options, sslContext, isSecured);
        this.init(ioHandler, NonBlockingConnection.getClientIoProvider(), HandlerProxy.newPrototype(appHandler, null).newProxy(this), workerpool);
        this.setIdleTimeoutSec(Integer.MAX_VALUE);
        this.setConnectionTimeoutSec(Integer.MAX_VALUE);
    }

    protected NonBlockingConnection() throws IOException {
    }

    static synchronized Executor getDefaultWorkerpool() {
        if (defaultWorkerPool == null) {
            defaultWorkerPool = Executors.newCachedThreadPool(new DefaultThreadFactory());
        }
        return defaultWorkerPool;
    }

    final void init(IIoHandler ioHandler, IHandlerIoProvider ioProvider, IHandler appHandler, Executor workerpool) throws IOException, SocketTimeoutException {
        this.ioHandler = ioHandler;
        this.ioProvider = ioProvider;
        this.appHandler = appHandler;
        this.setWorkerpool(workerpool);
        ioHandler.init(this.ioHandlerCallback);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("connection " + this.getId() + " created. IoHandler: " + ioHandler.toString());
        }
    }

    @Override
    public final void setHandler(IHandler hdl) {
        this.appHandler = HandlerProxy.newPrototype(hdl, null).newProxy(this);
    }

    public void setWorkerpool(Executor workerpool) {
        this.workerpool = workerpool;
    }

    @Override
    public Executor getWorkerpool() {
        return this.workerpool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setFlushmode(IConnection.FlushMode flushMode) {
        if (flushMode == IConnection.FlushMode.ASYNC) {
            Object object = this.writeSynchronizer;
            synchronized (object) {
                if (!this.pendingWriteConfirmations.isEmpty()) {
                    LOG.warning("Updating flush mode to " + (Object)((Object)flushMode) + ". A sync flush write operation is currently running which will be updated to async mode");
                    this.pendingWriteConfirmations.clear();
                    this.ioHandlerCallback.onWritten(null);
                }
                super.setFlushmode(flushMode);
            }
        } else {
            super.setFlushmode(flushMode);
        }
    }

    @Override
    protected boolean reset() {
        try {
            if (!this.pendingWriteConfirmations.isEmpty()) {
                return false;
            }
            this.writeException = null;
            boolean isReset = this.ioHandler.reset();
            if (!isReset) {
                return false;
            }
            return super.reset();
        }
        catch (Exception e) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("error occured by reseting connection " + this.getId() + " " + e.toString());
            }
            return false;
        }
    }

    @Override
    public final boolean isOpen() {
        if (this.isClosed) {
            return false;
        }
        return this.ioHandler.isOpen();
    }

    @Override
    public final void setWriteTransferRate(int bytesPerSecond) throws ClosedException, IOException {
        if (bytesPerSecond != Integer.MAX_VALUE && this.getFlushmode() != IConnection.FlushMode.ASYNC) {
            LOG.warning("setWriteTransferRate is only supported for FlushMode ASYNC. Ignore update of the transfer rate");
            return;
        }
        this.ioHandler = this.ioProvider.setWriteTransferRate(this.ioHandler, bytesPerSecond);
    }

    @Override
    public final void activateSecuredMode() throws IOException {
        boolean isPrestarted = DEFAULT_CLIENT_IO_PROVIDER.preStartSecuredMode(this.ioHandler);
        if (isPrestarted) {
            IConnection.FlushMode currentFlushMode = this.getFlushmode();
            this.setFlushmode(IConnection.FlushMode.ASYNC);
            this.internalFlush();
            this.setFlushmode(currentFlushMode);
            ByteBuffer[] buffer = this.readAvailableByteBuffer();
            DEFAULT_CLIENT_IO_PROVIDER.startSecuredMode(this.ioHandler, buffer);
            this.isSecured = true;
        }
    }

    @Override
    public boolean isSecure() {
        return this.isSecured;
    }

    @Override
    public final ByteBuffer[] readByteBufferByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        try {
            return super.readByteBufferByDelimiter(delimiter, encoding, maxLength);
        }
        catch (MaxReadSizeExceededException mre) {
            if (this.isOpen()) {
                throw mre;
            }
            throw new ClosedException("data source is already closed");
        }
        catch (BufferUnderflowException bue) {
            if (this.isOpen()) {
                throw bue;
            }
            throw new ClosedException("data source is already closed");
        }
    }

    @Override
    public ByteBuffer[] readByteBufferByLength(int length) throws IOException, BufferUnderflowException {
        try {
            ByteBuffer[] buffers = super.readByteBufferByLength(length);
            return buffers;
        }
        catch (BufferUnderflowException bue) {
            if (this.isOpen()) {
                throw bue;
            }
            throw new ClosedException("data source is already closed");
        }
    }

    @Override
    protected ByteBuffer readSingleByteBuffer(int length) throws IOException, ClosedException, BufferUnderflowException {
        try {
            return super.readSingleByteBuffer(length);
        }
        catch (BufferUnderflowException bue) {
            if (this.isOpen()) {
                throw bue;
            }
            throw new ClosedException("data source is already closed");
        }
    }

    @Override
    public final void setIdleTimeoutSec(int timeoutInSec) {
        this.ioHandler.setIdleTimeoutSec(timeoutInSec);
        this.idleTimeoutOccured = false;
    }

    @Override
    public final void setConnectionTimeoutSec(int timeoutSec) {
        this.ioHandler.setConnectionTimeoutSec(timeoutSec);
        this.connectionTimeoutOccured = false;
    }

    @Override
    public int getRemainingSecToConnectionTimeout() {
        return this.ioHandler.getRemainingSecToConnectionTimeout();
    }

    @Override
    public int getRemainingSecToIdleTimeout() {
        return this.ioHandler.getRemainingSecToIdleTimeout();
    }

    @Override
    public final int getConnectionTimeoutSec() {
        return this.ioHandler.getConnectionTimeoutSec();
    }

    @Override
    public final int getIdleTimeoutSec() {
        return this.ioHandler.getIdleTimeoutSec();
    }

    @Override
    public final InetAddress getLocalAddress() {
        return this.ioHandler.getLocalAddress();
    }

    @Override
    public final String getId() {
        return this.ioHandler.getId();
    }

    @Override
    public final int getLocalPort() {
        return this.ioHandler.getLocalPort();
    }

    @Override
    public final InetAddress getRemoteAddress() {
        return this.ioHandler.getRemoteAddress();
    }

    @Override
    public final int getRemotePort() {
        return this.ioHandler.getRemotePort();
    }

    @Override
    public final int getPendingWriteDataSize() {
        return this.getWriteBufferSize() + this.ioHandler.getPendingWriteDataSize();
    }

    @Override
    public final void suspendRead() throws IOException {
        this.ioHandler.suspendRead();
    }

    @Override
    public final void resumeRead() throws IOException {
        this.ioHandler.resumeRead();
    }

    @Override
    public long transferFrom(ReadableByteChannel sourceChannel) throws ClosedException, IOException {
        int chunkSize = this.getSoSndBufSize();
        return this.transferFrom(sourceChannel, chunkSize);
    }

    private int getSoSndBufSize() throws IOException {
        if (this.cachedSoSndBuf == null) {
            this.cachedSoSndBuf = (Integer)this.getOption("SOL_SOCKET.SO_SNDBUF");
        }
        return this.cachedSoSndBuf;
    }

    @Override
    protected void onWriteDataInserted() throws IOException, ClosedException {
        if (this.isAutoflush()) {
            this.internalFlush();
        }
    }

    @Override
    public final Object getOption(String name) throws IOException {
        return this.ioHandler.getOption(name);
    }

    @Override
    public final Map<String, Class> getOptions() {
        return this.ioHandler.getOptions();
    }

    @Override
    public void setOption(String name, Object value) throws IOException {
        if (name.equalsIgnoreCase("SOL_SOCKET.SO_SNDBUF")) {
            this.cachedSoSndBuf = (Integer)value;
        }
        this.ioHandler.setOption(name, value);
    }

    private void forceClose() {
        block2: {
            try {
                this.isClosed = true;
                this.ioHandler.close(true);
            }
            catch (IOException ioe) {
                if (!LOG.isLoggable(Level.FINE)) break block2;
                LOG.fine("Error occured by closing " + ioe.toString());
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.isOpen() && !this.isClosed) {
            this.isClosed = true;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("closing connection -> flush all remaining data");
            }
            if (!this.isWriteBufferEmpty()) {
                ByteBuffer[] buffers = this.drainWriteQueue();
                this.ioHandler.write(buffers);
            }
            this.ioHandler.close(false);
        }
    }

    @Override
    public final void flush() throws ClosedException, IOException {
        this.internalFlush();
    }

    private void internalFlush() throws ClosedException, IOException {
        this.removeWriteMark();
        if (this.getFlushmode() == IConnection.FlushMode.SYNC) {
            this.syncFlush();
        } else if (!this.isWriteBufferEmpty()) {
            ByteBuffer[] buffers = this.drainWriteQueue();
            this.ioHandler.write(buffers);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.getId() + "] flushed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncFlush() throws ClosedException, IOException {
        long start = System.currentTimeMillis();
        long remainingTime = sendTimeoutMillis;
        if (DefaultIoProvider.isDispatcherThread()) {
            String msg = "synchronized flushing in NonThreaded mode could cause dead locks (hint: set flush mode to ASYNC)";
            LOG.warning(msg);
        }
        Object object = this.writeSynchronizer;
        synchronized (object) {
            if (!this.isWriteBufferEmpty()) {
                try {
                    ByteBuffer[] buffers = this.drainWriteQueue();
                    this.pendingWriteConfirmations.addAll(Arrays.asList(buffers));
                    this.ioHandler.write(buffers);
                    do {
                        if (this.pendingWriteConfirmations.isEmpty()) {
                            return;
                        }
                        if (this.writeException != null) {
                            IOException ioe = this.writeException;
                            this.writeException = null;
                            throw ioe;
                        }
                        try {
                            this.writeSynchronizer.wait(remainingTime);
                        }
                        catch (InterruptedException ignore) {
                            // empty catch block
                        }
                    } while ((remainingTime = start + sendTimeoutMillis - System.currentTimeMillis()) > 0L);
                    throw new SocketTimeoutException("send timeout " + DataConverter.toFormatedDuration(sendTimeoutMillis) + " reached. returning from sync flushing");
                }
                finally {
                    this.pendingWriteConfirmations.clear();
                }
            }
        }
    }

    private static IClientIoProvider getClientIoProvider() {
        if (clientIoProvider == null) {
            String clientIoManagerClassname = System.getProperty("org.xsocket.stream.io.ClientIoProviderClass", DefaultIoProvider.class.getName());
            try {
                Class<?> clientIoManagerClass = Class.forName(clientIoManagerClassname, true, Thread.currentThread().getContextClassLoader());
                clientIoProvider = (IClientIoProvider)clientIoManagerClass.newInstance();
            }
            catch (Exception e) {
                LOG.warning("error occured by creating ClientIoManager " + clientIoManagerClassname + ": " + e.toString());
                LOG.info("using default ClientIoManager " + DEFAULT_CLIENT_IO_PROVIDER.getClass().getName());
                clientIoProvider = DEFAULT_CLIENT_IO_PROVIDER;
            }
        }
        return clientIoProvider;
    }

    public String toString() {
        try {
            if (this.isOpen()) {
                return "id=" + this.getId() + ", remote=" + this.getRemoteAddress().getCanonicalHostName() + "(" + this.getRemoteAddress() + ":" + this.getRemotePort() + ")";
            }
            return "id=" + this.getId() + " (closed)";
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public String dump() {
        StringBuilder sb = new StringBuilder(this.toString());
        sb.append(" readQueueSize=" + this.available() + " writeQueueSize=" + super.getWriteBufferSize());
        return sb.toString();
    }

    private static IIoHandler createClientIoHandler(InetSocketAddress remoteAddress, int connectTimeoutMillis, Map<String, Object> options, SSLContext sslContext, boolean sslOn) throws IOException {
        IIoHandler ioHandler = null;
        ioHandler = sslContext != null ? ((DefaultIoProvider)NonBlockingConnection.getClientIoProvider()).createSSLClientIoHandler(remoteAddress, connectTimeoutMillis, options, sslContext, sslOn) : NonBlockingConnection.getClientIoProvider().createClientIoHandler(remoteAddress, connectTimeoutMillis, options);
        return ioHandler;
    }

    static {
        try {
            sendTimeoutMillis = Long.valueOf(System.getProperty(SEND_TIMEOUT_KEY, Long.toString(60000L)));
        }
        catch (Exception e) {
            LOG.warning("invalid value for system property org.xsocket.stream.send_timeout_millis: " + System.getProperty(SEND_TIMEOUT_KEY) + " (valid is a int value)" + " using default");
            sendTimeoutMillis = 60000L;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("non blocking connection send time out set with " + DataConverter.toFormatedDuration(sendTimeoutMillis));
        }
        DEFAULT_CLIENT_IO_PROVIDER = new DefaultIoProvider();
        clientIoProvider = null;
    }

    private static class DefaultThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        DefaultThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "xNbcPool-" + poolNumber.getAndIncrement() + "-thread-";
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (!t.isDaemon()) {
                t.setDaemon(true);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    private final class IoHandlerCallback
    implements IIoHandlerCallback {
        private IoHandlerCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onWritten(ByteBuffer data) {
            if (NonBlockingConnection.this.getFlushmode() == IConnection.FlushMode.SYNC) {
                Object object = NonBlockingConnection.this.writeSynchronizer;
                synchronized (object) {
                    if (data != null) {
                        NonBlockingConnection.this.pendingWriteConfirmations.remove(data);
                    }
                    if (NonBlockingConnection.this.pendingWriteConfirmations.isEmpty()) {
                        NonBlockingConnection.this.writeSynchronizer.notifyAll();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onWriteException(IOException ioException, ByteBuffer data) {
            if (NonBlockingConnection.this.getFlushmode() == IConnection.FlushMode.SYNC) {
                Object object = NonBlockingConnection.this.writeSynchronizer;
                synchronized (object) {
                    NonBlockingConnection.this.writeException = ioException;
                    if (data != null) {
                        NonBlockingConnection.this.pendingWriteConfirmations.remove(data);
                    }
                    NonBlockingConnection.this.writeSynchronizer.notifyAll();
                }
            }
        }

        public void onData(ByteBuffer[] data) {
            block5: {
                if (LOG.isLoggable(Level.FINE)) {
                    int size = 0;
                    for (ByteBuffer byteBuffer : data) {
                        size += byteBuffer.remaining();
                    }
                    LOG.fine("adding " + size + " bytes to receive buffer");
                }
                NonBlockingConnection.this.appendDataToReadBuffer(data);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("calling app handler " + NonBlockingConnection.this.appHandler);
                }
                try {
                    ((IDataHandler)NonBlockingConnection.this.appHandler).onData(NonBlockingConnection.this);
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block5;
                    LOG.fine("error occured by performing onData callback on " + NonBlockingConnection.this.appHandler + " " + ioe.toString());
                }
            }
        }

        public void onConnectionAbnormalTerminated() {
            NonBlockingConnection.this.forceClose();
        }

        public void onConnect() {
            block2: {
                try {
                    ((IConnectHandler)NonBlockingConnection.this.appHandler).onConnect(NonBlockingConnection.this);
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("error occured by performing onConnect callback on " + NonBlockingConnection.this.appHandler + " " + ioe.toString());
                }
            }
        }

        public void onDisconnect() {
            block3: {
                if (!NonBlockingConnection.this.disconnectOccured) {
                    NonBlockingConnection.this.disconnectOccured = true;
                    try {
                        ((IDisconnectHandler)NonBlockingConnection.this.appHandler).onDisconnect(NonBlockingConnection.this);
                    }
                    catch (IOException ioe) {
                        if (!LOG.isLoggable(Level.FINE)) break block3;
                        LOG.fine("error occured by performing onDisconnect callback on " + NonBlockingConnection.this.appHandler + " " + ioe.toString());
                    }
                }
            }
        }

        public void onConnectionTimeout() {
            if (!NonBlockingConnection.this.connectionTimeoutOccured) {
                NonBlockingConnection.this.connectionTimeoutOccured = true;
                try {
                    ((IConnectionTimeoutHandler)NonBlockingConnection.this.appHandler).onConnectionTimeout(NonBlockingConnection.this);
                }
                catch (IOException ioe) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("error occured by performing onConnectionTimeout callback on " + NonBlockingConnection.this.appHandler + " " + ioe.toString());
                    }
                }
            } else {
                NonBlockingConnection.this.setConnectionTimeoutSec(Integer.MAX_VALUE);
            }
        }

        public void onIdleTimeout() {
            if (!NonBlockingConnection.this.idleTimeoutOccured) {
                NonBlockingConnection.this.idleTimeoutOccured = true;
                try {
                    ((IIdleTimeoutHandler)NonBlockingConnection.this.appHandler).onIdleTimeout(NonBlockingConnection.this);
                }
                catch (IOException ioe) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("error occured by performing onIdleTimeout callback on " + NonBlockingConnection.this.appHandler + " " + ioe.toString());
                    }
                }
            } else {
                NonBlockingConnection.this.setIdleTimeoutSec(Integer.MAX_VALUE);
            }
        }
    }
}

