/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xsocket.ClosedException;
import org.xsocket.DataConverter;
import org.xsocket.Execution;
import org.xsocket.ILifeCycle;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.WaitTimeoutException;
import org.xsocket.connection.HandlerProxy;
import org.xsocket.connection.IConnectHandler;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IConnectionPool;
import org.xsocket.connection.IConnectionTimeoutHandler;
import org.xsocket.connection.IDataHandler;
import org.xsocket.connection.IDisconnectHandler;
import org.xsocket.connection.IHandler;
import org.xsocket.connection.IIdleTimeoutHandler;
import org.xsocket.connection.IInternalHandler;
import org.xsocket.connection.INonBlockingConnection;
import org.xsocket.connection.NonBlockingConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NonBlockingConnectionPool
implements IConnectionPool {
    private static final Logger LOG = Logger.getLogger(NonBlockingConnectionPool.class.getName());
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
    private static final long WATCHDOG_PERIOD_MILLIS = 30000L;
    private static final Timer WATCHDOG_TIMER = new Timer("xResourcePoolTimer", true);
    private static final int MIN_REMAINING_SEC_TO_IDLE_TIMEOUT = 3000;
    private static final int MIN_REMAINING_SEC_TO_CONNECTION_TIMEOUT = 3000;
    protected static final long MIN_CHECKPERIOD_MILLIS = 60000L;
    protected static final int MAX_SIZE = Integer.MAX_VALUE;
    protected static final int MAX_TIMEOUT = Integer.MAX_VALUE;
    private static AtomicInteger nextProxyId = new AtomicInteger();
    private boolean isOpen = true;
    private int maxActive = Integer.MAX_VALUE;
    private int maxIdle = Integer.MAX_VALUE;
    private long maxWaitMillis = Long.MAX_VALUE;
    private int idleTimeoutSec = Integer.MAX_VALUE;
    private int lifeTimeoutSec = Integer.MAX_VALUE;
    private SSLContext sslContext = null;
    private Executor workerpool = NonBlockingConnection.getDefaultWorkerpool();
    private final Pool pool = new Pool();
    private final Object retrieveGuard = new Object();
    private final List<ILifeCycle> listeners = new ArrayList<ILifeCycle>();
    private final AtomicInteger countPendingGet = new AtomicInteger(0);
    private int countCreated = 0;
    private int countDestroyed = 0;
    private int countTimeoutPooledLifetime = 0;
    private int countTimeoutPooledIdle = 0;
    private int countTimeoutConnectionIdle = 0;
    private int countTimeoutConnectionLifetime = 0;
    private TimerTask watchDogTask = new TimerTask(){

        public void run() {
            long currentTimeSec = System.currentTimeMillis() / 1000L;
            for (PooledConnectionHolder pooledResource : NonBlockingConnectionPool.this.pool.getIdleConnections()) {
                boolean isValid = pooledResource.isValid(currentTimeSec);
                if (isValid || NonBlockingConnectionPool.this.pool.getIdleConnection(pooledResource) == null) continue;
                pooledResource.destroy();
            }
        }
    };

    public NonBlockingConnectionPool() {
        WATCHDOG_TIMER.schedule(this.watchDogTask, 30000L, 30000L);
    }

    public NonBlockingConnectionPool(SSLContext sslContext) {
        this();
        this.sslContext = sslContext;
    }

    public INonBlockingConnection getNonBlockingConnection(String host, int port) throws IOException, WaitTimeoutException {
        return this.getConnection(new InetSocketAddress(host, port), null, this.workerpool, Integer.MAX_VALUE, false);
    }

    public INonBlockingConnection getNonBlockingConnection(String host, int port, boolean isSSL) throws IOException, WaitTimeoutException {
        return this.getConnection(new InetSocketAddress(host, port), null, this.workerpool, Integer.MAX_VALUE, isSSL);
    }

    public INonBlockingConnection getNonBlockingConnection(String host, int port, int connectTimeoutMillis) throws IOException, WaitTimeoutException {
        return this.getConnection(new InetSocketAddress(host, port), null, this.workerpool, connectTimeoutMillis, false);
    }

    public INonBlockingConnection getNonBlockingConnection(String host, int port, int connectTimeoutMillis, boolean isSSL) throws IOException, WaitTimeoutException {
        return this.getConnection(new InetSocketAddress(host, port), null, this.workerpool, connectTimeoutMillis, isSSL);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port) throws IOException, WaitTimeoutException {
        return this.getConnection(new InetSocketAddress(address, port), null, this.workerpool, Integer.MAX_VALUE, false);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, boolean isSSL) throws IOException, WaitTimeoutException {
        return this.getConnection(new InetSocketAddress(address, port), null, this.workerpool, Integer.MAX_VALUE, isSSL);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, int connectTimeoutMillis) throws IOException, WaitTimeoutException {
        return this.getConnection(new InetSocketAddress(address, port), null, this.workerpool, connectTimeoutMillis, false);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, int connectTimeoutMillis, boolean isSSL) throws IOException, WaitTimeoutException {
        return this.getConnection(new InetSocketAddress(address, port), null, this.workerpool, connectTimeoutMillis, isSSL);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, IHandler appHandler) throws IOException, WaitTimeoutException {
        return this.getConnection(new InetSocketAddress(address, port), appHandler, this.workerpool, Integer.MAX_VALUE, false);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, IHandler appHandler, boolean isSSL) throws IOException, WaitTimeoutException {
        return this.getConnection(new InetSocketAddress(address, port), appHandler, this.workerpool, Integer.MAX_VALUE, isSSL);
    }

    public INonBlockingConnection getNonBlockingConnection(String host, int port, IHandler appHandler) throws IOException, WaitTimeoutException {
        return this.getConnection(new InetSocketAddress(host, port), appHandler, this.workerpool, Integer.MAX_VALUE, false);
    }

    public INonBlockingConnection getNonBlockingConnection(String host, int port, IHandler appHandler, boolean isSSL) throws IOException, WaitTimeoutException {
        return this.getConnection(new InetSocketAddress(host, port), appHandler, this.workerpool, Integer.MAX_VALUE, isSSL);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, IHandler appHandler, int connectTimeoutMillis) throws IOException, WaitTimeoutException {
        return this.getConnection(new InetSocketAddress(address, port), appHandler, this.workerpool, connectTimeoutMillis, false);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, IHandler appHandler, int connectTimeoutMillis, boolean isSSL) throws IOException, WaitTimeoutException {
        return this.getConnection(new InetSocketAddress(address, port), appHandler, this.workerpool, connectTimeoutMillis, isSSL);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, IHandler appHandler, Executor workerPool, int connectTimeoutMillis) throws IOException, WaitTimeoutException {
        return this.getConnection(new InetSocketAddress(address, port), appHandler, workerPool, connectTimeoutMillis, false);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, IHandler appHandler, Executor workerPool, int connectTimeoutMillis, boolean isSSL) throws IOException, WaitTimeoutException {
        return this.getConnection(new InetSocketAddress(address, port), appHandler, workerPool, connectTimeoutMillis, isSSL);
    }

    private INonBlockingConnection getConnection(InetSocketAddress address, IHandler appHandler, Executor workerPool, int connectTimeoutMillis, boolean isSSL) throws IOException, WaitTimeoutException {
        PooledConnectionHolder pooledConnectionHolder = this.getPooledConnection(address, workerPool, connectTimeoutMillis, isSSL);
        if (pooledConnectionHolder != null) {
            return new NonBlockingConnectionProxy(pooledConnectionHolder, appHandler);
        }
        throw new IOException("could not create a connection to " + address);
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void addListener(ILifeCycle listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean removeListener(ILifeCycle listener) {
        boolean result = this.listeners.remove(listener);
        return result;
    }

    public void setWorkerpool(Executor workerpool) {
        this.workerpool = workerpool;
    }

    public Executor getWorkerpool() {
        return this.workerpool;
    }

    @Override
    public int getMaxActivePooled() {
        return this.maxActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxActivePooled(int maxActive) {
        NonBlockingConnectionPool nonBlockingConnectionPool = this;
        synchronized (nonBlockingConnectionPool) {
            this.maxActive = maxActive;
            this.notifyAll();
        }
    }

    @Override
    public long getCreationMaxWaitMillis() {
        return this.maxWaitMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCreationMaxWaitMillis(long maxWaitMillis) {
        NonBlockingConnectionPool nonBlockingConnectionPool = this;
        synchronized (nonBlockingConnectionPool) {
            this.maxWaitMillis = maxWaitMillis;
            this.notifyAll();
        }
    }

    @Override
    public int getMaxIdlePooled() {
        return this.maxIdle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxIdlePooled(int maxIdle) {
        NonBlockingConnectionPool nonBlockingConnectionPool = this;
        synchronized (nonBlockingConnectionPool) {
            this.maxIdle = maxIdle;
            this.notifyAll();
        }
    }

    @Override
    public int getNumPooledActive() {
        return this.pool.getNumActive();
    }

    @Override
    public List<String> getActiveConnectionInfos() {
        return this.pool.getActiveConnectionInfos();
    }

    @Override
    public List<String> getIdleConnectionInfos() {
        return this.pool.getIdleConnectionInfos();
    }

    @Override
    public int getNumPooledIdle() {
        return this.pool.getNumIdle();
    }

    @Override
    public int getNumCreated() {
        return this.countCreated;
    }

    @Override
    public int getNumDestroyed() {
        return this.countDestroyed;
    }

    public int getNumTimeoutConnectionLifetime() {
        return this.countTimeoutConnectionLifetime;
    }

    public int getNumTimeoutConnectionIdle() {
        return this.countTimeoutConnectionIdle;
    }

    @Override
    public int getNumTimeoutPooledIdle() {
        return this.countTimeoutPooledIdle;
    }

    @Override
    public int getNumTimeoutPooledLifetime() {
        return this.countTimeoutPooledLifetime;
    }

    @Override
    public int getPooledIdleTimeoutSec() {
        return this.idleTimeoutSec;
    }

    @Override
    public void setPooledIdleTimeoutSec(int idleTimeoutSec) {
        this.idleTimeoutSec = idleTimeoutSec;
    }

    @Override
    public int getPooledLifeTimeoutSec() {
        return this.lifeTimeoutSec;
    }

    @Override
    public void setPooledLifeTimeoutSec(int lifeTimeoutSec) {
        this.lifeTimeoutSec = lifeTimeoutSec;
    }

    public int getNumPendingGet() {
        return this.countPendingGet.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PooledConnectionHolder getPooledConnection(InetSocketAddress address, Executor workerPool, int creationTimeoutMillis, boolean isSSL) throws IOException, WaitTimeoutException {
        if (this.isOpen) {
            PooledConnectionHolder pooledConnectionHolder = this.retrievePooledConnection(address, workerPool, creationTimeoutMillis, isSSL);
            if (pooledConnectionHolder != null) {
                return pooledConnectionHolder;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("no free resources available waiting max " + DataConverter.toFormatedDuration(this.maxWaitMillis) + " for a free resource (" + this.pool.toString() + ", idleTimeoutMillis=" + this.getPooledIdleTimeoutSec() + ", lifeTimeout=" + this.getPooledLifeTimeoutSec() + ")");
            }
            this.countPendingGet.incrementAndGet();
            long start = System.currentTimeMillis();
            while (System.currentTimeMillis() - start < this.maxWaitMillis) {
                long waitTime = this.maxWaitMillis - (System.currentTimeMillis() - start);
                if (waitTime > 0L) {
                    Object object = this.retrieveGuard;
                    synchronized (object) {
                        try {
                            this.retrieveGuard.wait(waitTime);
                        }
                        catch (InterruptedException ignore) {
                            // empty catch block
                        }
                    }
                }
                if ((pooledConnectionHolder = this.retrievePooledConnection(address, workerPool, creationTimeoutMillis, isSSL)) == null) continue;
                if (!LOG.isLoggable(Level.FINE)) break;
                LOG.fine("now got a resource (waiting time " + DataConverter.toFormatedDuration(System.currentTimeMillis() - start) + ")");
                break;
            }
            this.countPendingGet.decrementAndGet();
            if (pooledConnectionHolder == null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("wait timeout reached (" + DataConverter.toFormatedDuration(this.maxWaitMillis) + ")");
                }
                throw new WaitTimeoutException("wait timeout reached (" + DataConverter.toFormatedDuration(this.maxWaitMillis) + ")");
            }
            return pooledConnectionHolder;
        }
        throw new RuntimeException("pool is already closed");
    }

    private synchronized PooledConnectionHolder retrievePooledConnection(InetSocketAddress address, Executor workerPool, int creationTimeoutMillis, boolean isSSL) throws IOException {
        PooledConnectionHolder pooledConnectionHolder = this.getConnectionFromPool(address, isSSL);
        if (pooledConnectionHolder != null) {
            return pooledConnectionHolder;
        }
        if (this.pool.getNumActive() < this.maxActive) {
            return this.newPooledConnection(address, workerPool, creationTimeoutMillis, isSSL);
        }
        return null;
    }

    private PooledConnectionHolder getConnectionFromPool(InetSocketAddress address, boolean isSSL) throws IOException {
        PooledConnectionHolder pooledConnectionHolder = this.pool.getIdleConnection(address, isSSL);
        if (pooledConnectionHolder != null) {
            boolean isValid = pooledConnectionHolder.reset();
            if (isValid) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("got connection from pool (" + this.pool.toString() + ", idleTimeoutMillis=" + this.getPooledIdleTimeoutSec() + ", lifeTimeout=" + this.getPooledLifeTimeoutSec() + "): " + pooledConnectionHolder.getConnection());
                }
                return pooledConnectionHolder;
            }
            return this.getConnectionFromPool(address, isSSL);
        }
        return null;
    }

    public static void destroy(INonBlockingConnection connection) throws IOException {
        if (connection == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("warning trying to destroy a <null> connection. destroy will be ignored");
            }
            return;
        }
        if (connection instanceof NonBlockingConnectionProxy) {
            ((NonBlockingConnectionProxy)connection).destroy();
        } else {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("warning connection is not a pooled connection. closing it anyway");
            }
            connection.close();
        }
    }

    static boolean isDestroyed(INonBlockingConnection connection) {
        if (connection instanceof NonBlockingConnectionProxy) {
            return ((NonBlockingConnectionProxy)connection).isDestroyed();
        }
        return connection.isOpen();
    }

    @Override
    public final void close() {
        if (this.isOpen) {
            this.isOpen = false;
            this.watchDogTask.cancel();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("closing (idling=" + this.getNumPooledIdle() + ", active=" + this.getNumPooledActive() + ")");
            }
            for (PooledConnectionHolder pooledResource : this.pool.getManagedConnection()) {
                pooledResource.destroy();
            }
            for (ILifeCycle lifeCycle : this.listeners) {
                try {
                    lifeCycle.onDestroy();
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("exception occured by destroying " + lifeCycle + " " + ioe.toString());
                }
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " idling=" + this.getNumPooledIdle() + ", active=" + this.getNumPooledActive() + ", maxActive=" + this.getMaxActivePooled() + ", idleTimeoutMillis=" + this.getPooledIdleTimeoutSec() + ", lifeTimeout=" + this.getPooledLifeTimeoutSec() + ")";
    }

    private PooledConnectionHolder newPooledConnection(Object address, Executor workerPool, int creationTimeoutMillis, boolean isSSL) throws IOException {
        int trials = 0;
        int sleepTime = 3;
        IOException ex = null;
        long start = System.currentTimeMillis();
        while (true) {
            ++trials;
            try {
                PooledConnectionHolder pooledConnectionHolder = new PooledConnectionHolder();
                NonBlockingConnection pooledConnection = new NonBlockingConnection((InetSocketAddress)address, creationTimeoutMillis, new HashMap<String, Object>(), this.sslContext, isSSL, pooledConnectionHolder, workerPool);
                pooledConnectionHolder.init(pooledConnection);
                ++this.countCreated;
                return pooledConnectionHolder;
            }
            catch (IOException ioe) {
                ex = ioe;
                sleepTime *= 3;
                try {
                    Thread.sleep(sleepTime);
                    continue;
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                if (System.currentTimeMillis() < start + 500L) continue;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("error occured by creating connection to " + address + ". creation timeout " + 500 + " reached. (" + trials + " trials done)");
                }
                if (ex != null) {
                    throw ex;
                }
                throw new IOException("could not create a new connetion to " + address);
            }
            break;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class NonBlockingConnectionProxy
    implements INonBlockingConnection {
        private PooledConnectionHolder pooledConnectionHolder = null;
        private String id = null;
        private boolean isProxyOpen = true;
        private IHandler handler = null;
        private boolean idleTimeoutOccured = false;
        private boolean connectionTimeoutOccured = false;
        private boolean disconnectOccured = false;

        NonBlockingConnectionProxy(PooledConnectionHolder pooledConnectionHolder, IHandler appHandler) throws IOException {
            this.pooledConnectionHolder = pooledConnectionHolder;
            this.id = pooledConnectionHolder.getConnection().getId() + "." + Integer.toHexString(nextProxyId.getAndIncrement());
            this.setHandler(appHandler);
            pooledConnectionHolder.lease(this);
        }

        @Override
        public void setHandler(IHandler hdl) {
            this.handler = HandlerProxy.newPrototype(hdl, null).newProxy(this);
            if (!this.pooledConnectionHolder.getConnection().isReadBufferEmpty()) {
                this.onData();
            }
        }

        boolean isDestroyed() {
            return !this.pooledConnectionHolder.getConnection().isOpen();
        }

        @Override
        public boolean isOpen() {
            if (this.isProxyOpen) {
                return this.pooledConnectionHolder.getConnection().isOpen();
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (this.isProxyOpen) {
                this.isProxyOpen = false;
                this.pooledConnectionHolder.release();
                Object object = NonBlockingConnectionPool.this.retrieveGuard;
                synchronized (object) {
                    NonBlockingConnectionPool.this.retrieveGuard.notifyAll();
                }
            } else {
                this.destroy();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void destroy() {
            block6: {
                if (this.isProxyOpen) {
                    this.isProxyOpen = false;
                    try {
                        this.onDisconnect();
                        this.pooledConnectionHolder.destroy();
                        Object object = NonBlockingConnectionPool.this.retrieveGuard;
                        synchronized (object) {
                            NonBlockingConnectionPool.this.retrieveGuard.notifyAll();
                        }
                    }
                    catch (Exception e) {
                        if (!LOG.isLoggable(Level.FINE)) break block6;
                        LOG.fine("error occured while destroying pooledConnectionHolder " + this.pooledConnectionHolder + " reason: " + e.toString());
                    }
                }
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getId());
            if (!this.isOpen()) {
                sb.append(" closed");
            }
            sb.append(" (" + this.pooledConnectionHolder.getAddress() + ") ");
            sb.append(" (proxy ");
            if (!this.isProxyOpen) {
                sb.append("closed ");
            }
            sb.append("creationTime=" + this.pooledConnectionHolder.getCreationTimeSec() + ", lastUsageTime=" + this.pooledConnectionHolder.getCreationTimeSec() + ", countUsage=" + this.pooledConnectionHolder.getCountUsage() + ")");
            return sb.toString();
        }

        @Override
        public String getId() {
            return this.id;
        }

        private boolean onConnect() {
            try {
                return ((IConnectHandler)this.handler).onConnect(this);
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Error occured by perform onConnect callback on " + this.handler + " " + ioe.toString());
                }
                return false;
            }
        }

        private boolean onDisconnect() {
            if (!this.disconnectOccured) {
                this.disconnectOccured = true;
                try {
                    return ((IDisconnectHandler)this.handler).onDisconnect(this);
                }
                catch (IOException ioe) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Error occured by perform onDisconnect callback on " + this.handler + " " + ioe.toString());
                    }
                    return false;
                }
            }
            return true;
        }

        private boolean onData() {
            try {
                return ((IDataHandler)this.handler).onData(this);
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Error occured by perform onData callback on " + this.handler + " " + ioe.toString());
                }
                return false;
            }
        }

        private boolean onConnectionTimeout() {
            if (!this.connectionTimeoutOccured) {
                this.connectionTimeoutOccured = true;
                try {
                    return ((IConnectionTimeoutHandler)this.handler).onConnectionTimeout(this);
                }
                catch (IOException ioe) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Error occured by perform onConnectTimeout callback on " + this.handler + " " + ioe.toString());
                    }
                    return false;
                }
            }
            this.setConnectionTimeoutSec(Integer.MAX_VALUE);
            return true;
        }

        private boolean onIdleTimeout() {
            if (!this.idleTimeoutOccured) {
                this.idleTimeoutOccured = true;
                try {
                    return ((IIdleTimeoutHandler)this.handler).onIdleTimeout(this);
                }
                catch (IOException ioe) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Error occured by perform onIdleTimeout callback on " + this.handler + " " + ioe.toString());
                    }
                    return false;
                }
            }
            this.setIdleTimeoutSec(Integer.MAX_VALUE);
            return true;
        }

        @Override
        public Executor getWorkerpool() {
            return this.pooledConnectionHolder.getConnection().getWorkerpool();
        }

        void setReusable(boolean isReusable) {
            this.pooledConnectionHolder.setReusable(isReusable);
        }

        @Override
        public void setAttachment(Object obj) {
            this.pooledConnectionHolder.getConnection().setAttachment(obj);
        }

        @Override
        public Object getAttachment() {
            return this.pooledConnectionHolder.getConnection().getAttachment();
        }

        @Override
        public void setAutoflush(boolean autoflush) {
            this.pooledConnectionHolder.getConnection().setAutoflush(autoflush);
        }

        @Override
        public boolean isAutoflush() {
            return this.pooledConnectionHolder.getConnection().isAutoflush();
        }

        @Override
        public void setEncoding(String defaultEncoding) {
            this.pooledConnectionHolder.getConnection().setEncoding(defaultEncoding);
        }

        @Override
        public String getEncoding() {
            return this.pooledConnectionHolder.getConnection().getEncoding();
        }

        @Override
        public void setFlushmode(IConnection.FlushMode flushMode) {
            this.pooledConnectionHolder.getConnection().setFlushmode(flushMode);
        }

        @Override
        public IConnection.FlushMode getFlushmode() {
            return this.pooledConnectionHolder.getConnection().getFlushmode();
        }

        @Override
        public void setOption(String name, Object value) throws IOException {
            if (!this.isProxyOpen) {
                throw new ClosedException("connection (proxy) " + this.getId() + " is closed");
            }
            this.pooledConnectionHolder.getConnection().setOption(name, value);
        }

        @Override
        public Object getOption(String name) throws IOException {
            return this.pooledConnectionHolder.getConnection().getOption(name);
        }

        @Override
        public Map<String, Class> getOptions() {
            return this.pooledConnectionHolder.getConnection().getOptions();
        }

        @Override
        public void setWriteTransferRate(int bytesPerSecond) throws ClosedException, IOException {
            if (!this.isOpen()) {
                throw new ClosedException("connection (proxy) " + this.getId() + " is closed");
            }
            this.pooledConnectionHolder.getConnection().setWriteTransferRate(bytesPerSecond);
        }

        @Override
        public void setConnectionTimeoutSec(int timeoutSec) {
            if (!this.isProxyOpen) {
                throw new RuntimeException("connection (proxy) " + this.getId() + " is closed");
            }
            this.pooledConnectionHolder.getConnection().setConnectionTimeoutSec(timeoutSec);
            this.connectionTimeoutOccured = false;
        }

        @Override
        public int getConnectionTimeoutSec() {
            return this.pooledConnectionHolder.getConnection().getConnectionTimeoutSec();
        }

        @Override
        public void setIdleTimeoutSec(int timeoutInSec) {
            if (!this.isProxyOpen) {
                throw new RuntimeException("connection (proxy) " + this.getId() + " is closed");
            }
            this.pooledConnectionHolder.getConnection().setIdleTimeoutSec(timeoutInSec);
            this.idleTimeoutOccured = false;
        }

        @Override
        public int getIdleTimeoutSec() {
            return this.pooledConnectionHolder.getConnection().getIdleTimeoutSec();
        }

        @Override
        public int getRemainingSecToConnectionTimeout() {
            return this.pooledConnectionHolder.getConnection().getConnectionTimeoutSec();
        }

        @Override
        public int getRemainingSecToIdleTimeout() {
            return this.pooledConnectionHolder.getConnection().getRemainingSecToIdleTimeout();
        }

        @Override
        public boolean isSecure() {
            return this.pooledConnectionHolder.getConnection().isSecure();
        }

        @Override
        public void activateSecuredMode() throws IOException {
            if (!this.isProxyOpen) {
                throw new ClosedException("connection (proxy) " + this.getId() + " is closed");
            }
            this.pooledConnectionHolder.getConnection().activateSecuredMode();
            this.setReusable(false);
        }

        @Override
        public void suspendRead() throws IOException {
            if (!this.isProxyOpen) {
                throw new ClosedException("connection (proxy) " + this.getId() + " is closed");
            }
            this.pooledConnectionHolder.getConnection().suspendRead();
        }

        @Override
        public void resumeRead() throws IOException {
            if (!this.isProxyOpen) {
                throw new ClosedException("connection (proxy) " + this.getId() + " is closed");
            }
            this.pooledConnectionHolder.getConnection().resumeRead();
        }

        @Override
        public InetAddress getLocalAddress() {
            return this.pooledConnectionHolder.getConnection().getLocalAddress();
        }

        @Override
        public int getLocalPort() {
            return this.pooledConnectionHolder.getConnection().getLocalPort();
        }

        @Override
        public InetAddress getRemoteAddress() {
            return this.pooledConnectionHolder.getConnection().getRemoteAddress();
        }

        @Override
        public int getRemotePort() {
            return this.pooledConnectionHolder.getConnection().getRemotePort();
        }

        @Override
        public int write(byte b) throws IOException, BufferOverflowException {
            if (this.isProxyOpen) {
                return this.pooledConnectionHolder.getConnection().write(b);
            }
            throw new ClosedException("connection (proxy) " + this.getId() + " is closed");
        }

        @Override
        public int write(byte ... bytes) throws IOException, BufferOverflowException {
            if (this.isProxyOpen) {
                return this.pooledConnectionHolder.getConnection().write(bytes);
            }
            throw new ClosedException("connection (proxy) " + this.getId() + " is closed");
        }

        @Override
        public int write(byte[] bytes, int offset, int length) throws IOException, BufferOverflowException {
            if (this.isProxyOpen) {
                return this.pooledConnectionHolder.getConnection().write(bytes, offset, length);
            }
            throw new ClosedException("connection (proxy) " + this.getId() + " is closed");
        }

        @Override
        public int write(ByteBuffer buffer) throws IOException, BufferOverflowException {
            if (this.isProxyOpen) {
                return this.pooledConnectionHolder.getConnection().write(buffer);
            }
            throw new ClosedException("connection (proxy) " + this.getId() + " is closed");
        }

        @Override
        public long write(ByteBuffer[] buffers) throws IOException, BufferOverflowException {
            if (this.isProxyOpen) {
                return this.pooledConnectionHolder.getConnection().write(buffers);
            }
            throw new ClosedException("connection (proxy) " + this.getId() + " is closed");
        }

        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            if (this.isProxyOpen) {
                return this.pooledConnectionHolder.getConnection().write(srcs, offset, length);
            }
            throw new ClosedException("connection (proxy) " + this.getId() + " is closed");
        }

        @Override
        public int write(double d) throws IOException, BufferOverflowException {
            if (this.isProxyOpen) {
                return this.pooledConnectionHolder.getConnection().write(d);
            }
            throw new ClosedException("connection (proxy) " + this.getId() + " is closed");
        }

        @Override
        public int write(int i) throws IOException, BufferOverflowException {
            if (this.isProxyOpen) {
                return this.pooledConnectionHolder.getConnection().write(i);
            }
            throw new ClosedException("connection (proxy) " + this.getId() + " is closed");
        }

        @Override
        public long write(List<ByteBuffer> buffers) throws IOException, BufferOverflowException {
            if (this.isProxyOpen) {
                return this.pooledConnectionHolder.getConnection().write(buffers);
            }
            throw new ClosedException("connection (proxy) " + this.getId() + " is closed");
        }

        @Override
        public int write(long l) throws IOException, BufferOverflowException {
            if (this.isProxyOpen) {
                return this.pooledConnectionHolder.getConnection().write(l);
            }
            throw new ClosedException("connection (proxy) " + this.getId() + " is closed");
        }

        @Override
        public int write(short s) throws IOException, BufferOverflowException {
            if (this.isProxyOpen) {
                return this.pooledConnectionHolder.getConnection().write(s);
            }
            throw new ClosedException("connection (proxy) " + this.getId() + " is closed");
        }

        @Override
        public int write(String message) throws IOException, BufferOverflowException {
            if (this.isProxyOpen) {
                return this.pooledConnectionHolder.getConnection().write(message);
            }
            throw new ClosedException("connection (proxy) " + this.getId() + " is closed");
        }

        @Override
        public int write(String message, String encoding) throws IOException, BufferOverflowException {
            if (this.isProxyOpen) {
                return this.pooledConnectionHolder.getConnection().write(message, encoding);
            }
            throw new ClosedException("connection (proxy) " + this.getId() + " is closed");
        }

        @Override
        public void flush() throws ClosedException, IOException, SocketTimeoutException {
            if (!this.isProxyOpen) {
                throw new ClosedException("connection (proxy) " + this.getId() + " is closed");
            }
            this.pooledConnectionHolder.getConnection().flush();
        }

        @Override
        public long transferFrom(FileChannel source) throws IOException, BufferOverflowException {
            if (this.isProxyOpen) {
                return this.pooledConnectionHolder.getConnection().transferFrom(source);
            }
            throw new ClosedException("connection (proxy) " + this.getId() + " is closed");
        }

        @Override
        public long transferFrom(ReadableByteChannel source) throws IOException, BufferOverflowException {
            if (this.isProxyOpen) {
                return this.pooledConnectionHolder.getConnection().transferFrom(source);
            }
            throw new ClosedException("connection (proxy) " + this.getId() + " is closed");
        }

        @Override
        public long transferFrom(ReadableByteChannel source, int chunkSize) throws IOException, BufferOverflowException {
            if (this.isProxyOpen) {
                return this.pooledConnectionHolder.getConnection().transferFrom(source, chunkSize);
            }
            throw new ClosedException("connection (proxy) " + this.getId() + " is closed");
        }

        @Override
        public int getPendingWriteDataSize() {
            return this.pooledConnectionHolder.getConnection().getPendingWriteDataSize();
        }

        @Override
        public void markWritePosition() {
            if (!this.isProxyOpen) {
                throw new RuntimeException("connection (proxy) " + this.getId() + " is closed");
            }
            this.pooledConnectionHolder.getConnection().markWritePosition();
        }

        @Override
        public void removeWriteMark() {
            if (!this.isProxyOpen) {
                throw new RuntimeException("connection (proxy) " + this.getId() + " is closed");
            }
            this.pooledConnectionHolder.getConnection().removeWriteMark();
        }

        @Override
        public boolean resetToWriteMark() {
            if (this.isProxyOpen) {
                return this.pooledConnectionHolder.getConnection().resetToWriteMark();
            }
            throw new RuntimeException("connection (proxy) " + this.getId() + " is closed");
        }

        @Override
        public void markReadPosition() {
            if (!this.isProxyOpen) {
                throw new RuntimeException("connection (proxy) " + this.getId() + " is closed");
            }
            this.pooledConnectionHolder.getConnection().markReadPosition();
        }

        @Override
        public void removeReadMark() {
            if (!this.isProxyOpen) {
                throw new RuntimeException("connection (proxy) " + this.getId() + " is closed");
            }
            this.pooledConnectionHolder.getConnection().removeReadMark();
        }

        @Override
        public boolean resetToReadMark() {
            if (this.isProxyOpen) {
                return this.pooledConnectionHolder.getConnection().resetToReadMark();
            }
            throw new RuntimeException("connection (proxy) " + this.getId() + " is closed");
        }

        @Override
        public int available() {
            return this.pooledConnectionHolder.getConnection().available();
        }

        @Override
        public int getReadBufferVersion() {
            return this.pooledConnectionHolder.getConnection().getReadBufferVersion();
        }

        @Override
        public int indexOf(String str) throws IOException {
            return this.pooledConnectionHolder.getConnection().indexOf(str);
        }

        @Override
        public int indexOf(String str, String encoding) throws IOException {
            return this.pooledConnectionHolder.getConnection().indexOf(str, encoding);
        }

        @Override
        public int read(ByteBuffer buffer) throws IOException {
            return this.pooledConnectionHolder.getConnection().read(buffer);
        }

        @Override
        public ByteBuffer[] readAvailableByteBuffer() throws IOException {
            return this.pooledConnectionHolder.getConnection().readAvailableByteBuffer();
        }

        @Override
        public byte readByte() throws IOException, BufferUnderflowException {
            return this.pooledConnectionHolder.getConnection().readByte();
        }

        @Override
        public ByteBuffer[] readByteBufferByDelimiter(String delimiter) throws IOException, BufferUnderflowException {
            return this.pooledConnectionHolder.getConnection().readByteBufferByDelimiter(delimiter);
        }

        @Override
        public ByteBuffer[] readByteBufferByDelimiter(String delimiter, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            return this.pooledConnectionHolder.getConnection().readByteBufferByDelimiter(delimiter, maxLength);
        }

        @Override
        public ByteBuffer[] readByteBufferByDelimiter(String delimiter, String encoding) throws IOException, BufferUnderflowException {
            return this.pooledConnectionHolder.getConnection().readByteBufferByDelimiter(delimiter, encoding);
        }

        @Override
        public ByteBuffer[] readByteBufferByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            return this.pooledConnectionHolder.getConnection().readByteBufferByDelimiter(delimiter, encoding, maxLength);
        }

        @Override
        public ByteBuffer[] readByteBufferByLength(int length) throws IOException, BufferUnderflowException {
            return this.pooledConnectionHolder.getConnection().readByteBufferByLength(length);
        }

        @Override
        public byte[] readBytesByDelimiter(String delimiter) throws IOException, BufferUnderflowException {
            return this.pooledConnectionHolder.getConnection().readBytesByDelimiter(delimiter);
        }

        @Override
        public byte[] readBytesByDelimiter(String delimiter, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            return this.pooledConnectionHolder.getConnection().readBytesByDelimiter(delimiter, maxLength);
        }

        @Override
        public byte[] readBytesByDelimiter(String delimiter, String encoding) throws IOException, BufferUnderflowException {
            return this.pooledConnectionHolder.getConnection().readBytesByDelimiter(delimiter, encoding);
        }

        @Override
        public byte[] readBytesByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            return this.pooledConnectionHolder.getConnection().readBytesByDelimiter(delimiter, encoding, maxLength);
        }

        @Override
        public byte[] readBytesByLength(int length) throws IOException, BufferUnderflowException {
            return this.pooledConnectionHolder.getConnection().readBytesByLength(length);
        }

        @Override
        public double readDouble() throws IOException, BufferUnderflowException {
            return this.pooledConnectionHolder.getConnection().readDouble();
        }

        @Override
        public int readInt() throws IOException, BufferUnderflowException {
            return this.pooledConnectionHolder.getConnection().readInt();
        }

        @Override
        public long readLong() throws IOException, BufferUnderflowException {
            return this.pooledConnectionHolder.getConnection().readLong();
        }

        @Override
        public short readShort() throws IOException, BufferUnderflowException {
            return this.pooledConnectionHolder.getConnection().readShort();
        }

        @Override
        public String readStringByDelimiter(String delimiter) throws IOException, BufferUnderflowException, UnsupportedEncodingException {
            return this.pooledConnectionHolder.getConnection().readStringByDelimiter(delimiter);
        }

        @Override
        public String readStringByDelimiter(String delimiter, int maxLength) throws IOException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException {
            return this.pooledConnectionHolder.getConnection().readStringByDelimiter(delimiter, maxLength);
        }

        @Override
        public String readStringByDelimiter(String delimiter, String encoding) throws IOException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException {
            return this.pooledConnectionHolder.getConnection().readStringByDelimiter(delimiter, encoding);
        }

        @Override
        public String readStringByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException {
            return this.pooledConnectionHolder.getConnection().readStringByDelimiter(delimiter, encoding, maxLength);
        }

        @Override
        public String readStringByLength(int length) throws IOException, BufferUnderflowException, UnsupportedEncodingException {
            return this.pooledConnectionHolder.getConnection().readStringByLength(length);
        }

        @Override
        public String readStringByLength(int length, String encoding) throws IOException, BufferUnderflowException, UnsupportedEncodingException {
            return this.pooledConnectionHolder.getConnection().readStringByLength(length, encoding);
        }

        @Override
        public long transferTo(WritableByteChannel target, int length) throws IOException, BufferUnderflowException {
            return this.pooledConnectionHolder.getConnection().transferTo(target, length);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Pool {
        private final HashMap<InetSocketAddress, List<PooledConnectionHolder>> idlePool = new HashMap();
        private final HashSet<PooledConnectionHolder> managedPool = new HashSet();

        private Pool() {
        }

        public synchronized int getSize() {
            return this.managedPool.size();
        }

        public synchronized int getNumIdle() {
            int size = 0;
            for (List<PooledConnectionHolder> pooledResources : this.idlePool.values()) {
                size += pooledResources.size();
            }
            return size;
        }

        public synchronized int getNumActive() {
            return this.getSize() - this.getNumIdle();
        }

        public synchronized List<String> getActiveConnectionInfos() {
            ArrayList<String> result = new ArrayList<String>();
            HashSet managedPoolCopy = (HashSet)this.managedPool.clone();
            managedPoolCopy.removeAll(this.getIdleConnections());
            for (PooledConnectionHolder connectionHolder : managedPoolCopy) {
                result.add(connectionHolder.toString());
            }
            return result;
        }

        public synchronized List<String> getIdleConnectionInfos() {
            ArrayList<String> result = new ArrayList<String>();
            for (PooledConnectionHolder connectionHolder : this.getIdleConnections()) {
                result.add(connectionHolder.toString());
            }
            return result;
        }

        public synchronized Set<PooledConnectionHolder> getManagedConnection() {
            return (Set)this.managedPool.clone();
        }

        public synchronized Set<PooledConnectionHolder> getIdleConnections() {
            HashSet<PooledConnectionHolder> idleResources = new HashSet<PooledConnectionHolder>();
            for (List<PooledConnectionHolder> pooledResources : this.idlePool.values()) {
                for (PooledConnectionHolder pooledResource : pooledResources) {
                    idleResources.add(pooledResource);
                }
            }
            return idleResources;
        }

        public synchronized boolean remove(PooledConnectionHolder pooledResource) {
            boolean isRemoved = false;
            this.managedPool.remove(pooledResource);
            List<PooledConnectionHolder> pooledResources = this.idlePool.get(pooledResource.getAddress());
            if (pooledResources != null) {
                isRemoved = pooledResources.remove(pooledResource);
                if (pooledResources.isEmpty()) {
                    this.idlePool.remove(pooledResource.getAddress());
                }
            }
            return isRemoved;
        }

        public synchronized void register(PooledConnectionHolder pooledResource) {
            this.managedPool.add(pooledResource);
        }

        public synchronized PooledConnectionHolder getIdleConnection(InetSocketAddress address, boolean isSSL) {
            List<PooledConnectionHolder> pooledResources = this.idlePool.get(address);
            if (pooledResources == null) {
                return null;
            }
            PooledConnectionHolder result = null;
            for (PooledConnectionHolder pooledResource : pooledResources) {
                if (pooledResource.isSSL != isSSL) continue;
                result = pooledResource;
                break;
            }
            pooledResources.remove(result);
            if (pooledResources.isEmpty()) {
                this.idlePool.remove(address);
            }
            return result;
        }

        public synchronized PooledConnectionHolder getIdleConnection(PooledConnectionHolder pooledResource) {
            List<PooledConnectionHolder> pooledResources = this.idlePool.get(pooledResource.getAddress());
            if (pooledResources != null) {
                boolean isRemoved = pooledResources.remove(pooledResource);
                if (pooledResources.isEmpty()) {
                    this.idlePool.remove(pooledResource.getAddress());
                }
                if (isRemoved) {
                    return pooledResource;
                }
            }
            return null;
        }

        public synchronized void addIdleConnection(PooledConnectionHolder pooledResource) {
            this.managedPool.add(pooledResource);
            List<PooledConnectionHolder> pooledResources = this.idlePool.get(pooledResource.getAddress());
            if (pooledResources == null) {
                pooledResources = new ArrayList<PooledConnectionHolder>();
                this.idlePool.put(pooledResource.getAddress(), pooledResources);
            }
            pooledResources.add(pooledResource);
        }

        public String toString() {
            return "size=" + this.getSize() + ", active=" + this.getNumActive();
        }
    }

    @Execution(value=Execution.Mode.NONTHREADED)
    private final class PooledConnectionHolder
    implements IInternalHandler {
        private int creationTimeSec = (int)(System.currentTimeMillis() / 1000L);
        private int lastUsageTimeSec = (int)(System.currentTimeMillis() / 1000L);
        private InetSocketAddress address = null;
        private boolean isReusable = true;
        private NonBlockingConnection connection = null;
        private boolean isSSL = false;
        private NonBlockingConnectionProxy proxy = null;
        private int countUsage = 0;

        private PooledConnectionHolder() {
        }

        void init(NonBlockingConnection connection) {
            this.connection = connection;
            if (connection.isSecure()) {
                this.isSSL = true;
            }
            this.address = new InetSocketAddress(connection.getRemoteAddress(), connection.getRemotePort());
            NonBlockingConnectionPool.this.pool.register(this);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("pooled connection created (" + NonBlockingConnectionPool.this.pool.toString() + ", idleTimeoutMillis=" + NonBlockingConnectionPool.this.getPooledIdleTimeoutSec() + ", lifeTimeout=" + NonBlockingConnectionPool.this.getPooledLifeTimeoutSec() + "): " + connection);
            }
        }

        public boolean onConnect(INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            return true;
        }

        public boolean onData(INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            if (this.proxy != null) {
                return this.proxy.onData();
            }
            return true;
        }

        public boolean onDisconnect(INonBlockingConnection connection) throws IOException {
            this.isReusable = false;
            if (this.proxy != null) {
                return this.proxy.onDisconnect();
            }
            return true;
        }

        public boolean onConnectionTimeout(INonBlockingConnection connection) throws IOException {
            this.isReusable = false;
            NonBlockingConnectionPool.this.countTimeoutConnectionLifetime++;
            if (this.proxy != null) {
                return this.proxy.onConnectionTimeout();
            }
            return true;
        }

        public boolean onIdleTimeout(INonBlockingConnection connection) throws IOException {
            this.isReusable = false;
            NonBlockingConnectionPool.this.countTimeoutConnectionIdle++;
            if (this.proxy != null) {
                return this.proxy.onIdleTimeout();
            }
            return true;
        }

        void lease(NonBlockingConnectionProxy proxy) {
            this.proxy = proxy;
            if (proxy != null) {
                proxy.onConnect();
            }
            ++this.countUsage;
        }

        int getCountUsage() {
            return this.countUsage;
        }

        int getCreationTimeSec() {
            return this.creationTimeSec;
        }

        int getLastUsageTimeSec() {
            return this.lastUsageTimeSec;
        }

        void setReusable(boolean isReusable) {
            this.isReusable = isReusable;
        }

        NonBlockingConnection getConnection() {
            return this.connection;
        }

        InetSocketAddress getAddress() {
            return this.address;
        }

        boolean isSecure() {
            return this.isSSL;
        }

        void release() {
            block11: {
                if (this.proxy != null) {
                    this.proxy.onDisconnect();
                    this.proxy = null;
                }
                try {
                    this.lastUsageTimeSec = (int)(System.currentTimeMillis() / 1000L);
                    if (!this.connection.isOpen()) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("do not return pooled connection into to pool, because the connection is closed");
                        }
                        this.destroy();
                        return;
                    }
                    boolean isValid = this.reset();
                    if (!isValid || !this.isReusable) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("do not return pooled connection into to pool, because connection is not valid/reuseable");
                        }
                        this.destroy();
                        return;
                    }
                    if (NonBlockingConnectionPool.this.pool.getNumIdle() < NonBlockingConnectionPool.this.maxIdle) {
                        NonBlockingConnectionPool.this.pool.addIdleConnection(this);
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("connection returned to pool (" + NonBlockingConnectionPool.this.pool.toString() + ", idleTimeoutMillis=" + NonBlockingConnectionPool.this.getPooledIdleTimeoutSec() + ", lifeTimeout=" + NonBlockingConnectionPool.this.getPooledLifeTimeoutSec() + "): " + this.connection);
                        }
                    } else {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("destroy idling connection because max idle size " + NonBlockingConnectionPool.this.maxIdle + " reached: " + this);
                        }
                        this.destroy();
                    }
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block11;
                    LOG.fine("error occured by releasing a pooled connection " + e.toString());
                }
            }
        }

        void destroy() {
            block4: {
                if (this.proxy != null) {
                    this.proxy.onDisconnect();
                    this.proxy = null;
                }
                NonBlockingConnectionPool.this.pool.remove(this);
                try {
                    this.connection.close();
                    NonBlockingConnectionPool.this.countDestroyed++;
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block4;
                    LOG.fine("error occured by closing connection " + this.connection + ": " + e.toString());
                }
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("pooled connection destroyed (" + NonBlockingConnectionPool.this.pool.toString() + ", idleTimeoutMillis=" + NonBlockingConnectionPool.this.getPooledIdleTimeoutSec() + ", lifeTimeout=" + NonBlockingConnectionPool.this.getPooledLifeTimeoutSec() + "): " + this.connection);
            }
        }

        public boolean reset() {
            boolean isValid;
            int currentTimeSec = (int)(System.currentTimeMillis() / 1000L);
            boolean bl = isValid = this.connection.reset() && this.isValid(currentTimeSec);
            if (isValid) {
                return true;
            }
            this.destroy();
            return false;
        }

        boolean isValid(long currentTimeSec) {
            if (!this.connection.isOpen()) {
                return false;
            }
            if (this.connection.getRemainingSecToIdleTimeout() < 3000) {
                return false;
            }
            if (this.connection.getRemainingSecToConnectionTimeout() < 3000) {
                return false;
            }
            if (NonBlockingConnectionPool.this.idleTimeoutSec != Integer.MAX_VALUE && currentTimeSec > (long)(this.lastUsageTimeSec + NonBlockingConnectionPool.this.idleTimeoutSec)) {
                NonBlockingConnectionPool.this.countTimeoutPooledIdle++;
                return false;
            }
            if (NonBlockingConnectionPool.this.lifeTimeoutSec != Integer.MAX_VALUE && currentTimeSec > (long)(this.creationTimeSec + NonBlockingConnectionPool.this.lifeTimeoutSec)) {
                NonBlockingConnectionPool.this.countTimeoutPooledLifetime++;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.connection.getLocalAddress().toString() + ":" + this.connection.getLocalPort() + " -> " + this.connection.getRemoteAddress().toString() + ":" + this.connection.getRemotePort() + " " + "[" + this.connection.getId() + "]");
            sb.append(" countUsage=" + this.getCountUsage() + ", creationTime=" + DATE_FORMAT.format((long)this.getCreationTimeSec() * 1000L) + ", lastUsageTime=" + DATE_FORMAT.format((long)this.getLastUsageTimeSec() * 1000L));
            return sb.toString();
        }
    }
}

