/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.ClosedException;
import org.xsocket.DataConverter;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.connection.ByteBufferUtil;

final class ReadQueue
implements Cloneable {
    private static final Logger LOG = Logger.getLogger(ReadQueue.class.getName());
    private Queue queue = new Queue();
    private ByteBuffer[] readMarkBuffer = null;
    private boolean isReadMarked = false;

    ReadQueue() {
    }

    public void reset() {
        this.readMarkBuffer = null;
        this.isReadMarked = false;
        this.queue.reset();
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public int geVersion() {
        return this.queue.getVersion();
    }

    public void append(ByteBuffer[] bufs) {
        if (bufs != null && bufs.length > 0) {
            this.queue.append(bufs);
        }
    }

    public int retrieveIndexOf(byte[] delimiter, int maxReadSize) throws IOException, MaxReadSizeExceededException {
        return this.queue.retrieveIndexOf(delimiter, maxReadSize);
    }

    public int getSize() {
        return this.queue.getSize();
    }

    public ByteBuffer[] readAvailable() {
        ByteBuffer[] buffers = this.queue.drain();
        this.onExtracted(buffers);
        buffers = ReadQueue.removeEmptyBuffers(buffers);
        return buffers;
    }

    public ByteBuffer[] readByteBufferByDelimiter(byte[] delimiter, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        ByteBuffer[] buffers = this.queue.readByteBufferByDelimiter(delimiter, maxLength);
        this.onExtracted(buffers, delimiter);
        return buffers;
    }

    public ByteBuffer[] readByteBufferByLength(int length) throws BufferUnderflowException {
        ByteBuffer[] buffers = this.queue.readByteBufferByLength(length);
        this.onExtracted(buffers);
        return buffers;
    }

    public ByteBuffer readSingleByteBuffer(int length) throws BufferUnderflowException {
        if (this.getSize() < length) {
            throw new BufferUnderflowException();
        }
        ByteBuffer buffer = this.queue.readSingleByteBuffer(length);
        this.onExtracted(buffer);
        return buffer;
    }

    private static ByteBuffer[] removeEmptyBuffers(ByteBuffer[] buffers) {
        if (buffers == null) {
            return buffers;
        }
        int countEmptyBuffers = 0;
        for (int i = 0; i < buffers.length; ++i) {
            if (buffers[i] != null) continue;
            ++countEmptyBuffers;
        }
        if (countEmptyBuffers > 0) {
            if (countEmptyBuffers == buffers.length) {
                return new ByteBuffer[0];
            }
            ByteBuffer[] newBuffers = new ByteBuffer[buffers.length - countEmptyBuffers];
            int num = 0;
            for (int i = 0; i < buffers.length; ++i) {
                if (buffers[i] == null) continue;
                newBuffers[num] = buffers[i];
                ++num;
            }
            return newBuffers;
        }
        return buffers;
    }

    public long transferTo(WritableByteChannel target) throws ClosedException, IOException, SocketTimeoutException {
        long written = 0L;
        ByteBuffer[] buffers = this.readAvailable();
        this.onExtracted(buffers);
        for (ByteBuffer buffer : buffers = ReadQueue.removeEmptyBuffers(buffers)) {
            written += (long)target.write(buffer);
        }
        return written;
    }

    public long transferTo(WritableByteChannel target, int maxLength) throws ClosedException, IOException, SocketTimeoutException {
        long written = 0L;
        int length = maxLength;
        int available = this.getSize();
        if (available < length) {
            length = available;
        }
        ByteBuffer[] buffers = this.queue.readByteBufferByLength(length);
        this.onExtracted(buffers);
        for (ByteBuffer buffer : buffers = ReadQueue.removeEmptyBuffers(buffers)) {
            written += (long)target.write(buffer);
        }
        return written;
    }

    public final void markReadPosition() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("mark read position");
        }
        this.removeReadMark();
        this.isReadMarked = true;
    }

    public final boolean resetToReadMark() {
        if (this.isReadMarked) {
            if (this.readMarkBuffer != null) {
                this.queue.addFirst(this.readMarkBuffer);
                this.removeReadMark();
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("reset read mark. notihng to return to read queue");
            }
            return true;
        }
        return false;
    }

    public final void removeReadMark() {
        this.isReadMarked = false;
        this.readMarkBuffer = null;
    }

    private void onExtracted(ByteBuffer[] buffers) {
        if (this.isReadMarked) {
            for (ByteBuffer buffer : buffers) {
                this.onExtracted(buffer);
            }
        }
    }

    private void onExtracted(ByteBuffer[] buffers, byte[] delimiter) {
        if (this.isReadMarked) {
            if (buffers != null) {
                for (ByteBuffer buffer : buffers) {
                    this.onExtracted(buffer);
                }
            }
            this.onExtracted(ByteBuffer.wrap(delimiter));
        }
    }

    private void onExtracted(ByteBuffer buffer) {
        if (this.isReadMarked) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("add data (" + DataConverter.toFormatedBytesSize(buffer.remaining()) + ") to read mark buffer ");
            }
            if (this.readMarkBuffer == null) {
                this.readMarkBuffer = new ByteBuffer[1];
                this.readMarkBuffer[0] = buffer.duplicate();
            } else {
                ByteBuffer[] newReadMarkBuffer = new ByteBuffer[this.readMarkBuffer.length + 1];
                System.arraycopy(this.readMarkBuffer, 0, newReadMarkBuffer, 0, this.readMarkBuffer.length);
                newReadMarkBuffer[this.readMarkBuffer.length] = buffer.duplicate();
                this.readMarkBuffer = newReadMarkBuffer;
            }
        }
    }

    public String toString() {
        return this.queue.toString();
    }

    public String asString(String encoding) {
        return this.queue.asString(encoding);
    }

    protected Object clone() throws CloneNotSupportedException {
        ReadQueue copy = (ReadQueue)super.clone();
        copy.queue = (Queue)this.queue.clone();
        if (this.readMarkBuffer != null) {
            copy.readMarkBuffer = new ByteBuffer[this.readMarkBuffer.length];
            for (int i = 0; i < this.readMarkBuffer.length; ++i) {
                copy.readMarkBuffer[i] = this.readMarkBuffer[i].duplicate();
            }
        }
        return copy;
    }

    private static final class Queue
    implements Cloneable {
        private static final int THRESHOLD_COMPACT_BUFFER_COUNT_TOTAL = 20;
        private static final int THRESHOLD_COMPACT_BUFFER_COUNT_EMPTY = 10;
        private static final ByteBufferUtil BYTEBUFFER_UTIL = new ByteBufferUtil();
        private ByteBuffer[] buffers = null;
        private Integer currentSize = null;
        private int version = 0;
        private ByteBufferUtil.Index cachedIndex = null;

        private Queue() {
        }

        public synchronized void reset() {
            this.buffers = null;
            this.currentSize = null;
            this.cachedIndex = null;
        }

        public synchronized int getVersion() {
            return this.version;
        }

        public synchronized boolean isEmpty() {
            if (this.buffers == null) {
                return true;
            }
            return this.getSize() == 0;
        }

        public synchronized int getSize() {
            if (this.currentSize != null) {
                return this.currentSize;
            }
            if (this.buffers == null) {
                return 0;
            }
            int size = 0;
            for (int i = 0; i < this.buffers.length; ++i) {
                if (this.buffers[i] == null) continue;
                size += this.buffers[i].remaining();
            }
            this.currentSize = size;
            return size;
        }

        public synchronized void append(ByteBuffer[] bufs) {
            ++this.version;
            this.currentSize = null;
            if (this.buffers == null) {
                this.buffers = bufs;
            } else {
                ByteBuffer[] newBuffers = new ByteBuffer[this.buffers.length + bufs.length];
                System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
                System.arraycopy(bufs, 0, newBuffers, this.buffers.length, bufs.length);
                this.buffers = newBuffers;
            }
        }

        public synchronized void addFirst(ByteBuffer[] bufs) {
            ++this.version;
            this.currentSize = null;
            this.cachedIndex = null;
            this.addFirstSilence(bufs);
        }

        private void addFirstSilence(ByteBuffer[] bufs) {
            this.currentSize = null;
            if (this.buffers == null) {
                this.buffers = bufs;
            } else {
                ByteBuffer[] newBuffers = new ByteBuffer[this.buffers.length + bufs.length];
                System.arraycopy(bufs, 0, newBuffers, 0, bufs.length);
                System.arraycopy(this.buffers, 0, newBuffers, bufs.length, this.buffers.length);
                this.buffers = newBuffers;
            }
        }

        public synchronized ByteBuffer[] drain() {
            this.currentSize = null;
            this.cachedIndex = null;
            ByteBuffer[] result = this.buffers;
            this.buffers = null;
            ++this.version;
            return result;
        }

        public synchronized ByteBuffer readSingleByteBuffer(int length) throws BufferUnderflowException {
            if (this.buffers == null) {
                throw new BufferUnderflowException();
            }
            if (!this.isSizeEqualsOrLargerThan(length)) {
                throw new BufferUnderflowException();
            }
            if (length == 0) {
                return ByteBuffer.allocate(0);
            }
            ByteBuffer result = null;
            int countEmptyBuffer = 0;
            block0: for (int i = 0; i < this.buffers.length; ++i) {
                if (this.buffers[i] == null) {
                    ++countEmptyBuffer;
                    continue;
                }
                if (this.buffers[i].remaining() == length) {
                    result = this.buffers[i];
                    this.buffers[i] = null;
                    break;
                }
                if (this.buffers[i].remaining() > length) {
                    int savedLimit = this.buffers[i].limit();
                    int savedPos = this.buffers[i].position();
                    this.buffers[i].limit(this.buffers[i].position() + length);
                    result = this.buffers[i].slice();
                    this.buffers[i].position(savedPos + length);
                    this.buffers[i].limit(savedLimit);
                    this.buffers[i] = this.buffers[i].slice();
                    break;
                }
                result = ByteBuffer.allocate(length);
                int written = 0;
                for (int j = i; j < this.buffers.length; ++j) {
                    if (this.buffers[j] == null) {
                        ++countEmptyBuffer;
                        continue;
                    }
                    while (this.buffers[j].hasRemaining()) {
                        result.put(this.buffers[j].get());
                        if (++written != length) continue;
                        this.buffers[j] = this.buffers[j].position() < this.buffers[j].limit() ? this.buffers[j].slice() : null;
                        result.clear();
                        break block0;
                    }
                    this.buffers[j] = null;
                }
            }
            if (result == null) {
                throw new BufferUnderflowException();
            }
            if (countEmptyBuffer >= 10) {
                this.compact();
            }
            this.currentSize = null;
            this.cachedIndex = null;
            ++this.version;
            return result;
        }

        public ByteBuffer[] readByteBufferByLength(int length) throws BufferUnderflowException {
            if (length == 0) {
                return new ByteBuffer[0];
            }
            return this.extract(length, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ByteBuffer[] readByteBufferByDelimiter(byte[] delimiter, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            Queue queue = this;
            synchronized (queue) {
                if (this.buffers == null) {
                    throw new BufferUnderflowException();
                }
            }
            int index = this.retrieveIndexOf(delimiter, maxLength);
            if (index >= 0) {
                return this.extract(index, delimiter.length);
            }
            throw new BufferUnderflowException();
        }

        private synchronized ByteBuffer[] extract(int length, int countTailingBytesToRemove) throws BufferUnderflowException {
            ByteBuffer[] extracted = null;
            if (this.buffers == null || this.getSize() < length) {
                throw new BufferUnderflowException();
            }
            if (length > 0) {
                extracted = BYTEBUFFER_UTIL.extract(this.buffers, length);
            }
            if (countTailingBytesToRemove > 0) {
                BYTEBUFFER_UTIL.extract(this.buffers, countTailingBytesToRemove);
            }
            this.compact();
            this.currentSize = null;
            this.cachedIndex = null;
            ++this.version;
            return extracted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int retrieveIndexOf(byte[] delimiter, int maxReadSize) throws IOException, MaxReadSizeExceededException {
            ByteBuffer[] bufs = null;
            Queue queue = this;
            synchronized (queue) {
                if (this.buffers == null) {
                    return -1;
                }
                bufs = this.buffers;
                this.buffers = null;
            }
            int index = this.retrieveIndexOf(delimiter, bufs, maxReadSize);
            Queue queue2 = this;
            synchronized (queue2) {
                this.addFirstSilence(bufs);
            }
            if (index == -2) {
                throw new MaxReadSizeExceededException();
            }
            return index;
        }

        private int retrieveIndexOf(byte[] delimiter, ByteBuffer[] buffers, int maxReadSize) {
            Integer length = null;
            if (buffers == null) {
                return -1;
            }
            ByteBufferUtil.Index index = this.scanByDelimiter(buffers, delimiter);
            length = index.hasDelimiterFound() ? (index.getReadBytes() <= maxReadSize ? Integer.valueOf(index.getReadBytes() - delimiter.length) : null) : null;
            this.cachedIndex = index;
            if (length == null) {
                if (index.getReadBytes() >= maxReadSize) {
                    return -2;
                }
                return -1;
            }
            return length;
        }

        private ByteBufferUtil.Index scanByDelimiter(ByteBuffer[] buffers, byte[] delimiter) {
            if (this.cachedIndex != null && this.cachedIndex.isDelimiterEquals(delimiter)) {
                if (this.cachedIndex.hasDelimiterFound()) {
                    return this.cachedIndex;
                }
                return BYTEBUFFER_UTIL.find(buffers, this.cachedIndex);
            }
            return BYTEBUFFER_UTIL.find(buffers, delimiter);
        }

        private boolean isSizeEqualsOrLargerThan(int requiredSize) {
            if (this.buffers == null) {
                return false;
            }
            int bufferSize = 0;
            for (int i = 0; i < this.buffers.length; ++i) {
                if (this.buffers[i] == null || (bufferSize += this.buffers[i].remaining()) < requiredSize) continue;
                return true;
            }
            return false;
        }

        private void compact() {
            if (this.buffers != null && this.buffers.length > 20) {
                int emptyBuffers = 0;
                for (int i = 0; i < this.buffers.length; ++i) {
                    if (this.buffers[i] != null) continue;
                    ++emptyBuffers;
                }
                if (emptyBuffers > 10) {
                    if (emptyBuffers == this.buffers.length) {
                        this.buffers = null;
                    } else {
                        ByteBuffer[] newByteBuffer = new ByteBuffer[this.buffers.length - emptyBuffers];
                        int num = 0;
                        for (int i = 0; i < this.buffers.length; ++i) {
                            if (this.buffers[i] == null) continue;
                            newByteBuffer[num] = this.buffers[i];
                            ++num;
                        }
                        this.buffers = newByteBuffer;
                    }
                }
            }
        }

        protected synchronized Object clone() throws CloneNotSupportedException {
            Queue copy = (Queue)super.clone();
            if (this.buffers != null) {
                ByteBuffer[] bufs = new ByteBuffer[this.buffers.length];
                for (int i = 0; i < this.buffers.length; ++i) {
                    copy.buffers[i] = this.buffers[i].duplicate();
                }
                copy.buffers = bufs;
            }
            copy.version = this.version;
            if (this.cachedIndex != null) {
                copy.cachedIndex = (ByteBufferUtil.Index)this.cachedIndex.clone();
            }
            return copy;
        }

        public String toString() {
            try {
                ByteBuffer[] copy = (ByteBuffer[])this.buffers.clone();
                for (int i = 0; i < copy.length; ++i) {
                    if (copy[i] == null) continue;
                    copy[i] = copy[i].duplicate();
                }
                return DataConverter.toTextAndHexString(copy, "UTF-8", 300);
            }
            catch (NullPointerException npe) {
                return "";
            }
            catch (Exception e) {
                return e.toString();
            }
        }

        synchronized String asString(String encoding) {
            try {
                ByteBuffer[] copy = (ByteBuffer[])this.buffers.clone();
                for (int i = 0; i < copy.length; ++i) {
                    if (copy[i] == null) continue;
                    copy[i] = copy[i].duplicate();
                }
                return DataConverter.toString(copy, encoding);
            }
            catch (NullPointerException npe) {
                return "";
            }
            catch (Exception e) {
                return e.toString();
            }
        }
    }
}

