/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection.spi;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xsocket.IDispatcher;
import org.xsocket.connection.spi.DefaultIoProvider;
import org.xsocket.connection.spi.IAcceptor;
import org.xsocket.connection.spi.IAcceptorCallback;
import org.xsocket.connection.spi.IAcceptorListener;
import org.xsocket.connection.spi.IIoHandler;
import org.xsocket.connection.spi.IoSocketDispatcher;
import org.xsocket.connection.spi.IoSocketHandler;
import org.xsocket.connection.spi.UnsynchronizedMemoryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Acceptor
implements IAcceptor {
    private static final Logger LOG = Logger.getLogger(Acceptor.class.getName());
    private static final Map<String, Class> SUPPORTED_OPTIONS = new HashMap<String, Class>();
    private static final DefaultIoProvider IO_PROVIDER;
    private IAcceptorCallback callback = null;
    private volatile boolean isRunning = true;
    private ServerSocketChannel serverChannel = null;
    private boolean sslOn = false;
    private SSLContext sslContext = null;
    private int preallocationSize = 65536;
    private int bufferMinsize = 64;
    private boolean preallocation = true;
    private boolean useDirect = false;
    private final LinkedList<IoSocketDispatcher> dispatchers = new LinkedList();
    private int size = 0;
    private int pointer = 0;
    private final ArrayList<IAcceptorListener> listeners = new ArrayList();
    private long acceptedConnections = 0L;
    private long lastRequestAccpetedRate = System.currentTimeMillis();

    public Acceptor(IAcceptorCallback callback, InetSocketAddress address, int backlog) throws IOException {
        this(callback, address, backlog, null, false);
    }

    public Acceptor(IAcceptorCallback callback, InetSocketAddress address, int backlog, SSLContext sslContext, boolean sslOn) throws IOException {
        this.callback = callback;
        this.sslContext = sslContext;
        this.sslOn = sslOn;
        LOG.fine("try to bind server on " + address);
        this.serverChannel = ServerSocketChannel.open();
        this.serverChannel.configureBlocking(true);
        this.serverChannel.socket().setSoTimeout(0);
        this.serverChannel.socket().setReuseAddress(true);
        try {
            this.setDispatcherSize(Runtime.getRuntime().availableProcessors() + 1);
            assert (this.serverChannel != null);
            this.serverChannel.socket().bind(address, backlog);
        }
        catch (BindException be) {
            if (this.serverChannel != null) {
                this.serverChannel.close();
            }
            LOG.info("error occured while binding server on on " + address + ". Reason: " + be.toString());
            throw be;
        }
    }

    void addListener(IAcceptorListener listener) {
        this.listeners.add(listener);
    }

    boolean removeListener(IAcceptorListener listener) {
        return this.listeners.remove(listener);
    }

    void setOption(String name, Object value) throws IOException {
        if (name.equals("SOL_SOCKET.SO_RCVBUF")) {
            this.serverChannel.socket().setReceiveBufferSize((Integer)value);
        } else if (name.equals("SOL_SOCKET.SO_REUSEADDR")) {
            this.serverChannel.socket().setReuseAddress((Boolean)value);
        } else {
            LOG.warning("option " + name + " is not supproted for " + this.getClass().getName());
        }
    }

    @Override
    public Object getOption(String name) throws IOException {
        if (name.equals("SOL_SOCKET.SO_RCVBUF")) {
            return this.serverChannel.socket().getReceiveBufferSize();
        }
        if (name.equals("SOL_SOCKET.SO_REUSEADDR")) {
            return this.serverChannel.socket().getReuseAddress();
        }
        LOG.warning("option " + name + " is not supproted for " + this.getClass().getName());
        return null;
    }

    @Override
    public Map<String, Class> getOptions() {
        return Collections.unmodifiableMap(SUPPORTED_OPTIONS);
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.serverChannel.socket().getInetAddress();
    }

    @Override
    public int getLocalPort() {
        return this.serverChannel.socket().getLocalPort();
    }

    @Override
    public void listen() throws IOException {
        this.callback.onConnected();
        this.accept();
    }

    private void accept() {
        while (this.isRunning) {
            try {
                SocketChannel channel = this.serverChannel.accept();
                IoSocketDispatcher dispatcher = this.nextDispatcher();
                IIoHandler ioHandler = IO_PROVIDER.createIoHandler(false, dispatcher, channel, this.sslContext, this.sslOn);
                this.callback.onConnectionAccepted(ioHandler);
                ++this.acceptedConnections;
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE) || !this.serverChannel.isOpen()) continue;
                LOG.fine("error occured while accepting connection: " + e.toString());
            }
        }
    }

    private IoSocketDispatcher nextDispatcher() {
        IoSocketDispatcher result = null;
        try {
            ++this.pointer;
            if (this.pointer >= this.size) {
                this.pointer = 0;
            }
            result = this.dispatchers.get(this.pointer);
        }
        catch (Exception concurrentException) {
            result = this.nextDispatcher();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDispatcher() {
        if (this.isRunning) {
            LinkedList<IoSocketDispatcher> linkedList = this.dispatchers;
            synchronized (linkedList) {
                int currentRunning = this.dispatchers.size();
                if (currentRunning != this.size) {
                    int i;
                    if (currentRunning > this.size) {
                        for (i = this.size; i < currentRunning; ++i) {
                            IDispatcher dispatcher;
                            block15: {
                                dispatcher = this.dispatchers.getLast();
                                this.dispatchers.remove(dispatcher);
                                try {
                                    dispatcher.close();
                                }
                                catch (IOException ioe) {
                                    if (!LOG.isLoggable(Level.FINE)) break block15;
                                    LOG.fine("error occured by closing the dispatcher " + dispatcher + ". reason " + ioe.toString());
                                }
                            }
                            for (IAcceptorListener listener : this.listeners) {
                                listener.onDispatcherRemoved(dispatcher);
                            }
                        }
                    } else if (currentRunning < this.size) {
                        for (i = currentRunning; i < this.size; ++i) {
                            UnsynchronizedMemoryManager memoryManager = null;
                            memoryManager = this.preallocation ? UnsynchronizedMemoryManager.createPreallocatedMemoryManager(this.preallocationSize, this.bufferMinsize, this.useDirect) : UnsynchronizedMemoryManager.createNonPreallocatedMemoryManager(this.useDirect);
                            IoSocketDispatcher dispatcher = new IoSocketDispatcher(memoryManager);
                            this.dispatchers.addLast(dispatcher);
                            Thread t = new Thread(dispatcher);
                            t.setDaemon(false);
                            t.setName("xDispatcher#" + i);
                            t.start();
                            for (IAcceptorListener listener : this.listeners) {
                                listener.onDispatcherAdded(dispatcher);
                            }
                        }
                    }
                }
                IDispatcher[] connectionDispatchers = new IDispatcher[this.dispatchers.size()];
                for (int i = 0; i < connectionDispatchers.length; ++i) {
                    connectionDispatchers[i] = this.dispatchers.get(i);
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.isRunning) {
            this.isRunning = false;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("closing acceptor");
            }
            try {
                this.serverChannel.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.shutdownDispatcher();
            this.callback.onDisconnected();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownDispatcher() {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.fine("terminate dispatchers");
        }
        LinkedList<IoSocketDispatcher> linkedList = this.dispatchers;
        synchronized (linkedList) {
            for (IoSocketDispatcher dispatcher : this.dispatchers) {
                try {
                    dispatcher.close();
                    for (IAcceptorListener listener : this.listeners) {
                        listener.onDispatcherRemoved(dispatcher);
                    }
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("error occured by closing the dispatcher " + dispatcher + ". reason " + ioe.toString());
                }
            }
        }
        this.dispatchers.clear();
    }

    @Override
    public int getNumberOfOpenConnections() {
        return this.getOpenConntionInfos().size();
    }

    public List<String> getOpenConntionInfos() {
        ArrayList<String> result = new ArrayList<String>();
        for (IDispatcher<IoSocketHandler> dispatcher : this.getDispatchers()) {
            for (IoSocketHandler handler : dispatcher.getRegistered()) {
                result.add(handler.toString());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<IDispatcher<IoSocketHandler>> getDispatchers() {
        List result = null;
        LinkedList<IoSocketDispatcher> linkedList = this.dispatchers;
        synchronized (linkedList) {
            result = (List)this.dispatchers.clone();
        }
        return result;
    }

    void setDispatcherSize(int size) {
        this.size = size;
        this.updateDispatcher();
    }

    int getDispatcherSize() {
        return this.size;
    }

    boolean getReceiveBufferIsDirect() {
        return this.useDirect;
    }

    void setReceiveBufferIsDirect(boolean isDirect) {
        this.useDirect = isDirect;
        for (IoSocketDispatcher dispatcher : this.dispatchers) {
            dispatcher.setReceiveBufferIsDirect(isDirect);
        }
    }

    boolean isReceiveBufferPreallocationMode() {
        return this.preallocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setReceiveBufferPreallocationMode(boolean mode) {
        this.preallocation = mode;
        LinkedList<IoSocketDispatcher> linkedList = this.dispatchers;
        synchronized (linkedList) {
            for (IoSocketDispatcher dispatcher : this.dispatchers) {
                dispatcher.setReceiveBufferPreallocationMode(mode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setReceiveBufferPreallocatedMinSize(Integer minSize) {
        this.bufferMinsize = minSize;
        LinkedList<IoSocketDispatcher> linkedList = this.dispatchers;
        synchronized (linkedList) {
            for (IoSocketDispatcher dispatcher : this.dispatchers) {
                dispatcher.setReceiveBufferPreallocatedMinSize(minSize);
            }
        }
    }

    Integer getReceiveBufferPreallocatedMinSize() {
        return this.bufferMinsize;
    }

    Integer getReceiveBufferPreallocationSize() {
        return this.preallocationSize;
    }

    void setReceiveBufferPreallocationSize(int size) {
        this.preallocationSize = size;
        for (IoSocketDispatcher dispatcher : this.dispatchers) {
            dispatcher.setReceiveBufferPreallocatedSize(size);
        }
    }

    double getAcceptedRateCountPerSec() {
        double rate = 0.0;
        long elapsed = System.currentTimeMillis() - this.lastRequestAccpetedRate;
        rate = this.acceptedConnections == 0L ? 0.0 : (elapsed == 0L ? 2.147483647E9 : (double)(this.acceptedConnections * 1000L) / (double)elapsed);
        this.lastRequestAccpetedRate = System.currentTimeMillis();
        this.acceptedConnections = 0L;
        return rate;
    }

    long getSendRateBytesPerSec() {
        long rate = 0L;
        for (IoSocketDispatcher dispatcher : this.dispatchers) {
            rate += dispatcher.getSendRateBytesPerSec();
        }
        return rate;
    }

    long getReceiveRateBytesPerSec() {
        long rate = 0L;
        for (IoSocketDispatcher dispatcher : this.dispatchers) {
            rate += dispatcher.getReceiveRateBytesPerSec();
        }
        return rate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getNumberOfConnectionTimeouts() {
        long timeouts = 0L;
        LinkedList copy = null;
        LinkedList<IoSocketDispatcher> linkedList = this.dispatchers;
        synchronized (linkedList) {
            copy = (LinkedList)this.dispatchers.clone();
        }
        for (IoSocketDispatcher dispatcher : copy) {
            timeouts += dispatcher.getCountConnectionTimeout();
        }
        return timeouts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNumberOfIdleTimeouts() {
        long timeouts = 0L;
        LinkedList copy = null;
        LinkedList<IoSocketDispatcher> linkedList = this.dispatchers;
        synchronized (linkedList) {
            copy = (LinkedList)this.dispatchers.clone();
        }
        for (IoSocketDispatcher dispatcher : copy) {
            timeouts += dispatcher.getCountIdleTimeout();
        }
        return timeouts;
    }

    static {
        SUPPORTED_OPTIONS.put("SOL_SOCKET.SO_RCVBUF", Integer.class);
        SUPPORTED_OPTIONS.put("SOL_SOCKET.SO_REUSEADDR", Boolean.class);
        IO_PROVIDER = new DefaultIoProvider();
    }
}

