/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection.spi;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.rmi.server.UID;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.ObjectName;
import javax.net.ssl.SSLContext;
import org.xsocket.DataConverter;
import org.xsocket.Dispatcher;
import org.xsocket.IDispatcher;
import org.xsocket.IntrospectionBasedDynamicMBean;
import org.xsocket.connection.IServerListener;
import org.xsocket.connection.Server;
import org.xsocket.connection.spi.Acceptor;
import org.xsocket.connection.spi.ChainableIoHandler;
import org.xsocket.connection.spi.IAcceptor;
import org.xsocket.connection.spi.IAcceptorCallback;
import org.xsocket.connection.spi.IAcceptorListener;
import org.xsocket.connection.spi.IClientIoProvider;
import org.xsocket.connection.spi.IIoHandler;
import org.xsocket.connection.spi.IMemoryManager;
import org.xsocket.connection.spi.IServerIoProvider;
import org.xsocket.connection.spi.IoActivateableSSLHandler;
import org.xsocket.connection.spi.IoSSLHandler;
import org.xsocket.connection.spi.IoSocketDispatcher;
import org.xsocket.connection.spi.IoSocketHandler;
import org.xsocket.connection.spi.IoThrottledWriteHandler;
import org.xsocket.connection.spi.SynchronizedMemoryManager;
import org.xsocket.connection.spi.UnsynchronizedMemoryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultIoProvider
implements IClientIoProvider,
IServerIoProvider {
    private static final Logger LOG = Logger.getLogger(DefaultIoProvider.class.getName());
    private static final Timer TIMER = new Timer("xIoTimer", true);
    private static IoSocketDispatcher globalDispatcher = null;
    public static final String DEFAULT_USE_DIRECT_BUFFER = "true";
    public static final String CLIENT_READBUFFER_USE_DIRECT_KEY = "org.xsocket.connection.client.readbuffer.usedirect";
    public static final String SERVER_READBUFFER_USE_DIRECT_KEY = "org.xsocket.connection.server.readbuffer.usedirect";
    public static final String DEFAULT_READ_BUFFER_PREALLOCATION_ON = "true";
    public static final int DEFAULT_READ_BUFFER_PREALLOCATION_SIZE = 65536;
    public static final int DEFAULT_READ_BUFFER_MIN_SIZE = 64;
    public static final String CLIENT_READBUFFER_PREALLOCATION_ON_KEY = "org.xsocket.connection.client.readbuffer.preallocation.on";
    public static final String CLIENT_READBUFFER_PREALLOCATION_SIZE_KEY = "org.xsocket.connection.client.readbuffer.preallocation.size";
    public static final String CLIENT_READBUFFER_PREALLOCATION_MIN_SIZE_KEY = "org.xsocket.connection.client.readbuffer.preallocation.minSize";
    public static final String SERVER_READBUFFER_PREALLOCATION_ON_KEY = "org.xsocket.connection.server.readbuffer.preallocation.on";
    public static final String SERVER_READBUFFER_PREALLOCATION_SIZE_KEY = "org.xsocket.connection.server.readbuffer.preallocation.size";
    public static final String SERVER_READBUFFER_PREALLOCATION_MIN_SIZE_KEY = "org.xsocket.connection.server.readbuffer.preallocation.minSize";
    private static Boolean clientReadBufferUseDirect = null;
    private static Boolean serverReadBufferUseDirect = null;
    private static Boolean clientReadBufferPreallocationOn = null;
    private static int clientReadBufferPreallocationsize = 65536;
    private static int clientReadBufferMinsize = 64;
    private static Boolean serverReadBufferPreallocationOn = null;
    private static int serverReadBufferPreallocationsize = 65536;
    private static int serverReadBufferMinsize = 64;
    private static String idPrefix = null;
    private IMemoryManager sslMemoryManagerServer = null;
    private IMemoryManager sslMemoryManagerClient = null;
    private final AtomicInteger nextId = new AtomicInteger();

    public DefaultIoProvider() {
        this.sslMemoryManagerServer = serverReadBufferPreallocationOn != false ? SynchronizedMemoryManager.createPreallocatedMemoryManager(serverReadBufferPreallocationsize, serverReadBufferMinsize, serverReadBufferUseDirect) : SynchronizedMemoryManager.createNonPreallocatedMemoryManager(serverReadBufferUseDirect);
        this.sslMemoryManagerClient = clientReadBufferPreallocationOn != false ? SynchronizedMemoryManager.createPreallocatedMemoryManager(clientReadBufferPreallocationsize, clientReadBufferMinsize, clientReadBufferUseDirect) : SynchronizedMemoryManager.createNonPreallocatedMemoryManager(clientReadBufferUseDirect);
    }

    public static boolean isDispatcherThread() {
        return IoSocketDispatcher.isDispatcherThread();
    }

    @Override
    public String getImplementationVersion() {
        return "";
    }

    @Override
    public IAcceptor createAcceptor(IAcceptorCallback callback, InetSocketAddress address, int backlog, Map<String, Object> options) throws IOException {
        Acceptor acceptor = new Acceptor(callback, address, backlog);
        for (Map.Entry<String, Object> entry : options.entrySet()) {
            acceptor.setOption(entry.getKey(), entry.getValue());
        }
        return acceptor;
    }

    public IAcceptor create(IAcceptorCallback callback, InetSocketAddress address, int backlog, Map<String, Object> options, SSLContext sslContext, boolean sslOn) throws IOException {
        Acceptor acceptor = new Acceptor(callback, address, backlog, sslContext, sslOn);
        for (Map.Entry<String, Object> entry : options.entrySet()) {
            acceptor.setOption(entry.getKey(), entry.getValue());
        }
        return acceptor;
    }

    @Override
    public IIoHandler createClientIoHandler(InetSocketAddress remoteAddress, int connectTimeoutMillis, Map<String, Object> options) throws IOException {
        return this.createIoHandler(true, DefaultIoProvider.getClientDispatcher(), DefaultIoProvider.openSocket(remoteAddress, options, connectTimeoutMillis), null, false);
    }

    public IIoHandler createSSLClientIoHandler(InetSocketAddress remoteAddress, int connectTimeoutMillis, Map<String, Object> options, SSLContext sslContext, boolean sslOn) throws IOException {
        return this.createIoHandler(true, DefaultIoProvider.getClientDispatcher(), DefaultIoProvider.openSocket(remoteAddress, options, connectTimeoutMillis), sslContext, sslOn);
    }

    IIoHandler createIoHandler(boolean isClient, IoSocketDispatcher dispatcher, SocketChannel channel, SSLContext sslContext, boolean sslOn) throws IOException {
        String connectionId = null;
        connectionId = isClient ? idPrefix + ".c." + this.nextId.incrementAndGet() : idPrefix + ".s." + this.nextId.incrementAndGet();
        ChainableIoHandler ioHandler = new IoSocketHandler(channel, dispatcher, connectionId);
        if (sslContext != null) {
            IMemoryManager mm = null;
            mm = isClient ? this.sslMemoryManagerClient : this.sslMemoryManagerServer;
            ioHandler = sslOn ? new IoSSLHandler(ioHandler, sslContext, isClient, mm) : new IoActivateableSSLHandler(ioHandler, sslContext, isClient, mm);
        }
        return ioHandler;
    }

    @Override
    public IIoHandler setWriteTransferRate(IIoHandler ioHandler, int bytesPerSecond) throws IOException {
        if (bytesPerSecond == Integer.MAX_VALUE) {
            IoThrottledWriteHandler delayWriter = (IoThrottledWriteHandler)this.getHandler((ChainableIoHandler)ioHandler, IoThrottledWriteHandler.class);
            if (delayWriter != null) {
                delayWriter.flushOutgoing();
                ChainableIoHandler successor = delayWriter.getSuccessor();
                return successor;
            }
            return ioHandler;
        }
        IoThrottledWriteHandler delayWriter = (IoThrottledWriteHandler)this.getHandler((ChainableIoHandler)ioHandler, IoThrottledWriteHandler.class);
        if (delayWriter == null) {
            delayWriter = new IoThrottledWriteHandler((ChainableIoHandler)ioHandler);
        }
        delayWriter.setWriteRateSec(bytesPerSecond);
        return delayWriter;
    }

    public boolean preStartSecuredMode(IIoHandler ioHandler) throws IOException {
        try {
            IoActivateableSSLHandler activateableHandler = (IoActivateableSSLHandler)this.getHandler((ChainableIoHandler)ioHandler, IoActivateableSSLHandler.class);
            if (activateableHandler != null) {
                return activateableHandler.preStartSecuredMode();
            }
            throw new IOException("connection is not SSL activatable (non IoActivateableHandler in chain)");
        }
        catch (ClassCastException cce) {
            throw new IOException("only ioHandler of tpye " + ChainableIoHandler.class.getName() + " are supported");
        }
    }

    public void startSecuredMode(IIoHandler ioHandler, ByteBuffer[] buffers) throws IOException {
        try {
            ((ChainableIoHandler)ioHandler).flushOutgoing();
        }
        catch (ClassCastException cce) {
            throw new IOException("only ioHandler of tpye " + ChainableIoHandler.class.getName() + " are supported");
        }
        IoActivateableSSLHandler activateableHandler = (IoActivateableSSLHandler)this.getHandler((ChainableIoHandler)ioHandler, IoActivateableSSLHandler.class);
        if (activateableHandler != null) {
            activateableHandler.startSecuredMode(buffers);
        } else {
            LOG.warning("connection is not SSL activatable (non IoActivateableHandler in chain");
        }
    }

    static Timer getTimer() {
        return TIMER;
    }

    static boolean isUseDirectReadBufferServer() {
        return serverReadBufferUseDirect;
    }

    static int getReadBufferPreallocationsizeServer() {
        return serverReadBufferPreallocationsize;
    }

    static int getReadBufferMinSizeServer() {
        return serverReadBufferMinsize;
    }

    static boolean isReadBufferPreallocationActivated() {
        return serverReadBufferPreallocationOn;
    }

    private static SocketChannel openSocket(InetSocketAddress remoteAddress, Map<String, Object> options, int connectTimeoutMillis) throws IOException {
        SocketChannel channel = SocketChannel.open();
        for (Map.Entry<String, Object> entry : options.entrySet()) {
            DefaultIoProvider.setOption(channel.socket(), entry.getKey(), entry.getValue());
        }
        try {
            channel.socket().connect(remoteAddress, connectTimeoutMillis);
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("error occured by bindung socket to remote address " + remoteAddress + " " + ioe.toString());
            }
            throw ioe;
        }
        return channel;
    }

    static void setOption(Socket socket, String name, Object value) throws IOException {
        if (name.equals("SOL_SOCKET.SO_SNDBUF")) {
            socket.setSendBufferSize(DefaultIoProvider.asInt(value));
        } else if (name.equals("SOL_SOCKET.SO_REUSEADDR")) {
            socket.setReuseAddress(DefaultIoProvider.asBoolean(value));
        } else if (name.equals("SOL_SOCKET.SO_TIMEOUT")) {
            socket.setSoTimeout(DefaultIoProvider.asInt(value));
        } else if (name.equals("SOL_SOCKET.SO_RCVBUF")) {
            socket.setReceiveBufferSize(DefaultIoProvider.asInt(value));
        } else if (name.equals("SOL_SOCKET.SO_KEEPALIVE")) {
            socket.setKeepAlive(DefaultIoProvider.asBoolean(value));
        } else if (name.equals("SOL_SOCKET.SO_LINGER")) {
            try {
                socket.setSoLinger(true, DefaultIoProvider.asInt(value));
            }
            catch (ClassCastException cce) {
                socket.setSoLinger(Boolean.FALSE, 0);
            }
        } else if (name.equals("IPPROTO_TCP.TCP_NODELAY")) {
            socket.setTcpNoDelay(DefaultIoProvider.asBoolean(value));
        } else {
            LOG.warning("option " + name + " is not supported");
        }
    }

    static Object getOption(Socket socket, String name) throws IOException {
        if (name.equals("SOL_SOCKET.SO_SNDBUF")) {
            return socket.getSendBufferSize();
        }
        if (name.equals("SOL_SOCKET.SO_REUSEADDR")) {
            return socket.getReuseAddress();
        }
        if (name.equals("SOL_SOCKET.SO_RCVBUF")) {
            return socket.getReceiveBufferSize();
        }
        if (name.equals("SOL_SOCKET.SO_KEEPALIVE")) {
            return socket.getKeepAlive();
        }
        if (name.equals("SOL_SOCKET.SO_TIMEOUT")) {
            return socket.getSoTimeout();
        }
        if (name.equals("IPPROTO_TCP.TCP_NODELAY")) {
            return socket.getTcpNoDelay();
        }
        if (name.equals("SOL_SOCKET.SO_LINGER")) {
            return socket.getSoLinger();
        }
        LOG.warning("option " + name + " is not supported");
        return null;
    }

    private static int asInt(Object obj) {
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return Integer.parseInt(obj.toString());
    }

    private static boolean asBoolean(Object obj) {
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return Boolean.parseBoolean(obj.toString());
    }

    private ChainableIoHandler getHandler(ChainableIoHandler head, Class clazz) {
        ChainableIoHandler handler = head;
        do {
            if (handler.getClass() != clazz) continue;
            return handler;
        } while ((handler = handler.getSuccessor()) != null);
        return null;
    }

    private static synchronized IoSocketDispatcher getClientDispatcher() {
        if (globalDispatcher == null) {
            UnsynchronizedMemoryManager memoryManager = null;
            memoryManager = clientReadBufferPreallocationOn != false ? UnsynchronizedMemoryManager.createPreallocatedMemoryManager(clientReadBufferPreallocationsize, clientReadBufferMinsize, clientReadBufferUseDirect) : UnsynchronizedMemoryManager.createNonPreallocatedMemoryManager(clientReadBufferUseDirect);
            globalDispatcher = new IoSocketDispatcher(memoryManager);
            Thread t = new Thread(globalDispatcher);
            t.setName("xDispatcher#CLIENT");
            t.setDaemon(true);
            t.start();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("client dispatcher created");
            }
        }
        return globalDispatcher;
    }

    @Override
    public ObjectName registerMBeans(Server server, IAcceptor acceptor, String domain, String address) throws JMException {
        address = address.replace(":", "_");
        if (acceptor instanceof Acceptor) {
            IntrospectionBasedDynamicMBean serverMBean = new IntrospectionBasedDynamicMBean(new MBeanAdapter(server, (Acceptor)acceptor));
            DispatcherPoolListener dispatcherPoolListener = new DispatcherPoolListener(domain, address);
            ((Acceptor)acceptor).addListener(dispatcherPoolListener);
            for (IDispatcher<IoSocketHandler> dispatcher : ((Acceptor)acceptor).getDispatchers()) {
                try {
                    dispatcherPoolListener.onDispatcherAdded((Dispatcher)dispatcher);
                }
                catch (Exception ignore) {}
            }
            server.addListener(new ServerListener());
            ObjectName serverObjectName = new ObjectName(domain + ":type=xServer,name=" + address);
            ManagementFactory.getPlatformMBeanServer().registerMBean(serverMBean, serverObjectName);
            return serverObjectName;
        }
        throw new JMException("only accpetor of instance " + Acceptor.class.getName() + " is supported, not " + acceptor.getClass().getName());
    }

    static {
        try {
            clientReadBufferUseDirect = Boolean.valueOf(System.getProperty(CLIENT_READBUFFER_USE_DIRECT_KEY, "true"));
        }
        catch (Exception e) {
            LOG.warning("invalid value for system property org.xsocket.connection.client.readbuffer.usedirect: " + System.getProperty(CLIENT_READBUFFER_USE_DIRECT_KEY) + " (valid is true|false)" + " using direct buffer");
            clientReadBufferUseDirect = Boolean.TRUE;
        }
        try {
            serverReadBufferUseDirect = Boolean.valueOf(System.getProperty(SERVER_READBUFFER_USE_DIRECT_KEY, "true"));
        }
        catch (Exception e) {
            LOG.warning("invalid value for system property org.xsocket.connection.server.readbuffer.usedirect: " + System.getProperty(SERVER_READBUFFER_USE_DIRECT_KEY) + " (valid is true|false)" + " using direct buffer");
            serverReadBufferUseDirect = Boolean.TRUE;
        }
        try {
            clientReadBufferPreallocationOn = Boolean.valueOf(System.getProperty(CLIENT_READBUFFER_PREALLOCATION_ON_KEY, "true"));
        }
        catch (Exception e) {
            LOG.warning("invalid value for system property org.xsocket.connection.client.readbuffer.preallocation.on: " + System.getProperty(CLIENT_READBUFFER_PREALLOCATION_ON_KEY) + " using preallocation mode");
            clientReadBufferPreallocationOn = Boolean.TRUE;
        }
        if (clientReadBufferPreallocationOn.booleanValue()) {
            try {
                clientReadBufferPreallocationsize = Integer.parseInt(System.getProperty(CLIENT_READBUFFER_PREALLOCATION_SIZE_KEY, Integer.toString(65536)));
            }
            catch (Exception e) {
                LOG.warning("invalid value for system property org.xsocket.connection.client.readbuffer.preallocation.size: " + System.getProperty(CLIENT_READBUFFER_PREALLOCATION_SIZE_KEY) + " using default preallocation size " + 65536);
                clientReadBufferPreallocationsize = 65536;
            }
            try {
                clientReadBufferMinsize = Integer.parseInt(System.getProperty(CLIENT_READBUFFER_PREALLOCATION_MIN_SIZE_KEY, Integer.toString(64)));
            }
            catch (Exception e) {
                LOG.warning("invalid value for system property org.xsocket.connection.client.readbuffer.preallocation.minSize: " + System.getProperty(CLIENT_READBUFFER_PREALLOCATION_MIN_SIZE_KEY) + " using default min size " + 64);
                clientReadBufferMinsize = 64;
            }
        }
        try {
            serverReadBufferPreallocationOn = Boolean.valueOf(System.getProperty(SERVER_READBUFFER_PREALLOCATION_ON_KEY, "true"));
        }
        catch (Exception e) {
            LOG.warning("invalid value for system property org.xsocket.connection.server.readbuffer.preallocation.on: " + System.getProperty(SERVER_READBUFFER_PREALLOCATION_ON_KEY) + " using preallocation mode");
            serverReadBufferPreallocationOn = Boolean.TRUE;
        }
        if (serverReadBufferPreallocationOn.booleanValue()) {
            try {
                serverReadBufferPreallocationsize = Integer.parseInt(System.getProperty(SERVER_READBUFFER_PREALLOCATION_SIZE_KEY, Integer.toString(65536)));
            }
            catch (Exception e) {
                LOG.warning("invalid value for system property org.xsocket.connection.server.readbuffer.preallocation.size: " + System.getProperty(SERVER_READBUFFER_PREALLOCATION_SIZE_KEY) + " using default preallocation size " + 65536);
                serverReadBufferPreallocationsize = 65536;
            }
            try {
                serverReadBufferMinsize = Integer.parseInt(System.getProperty(SERVER_READBUFFER_PREALLOCATION_MIN_SIZE_KEY, Integer.toString(64)));
            }
            catch (Exception e) {
                LOG.warning("invalid value for system property org.xsocket.connection.server.readbuffer.preallocation.minSize: " + System.getProperty(SERVER_READBUFFER_PREALLOCATION_MIN_SIZE_KEY) + " using default min size " + 64);
                serverReadBufferMinsize = 64;
            }
        }
        String base = null;
        try {
            base = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (Exception e) {
            base = new UID().toString();
        }
        int random = 0;
        Random rand = new Random();
        while ((random = rand.nextInt()) < 0) {
        }
        idPrefix = Integer.toHexString(base.hashCode()) + "." + Long.toHexString(System.currentTimeMillis()) + "." + Integer.toHexString(random);
        if (LOG.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder();
            sb.append(DefaultIoProvider.class.getName() + " initialized (");
            sb.append("client: directMemory=" + clientReadBufferUseDirect);
            sb.append(" preallocation=" + clientReadBufferPreallocationOn);
            if (clientReadBufferPreallocationOn.booleanValue()) {
                sb.append(" preallocationSize=" + DataConverter.toFormatedBytesSize(clientReadBufferPreallocationsize));
                sb.append(" minBufferSize=" + DataConverter.toFormatedBytesSize(clientReadBufferMinsize));
            }
            sb.append(" & server: directMemory=" + serverReadBufferUseDirect);
            sb.append(" preallocation=" + serverReadBufferPreallocationOn);
            if (serverReadBufferPreallocationOn.booleanValue()) {
                sb.append(" preallocationSize=" + DataConverter.toFormatedBytesSize(serverReadBufferPreallocationsize));
                sb.append(" minBufferSize=" + DataConverter.toFormatedBytesSize(serverReadBufferMinsize));
            }
            sb.append(")");
            LOG.fine(sb.toString());
        }
    }

    private static final class DispatcherPoolListener
    implements IAcceptorListener {
        private String domain = null;
        private String address = null;

        DispatcherPoolListener(String domain, String address) {
            this.domain = domain;
            this.address = address;
        }

        public void onDispatcherAdded(IDispatcher dispatcher) {
            block2: {
                try {
                    ObjectName objectName = new ObjectName(this.domain + ":type=xDispatcher,name=" + this.address + "." + dispatcher.hashCode());
                    ManagementFactory.getPlatformMBeanServer().registerMBean(new IntrospectionBasedDynamicMBean(dispatcher), objectName);
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("error occured by adding mbean for new dispatcher: " + e.toString());
                }
            }
        }

        public void onDispatcherRemoved(IDispatcher dispatcher) {
            block2: {
                try {
                    ObjectName objectName = new ObjectName(this.domain + ":type=xDispatcher,name=" + this.address + "." + dispatcher.hashCode());
                    ManagementFactory.getPlatformMBeanServer().unregisterMBean(objectName);
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("error occured by removing mbean of dispatcher: " + e.toString());
                }
            }
        }
    }

    private static final class ServerListener
    implements IServerListener {
        private ServerListener() {
        }

        public void onInit() {
        }

        public void onDestroy() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MBeanAdapter {
        private Server server = null;
        private Acceptor acceptor = null;

        public MBeanAdapter(Server server, Acceptor acceptor) {
            this.server = server;
            this.acceptor = acceptor;
        }

        public long getNumberOfConnectionTimeouts() {
            return this.acceptor.getNumberOfConnectionTimeouts();
        }

        public long getNumberOfIdleTimeouts() {
            return this.acceptor.getNumberOfIdleTimeouts();
        }

        public String getVersion() {
            return this.server.getVersion();
        }

        public String getLocalHost() {
            return this.acceptor.getLocalAddress().getCanonicalHostName();
        }

        public int getLocalPort() {
            return this.acceptor.getLocalPort();
        }

        public int getDispatcherPoolSize() {
            return this.acceptor.getDispatcherSize();
        }

        public void setDispatcherPoolSize(int size) {
            this.acceptor.setDispatcherSize(size);
        }

        public List<String> getActiveConnectionInfos() {
            return this.acceptor.getOpenConntionInfos();
        }

        public boolean getReceiveBufferIsDirect() {
            return this.acceptor.getReceiveBufferIsDirect();
        }

        public void setReceiveBufferIsDirect(boolean isDirect) {
            this.acceptor.setReceiveBufferIsDirect(isDirect);
        }

        public Integer getReceiveBufferPreallocatedMinSize() {
            if (this.acceptor.isReceiveBufferPreallocationMode()) {
                return this.acceptor.getReceiveBufferPreallocatedMinSize();
            }
            return null;
        }

        public void setReceiveBufferPreallocatedMinSize(Integer minSize) {
            this.acceptor.setReceiveBufferPreallocatedMinSize(minSize);
        }

        public boolean getReceiveBufferPreallocationMode() {
            return this.acceptor.isReceiveBufferPreallocationMode();
        }

        public void setReceiveBufferPreallocationMode(boolean mode) {
            this.acceptor.setReceiveBufferPreallocationMode(mode);
        }

        public Integer getReceiveBufferPreallocationSize() {
            if (this.acceptor.isReceiveBufferPreallocationMode()) {
                return this.acceptor.getReceiveBufferPreallocationSize();
            }
            return null;
        }

        public void setReceiveBufferPreallocationSize(Integer size) {
            this.acceptor.setReceiveBufferPreallocationSize(size);
        }

        public int getConnectionTimeoutSec() {
            return this.server.getConnectionTimeoutSec();
        }

        public void setConnectionTimeoutSec(int timeoutSec) {
            this.server.setConnectionTimeoutSec(timeoutSec);
        }

        public int getIdleTimeoutSec() {
            return this.server.getIdleTimeoutSec();
        }

        public void setIdleTimeoutSec(int timeoutSec) {
            this.server.setIdleTimeoutSec(timeoutSec);
        }

        public long getReceiveRateBytesPerSec() {
            return this.acceptor.getReceiveRateBytesPerSec();
        }

        public long getSendRateBytesPerSec() {
            return this.acceptor.getSendRateBytesPerSec();
        }

        public double getAcceptedRateCountPerSec() {
            return this.acceptor.getAcceptedRateCountPerSec();
        }
    }
}

