/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection.spi;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xsocket.ClosedException;
import org.xsocket.connection.spi.ChainableIoHandler;
import org.xsocket.connection.spi.DefaultIoProvider;
import org.xsocket.connection.spi.IIoHandlerCallback;
import org.xsocket.connection.spi.IMemoryManager;
import org.xsocket.connection.spi.IoQueue;
import org.xsocket.connection.spi.SSLProcessor;

final class IoSSLHandler
extends ChainableIoHandler
implements SSLProcessor.EventHandler {
    private static final Logger LOG = Logger.getLogger(IoSSLHandler.class.getName());
    private final IoQueue outAppDataQueue = new IoQueue();
    private final PendingWriteMap pendingWriteMap = new PendingWriteMap();
    private final IOEventHandler ioEventHandler = new IOEventHandler();
    private SSLProcessor sslProcessor = null;
    private boolean isClientMode = false;
    private boolean isSSLConnected = false;
    private final Object initGuard = new Object();

    IoSSLHandler(ChainableIoHandler successor, SSLContext sslContext, boolean isClientMode, IMemoryManager memoryManager) throws IOException {
        super(successor);
        this.isClientMode = isClientMode;
        this.sslProcessor = new SSLProcessor(sslContext, isClientMode, memoryManager, this);
    }

    public void init(IIoHandlerCallback callbackHandler) throws IOException {
        this.setPreviousCallback(callbackHandler);
        this.getSuccessor().init(this.ioEventHandler);
        this.startSSL();
    }

    public boolean reset() {
        this.outAppDataQueue.drain();
        this.pendingWriteMap.clear();
        return super.reset();
    }

    public void setPreviousCallback(IIoHandlerCallback callbackHandler) {
        super.setPreviousCallback(callbackHandler);
        this.getSuccessor().setPreviousCallback(this.ioEventHandler);
    }

    public int getPendingWriteDataSize() {
        return this.outAppDataQueue.getSize() + super.getPendingWriteDataSize();
    }

    public boolean hasDataToSend() {
        return !this.outAppDataQueue.isEmpty() || super.hasDataToSend();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startSSL() throws IOException {
        if (!this.isSSLConnected) {
            this.sslProcessor.start();
        }
        if (this.isClientMode) {
            Object object = this.initGuard;
            synchronized (object) {
                while (!this.isSSLConnected) {
                    try {
                        if (DefaultIoProvider.isDispatcherThread()) {
                            LOG.warning("try to initialize ssl client within xSocket I/O thread (" + Thread.currentThread().getName() + "). This will cause a deadlock");
                        }
                        this.initGuard.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    public final void close(boolean immediate) throws IOException {
        if (!immediate) {
            this.flushOutgoing();
        }
        this.getSuccessor().close(immediate);
    }

    public final void write(ByteBuffer[] buffers) throws ClosedException, IOException {
        this.outAppDataQueue.append(buffers);
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() throws ClosedException, IOException {
        SSLProcessor sSLProcessor = this.sslProcessor;
        synchronized (sSLProcessor) {
            if (!this.sslProcessor.isHandshaking()) {
                if (!this.outAppDataQueue.isEmpty()) {
                    this.sslProcessor.encrypt(this.outAppDataQueue.drain());
                }
            } else {
                this.sslProcessor.encrypt();
            }
        }
    }

    public void flushOutgoing() throws IOException {
    }

    private synchronized void readIncomingEncryptedData(ByteBuffer[] inNetDataList) throws ClosedException, IOException {
        if (inNetDataList != null) {
            if (LOG.isLoggable(Level.FINE)) {
                int size = 0;
                for (ByteBuffer buffer : inNetDataList) {
                    size += buffer.remaining();
                }
                LOG.fine("received " + size + " bytes encrypted data");
            }
            this.sslProcessor.decrypt(inNetDataList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onHandshakeFinished() throws IOException {
        if (!this.isSSLConnected) {
            if (LOG.isLoggable(Level.FINE)) {
                if (this.isClientMode) {
                    LOG.fine("[" + this.getId() + "] handshake has been finished (clientMode)");
                } else {
                    LOG.fine("[" + this.getId() + "] handshake has been finished (serverMode)");
                }
            }
            this.isSSLConnected = true;
            Object object = this.initGuard;
            synchronized (object) {
                this.initGuard.notifyAll();
            }
            this.getPreviousCallback().onConnect();
        }
        this.flush();
    }

    public void onSSLProcessorClosed() throws IOException {
        this.close(true);
    }

    public void onDataDecrypted(ByteBuffer[] decryptedBufferList) {
        if (decryptedBufferList == null) {
            return;
        }
        if (decryptedBufferList.length == 0) {
            return;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("reading decryted data");
        }
        this.getPreviousCallback().onData(decryptedBufferList);
    }

    public void onDataEncrypted(ByteBuffer plainData, ByteBuffer encryptedData) throws IOException {
        if (encryptedData.hasRemaining()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("writing encryted data");
            }
            this.pendingWriteMap.add(plainData, encryptedData);
            ByteBuffer[] buffers = new ByteBuffer[]{encryptedData};
            this.getSuccessor().write(buffers);
        }
    }

    private static final class PendingWriteMap {
        private Map<ByteBuffer, List<ByteBuffer>> plainEncryptedMapping = new IdentityHashMap<ByteBuffer, List<ByteBuffer>>();
        private Map<ByteBuffer, ByteBuffer> encryptedPlainMapping = new IdentityHashMap<ByteBuffer, ByteBuffer>();

        private PendingWriteMap() {
        }

        public synchronized void add(ByteBuffer plain, ByteBuffer encrypted) {
            if (plain.limit() > 0) {
                List<ByteBuffer> encryptedList = this.plainEncryptedMapping.get(plain);
                if (encryptedList == null) {
                    encryptedList = new ArrayList<ByteBuffer>();
                    this.plainEncryptedMapping.put(plain, encryptedList);
                }
                encryptedList.add(encrypted);
                this.encryptedPlainMapping.put(encrypted, plain);
            }
        }

        public synchronized ByteBuffer getPlainIfWritten(ByteBuffer encrypted) {
            ByteBuffer plain = this.encryptedPlainMapping.remove(encrypted);
            if (plain != null) {
                List<ByteBuffer> encryptedList = this.plainEncryptedMapping.get(plain);
                encryptedList.remove(encrypted);
                if (encryptedList.isEmpty()) {
                    this.plainEncryptedMapping.remove(plain);
                    return plain;
                }
            }
            return null;
        }

        public synchronized void clear() {
            this.plainEncryptedMapping.clear();
            this.encryptedPlainMapping.clear();
        }
    }

    private final class IOEventHandler
    implements IIoHandlerCallback {
        private IOEventHandler() {
        }

        public void onData(ByteBuffer[] data) {
            block2: {
                try {
                    IoSSLHandler.this.readIncomingEncryptedData(data);
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("[" + IoSSLHandler.this.getId() + "] error occured while receiving data. Reason: " + e.toString());
                }
            }
        }

        public void onConnect() {
        }

        public void onWriteException(IOException ioException, ByteBuffer data) {
            IoSSLHandler.this.getPreviousCallback().onWriteException(ioException, data);
        }

        public void onWritten(ByteBuffer data) {
            ByteBuffer plainData = IoSSLHandler.this.pendingWriteMap.getPlainIfWritten(data);
            if (plainData != null) {
                IoSSLHandler.this.getPreviousCallback().onWritten(plainData);
            } else {
                IoSSLHandler.this.getPreviousCallback().onWritten(data);
            }
        }

        public void onDisconnect() {
            IoSSLHandler.this.sslProcessor.destroy();
            IoSSLHandler.this.getPreviousCallback().onDisconnect();
        }

        public void onConnectionAbnormalTerminated() {
            IoSSLHandler.this.getPreviousCallback().onConnectionAbnormalTerminated();
        }

        public void onConnectionTimeout() {
            IoSSLHandler.this.getPreviousCallback().onConnectionTimeout();
        }

        public void onIdleTimeout() {
            IoSSLHandler.this.getPreviousCallback().onIdleTimeout();
        }
    }
}

