/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection.spi;

import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.util.Set;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.DataConverter;
import org.xsocket.Dispatcher;
import org.xsocket.IDispatcherEventHandler;
import org.xsocket.connection.spi.DefaultIoProvider;
import org.xsocket.connection.spi.IMemoryManager;
import org.xsocket.connection.spi.IoSocketHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IoSocketDispatcher
extends Dispatcher<IoSocketHandler> {
    private static final Logger LOG = Logger.getLogger(IoSocketDispatcher.class.getName());
    static final String DISPATCHER_PREFIX = "xDispatcher";
    private static final long DEFAULT_WATCHDOG_PERIOD_MILLIS = 300000L;
    private long watchDogPeriod = 300000L;
    private TimerTask watchDogTask = null;
    private IMemoryManager memoryManager = null;
    private long countIdleTimeouts = 0L;
    private long countConnectionTimeouts = 0L;

    IoSocketDispatcher(IMemoryManager memoryManager) {
        super(new DispatcherEventHandler(memoryManager));
        this.memoryManager = memoryManager;
        this.updateTimeoutCheckPeriod(300000L);
    }

    long getReceiveRateBytesPerSec() {
        return ((DispatcherEventHandler)this.getEventHandler()).getReceiveRateBytesPerSec();
    }

    long getSendRateBytesPerSec() {
        return ((DispatcherEventHandler)this.getEventHandler()).getSendRateBytesPerSec();
    }

    @Override
    public void resetStatistics() {
        super.resetStatistics();
        this.countIdleTimeouts = 0L;
        this.countConnectionTimeouts = 0L;
    }

    @Override
    public void register(IoSocketHandler handle, int ops) throws IOException {
        handle.setMemoryManager(this.memoryManager);
        super.register(handle, ops);
    }

    @Override
    public long getNumberOfHandledRegistrations() {
        return super.getNumberOfHandledRegistrations();
    }

    @Override
    public long getNumberOfHandledReads() {
        return super.getNumberOfHandledReads();
    }

    @Override
    public long getNumberOfHandledWrites() {
        return super.getNumberOfHandledWrites();
    }

    public int getPreallocatedReadMemorySize() {
        return this.memoryManager.getCurrentSizePreallocatedBuffer();
    }

    boolean getReceiveBufferPreallocationMode() {
        return this.memoryManager.isPreallocationMode();
    }

    void setReceiveBufferPreallocationMode(boolean mode) {
        this.memoryManager.setPreallocationMode(mode);
    }

    void setReceiveBufferPreallocatedMinSize(Integer minSize) {
        this.memoryManager.setPreallocatedMinBufferSize(minSize);
    }

    Integer getReceiveBufferPreallocatedMinSize() {
        if (this.memoryManager.isPreallocationMode()) {
            return this.memoryManager.getPreallocatedMinBufferSize();
        }
        return null;
    }

    Integer getReceiveBufferPreallocatedSize() {
        if (this.memoryManager.isPreallocationMode()) {
            return this.memoryManager.gettPreallocationBufferSize();
        }
        return null;
    }

    void setReceiveBufferPreallocatedSize(Integer size) {
        this.memoryManager.setPreallocationBufferSize(size);
    }

    boolean getReceiveBufferIsDirect() {
        return this.memoryManager.isDirect();
    }

    void setReceiveBufferIsDirect(boolean isDirect) {
        this.memoryManager.setDirect(isDirect);
    }

    public void updateTimeoutCheckPeriod(long requiredMinPeriod) {
        if (this.watchDogTask != null && this.watchDogPeriod <= requiredMinPeriod) {
            return;
        }
        this.watchDogPeriod = requiredMinPeriod;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("update dispatcher`s watchdog task " + DataConverter.toFormatedDuration(this.watchDogPeriod));
        }
        if (this.watchDogTask != null) {
            this.watchDogTask.cancel();
        }
        this.watchDogTask = new TimerTask(){

            public void run() {
                IoSocketDispatcher.this.checkTimeouts();
            }
        };
        DefaultIoProvider.getTimer().schedule(this.watchDogTask, this.watchDogPeriod, this.watchDogPeriod);
    }

    @Override
    public void close() {
        super.close();
        if (this.watchDogTask != null) {
            this.watchDogTask.cancel();
        }
    }

    long getCountIdleTimeout() {
        return this.countIdleTimeouts;
    }

    long getCountConnectionTimeout() {
        return this.countConnectionTimeouts;
    }

    void checkTimeouts() {
        block4: {
            try {
                long current = System.currentTimeMillis();
                Set socketHandlers = this.getRegistered();
                for (IoSocketHandler socketHandler : socketHandlers) {
                    this.checkTimeout(socketHandler, current);
                }
            }
            catch (ClosedSelectorException cse) {
                this.watchDogTask.cancel();
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block4;
                LOG.fine("error occured: " + e.toString());
            }
        }
    }

    private void checkTimeout(IoSocketHandler ioSocketHandler, long current) {
        ioSocketHandler.checkConnection();
        boolean timeoutOccured = ioSocketHandler.checkIdleTimeout(current);
        if (timeoutOccured) {
            ++this.countIdleTimeouts;
        }
        if (timeoutOccured = ioSocketHandler.checkConnectionTimeout(current)) {
            ++this.countConnectionTimeouts;
        }
    }

    public String toString() {
        return "open channels  " + super.getRegistered().size();
    }

    static boolean isDispatcherThread() {
        return Thread.currentThread().getName().startsWith(DISPATCHER_PREFIX);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DispatcherEventHandler
    implements IDispatcherEventHandler<IoSocketHandler> {
        private IMemoryManager memoryManager = null;
        private long receivedBytes = 0L;
        private long sentBytes = 0L;
        private long lastRequestReceiveRate = System.currentTimeMillis();
        private long lastRequestSendRate = System.currentTimeMillis();

        DispatcherEventHandler(IMemoryManager memoryManager) {
            this.memoryManager = memoryManager;
        }

        IMemoryManager getMemoryManager() {
            return this.memoryManager;
        }

        long getReceiveRateBytesPerSec() {
            long rate = 0L;
            long elapsed = System.currentTimeMillis() - this.lastRequestReceiveRate;
            rate = this.receivedBytes == 0L ? 0L : (elapsed == 0L ? Long.MAX_VALUE : this.receivedBytes * 1000L / elapsed);
            this.lastRequestReceiveRate = System.currentTimeMillis();
            this.receivedBytes = 0L;
            return rate;
        }

        long getSendRateBytesPerSec() {
            long rate = 0L;
            long elapsed = System.currentTimeMillis() - this.lastRequestSendRate;
            rate = this.sentBytes == 0L ? 0L : (elapsed == 0L ? Long.MAX_VALUE : this.sentBytes * 1000L / elapsed);
            this.lastRequestSendRate = System.currentTimeMillis();
            this.sentBytes = 0L;
            return rate;
        }

        @Override
        public void onHandleReadableEvent(IoSocketHandler socketIOHandler) throws IOException {
            long read = socketIOHandler.onReadableEvent();
            this.receivedBytes += read;
        }

        @Override
        public void onHandleWriteableEvent(IoSocketHandler socketIOHandler) throws IOException {
            long written = socketIOHandler.onWriteableEvent();
            this.sentBytes += written;
        }

        @Override
        public void onHandleRegisterEvent(IoSocketHandler socketIOHandler) throws IOException {
            socketIOHandler.onConnectEvent();
        }

        @Override
        public void onDispatcherCloseEvent(IoSocketHandler socketIOHandler) {
            socketIOHandler.onDispatcherClose();
        }
    }
}

