/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection.spi;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.ClosedException;
import org.xsocket.DataConverter;
import org.xsocket.IDispatcher;
import org.xsocket.IHandle;
import org.xsocket.connection.spi.ChainableIoHandler;
import org.xsocket.connection.spi.DefaultIoProvider;
import org.xsocket.connection.spi.IIoHandlerCallback;
import org.xsocket.connection.spi.IMemoryManager;
import org.xsocket.connection.spi.IoQueue;
import org.xsocket.connection.spi.IoSocketDispatcher;
import org.xsocket.connection.spi.UnsynchronizedMemoryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IoSocketHandler
extends ChainableIoHandler
implements IHandle {
    private static final Logger LOG = Logger.getLogger(IoSocketHandler.class.getName());
    private static final int MAXSIZE_LOG_READ = 2000;
    private static final Map<String, Class> SUPPORTED_OPTIONS = new HashMap<String, Class>();
    private boolean isLogicalOpen = true;
    private boolean isDisconnect = false;
    private SocketChannel channel = null;
    private IoSocketDispatcher dispatcher = null;
    private IMemoryManager memoryManager = null;
    private final IoQueue sendQueue = new IoQueue();
    private String id = null;
    private int idleTimeoutSec = Integer.MAX_VALUE;
    private long idleTimeoutDateMillis = Long.MAX_VALUE;
    private int connectionTimeoutSec = Integer.MAX_VALUE;
    private long connectionTimeoutDateMillis = Long.MAX_VALUE;
    private boolean suspendRead = false;
    private int soRcvbuf = 0;
    private long openTime = -1L;
    private long lastTimeReceivedMillis = System.currentTimeMillis();
    private long receivedBytes = 0L;
    private long sendBytes = 0L;

    IoSocketHandler(SocketChannel channel, IoSocketDispatcher dispatcher, String connectionId) throws IOException {
        super(null);
        assert (channel != null);
        this.channel = channel;
        this.openTime = System.currentTimeMillis();
        channel.configureBlocking(false);
        this.dispatcher = dispatcher;
        this.id = connectionId;
        this.soRcvbuf = (Integer)this.getOption("SOL_SOCKET.SO_RCVBUF");
    }

    @Override
    public void init(IIoHandlerCallback callbackHandler) throws IOException, SocketTimeoutException {
        this.setPreviousCallback(callbackHandler);
        this.blockUntilIsConnected();
        this.dispatcher.register(this, 1);
    }

    @Override
    public boolean reset() {
        try {
            this.sendQueue.drain();
            this.resumeRead();
            return super.reset();
        }
        catch (Exception e) {
            return false;
        }
    }

    void setMemoryManager(IMemoryManager memoryManager) {
        this.memoryManager = memoryManager;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getPendingWriteDataSize() {
        return this.sendQueue.getSize() + super.getPendingWriteDataSize();
    }

    @Override
    public boolean hasDataToSend() {
        return !this.sendQueue.isEmpty();
    }

    @Override
    public void setOption(String name, Object value) throws IOException {
        DefaultIoProvider.setOption(this.channel.socket(), name, value);
        if (name.equals("SOL_SOCKET.SO_RCVBUF")) {
            this.soRcvbuf = (Integer)value;
        }
    }

    @Override
    public Object getOption(String name) throws IOException {
        return DefaultIoProvider.getOption(this.channel.socket(), name);
    }

    @Override
    public Map<String, Class> getOptions() {
        return Collections.unmodifiableMap(SUPPORTED_OPTIONS);
    }

    @Override
    public void setIdleTimeoutSec(int timeoutSec) {
        if (timeoutSec <= 0) {
            LOG.warning("connection timeout " + timeoutSec + " sec is invalid");
            return;
        }
        this.idleTimeoutSec = timeoutSec;
        this.idleTimeoutDateMillis = System.currentTimeMillis() + DataConverter.unsignedIntToLong(this.idleTimeoutSec);
        this.dispatcher.updateTimeoutCheckPeriod((long)this.idleTimeoutSec * 100L);
    }

    @Override
    public void setConnectionTimeoutSec(int timeoutSec) {
        if (timeoutSec <= 0) {
            LOG.warning("connection timeout " + timeoutSec + " sec is invalid");
            return;
        }
        this.connectionTimeoutSec = timeoutSec;
        this.connectionTimeoutDateMillis = System.currentTimeMillis() + DataConverter.unsignedIntToLong(this.connectionTimeoutSec);
        this.dispatcher.updateTimeoutCheckPeriod((long)this.connectionTimeoutSec * 100L);
    }

    @Override
    public int getConnectionTimeoutSec() {
        return this.connectionTimeoutSec;
    }

    @Override
    public int getIdleTimeoutSec() {
        return this.idleTimeoutSec;
    }

    boolean checkIdleTimeout(Long currentMillis) {
        if (this.getRemainingSecToIdleTimeout(currentMillis) <= 0) {
            this.getPreviousCallback().onIdleTimeout();
            return true;
        }
        return false;
    }

    @Override
    public int getRemainingSecToIdleTimeout() {
        return this.getRemainingSecToIdleTimeout(System.currentTimeMillis());
    }

    private int getRemainingSecToIdleTimeout(long currentMillis) {
        long remaining = this.idleTimeoutDateMillis - currentMillis;
        if (remaining > 0L) {
            return DataConverter.unsignedLongToInt(remaining);
        }
        remaining = this.lastTimeReceivedMillis + DataConverter.unsignedIntToLong(this.idleTimeoutSec) - currentMillis;
        return DataConverter.unsignedLongToInt(remaining);
    }

    boolean checkConnectionTimeout(Long currentMillis) {
        if (this.getRemainingSecToConnectionTimeout(currentMillis) <= 0) {
            this.getPreviousCallback().onConnectionTimeout();
            return true;
        }
        return false;
    }

    @Override
    public int getRemainingSecToConnectionTimeout() {
        return this.getRemainingSecToConnectionTimeout(System.currentTimeMillis());
    }

    private int getRemainingSecToConnectionTimeout(long currentMillis) {
        long remaining = this.connectionTimeoutDateMillis - currentMillis;
        return DataConverter.unsignedLongToInt(remaining);
    }

    void checkConnection() {
        if (!this.channel.isOpen()) {
            this.getPreviousCallback().onConnectionAbnormalTerminated();
        }
    }

    void onConnectEvent() throws IOException {
        this.getPreviousCallback().onConnect();
    }

    int onReadableEvent() throws IOException {
        assert (IoSocketDispatcher.isDispatcherThread()) : "receiveQueue can only be accessed by the dispatcher thread";
        int read = 0;
        try {
            ByteBuffer[] received = this.readSocket();
            if (received != null) {
                this.getPreviousCallback().onData(received);
            }
            this.checkPreallocatedReadMemory();
        }
        catch (ClosedException ce) {
            this.close(false);
        }
        catch (Exception t) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] error occured by handling readable event. reason: " + t.toString());
            }
            this.close(false);
        }
        catch (Error e) {
            this.close(false);
            throw e;
        }
        return read;
    }

    int onWriteableEvent() throws IOException {
        assert (IoSocketDispatcher.isDispatcherThread());
        int sent = 0;
        if (this.suspendRead) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("[" + this.getId() + "] writeable event occured. update interested to none (because suspendRead is set) and write data to socket");
            }
            this.updateInterestedSetNonen();
        } else {
            this.updateInterestedSetRead();
        }
        sent = this.writeSocket();
        if (this.sendQueue.isEmpty()) {
            if (this.shouldClosedPhysically()) {
                this.realClose();
            }
        } else {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.id + "] remaining data to send. initiate sending of the remaining (" + DataConverter.toFormatedBytesSize(this.sendQueue.getSize()) + ")");
            }
            this.updateInterestedSetWrite();
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("[" + this.getId() + "] writeable event handled");
        }
        return sent;
    }

    private void blockUntilIsConnected() throws IOException, SocketTimeoutException {
        while (!this.getChannel().finishConnect()) {
            this.getChannel().configureBlocking(true);
            this.getChannel().finishConnect();
            this.getChannel().configureBlocking(false);
        }
    }

    private boolean shouldClosedPhysically() {
        return !this.isLogicalOpen && this.sendQueue.isEmpty();
    }

    @Override
    public void write(ByteBuffer[] buffers) throws IOException {
        if (buffers != null) {
            this.sendQueue.append(buffers);
            this.updateInterestedSetWrite();
        }
    }

    @Override
    public void close(boolean immediate) throws IOException {
        if (immediate || this.sendQueue.isEmpty()) {
            this.realClose();
        } else {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("postpone close until remaning data to write (" + this.sendQueue.getSize() + ") has been written");
            }
            this.isLogicalOpen = false;
            this.updateInterestedSetWrite();
        }
    }

    private void realClose() {
        block7: {
            block6: {
                try {
                    this.getDispatcher().deregister(this);
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block6;
                    LOG.fine("error occured by deregistering connection " + this.id + " on dispatcher. reason: " + e.toString());
                }
            }
            try {
                this.channel.close();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("connection " + this.id + " has been closed");
                }
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block7;
                LOG.fine("error occured by closing connection " + this.id + " reason: " + e.toString());
            }
        }
        if (!this.isDisconnect) {
            this.isDisconnect = true;
            this.getPreviousCallback().onDisconnect();
        }
    }

    void onDispatcherClose() {
        this.getPreviousCallback().onConnectionAbnormalTerminated();
    }

    private void updateInterestedSetWrite() throws ClosedException {
        try {
            this.dispatcher.updateInterestSet(this, 5);
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("couldn`t update interested set to write data on socket. Reason: " + ioe.toString());
            }
            try {
                this.dispatcher.deregister(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ClosedException("connection " + this.id + " is already closed", ioe);
        }
    }

    private void updateInterestedSetRead() throws ClosedException {
        try {
            this.dispatcher.updateInterestSet(this, 1);
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("couldn`t update interested set to read data. Reason: " + ioe.toString());
            }
            try {
                this.dispatcher.deregister(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ClosedException("connection " + this.id + " is already closed", ioe);
        }
    }

    private void updateInterestedSetNonen() throws ClosedException {
        try {
            this.dispatcher.updateInterestSet(this, 0);
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("could not update interested set to nonen. Reason: " + ioe.toString());
            }
            try {
                this.dispatcher.deregister(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ClosedException("connection " + this.id + " is already closed", ioe);
        }
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public SocketChannel getChannel() {
        return this.channel;
    }

    IDispatcher<IoSocketHandler> getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public void suspendRead() throws IOException {
        this.suspendRead = true;
        this.updateInterestedSetWrite();
    }

    @Override
    public void resumeRead() throws IOException {
        if (this.suspendRead) {
            this.suspendRead = false;
            this.updateInterestedSetWrite();
        }
    }

    private ByteBuffer[] readSocket() throws IOException {
        assert (IoSocketDispatcher.isDispatcherThread()) : "receiveQueue can only be accessed by the dispatcher thread";
        ByteBuffer[] received = null;
        int read = 0;
        this.lastTimeReceivedMillis = System.currentTimeMillis();
        if (this.isOpen() && !this.suspendRead) {
            assert (this.memoryManager instanceof UnsynchronizedMemoryManager);
            ByteBuffer readBuffer = this.memoryManager.acquireMemoryStandardSizeOrPreallocated(this.soRcvbuf);
            int pos = readBuffer.position();
            int limit = readBuffer.limit();
            try {
                read = this.channel.read(readBuffer);
            }
            catch (IOException ioe) {
                readBuffer.position(pos);
                readBuffer.limit(limit);
                this.memoryManager.recycleMemory(readBuffer);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.id + "] error occured while reading channel: " + ioe.toString());
                }
                throw ioe;
            }
            switch (read) {
                case -1: {
                    this.memoryManager.recycleMemory(readBuffer);
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + this.id + "] channel has reached end-of-stream (maybe closed by peer)");
                    }
                    ClosedException cce = new ClosedException("[" + this.id + "] End of stream reached");
                    throw cce;
                }
                case 0: {
                    this.memoryManager.recycleMemory(readBuffer);
                    return null;
                }
            }
            int remainingFreeSize = readBuffer.remaining();
            ByteBuffer dataBuffer = this.memoryManager.extractAndRecycleMemory(readBuffer, read);
            if (received == null) {
                received = new ByteBuffer[]{dataBuffer};
            }
            this.receivedBytes += (long)read;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.id + "] received (" + (dataBuffer.limit() - dataBuffer.position()) + " bytes, total " + (this.receivedBytes + (long)read) + " bytes): " + DataConverter.toTextOrHexString(new ByteBuffer[]{dataBuffer.duplicate()}, "UTF-8", 2000));
            }
            if (remainingFreeSize == 0) {
                if (read < this.memoryManager.gettPreallocationBufferSize()) {
                    ByteBuffer[] repeatedReceived;
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + this.id + "] complete read buffer has been used, initiating repeated read");
                    }
                    if ((repeatedReceived = this.readSocket()) != null) {
                        ByteBuffer[] newReceived = new ByteBuffer[received.length + 1];
                        newReceived[0] = dataBuffer;
                        System.arraycopy(repeatedReceived, 0, newReceived, 1, repeatedReceived.length);
                        received = newReceived;
                        return received;
                    }
                    return received;
                }
                return received;
            }
            return received;
        }
        if (LOG.isLoggable(Level.FINEST)) {
            if (!this.isOpen()) {
                LOG.finest("[" + this.getId() + "] couldn't read socket because socket is already closed");
            }
            if (this.suspendRead) {
                LOG.finest("[" + this.getId() + "] read is suspended, do nothing");
            }
        }
        return null;
    }

    private void checkPreallocatedReadMemory() {
        assert (IoSocketDispatcher.isDispatcherThread());
        this.memoryManager.preallocate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeSocket() throws IOException {
        assert (IoSocketDispatcher.isDispatcherThread());
        int sent = 0;
        if (this.isOpen()) {
            ByteBuffer[] buffers = this.sendQueue.drain();
            if (buffers == null) {
                return 0;
            }
            boolean hasUnwrittenBuffers = false;
            try {
                for (int i = 0; i < buffers.length; ++i) {
                    int writeSize;
                    if (buffers[i] == null || (writeSize = buffers[i].remaining()) <= 0) continue;
                    if (LOG.isLoggable(Level.FINE) && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + this.id + "] sending (" + writeSize + " bytes): " + DataConverter.toTextOrHexString(buffers[i].duplicate(), "UTF-8", 500));
                    }
                    try {
                        int written = this.channel.write(buffers[i]);
                        sent += written;
                        this.sendBytes += (long)written;
                        if (written == writeSize) {
                            block23: {
                                try {
                                    this.getPreviousCallback().onWritten(buffers[i]);
                                }
                                catch (Exception e) {
                                    if (!LOG.isLoggable(Level.FINE)) break block23;
                                    LOG.fine("error occured by notifying that buffer has been written " + e.toString());
                                }
                            }
                            buffers[i] = null;
                            continue;
                        }
                        hasUnwrittenBuffers = true;
                        if (!LOG.isLoggable(Level.FINE)) break;
                        LOG.fine("[" + this.id + "] " + written + " of " + (writeSize - written) + " bytes has been sent (" + DataConverter.toFormatedBytesSize(writeSize - written) + ")");
                    }
                    catch (IOException ioe) {
                        block24: {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.fine("error " + ioe.toString() + " occured by writing " + DataConverter.toTextOrHexString(buffers[i].duplicate(), "US-ASCII", 500));
                            }
                            try {
                                this.getPreviousCallback().onWriteException(ioe, buffers[i]);
                            }
                            catch (Exception e) {
                                if (!LOG.isLoggable(Level.FINE)) break block24;
                                LOG.fine("error occured by notifying that write exception (" + e.toString() + ") has been occured " + e.toString());
                            }
                        }
                        buffers[i] = null;
                        int n = sent;
                        if (hasUnwrittenBuffers) {
                            this.sendQueue.addFirst(buffers);
                        }
                        return n;
                    }
                }
            }
            finally {
                if (hasUnwrittenBuffers) {
                    this.sendQueue.addFirst(buffers);
                }
            }
        } else if (LOG.isLoggable(Level.FINEST)) {
            if (!this.isOpen()) {
                LOG.finest("[" + this.getId() + "] couldn't write send queue to socket because socket is already closed (sendQueuesize=" + DataConverter.toFormatedBytesSize(this.sendQueue.getSize()) + ")");
            }
            if (this.sendQueue.isEmpty()) {
                LOG.finest("[" + this.getId() + "] nothing to write, because send queue is empty ");
            }
        }
        return sent;
    }

    @Override
    public final InetAddress getLocalAddress() {
        return this.channel.socket().getLocalAddress();
    }

    @Override
    public final int getLocalPort() {
        return this.channel.socket().getLocalPort();
    }

    @Override
    public final InetAddress getRemoteAddress() {
        return this.channel.socket().getInetAddress();
    }

    @Override
    public final int getRemotePort() {
        return this.channel.socket().getPort();
    }

    @Override
    public void flushOutgoing() {
    }

    @Override
    public String toString() {
        try {
            return "(" + this.channel.socket().getInetAddress().toString() + ":" + this.channel.socket().getPort() + " -> " + this.channel.socket().getLocalAddress().toString() + ":" + this.channel.socket().getLocalPort() + ")" + " received=" + DataConverter.toFormatedBytesSize(this.receivedBytes) + ", sent=" + DataConverter.toFormatedBytesSize(this.sendBytes) + ", age=" + DataConverter.toFormatedDuration(System.currentTimeMillis() - this.openTime) + ", lastReceived=" + DataConverter.toFormatedDate(this.lastTimeReceivedMillis) + ", sendQueueSize=" + DataConverter.toFormatedBytesSize(this.sendQueue.getSize()) + " [" + this.id + "]";
        }
        catch (Throwable e) {
            return super.toString();
        }
    }

    static {
        SUPPORTED_OPTIONS.put("SOL_SOCKET.SO_RCVBUF", Integer.class);
        SUPPORTED_OPTIONS.put("SOL_SOCKET.SO_SNDBUF", Integer.class);
        SUPPORTED_OPTIONS.put("SOL_SOCKET.SO_REUSEADDR", Boolean.class);
        SUPPORTED_OPTIONS.put("SOL_SOCKET.SO_KEEPALIVE", Boolean.class);
        SUPPORTED_OPTIONS.put("IPPROTO_TCP.TCP_NODELAY", Boolean.class);
        SUPPORTED_OPTIONS.put("SOL_SOCKET.SO_LINGER", Integer.class);
    }
}

