/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection.spi;

import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.DataConverter;
import org.xsocket.connection.spi.AbstractMemoryManager;

final class UnsynchronizedMemoryManager
extends AbstractMemoryManager {
    private static final Logger LOG = Logger.getLogger(UnsynchronizedMemoryManager.class.getName());
    private ByteBuffer freeBuffer = null;

    private UnsynchronizedMemoryManager(int preallocationSize, boolean preallocate, int minPreallocatedBufferSize, boolean useDirectMemory) {
        super(preallocationSize, preallocate, minPreallocatedBufferSize, useDirectMemory);
    }

    public static UnsynchronizedMemoryManager createPreallocatedMemoryManager(int preallocationSize, int minBufferSze, boolean useDirectMemory) {
        return new UnsynchronizedMemoryManager(preallocationSize, true, minBufferSze, useDirectMemory);
    }

    public static UnsynchronizedMemoryManager createNonPreallocatedMemoryManager(boolean useDirectMemory) {
        return new UnsynchronizedMemoryManager(0, false, 1, useDirectMemory);
    }

    public int getCurrentSizePreallocatedBuffer() {
        if (this.freeBuffer != null) {
            return this.freeBuffer.remaining();
        }
        return 0;
    }

    public void recycleMemory(ByteBuffer buffer) {
        if (this.isPreallocationMode() && buffer.remaining() >= this.getPreallocatedMinBufferSize()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("recycling " + DataConverter.toFormatedBytesSize(buffer.remaining()));
            }
            this.freeBuffer = buffer;
        }
    }

    public ByteBuffer acquireMemoryStandardSizeOrPreallocated(int standardSize) {
        if (this.isPreallocationMode()) {
            this.preallocate();
        } else {
            this.freeBuffer = this.newBuffer(standardSize);
        }
        ByteBuffer buffer = this.freeBuffer;
        this.freeBuffer = null;
        return buffer;
    }

    public void preallocate() {
        if (this.isPreallocationMode()) {
            if (this.freeBuffer != null && this.freeBuffer.remaining() >= this.getPreallocatedMinBufferSize()) {
                return;
            }
            this.freeBuffer = this.newBuffer(this.gettPreallocationBufferSize());
        }
    }
}

