/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xsocket.connection.ConnectionUtils;
import org.xsocket.connection.HandlerProxy;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IHandler;
import org.xsocket.connection.IServer;
import org.xsocket.connection.IServerListener;
import org.xsocket.connection.NonBlockingConnection;
import org.xsocket.connection.spi.DefaultIoProvider;
import org.xsocket.connection.spi.IAcceptor;
import org.xsocket.connection.spi.IAcceptorCallback;
import org.xsocket.connection.spi.IIoHandler;
import org.xsocket.connection.spi.IServerIoProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server
implements IServer {
    private static final Logger LOG = Logger.getLogger(Server.class.getName());
    public static final int SIZE_DEFAULT_WORKER_POOL = 40;
    private static String implementationVersion = null;
    private IConnection.FlushMode flushMode = IConnection.DEFAULT_FLUSH_MODE;
    private boolean autoflush = true;
    private Integer writeRate = null;
    private Integer readRate = null;
    private boolean isOpen = false;
    private String name = "server";
    private boolean isSsslOn = false;
    private static IServerIoProvider serverIoProvider = null;
    private IAcceptor acceptor = null;
    private ExecutorService defaultWorkerPool = Executors.newFixedThreadPool(40, new DefaultThreadFactory());
    private Executor workerpool = this.defaultWorkerPool;
    private HandlerProxy handlerProxyPrototype = HandlerProxy.newPrototype(null, null);
    private long idleTimeoutMillis = Long.MAX_VALUE;
    private long connectionTimeoutMillis = Long.MAX_VALUE;
    private final ArrayList<IServerListener> listeners = new ArrayList();
    private String startUpLogMessage = null;

    public Server(IHandler handler) throws UnknownHostException, IOException {
        this(new InetSocketAddress(InetAddress.getByName("0.0.0.0"), 0), new HashMap<String, Object>(), handler, null, false);
    }

    public Server(Map<String, Object> options, IHandler handler) throws UnknownHostException, IOException {
        this(InetAddress.getByName("0.0.0.0"), 0, options, handler, null, false);
    }

    public Server(int port, IHandler handler) throws UnknownHostException, IOException {
        this(new InetSocketAddress(InetAddress.getByName("0.0.0.0"), port), new HashMap<String, Object>(), handler, null, false);
    }

    public Server(int port, Map<String, Object> options, IHandler handler) throws UnknownHostException, IOException {
        this(InetAddress.getByName("0.0.0.0"), port, options, handler, null, false);
    }

    public Server(InetAddress address, int port, IHandler handler) throws UnknownHostException, IOException {
        this(address, port, new HashMap<String, Object>(), handler, null, false);
    }

    public Server(String ipAddress, int port, IHandler handler) throws UnknownHostException, IOException {
        this(InetAddress.getByName(ipAddress), port, new HashMap<String, Object>(), handler, null, false);
    }

    public Server(String ipAddress, int port, Map<String, Object> options, IHandler handler) throws UnknownHostException, IOException {
        this(InetAddress.getByName(ipAddress), port, options, handler, null, false);
    }

    public Server(int port, IHandler handler, SSLContext sslContext, boolean sslOn) throws UnknownHostException, IOException {
        this(InetAddress.getByName("0.0.0.0"), port, new HashMap<String, Object>(), handler, sslContext, sslOn);
    }

    public Server(int port, Map<String, Object> options, IHandler handler, SSLContext sslContext, boolean sslOn) throws UnknownHostException, IOException {
        this(InetAddress.getByName("0.0.0.0"), port, options, handler, sslContext, sslOn);
    }

    public Server(String ipAddress, int port, IHandler handler, SSLContext sslContext, boolean sslOn) throws UnknownHostException, IOException {
        this(InetAddress.getByName(ipAddress), port, new HashMap<String, Object>(), handler, sslContext, sslOn);
    }

    public Server(String ipAddress, int port, Map<String, Object> options, IHandler handler, SSLContext sslContext, boolean sslOn) throws UnknownHostException, IOException {
        this(InetAddress.getByName(ipAddress), port, options, handler, sslContext, sslOn);
    }

    public Server(InetAddress address, int port, IHandler handler, SSLContext sslContext, boolean sslOn) throws UnknownHostException, IOException {
        this(address, port, new HashMap<String, Object>(), handler, sslContext, sslOn);
    }

    public Server(InetAddress address, int port, Map<String, Object> options, IHandler handler, SSLContext sslContext, boolean sslOn) throws UnknownHostException, IOException {
        this(new InetSocketAddress(address, port), options, handler, sslContext, sslOn);
    }

    protected Server(InetSocketAddress address, Map<String, Object> options, IHandler appHandler, SSLContext sslContext, boolean sslOn) throws UnknownHostException, IOException {
        if (sslContext != null) {
            this.isSsslOn = true;
            this.acceptor = new DefaultIoProvider().create(new AcceptorCallback(), address, 0, options, sslContext, sslOn);
        } else {
            this.isSsslOn = false;
            this.acceptor = Server.getServerIoProvider().createAcceptor(new AcceptorCallback(), address, 0, options);
        }
        this.setHandler(appHandler);
    }

    private void setHandler(IHandler handler) {
        if (this.isOpen) {
            this.destroyCurrentHandler();
        }
        this.handlerProxyPrototype = HandlerProxy.newPrototype(handler, this);
        if (this.isOpen) {
            this.initCurrentHandler();
        }
    }

    private void initCurrentHandler() {
        this.handlerProxyPrototype.onInit();
    }

    private void destroyCurrentHandler() {
        this.handlerProxyPrototype.onDestroy();
    }

    IServerIoProvider getIoProvider() {
        return serverIoProvider;
    }

    public final void setServerName(String name) {
        this.name = name;
    }

    public final String getServerName() {
        return this.name;
    }

    @Override
    public String getStartUpLogMessage() {
        return this.startUpLogMessage;
    }

    @Override
    public void setStartUpLogMessage(String message) {
        this.startUpLogMessage = message;
    }

    private static IServerIoProvider getServerIoProvider() {
        if (serverIoProvider == null) {
            String serverIoProviderClassname = System.getProperty("org.xsocket.stream.io.ServerIoProviderClass");
            if (serverIoProviderClassname != null) {
                try {
                    Class<?> serverIoProviderClass = Class.forName(serverIoProviderClassname, true, Thread.currentThread().getContextClassLoader());
                    serverIoProvider = (IServerIoProvider)serverIoProviderClass.newInstance();
                }
                catch (Exception e) {
                    LOG.warning("error occured by creating ServerIoProivder " + serverIoProviderClassname + ": " + e.toString());
                    LOG.info("using default ServerIoProvider");
                }
            }
            if (serverIoProvider == null) {
                serverIoProvider = new DefaultIoProvider();
            }
        }
        return serverIoProvider;
    }

    @Override
    public final void run() {
        try {
            if (this.getHandler() == null) {
                LOG.warning("no handler has been set. Call setHandler-method to set an assigned handler");
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    Server.this.close();
                }
            });
            this.acceptor.listen();
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    @Override
    public final Object getOption(String name) throws IOException {
        return this.acceptor.getOption(name);
    }

    @Override
    public IHandler getHandler() {
        return this.handlerProxyPrototype.getHandler();
    }

    @Override
    public final Map<String, Class> getOptions() {
        return this.acceptor.getOptions();
    }

    @Override
    public final void close() {
        if (this.isOpen) {
            this.isOpen = false;
            try {
                this.acceptor.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.defaultWorkerPool != null) {
                this.defaultWorkerPool.shutdownNow();
            }
        }
    }

    IAcceptor getAcceptor() {
        return this.acceptor;
    }

    @Override
    public final void addListener(IServerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public final boolean removeListener(IServerListener listener) {
        boolean result = this.listeners.remove(listener);
        return result;
    }

    @Override
    public final Executor getWorkerpool() {
        return this.workerpool;
    }

    @Override
    public final void setWorkerpool(Executor executor) {
        if (executor == null) {
            throw new NullPointerException("executor has to be set");
        }
        if (this.isOpen) {
            LOG.warning("server is already running");
        }
        this.workerpool = executor;
        if (this.defaultWorkerPool != null) {
            this.defaultWorkerPool.shutdown();
            this.defaultWorkerPool = null;
        }
    }

    @Override
    public final boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public final int getLocalPort() {
        return this.acceptor.getLocalPort();
    }

    @Override
    public final InetAddress getLocalAddress() {
        return this.acceptor.getLocalAddress();
    }

    @Override
    public final int getNumberOfOpenConnections() {
        return this.acceptor.getNumberOfOpenConnections();
    }

    @Override
    public final IConnection.FlushMode getFlushMode() {
        return this.flushMode;
    }

    @Override
    public final void setFlushMode(IConnection.FlushMode flusmode) {
        this.flushMode = flusmode;
    }

    @Override
    public final void setAutoflush(boolean autoflush) {
        this.autoflush = autoflush;
    }

    @Override
    public final boolean getAutoflush() {
        return this.autoflush;
    }

    @Override
    public final void setConnectionTimeoutMillis(long timeoutMillis) {
        this.connectionTimeoutMillis = timeoutMillis;
    }

    @Override
    public void setWriteTransferRate(int bytesPerSecond) throws IOException {
        this.writeRate = bytesPerSecond;
    }

    public void setReadTransferRate(int bytesPerSecond) throws IOException {
        this.readRate = bytesPerSecond;
    }

    @Override
    public void setIdleTimeoutMillis(long timeoutMillis) {
        this.idleTimeoutMillis = timeoutMillis;
    }

    @Override
    public final long getConnectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    @Override
    public final long getIdleTimeoutMillis() {
        return this.idleTimeoutMillis;
    }

    public final String getVersion() {
        if (implementationVersion == null) {
            implementationVersion = ConnectionUtils.getVersionInfo();
        }
        return implementationVersion;
    }

    private static class DefaultThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        DefaultThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "xServerPool-" + poolNumber.getAndIncrement() + "-thread-";
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    private final class AcceptorCallback
    implements IAcceptorCallback {
        private AcceptorCallback() {
        }

        public void onConnected() {
            String verInfo;
            Server.this.isOpen = true;
            Server.this.startUpLogMessage = Server.this.getVersion();
            if (Server.this.startUpLogMessage.length() > 0) {
                Server.this.startUpLogMessage = "xSocket " + Server.this.startUpLogMessage;
            }
            if (!(serverIoProvider instanceof DefaultIoProvider) && (verInfo = Server.getServerIoProvider().getImplementationVersion()).length() > 0) {
                Server.this.startUpLogMessage = Server.this.startUpLogMessage + "/" + Server.getServerIoProvider().getClass().getSimpleName() + " " + verInfo;
            }
            Server.this.initCurrentHandler();
            for (IServerListener listener : (ArrayList)Server.this.listeners.clone()) {
                listener.onInit();
            }
            if (Server.this.isSsslOn) {
                LOG.info(Server.this.name + " listening on " + Server.this.acceptor.getLocalAddress().getHostName() + ":" + Server.this.acceptor.getLocalPort() + " - SSL mode (" + Server.this.startUpLogMessage + ")");
            } else {
                LOG.info(Server.this.name + " listening on " + Server.this.acceptor.getLocalAddress().getHostName() + ":" + Server.this.acceptor.getLocalPort() + " (" + Server.this.startUpLogMessage + ")");
            }
        }

        public void onDisconnected() {
            Server.this.destroyCurrentHandler();
            for (IServerListener listener : (ArrayList)Server.this.listeners.clone()) {
                try {
                    listener.onDestroy();
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("exception occured by destroying " + listener + " " + ioe.toString());
                }
            }
            LOG.info("server has been shutdown");
        }

        public void onConnectionAccepted(IIoHandler ioHandler) throws IOException {
            NonBlockingConnection connection = new NonBlockingConnection();
            connection.setAutoflush(Server.this.autoflush);
            connection.setFlushmode(Server.this.flushMode);
            connection.init(ioHandler, Server.getServerIoProvider(), Server.this.handlerProxyPrototype.newProxy(connection), Server.this.workerpool);
            connection.setIdleTimeoutMillis(Server.this.idleTimeoutMillis);
            connection.setConnectionTimeoutMillis(Server.this.connectionTimeoutMillis);
            if (Server.this.writeRate != null) {
                connection.setWriteTransferRate(Server.this.writeRate);
            }
        }
    }
}

