/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.xsocket.IntrospectionBasedDynamicMBean;
import org.xsocket.connection.IHandlerAdapter;
import org.xsocket.connection.IServer;
import org.xsocket.connection.IServerListener;
import org.xsocket.connection.Server;

final class ServerMBeanProxyFactory {
    ServerMBeanProxyFactory() {
    }

    public static ObjectName createAndRegister(IServer server, String domain, MBeanServer mbeanServer) throws JMException {
        String address = server.getLocalAddress().getCanonicalHostName() + ":" + server.getLocalPort();
        ObjectName serverObjectName = ServerMBeanProxyFactory.registerMBeans(server, domain, address);
        server.addListener(new Listener(server, domain, address));
        return serverObjectName;
    }

    private static ObjectName registerMBeans(IServer server, String domain, String address) throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException, JMException {
        address = address.replace(":", "_");
        Object hdl = server.getHandler();
        if (hdl instanceof IHandlerAdapter) {
            hdl = ((IHandlerAdapter)hdl).getAdaptee();
        }
        ObjectName hdlObjectName = new ObjectName(domain + ".server." + address + ":type=" + hdl.getClass().getSimpleName());
        ManagementFactory.getPlatformMBeanServer().registerMBean(new IntrospectionBasedDynamicMBean(hdl), hdlObjectName);
        ObjectName serverObjectName = null;
        if (server instanceof Server) {
            serverObjectName = ((Server)server).getIoProvider().registerMBeans((Server)server, ((Server)server).getAcceptor(), domain, address);
        } else {
            serverObjectName = new ObjectName(domain + ".server." + address + ":type=xServer,name=" + server.hashCode());
            ManagementFactory.getPlatformMBeanServer().registerMBean(new IntrospectionBasedDynamicMBean(server), serverObjectName);
        }
        ObjectName workerpoolObjectName = new ObjectName(domain + ".server." + address + ":type=Workerpool");
        ManagementFactory.getPlatformMBeanServer().registerMBean(new IntrospectionBasedDynamicMBean(server.getWorkerpool()), workerpoolObjectName);
        return serverObjectName;
    }

    private static void unregisterMBeans(IServer server, String domain, String address) throws JMException {
        address = address.replace(":", "_");
        ObjectName hdlObjectName = new ObjectName(domain + ".server." + address + ":type=" + server.getHandler().getClass().getSimpleName());
        ManagementFactory.getPlatformMBeanServer().unregisterMBean(hdlObjectName);
        ObjectName workerpoolObjectName = new ObjectName(domain + ".server." + address + ":type=Workerpool");
        ManagementFactory.getPlatformMBeanServer().unregisterMBean(workerpoolObjectName);
    }

    private static final class Listener
    implements IServerListener {
        private static final Logger LOG = Logger.getLogger(Listener.class.getName());
        private IServer server = null;
        private String domain = null;
        private String address = null;

        Listener(IServer server, String domain, String address) {
            this.server = server;
            this.domain = domain;
            this.address = address;
            server.addListener(this);
        }

        public void onInit() {
        }

        public void onDestroy() {
            block2: {
                try {
                    ServerMBeanProxyFactory.unregisterMBeans(this.server, this.domain, this.address);
                }
                catch (Exception ex) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("error occured by deregistering the server (domain=" + this.domain + "). reason: " + ex.toString());
                }
            }
        }
    }
}

