/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection.spi;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import org.xsocket.connection.spi.IIoHandler;
import org.xsocket.connection.spi.IIoHandlerCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ChainableIoHandler
implements IIoHandler {
    private ChainableIoHandler successor = null;
    private ChainableIoHandler previous = null;
    private IIoHandlerCallback callback = null;

    public ChainableIoHandler(ChainableIoHandler successor) {
        this.setSuccessor(successor);
    }

    public final ChainableIoHandler getSuccessor() {
        return this.successor;
    }

    protected final void setSuccessor(ChainableIoHandler successor) {
        this.successor = successor;
        if (successor != null) {
            successor.setPrevious(this);
        }
    }

    protected final void setPrevious(ChainableIoHandler previous) {
        this.previous = previous;
    }

    protected final ChainableIoHandler getPrevious() {
        return this.previous;
    }

    @Override
    public boolean reset() {
        ChainableIoHandler successor = this.getSuccessor();
        if (successor != null) {
            return successor.reset();
        }
        return true;
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.getSuccessor().getLocalAddress();
    }

    @Override
    public int getPendingWriteDataSize() {
        ChainableIoHandler successor = this.getSuccessor();
        if (successor != null) {
            return successor.getPendingWriteDataSize();
        }
        return 0;
    }

    @Override
    public boolean hasDataToSend() {
        ChainableIoHandler successor = this.getSuccessor();
        if (successor != null) {
            return successor.hasDataToSend();
        }
        return false;
    }

    @Override
    public void suspendRead() throws IOException {
        ChainableIoHandler successor = this.getSuccessor();
        if (successor != null) {
            successor.suspendRead();
        }
    }

    @Override
    public void resumeRead() throws IOException {
        ChainableIoHandler successor = this.getSuccessor();
        if (successor != null) {
            successor.resumeRead();
        }
    }

    @Override
    public String getId() {
        return this.getSuccessor().getId();
    }

    void setPreviousCallback(IIoHandlerCallback callback) {
        this.callback = callback;
    }

    IIoHandlerCallback getPreviousCallback() {
        return this.callback;
    }

    @Override
    public int getLocalPort() {
        return this.getSuccessor().getLocalPort();
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.getSuccessor().getRemoteAddress();
    }

    @Override
    public int getRemotePort() {
        return this.getSuccessor().getRemotePort();
    }

    @Override
    public boolean isOpen() {
        return this.getSuccessor().isOpen();
    }

    @Override
    public void setIdleTimeoutMillis(long timeout) {
        this.getSuccessor().setIdleTimeoutMillis(timeout);
    }

    @Override
    public void setConnectionTimeoutMillis(long timeout) {
        this.getSuccessor().setConnectionTimeoutMillis(timeout);
    }

    @Override
    public long getConnectionTimeoutMillis() {
        return this.getSuccessor().getConnectionTimeoutMillis();
    }

    @Override
    public long getIdleTimeoutMillis() {
        return this.getSuccessor().getIdleTimeoutMillis();
    }

    @Override
    public long getRemainingMillisToConnectionTimeout() {
        return this.getSuccessor().getRemainingMillisToConnectionTimeout();
    }

    @Override
    public long getRemainingMillisToIdleTimeout() {
        return this.getSuccessor().getRemainingMillisToIdleTimeout();
    }

    @Override
    public Object getOption(String name) throws IOException {
        return this.getSuccessor().getOption(name);
    }

    @Override
    public Map<String, Class> getOptions() {
        return this.getSuccessor().getOptions();
    }

    @Override
    public void setOption(String name, Object value) throws IOException {
        this.getSuccessor().setOption(name, value);
    }

    public abstract void flushOutgoing() throws IOException;

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName() + "#" + this.hashCode());
        ChainableIoHandler ioHandler = this;
        while (ioHandler.getPrevious() != null) {
            ioHandler = ioHandler.getPrevious();
        }
        String forwardChain = "";
        while (ioHandler != null) {
            forwardChain = forwardChain + ioHandler.getClass().getSimpleName() + " > ";
            ioHandler = ioHandler.getSuccessor();
        }
        forwardChain = forwardChain.trim();
        forwardChain = forwardChain.substring(0, forwardChain.length() - 1);
        sb.append(" (forward chain: " + forwardChain.trim() + ")");
        return sb.toString();
    }
}

