/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection.spi;

import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.DataConverter;
import org.xsocket.connection.spi.AbstractMemoryManager;

final class SynchronizedMemoryManager
extends AbstractMemoryManager {
    private static final Logger LOG = Logger.getLogger(SynchronizedMemoryManager.class.getName());
    private final List<SoftReference<ByteBuffer>> memoryBuffer = new ArrayList<SoftReference<ByteBuffer>>();

    private SynchronizedMemoryManager(int preallocationSize, boolean preallocate, int minPreallocatedBufferSize, boolean useDirectMemory) {
        super(preallocationSize, preallocate, minPreallocatedBufferSize, useDirectMemory);
    }

    public static SynchronizedMemoryManager createPreallocatedMemoryManager(int preallocationSize, int minBufferSze, boolean useDirectMemory) {
        return new SynchronizedMemoryManager(preallocationSize, true, minBufferSze, useDirectMemory);
    }

    public static SynchronizedMemoryManager createNonPreallocatedMemoryManager(boolean useDirectMemory) {
        return new SynchronizedMemoryManager(0, false, 1, useDirectMemory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getCurrentSizePreallocatedBuffer() {
        int size = 0;
        List<SoftReference<ByteBuffer>> list = this.memoryBuffer;
        synchronized (list) {
            for (SoftReference<ByteBuffer> bufferRef : this.memoryBuffer) {
                ByteBuffer buffer = bufferRef.get();
                if (buffer == null) continue;
                size += buffer.remaining();
            }
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycleMemory(ByteBuffer buffer) {
        int remaining;
        if (this.isPreallocationMode() && (remaining = buffer.remaining()) >= this.getPreallocatedMinBufferSize()) {
            List<SoftReference<ByteBuffer>> list = this.memoryBuffer;
            synchronized (list) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("recycling " + DataConverter.toFormatedBytesSize(buffer.remaining()));
                }
                this.memoryBuffer.add(new SoftReference<ByteBuffer>(buffer));
            }
        }
    }

    public void preallocate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer acquireMemoryStandardSizeOrPreallocated(int standardSize) {
        ByteBuffer buffer = null;
        if (this.isPreallocationMode()) {
            List<SoftReference<ByteBuffer>> list = this.memoryBuffer;
            synchronized (list) {
                SoftReference<ByteBuffer> freeBuffer;
                if (!this.memoryBuffer.isEmpty() && (buffer = (freeBuffer = this.memoryBuffer.remove(0)).get()) != null && buffer.limit() < this.getPreallocatedMinBufferSize()) {
                    buffer = null;
                }
            }
            if (buffer == null) {
                buffer = this.newBuffer(standardSize);
            }
            return buffer;
        }
        return this.newBuffer(standardSize);
    }
}

