/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket;

import java.util.LinkedList;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SerializedTaskQueue {
    private static final Logger LOG = Logger.getLogger(SerializedTaskQueue.class.getName());
    private final LinkedList<Runnable> taskQueue = new LinkedList();
    private final MultithreadedTaskProcessor multithreadedTaskProcessor = new MultithreadedTaskProcessor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performNonThreaded(Runnable task) {
        LinkedList<Runnable> linkedList = this.taskQueue;
        synchronized (linkedList) {
            if (this.taskQueue.isEmpty()) {
                task.run();
            } else {
                this.taskQueue.addLast(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performMultiThreaded(Runnable task, Executor workerpool) {
        boolean isWorkerRequired = false;
        LinkedList<Runnable> linkedList = this.taskQueue;
        synchronized (linkedList) {
            if (this.taskQueue.isEmpty()) {
                this.taskQueue.addLast(task);
                isWorkerRequired = true;
            } else {
                this.taskQueue.addLast(task);
            }
        }
        if (isWorkerRequired) {
            workerpool.execute(this.multithreadedTaskProcessor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performPendingTasks() {
        boolean taskToProcess = true;
        while (taskToProcess) {
            Runnable task = null;
            LinkedList<Runnable> linkedList = this.taskQueue;
            synchronized (linkedList) {
                task = this.taskQueue.getFirst();
            }
            assert (task != null) : "a task should always be available";
            task.run();
            linkedList = this.taskQueue;
            synchronized (linkedList) {
                if (this.taskQueue.size() > 1) {
                    if (LOG.isLoggable(Level.FINER)) {
                        LOG.finer("more task to process. process next task");
                    }
                    this.taskQueue.remove(task);
                    taskToProcess = true;
                } else {
                    this.taskQueue.remove(task);
                    taskToProcess = false;
                }
            }
        }
    }

    private final class MultithreadedTaskProcessor
    implements Runnable {
        private MultithreadedTaskProcessor() {
        }

        public void run() {
            SerializedTaskQueue.this.performPendingTasks();
        }
    }
}

