/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.xsocket.ILifeCycle;
import org.xsocket.connection.IConnectionPool;
import org.xsocket.connection.IntrospectionBasedDynamicMBean;

final class ConnectionPoolMBeanProxyFactory {
    ConnectionPoolMBeanProxyFactory() {
    }

    public static ObjectName createAndRegister(IConnectionPool pool, String domain, MBeanServer mbeanServer) throws JMException {
        ObjectName objectName = new ObjectName(domain + ":type=" + pool.getClass().getSimpleName() + ",name=" + pool.hashCode());
        ManagementFactory.getPlatformMBeanServer().registerMBean(new IntrospectionBasedDynamicMBean(pool), objectName);
        new ResourcePoolListener(pool, domain);
        return objectName;
    }

    private static void unregister(IConnectionPool pool, String domain) throws JMException {
        ObjectName objectName = new ObjectName(domain + ":type=" + pool.getClass().getSimpleName() + ",name=" + pool.hashCode());
        ManagementFactory.getPlatformMBeanServer().unregisterMBean(objectName);
    }

    private static final class ResourcePoolListener
    implements ILifeCycle {
        private static final Logger LOG = Logger.getLogger(ResourcePoolListener.class.getName());
        private IConnectionPool pool = null;
        private String domain = null;

        ResourcePoolListener(IConnectionPool pool, String domain) {
            this.pool = pool;
            this.domain = domain;
            pool.addListener(this);
        }

        public void onInit() {
        }

        public void onDestroy() {
            block2: {
                try {
                    ConnectionPoolMBeanProxyFactory.unregister(this.pool, this.domain);
                }
                catch (Exception ex) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("error occured by deregistering the pool (domain=" + this.domain + "). reason: " + ex.toString());
                }
            }
        }
    }
}

